/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.AtomicTagSegment;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticPartSegment;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.util.Interval;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HierarchicSegment
extends Segment {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TagProperties properties;
    protected int level;
    protected IGeneratedTag tag;
    protected int minRank;
    protected int maxRank;
    protected Segment[] sons;
    protected Segment[] subSegments;
    protected int status;
    protected int partsChangesCount;
    protected int subtreesChangesCount;
    protected static final int PARTS_STATUS_SHIFT = 3;
    protected static final int PARTS_STATUS_MASK = 56;
    protected static final int SUBTREES_STATUS_SHIFT = 6;
    protected static final int SUBTREES_STATUS_MASK = 448;

    protected HierarchicSegment() {
    }

    protected HierarchicSegment(UserChangeSet userChangeSet, IGeneratedTag generatedTag) {
        super(userChangeSet);
        this.tag = generatedTag;
        this.enclosing = userChangeSet.topSegment;
    }

    protected HierarchicSegment(UserChangeSet userChangeSet, HierarchicSegment parentSegment, IGeneratedTag generatedTag) {
        super(userChangeSet, parentSegment);
        this.tag = generatedTag;
        if (parentSegment != null) {
            this.level = parentSegment.generatedLevel() + 1;
            this.enclosing = parentSegment;
        } else {
            this.enclosing = userChangeSet.topSegment;
        }
    }

    @Override
    public int generatedLevel() {
        return this.level;
    }

    @Override
    public TagProperties getTagProperties() {
        if (this.properties == null) {
            this.properties = this.newTagProperties();
        }
        return this.properties;
    }

    protected TagProperties newTagProperties() {
        return new TagProperties((Segment)this, this.tag);
    }

    @Override
    public boolean isSyntactic() {
        return false;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments.length == 0;
    }

    @Override
    public Segment enclosingSegment() {
        if (this.enclosing.dirtySubSegments()) {
            this.computeEnclosingSegment();
        }
        return this.enclosing;
    }

    protected void computeEnclosingSegment() {
        this.findInSubHierarchy(this.parent != null ? this.parent : this.changeSet.topSegment);
    }

    protected boolean findInSubHierarchy(Segment head) {
        Segment[] subs;
        boolean found = false;
        Segment[] segmentArray = subs = head.subSegments();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Segment sub = segmentArray[n2];
            if (sub == this || sub.isSyntactic() && this.findInSubHierarchy(sub)) {
                found = true;
            }
            ++n2;
        }
        return found;
    }

    @Override
    public Segment[] subSegments() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments;
    }

    protected Segment[] buildSubSegments() {
        Segment[] sons = this.sons();
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return sons;
        }
        int startSonRank = 0;
        int minSonRank = 0;
        int begin = this.beginIndex();
        int end = this.endIndex();
        Iterator<SyntacticTag> subtags = si.subTags(begin, end);
        ArrayList<Segment> subSegmentsList = null;
        boolean firstTag = true;
        while (subtags.hasNext()) {
            SyntacticTag tag = subtags.next();
            if (firstTag && tag.beginIndex() == begin && tag.endIndex() == end && sons[0].generatedText().length() > 0) {
                end = this.endIndex();
                if (!(subtags = si.subTags(++begin, end)).hasNext()) break;
                tag = subtags.next();
            }
            firstTag = false;
            if (!tag.isToInsertInEditTree() || tag.beginIndex() == begin && tag.endIndex() == end && sons[0].generatedText().length() > 0) continue;
            boolean sonWithSameIndexesExist = false;
            int i = 0;
            while (i < sons.length) {
                Segment seg = sons[i];
                if ((seg instanceof HierarchicSegment || seg instanceof AtomicTagSegment) && seg.beginIndex() == tag.beginIndex() && seg.endIndex() == tag.endIndex()) {
                    sonWithSameIndexesExist = true;
                    break;
                }
                ++i;
            }
            if (sonWithSameIndexesExist) continue;
            Segment son = sons[minSonRank];
            int tagBeginIdx = tag.beginIndex();
            while (son.endIndex() < tagBeginIdx) {
                son = sons[++minSonRank];
            }
            while (son.endIndex() == tagBeginIdx) {
                int syntacticTagBeginRank;
                if (son.isTagged()) {
                    son = sons[++minSonRank];
                    continue;
                }
                int maxRank = son.maxRank();
                Interval interval = new Interval(0, this.changeSet.nbAtom);
                int nbAtoms = this.changeSet.atomsTouching(tagBeginIdx + 1, tagBeginIdx + 1, interval);
                if (nbAtoms != 1 || maxRank >= (syntacticTagBeginRank = interval.begin)) break;
                son = sons[++minSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagBeginIdx) continue;
                son = sons[++minSonRank];
            }
            int maxSonRank = minSonRank;
            int tagEndIdx = tag.endIndex();
            while (son.endIndex() < tagEndIdx) {
                son = sons[++maxSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagEndIdx) {
                    minSonRank = maxSonRank;
                    continue;
                }
                ++maxSonRank;
            }
            if (subSegmentsList == null) {
                subSegmentsList = new ArrayList<Segment>();
            }
            this.addSubSegments(sons, startSonRank, minSonRank, maxSonRank, tag, subSegmentsList);
            startSonRank = minSonRank = maxSonRank;
        }
        if (subSegmentsList == null) {
            return sons;
        }
        this.completeSubSegments(sons, startSonRank, subSegmentsList);
        Segment[] subSegments = new Segment[subSegmentsList.size()];
        subSegmentsList.toArray(subSegments);
        return subSegments;
    }

    protected void addSubSegments(Segment[] sons, int startSonRank, int minSonRank, int maxSonRank, SyntacticTag tag, List<Segment> subSegmentsList) {
        HierarchicSegment previous;
        int tagMinRank = sons[minSonRank].minRank();
        int tagMaxRank = sons[maxSonRank].maxRank();
        SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(this, this, tag, tagMinRank, tagMaxRank);
        Segment segment = previous = subSegmentsList.isEmpty() ? this : subSegmentsList.get(subSegmentsList.size() - 1);
        if (startSonRank == minSonRank) {
            SyntacticPartSegment partSegment = this.changeSet.newSyntacticPartSegment(this, this, previous, tagSegment, tagMinRank);
            subSegmentsList.add(partSegment);
            subSegmentsList.add(tagSegment);
            return;
        }
        if (previous != this) {
            int rank1 = sons[startSonRank].minRank();
            SyntacticPartSegment part1 = this.changeSet.newSyntacticPartSegment(this, this, previous, sons[++startSonRank], rank1);
            subSegmentsList.add(part1);
        }
        do {
            subSegmentsList.add(sons[startSonRank]);
        } while (++startSonRank < minSonRank);
        SyntacticPartSegment part2 = this.changeSet.newSyntacticPartSegment(this, this, sons[minSonRank - 1], tagSegment, tagMinRank);
        subSegmentsList.add(part2);
        subSegmentsList.add(tagSegment);
    }

    protected void completeSubSegments(Segment[] sons, int startSonRank, List<Segment> subSegmentsList) {
        int startRank = sons[startSonRank].minRank();
        Segment previous = subSegmentsList.get(subSegmentsList.size() - 1);
        int maxSonRank = sons.length - 1;
        if (startSonRank == maxSonRank) {
            SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(this, this, previous, this, startRank);
            subSegmentsList.add(part);
            return;
        }
        SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(this, this, previous, sons[++startSonRank], startRank);
        subSegmentsList.add(part);
        do {
            subSegmentsList.add(sons[startSonRank]);
        } while (++startSonRank <= maxSonRank);
    }

    @Override
    protected boolean dirtySubSegments() {
        return this.subSegments == null;
    }

    @Override
    protected void touchSubSegments() {
        if (this.subSegments == null) {
            return;
        }
        if (this.subSegments != this.sons()) {
            Segment[] segmentArray = this.subSegments;
            int n = this.subSegments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment subSegment = segmentArray[n2];
                if (subSegment.isSyntactic() && subSegment.isTagged()) {
                    this.changeSet.syntacticTagNameToSegment.remove(subSegment.enclosingTagName());
                    subSegment.touchSubSegments();
                }
                ++n2;
            }
        }
        this.subSegments = null;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return true;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public boolean isFirstPart() {
        return false;
    }

    @Override
    public boolean isMiddlePart() {
        return false;
    }

    @Override
    public boolean isLastPart() {
        return false;
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return this.tag;
    }

    @Override
    public IGeneratedTag fromTag() {
        return this.tag;
    }

    @Override
    public IGeneratedTag toTag() {
        return this.tag;
    }

    @Override
    public String enclosingTagName() {
        return this.tag.getName();
    }

    @Override
    public String fromTagName() {
        return this.tag.getName();
    }

    @Override
    public String toTagName() {
        return this.tag.getName();
    }

    @Override
    public int nbOfSons() {
        return 1 + (this.tag.nbOfSons() << 1);
    }

    @Override
    public int nbOfTaggedSons() {
        return this.tag.nbOfSons();
    }

    @Override
    public Segment[] sons() {
        if (this.sons == null) {
            this.sons = this.findSons();
        }
        return this.sons;
    }

    protected Segment[] findSons() {
        SegmentSelectionParameter selection = this.changeSet.newSubtreeSelection(false, this, false, false);
        selection.setFilter(this.changeSet.sonsOnlySegmentFilter(this));
        int nbOfSons = 1 + (this.tag.nbOfSons() << 1);
        Segment[] sonsArray = new Segment[nbOfSons];
        Iterator<Segment> segments = this.changeSet.segments(selection);
        int sonIdx = 0;
        while (sonIdx < nbOfSons) {
            sonsArray[sonIdx] = segments.next();
            ++sonIdx;
        }
        return sonsArray;
    }

    @Override
    public boolean isAncestorOf(Segment segment) {
        return this.level < segment.generatedLevel() && this.minRank <= segment.minRank() && this.maxRank >= segment.maxRank();
    }

    @Override
    public Segment firstAtom() {
        return this.changeSet.getAtomAt(this.minRank);
    }

    @Override
    public Segment lastAtom() {
        return this.changeSet.getAtomAt(this.maxRank);
    }

    @Override
    public Segment previousAtom() {
        return this.minRank > 0 ? this.changeSet.getAtomAt(this.minRank - 1) : null;
    }

    @Override
    public Segment nextAtom() {
        return this.maxRank < this.changeSet.nbAtom - 1 ? this.changeSet.getAtomAt(this.maxRank + 1) : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Segment previousBrother() {
        if (this.minRank == 0) {
            return null;
        }
        brother /* !! */  = this.changeSet.getAtomAt(this.minRank - 1);
        if (brother /* !! */ .generatedLevel() >= this.level) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            brother /* !! */  = brother /* !! */ .parent;
lbl7:
            // 2 sources

            ** while (brother /* !! */ .generatedLevel() > this.level)
        }
lbl8:
        // 1 sources

        return brother /* !! */ .parent == this.parent ? brother /* !! */  : null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Segment nextBrother() {
        if (this.maxRank == this.changeSet.nbAtom - 1) {
            return null;
        }
        brother = (Segment)this.changeSet.atomArray[this.maxRank + 1];
        if (brother.generatedLevel() >= this.level) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            brother = brother.parent;
lbl7:
            // 2 sources

            ** while (brother.generatedLevel() > this.level)
        }
lbl8:
        // 1 sources

        return brother.parent == this.parent ? brother : null;
    }

    @Override
    public int minRank() {
        return this.minRank;
    }

    @Override
    public int maxRank() {
        return this.maxRank;
    }

    @Override
    public int beginIndex() {
        return this.changeSet.beginIndexOfAtom(this.minRank);
    }

    @Override
    public int endIndex() {
        return this.changeSet.endIndexOfAtom(this.maxRank);
    }

    @Override
    public void setBeginIndex(int newBeginIdx) {
        this.changeSet.changeBeginIndex(this.changeSet.getAtomAt(this.minRank), newBeginIdx);
    }

    @Override
    public int length() {
        return this.endIndex() - this.beginIndex();
    }

    @Override
    public void setText(CharSequence newText) {
        this.changeSet.replaceTextOfAtoms(this.minRank, this.maxRank, newText);
    }

    @Override
    public int generatedBeginIndex() {
        return this.tag.getBeginIndex();
    }

    @Override
    public int generatedEndIndex() {
        return this.tag.getEndIndex();
    }

    @Override
    public int generatedLength() {
        return this.tag.getEndIndex() - this.tag.getBeginIndex();
    }

    @Override
    public CharSequence generatedText() {
        return this.tag.getGeneratedInfo().getText().subSequence(this.tag.getBeginIndex(), this.tag.getEndIndex());
    }

    @Override
    public ChangeNature getChangeNature() {
        return HierarchicSegment.changeNatureFromStatus(this.getSegmentStatus());
    }

    @Override
    public void setChangeNature(ChangeNature newChangeNature) {
        int oldTreeStatus = this.getTreeStatus();
        this.setSegmentStatus(newChangeNature.ordinal());
        int newTreeStatus = this.getTreeStatus();
        this.updateAncestorsStatus(oldTreeStatus, newTreeStatus);
    }

    @Override
    public ChangeNature getSubtreesChangeNature() {
        return HierarchicSegment.changeNatureFromStatus(this.getSubtreesStatus());
    }

    @Override
    public ChangeNature getTreeChangeNature() {
        return HierarchicSegment.changeNatureFromStatus(this.getTreeStatus());
    }

    @Override
    protected int getTreeStatus() {
        if (this.status == 0) {
            return 0;
        }
        int segmentStatus = this.getSegmentStatus();
        int subtreesStatus = this.getSubtreesStatus();
        if (segmentStatus == 6 || subtreesStatus == 6) {
            return 6;
        }
        if (segmentStatus >= 2) {
            return segmentStatus;
        }
        return subtreesStatus >= 2 ? 2 : 1;
    }

    protected void resetStatus() {
        this.status = 0;
        this.subtreesChangesCount = 0;
        this.partsChangesCount = 0;
    }

    @Override
    protected void updatePartStatus(int oldPartStatus, int newPartStatus) {
        int newPartChangeLevel;
        int oldPartChangeLevel = HierarchicSegment.changeLevel(oldPartStatus);
        if (oldPartChangeLevel == (newPartChangeLevel = HierarchicSegment.changeLevel(newPartStatus))) {
            return;
        }
        int segmentChangeLevel = HierarchicSegment.changeLevel(this.getSegmentStatus());
        if (newPartChangeLevel == segmentChangeLevel) {
            ++this.partsChangesCount;
        } else if (newPartChangeLevel > segmentChangeLevel) {
            int oldTreeStatus = this.getTreeStatus();
            this.setPartsStatus(newPartChangeLevel);
            this.updateSegmentStatusFromPartStatus(newPartChangeLevel);
            this.partsChangesCount = 1;
            this.updateAncestorsStatus(oldTreeStatus, this.getTreeStatus());
        } else if (segmentChangeLevel == oldPartChangeLevel && --this.partsChangesCount == 0) {
            int oldTreeStatus = this.getTreeStatus();
            this.recomputePartsStatus();
            this.updateAncestorsStatus(oldTreeStatus, this.getTreeStatus());
        }
    }

    protected void recomputePartsStatus() {
        int maxLevel = 0;
        int count = 0;
        Segment[] segmentArray = this.sons();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment son = segmentArray[n2];
            if (son.isPart()) {
                int sonChangeLevel = HierarchicSegment.changeLevel(son.getSegmentStatus());
                if (sonChangeLevel > maxLevel) {
                    maxLevel = sonChangeLevel;
                    count = 1;
                } else if (sonChangeLevel == maxLevel) {
                    ++count;
                }
            }
            ++n2;
        }
        this.setPartsStatus(maxLevel);
        this.updateSegmentStatusFromPartStatus(maxLevel);
        this.partsChangesCount = maxLevel != 0 ? count : 0;
    }

    protected void updateSegmentStatusFromPartStatus(int partsStatus) {
        if (HierarchicSegment.changeLevel(partsStatus) != HierarchicSegment.changeLevel(this.getSegmentStatus())) {
            this.setSegmentStatus(partsStatus);
        }
    }

    @Override
    protected void updateSubtreeStatus(int oldSubtreeStatus, int newSubtreeStatus) {
        int newSubtreeChangeLevel;
        int oldSubtreeChangeLevel = HierarchicSegment.changeLevel(oldSubtreeStatus);
        if (oldSubtreeChangeLevel == (newSubtreeChangeLevel = HierarchicSegment.changeLevel(newSubtreeStatus))) {
            return;
        }
        int subtreesChangeLevel = HierarchicSegment.changeLevel(this.getSubtreesStatus());
        if (subtreesChangeLevel == newSubtreeChangeLevel) {
            ++this.subtreesChangesCount;
        } else if (newSubtreeChangeLevel > subtreesChangeLevel) {
            int oldTreeStatus = this.getTreeStatus();
            this.setSubtreesStatus(newSubtreeChangeLevel);
            this.subtreesChangesCount = 1;
            this.updateAncestorsStatus(oldTreeStatus, this.getTreeStatus());
        } else if (subtreesChangeLevel == oldSubtreeChangeLevel && --this.subtreesChangesCount == 0) {
            int oldTreeStatus = this.getTreeStatus();
            this.recomputeSubtreesStatus();
            this.updateAncestorsStatus(oldTreeStatus, this.getTreeStatus());
        }
    }

    protected void recomputeSubtreesStatus() {
        int maxLevel = 0;
        int count = 0;
        Segment[] segmentArray = this.sons();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment son = segmentArray[n2];
            if (son.isTagged()) {
                int sonChangeLevel = HierarchicSegment.changeLevel(son.getTreeStatus());
                if (sonChangeLevel > maxLevel) {
                    maxLevel = sonChangeLevel;
                    count = 1;
                } else if (sonChangeLevel == maxLevel) {
                    ++count;
                }
            }
            ++n2;
        }
        this.setSubtreesStatus(maxLevel);
        this.subtreesChangesCount = maxLevel != 0 ? count : 0;
    }

    protected void updateAncestorsStatus(int oldTreeStatus, int newTreeStatus) {
        if (oldTreeStatus == newTreeStatus) {
            return;
        }
        if (this.parent == null) {
            this.changeSet.updateRootSegmentStatus(oldTreeStatus, newTreeStatus);
        } else {
            this.parent.updateSubtreeStatus(oldTreeStatus, newTreeStatus);
        }
    }

    @Override
    protected int getSegmentStatus() {
        return this.status & 7;
    }

    protected void setSegmentStatus(int segmentStatus) {
        this.status = segmentStatus | this.status & 0xFFFFFFF8;
    }

    protected int getPartsStatus() {
        return this.status >> 3 & 7;
    }

    protected void setPartsStatus(int partsStatus) {
        if (partsStatus < 2) {
            this.subSegments = this.sons;
        }
        this.status = this.status & 0xFFFFFFC7 | partsStatus << 3;
    }

    protected int getSubtreesStatus() {
        return this.status >> 6 & 7;
    }

    protected void setSubtreesStatus(int subtreesStatus) {
        this.status = this.status & 0xFFFFFE3F | subtreesStatus << 6;
    }

    @Override
    public boolean restoreGeneratedText() {
        if (this.getTreeStatus() == 0) {
            return false;
        }
        return this.changeSet.restoreAtomGeneratedText(this.minRank, this.maxRank);
    }

    @Override
    public IDetailedChanges detailedChanges() {
        return null;
    }

    @Override
    public void setDetailedChanges(IDetailedChanges newDetails) {
        throw new UnsupportedOperationException("HierarchicSegment.setDetailedChanges");
    }

    public String toString() {
        return String.valueOf(this.tag.getName()) + " [" + this.beginIndex() + ", " + this.endIndex() + "]";
    }
}

