/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.GeneratedChangePosition;
import com.ibm.pdp.engine.turbo.core.GeneratedInfoChange;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class GeneratedInfoTransformer
extends GeneratedInfoConverter {
    protected Iterator<GeneratedInfoChange> changes;
    protected GeneratedInfoChange change;
    protected Deque<String> parentTagNames;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratedInfoTransformer() {
    }

    public GeneratedInfoTransformer(IGeneratedInfoFactory factory, Iterator<GeneratedInfoChange> changes) {
        super(factory);
        this.changes = changes;
        if (changes.hasNext()) {
            this.change = changes.next();
        }
        this.parentTagNames = new ArrayDeque<String>();
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        return true;
    }

    protected IGeneratedInfo createNewGeneratedInfo(IGeneratedInfo generatedInfoToConvert) {
        if (this.change != null) {
            throw new RuntimeException("Changes have not been fully consumed");
        }
        return super.createNewGeneratedInfo(generatedInfoToConvert);
    }

    protected void beginTag(String tagName) {
        boolean noSkip = true;
        while (this.change != null && this.change.getPosition() == GeneratedChangePosition.BEFORE_TAG_OPEN && this.change.acceptTagName(tagName)) {
            if (this.change.process(this.factory)) {
                noSkip = false;
            }
            GeneratedInfoChange generatedInfoChange = this.change = this.changes.hasNext() ? this.changes.next() : null;
        }
        if (noSkip) {
            super.beginTag(tagName);
        }
        while (this.change != null && this.change.getPosition() == GeneratedChangePosition.AFTER_TAG_OPEN && this.change.acceptTagName(tagName)) {
            this.change.process(this.factory);
            GeneratedInfoChange generatedInfoChange = this.change = this.changes.hasNext() ? this.changes.next() : null;
        }
        this.parentTagNames.push(tagName);
    }

    protected void endTag(String tagName) {
        boolean noSkip = true;
        while (this.change != null && this.change.getPosition() == GeneratedChangePosition.BEFORE_TAG_CLOSE && this.change.acceptTagName(tagName)) {
            if (this.change.process(this.factory)) {
                noSkip = false;
            }
            GeneratedInfoChange generatedInfoChange = this.change = this.changes.hasNext() ? this.changes.next() : null;
        }
        if (noSkip) {
            super.endTag(tagName);
        }
        while (this.change != null && this.change.getPosition() == GeneratedChangePosition.AFTER_TAG_CLOSE && this.change.acceptTagName(tagName)) {
            this.change.process(this.factory);
            GeneratedInfoChange generatedInfoChange = this.change = this.changes.hasNext() ? this.changes.next() : null;
        }
        this.parentTagNames.pop();
    }

    protected void convertText(int beginIdx, int endIdx) {
        while (this.change != null && this.change.getPosition() == GeneratedChangePosition.TEXT_CONVERT && this.change.beginIndex() <= endIdx && this.change.endIndex() >= beginIdx && this.change.acceptTagName(this.parentTagName())) {
            int startIdx = Math.max(beginIdx, this.change.beginIndex());
            int stopIdx = Math.min(this.change.endIndex(), endIdx);
            if (startIdx > beginIdx) {
                super.convertText(beginIdx, startIdx);
            }
            if (!this.change.acceptInterval(startIdx, stopIdx) || !this.change.process(this.factory)) {
                super.convertText(startIdx, stopIdx);
            }
            if (stopIdx < this.change.endIndex()) {
                return;
            }
            this.change = this.changes.hasNext() ? this.changes.next() : null;
            beginIdx = stopIdx;
        }
        super.convertText(beginIdx, endIdx);
    }

    protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
        if (this.change != null && this.change.getPosition() == GeneratedChangePosition.TAG_CONVERT_MODE && this.change.acceptTagName(tag.getName())) {
            TagConversionMode mode = this.change.tagConversionMode(tag.getName());
            this.change = this.changes.hasNext() ? this.changes.next() : null;
            return mode;
        }
        return super.tagConversionMode(tag);
    }

    protected String parentTagName() {
        return this.parentTagNames.peek();
    }
}

