/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;
import com.ibm.pdp.engine.turbo.core.SegmentIterator;

public class FilteredSegmentIterator
extends SegmentIterator {
    protected SegmentFilter filter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected FilteredSegmentIterator() {
    }

    protected FilteredSegmentIterator(Object[] atomArray, Segment startSegment, boolean startSegmentIncluded, Segment stopSegment, boolean stopSegmentIncluded, boolean reverseOrder, SegmentFilter segmentFilter) {
        super(atomArray, startSegment, startSegmentIncluded, stopSegment, stopSegmentIncluded, reverseOrder);
        this.filter = segmentFilter;
        this.checkStartSegment();
    }

    protected void checkStartSegment() {
        Segment startSegment = this.found;
        if (startSegment == null) {
            startSegment = this.lastReturned;
        }
        if (!this.skip(startSegment)) {
            return;
        }
        Segment parent = startSegment.parent;
        while (parent != null && this.skipSons(parent)) {
            startSegment = parent;
            parent = parent.parent;
        }
        this.lastReturned = startSegment;
        this.found = null;
    }

    @Override
    protected boolean findForward(Segment segment) {
        Segment nextCandidate;
        do {
            if ((nextCandidate = this.forwardCandidate(segment)) != null) continue;
            this.found = null;
            return false;
        } while (this.skip(segment = this.nextToReturn(segment, nextCandidate)));
        this.found = segment;
        return true;
    }

    @Override
    protected Segment forwardCandidate(Segment segment) {
        int minRank = segment.minRank();
        return minRank < this.stopRank || minRank == this.stopRank && segment.generatedLevel() < this.stopLevel ? (Segment)this.atom[segment.isAtomic() || this.skipSons(segment) ? segment.maxRank() + 1 : minRank] : null;
    }

    @Override
    protected boolean findBackward(Segment segment) {
        Segment previousCandidate;
        do {
            if ((previousCandidate = this.backwardCandidate(segment)) != null) continue;
            this.found = null;
            return false;
        } while (this.skip(segment = this.nextToReturn(segment, previousCandidate)));
        this.found = segment;
        return true;
    }

    @Override
    protected Segment backwardCandidate(Segment segment) {
        int maxRank = segment.maxRank();
        return maxRank > this.stopRank || maxRank == this.stopRank && segment.generatedLevel() < this.stopLevel ? (Segment)this.atom[segment.isAtomic() || this.skipSons(segment) ? segment.minRank() - 1 : maxRank] : null;
    }

    protected boolean skip(Segment segment) {
        return this.filter.skip(segment);
    }

    protected boolean skipSons(Segment segment) {
        return this.filter.skipSons(segment);
    }
}

