/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.AtomicSegment;
import com.ibm.pdp.engine.turbo.core.AtomicSegmentIterator;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;

public class FilteredAtomicSegmentIterator
extends AtomicSegmentIterator {
    protected SegmentFilter filter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected FilteredAtomicSegmentIterator() {
    }

    protected FilteredAtomicSegmentIterator(Object[] atoms, Segment startSegment, boolean includeStartSegment, Segment stopSegment, boolean includeStopSegment, boolean reverseOrder, SegmentFilter segmentFilter) {
        super(atoms, startSegment, includeStartSegment, stopSegment, includeStopSegment, reverseOrder);
        this.filter = segmentFilter;
    }

    protected FilteredAtomicSegmentIterator(AtomicSegment[] atoms, int startRank, int stopRank, boolean reverseOrder, SegmentFilter segmentFilter) {
        super(atoms, startRank, stopRank, reverseOrder);
        this.filter = segmentFilter;
    }

    @Override
    protected boolean findForward() {
        while (this.nextRank <= this.endRank) {
            AtomicSegment nextSegment;
            if (!this.skip(nextSegment = (AtomicSegment)this.atom[this.nextRank++])) {
                this.found = nextSegment;
                return true;
            }
            Segment toSkip = nextSegment;
            Segment parent = toSkip.parent;
            while (parent != null && this.skipSons(parent)) {
                toSkip = parent;
                parent = parent.parent;
            }
            this.nextRank = ((Segment)toSkip).maxRank() + 1;
        }
        return false;
    }

    @Override
    protected boolean findBackward() {
        while (this.nextRank >= this.endRank) {
            AtomicSegment nextSegment;
            if (!this.skip(nextSegment = (AtomicSegment)this.atom[this.nextRank--])) {
                this.found = nextSegment;
                return true;
            }
            Segment toSkip = nextSegment;
            Segment parent = toSkip.parent;
            while (parent != null && this.skipSons(parent)) {
                toSkip = parent;
                parent = parent.parent;
            }
            this.nextRank = ((Segment)toSkip).minRank() - 1;
        }
        return false;
    }

    protected boolean skip(Segment segment) {
        return this.filter.skip(segment);
    }

    protected boolean skipSons(Segment segment) {
        return this.filter.skipSons(segment);
    }
}

