/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.extension.DefaultTextPartitioner;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.EditableTextPartition;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.IncrementalTextPartition;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.RandomBuilder;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.ints.IntSequence;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class EditableTextPartitionTest {
    protected static int testCount;
    protected static RandomBuilder random;
    protected static Formatter fmt;
    protected static final CharSequence initialText0;
    protected static final CharSequence initialText;
    protected static int checkCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        initialText0 = " Value0 Value1 Value2 Value3 Value4 Value5 Value6 Value7 Value8 Value9 Value10 Value11 Value12 Value13 Value14 Value15 Value16 Value17 Value18 Value19 Value20 Value21 Value22 Value23 Value24 Value25 Value26 Value27 Value28 Value29 Value30 Value31 SpaceChar CharExclam CharDoubleQuote CharSharp CharDollard CharPercent CharAnd CharQuote CharOpenParenthesis CharCloseParenthesis CharStar CharAdd CharComma CharMinus CharDot CharSlash Char0 Char1 Char2 Char3 Char4 Char5 Char6 Char7 Char8 Char9 CharColumn CharSemiColumn CharLowerThan CharEqual CharGreaterThan CharQuestionMark CharAt CharA CharB CharC CharD CharE CharF CharG CharH CharI CharJ CharK CharL CharM CharN CharO CharP CharQ CharR CharS CharT CharU CharV CharW CharX CharY CharZ CharOpenBracket Value92 CharCloseBracket CharPower CharUnderscore CharBackQuote Chara Charb Charc Chard Chare Charf Charg Charh Chari Charj Chark Charl Charm Charn Charo Charp Charq Charr Chars Chart Charu Charv Charw Charx Chary Charz ";
        initialText = " CharExclam CharSharp CharDollard CharPercent CharAnd CharQuote  CharOpenParenthesis CharCloseParenthesis CharStar CharAdd CharMinus CharDot CharSlash Char0 Char1 Char2 Char3 Char4 Char5 Char6 Char7 Char8 Char9 CharColumn CharSemiColumn CharLowerThan CharEqual CharGreaterThan CharQuestionMark CharAt CharA CharB CharC CharD CharE CharF CharG CharH CharI CharJ CharK CharL CharM CharN CharO CharP CharQ CharR CharS CharT CharU CharV CharW CharX CharY CharZ CharOpenBracket CharCloseBracket CharPower CharUnderscore Chara Charb Charc Chard Chare Charf Charg Charh Chari Charj Chark Charl Charm Charn Charo Charp Charq Charr Chars Chart Charu Charv Charw Charx Chary Charz ";
    }

    public static void main(String[] args) {
        long seed = System.currentTimeMillis();
        random = new RandomBuilder(seed);
        fmt = new Formatter(System.out);
        fmt.format("Start EditableTextPartitionTest seed=%dL\n", seed);
        testCount = 1;
        long time = System.currentTimeMillis();
        try {
            EditableTextPartitionTest.test(seed, 5);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        time = System.currentTimeMillis() - time;
        fmt.format("Stop EditableTextPartitionTest, %d checkings done in %d ms.\n", checkCount, time);
    }

    protected static void test(long seed, int testSize) {
        random.setSeed(seed);
        Dictionary dictionary = new Dictionary();
        BasicTextPartition initWordsPartition = new BasicTextPartition(dictionary, (ITextPartitioner)new DefaultTextPartitioner());
        initWordsPartition.setText(initialText0);
        initWordsPartition.getWords();
        CharSequence fullText = EditableTextPartitionTest.makeBigText(initialText, testSize);
        DefaultTextPartitioner partitioner = new DefaultTextPartitioner();
        IncrementalTextPartition basicPartition = new IncrementalTextPartition(dictionary, (ITextPartitioner)partitioner);
        basicPartition.setText(fullText);
        int wordCount1 = basicPartition.getWordsCount();
        int nbWords = dictionary.nbOfWord();
        int textLength = fullText.length();
        fmt.format("TextLength=%d, DistinctWords=%d, WordsCount=%d\n", textLength, nbWords, wordCount1);
        EditableTextPartition editablePartition = new EditableTextPartition(basicPartition);
        EditableTextPartitionTest.checkSamePartitions(basicPartition, editablePartition);
        EditableTextPartitionTest.testModify(basicPartition, editablePartition);
        EditableTextPartitionTest.checkSamePartitions(basicPartition.subTextPartition(0, textLength), editablePartition.subTextPartition(0, textLength));
        int i = 0;
        while (i < 10) {
            int beginIdx = random.nextInt(textLength + 1);
            int endIdx = random.nextInt(textLength + 1);
            if (endIdx < beginIdx) {
                int tmp = endIdx;
                endIdx = beginIdx;
                beginIdx = tmp;
            }
            ISubTextPartition subPart1 = basicPartition.subTextPartition(beginIdx, endIdx);
            ISubTextPartition subPart2 = editablePartition.subTextPartition(beginIdx, endIdx);
            EditableTextPartitionTest.checkSamePartitions(subPart1, subPart2);
            EditableTextPartition subPart1Copy = new EditableTextPartition(subPart1);
            EditableTextPartition subPart2Copy = new EditableTextPartition(subPart2);
            EditableTextPartitionTest.checkSamePartitions(subPart1Copy, subPart2Copy);
            EditableTextPartitionTest.testModify(subPart1, subPart1Copy);
            ++i;
        }
    }

    protected static void checkSamePartitions(ITextPartition partition1, ITextPartition partition2) {
        EditableTextPartitionTest.check(Strings.sameCharSequences((CharSequence)partition1.getText(), (CharSequence)partition2.getText()));
        EditableTextPartitionTest.check(Ints.sameIntSequences((IntSequence)partition1.getWords(), (IntSequence)partition2.getWords()));
        EditableTextPartitionTest.checkSameWords(partition1, partition2);
    }

    protected static void checkSameWords(ITextPartition partition1, ITextPartition partition2) {
        int wordCount2;
        int wordCount1 = partition1.getWordsCount();
        EditableTextPartitionTest.check(wordCount1 == (wordCount2 = partition2.getWordsCount()));
        IntSequence words1 = partition1.getWords();
        IntSequence words2 = partition2.getWords();
        int wordRank = 0;
        while (wordRank < wordCount1) {
            int wordId = words1.intAt(wordRank);
            EditableTextPartitionTest.check(wordId == words2.intAt(wordRank));
            int wordLength = partition1.wordLength(wordRank);
            EditableTextPartitionTest.check(partition2.wordLength(wordRank) == wordLength);
            int wordIdx = partition1.wordBeginIndex(wordRank);
            EditableTextPartitionTest.check(partition2.wordBeginIndex(wordRank) == wordIdx);
            int spaceBefore = partition1.spaceBeforeWord(wordRank);
            EditableTextPartitionTest.check(partition2.spaceBeforeWord(wordRank) == spaceBefore);
            int spaceAfter = partition1.spaceAfterWord(wordRank);
            EditableTextPartitionTest.check(partition2.spaceAfterWord(wordRank) == spaceAfter);
            int rank1 = partition1.wordRankFromIndex(wordIdx);
            EditableTextPartitionTest.check(rank1 == wordRank);
            int rank2 = partition2.wordRankFromIndex(wordIdx);
            EditableTextPartitionTest.check(rank2 == wordRank);
            if (wordIdx > 0) {
                rank1 = partition1.wordRankFromIndex(wordIdx - 1);
                EditableTextPartitionTest.check(rank1 < 0 ? ~rank1 == wordRank : rank1 == wordRank - 1);
                rank2 = partition2.wordRankFromIndex(wordIdx - 1);
                EditableTextPartitionTest.check(rank2 < 0 ? ~rank2 == wordRank : rank2 == wordRank - 1);
            }
            if (wordLength > 1) {
                rank1 = partition1.wordRankFromIndex(wordIdx + 1);
                EditableTextPartitionTest.check(rank1 == wordRank);
                rank2 = partition2.wordRankFromIndex(wordIdx + 1);
                EditableTextPartitionTest.check(rank2 == wordRank);
            }
            EditableTextPartitionTest.check((rank1 = partition1.wordRankFromIndex(wordIdx + wordLength)) < 0 ? ~rank1 == wordRank + 1 : rank1 == wordRank + 1);
            rank2 = partition2.wordRankFromIndex(wordIdx + wordLength);
            EditableTextPartitionTest.check(rank2 < 0 ? ~rank2 == wordRank + 1 : rank2 == wordRank + 1);
            ++wordRank;
        }
    }

    protected static void testModify(ITextPartition partition, EditableTextPartition editablePartition) {
        EditableTextPartition initialPartition = new EditableTextPartition(partition);
        ArrayList<TextInterval> deletedIntervals = new ArrayList<TextInterval>();
        int modifCount = 0;
        while (modifCount < 10) {
            int wordCount = partition.getWordsCount();
            if (wordCount == 0) break;
            int nbWordsToDelete = 1 + random.nextInt(wordCount);
            int deleteBeginRank = random.nextInt(1 + wordCount - nbWordsToDelete);
            int deleteEndRank = deleteBeginRank + nbWordsToDelete;
            int deleteBeginIdx = partition.wordBeginIndex(deleteBeginRank);
            int deleteEndIdx = partition.wordBeginIndex(deleteEndRank);
            HashSet<Word> deletedWords = new HashSet<Word>();
            int rank = deleteBeginRank;
            while (rank < deleteEndRank) {
                deletedWords.add(new Word(partition.wordIdAt(rank), partition.wordBeginIndex(rank), partition.wordEndIndex(rank)));
                ++rank;
            }
            CharSequence deletedText = editablePartition.getTextInterval(deleteBeginIdx, deleteEndIdx);
            TextInterval interval = new TextInterval(deletedText, deleteBeginIdx);
            interval.words = deletedWords;
            deletedIntervals.add(interval);
            partition.replaceText(deleteBeginIdx, deleteEndIdx, " ");
            editablePartition.replaceText(deleteBeginIdx, deleteEndIdx, " ");
            ++modifCount;
        }
        EditableTextPartitionTest.checkSamePartitions(partition, editablePartition);
        ListIterator intervals = deletedIntervals.listIterator(deletedIntervals.size());
        while (intervals.hasPrevious()) {
            TextInterval interval = (TextInterval)intervals.previous();
            partition.replaceText(interval.beginIdx, interval.beginIdx + 1, interval.text);
            editablePartition.replaceText(interval.beginIdx, interval.beginIdx + 1, interval.text);
            for (Word deletedWord : interval.words) {
                editablePartition.addWord(deletedWord.id, deletedWord.beginIdx, deletedWord.endIdx);
            }
        }
        EditableTextPartitionTest.checkSamePartitions(partition, initialPartition);
        EditableTextPartitionTest.checkSamePartitions(partition, editablePartition);
        EditableTextPartitionTest.checkSamePartitions(editablePartition, initialPartition);
    }

    protected static void check(boolean condition) {
        ++checkCount;
        if (!condition) {
            throw new RuntimeException("Wrong check #" + checkCount);
        }
    }

    protected static CharSequence makeBigText(CharSequence initial, int growthFactor) {
        StringBuilder builder = new StringBuilder(initial);
        int i = 0;
        while (i < growthFactor) {
            builder.append((CharSequence)builder);
            ++i;
        }
        return builder.toString();
    }

    protected static class TextInterval {
        protected CharSequence text;
        protected int beginIdx;
        protected Set<Word> words;

        protected TextInterval(CharSequence intervalText, int intervalBeginIdx) {
            this.text = intervalText;
            this.beginIdx = intervalBeginIdx;
        }
    }

    protected static class Word {
        protected int id;
        protected int beginIdx;
        protected int endIdx;

        protected Word(int wordId, int wordBeginIdx, int wordEndIdx) {
            this.id = wordId;
            this.beginIdx = wordBeginIdx;
            this.endIdx = wordEndIdx;
        }
    }
}

