/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.EditableSubTextPartition;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.PatchCharSequence;
import com.ibm.pdp.engine.turbo.core.WordSegment;
import com.ibm.pdp.util.containers.EditBuffer;
import com.ibm.pdp.util.ints.ArrayIntSequence;
import com.ibm.pdp.util.ints.IntSequence;
import com.ibm.pdp.util.ints.PatchIntSequence;

public class EditableTextPartition
implements ITextPartition {
    protected PatchCharSequence text;
    protected int nbSegment;
    protected int segmentHoleIdx;
    protected WordSegment[] segments;
    protected int gapBeginRank;
    protected int indexGap;
    protected PatchIntSequence words;
    protected int minWordId;
    protected int maxWordId;
    protected int modCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public EditableTextPartition() {
        this.text = new PatchCharSequence();
        this.segments = new WordSegment[4];
        this.maxWordId = -1;
    }

    public EditableTextPartition(ITextPartition partitionToCopy) {
        this.text = new PatchCharSequence(partitionToCopy.getText());
        this.segments = new WordSegment[partitionToCopy.getWordsCount()];
        this.maxWordId = -1;
        this.copyWords(partitionToCopy);
    }

    protected void copyWords(ITextPartition fromPartition) {
        int nbWord = fromPartition.getWordsCount();
        int wordRank = 0;
        while (wordRank < nbWord) {
            this.addWord(fromPartition.wordIdAt(wordRank), fromPartition.wordBeginIndex(wordRank), fromPartition.wordEndIndex(wordRank));
            ++wordRank;
        }
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public CharSequence getText() {
        return this.text.getText();
    }

    @Override
    public CharSequence getTextInterval(int beginIdx, int endIdx) {
        return this.text.getTextInterval(beginIdx, endIdx);
    }

    @Override
    public int getTextLength() {
        return this.text.length();
    }

    @Override
    public IntSequence getWords() {
        if (this.words == null) {
            this.words = this.buildWords();
        }
        return this.words;
    }

    protected PatchIntSequence buildWords() {
        int[] wordSequence = new int[this.nbSegment];
        int rank = 0;
        while (rank < this.nbSegment) {
            wordSequence[rank] = this.wordSegmentAt((int)rank).id;
            ++rank;
        }
        return new PatchIntSequence((IntSequence)new ArrayIntSequence(wordSequence));
    }

    @Override
    public int getWordsCount() {
        return this.nbSegment;
    }

    @Override
    public IntSequence getWordsInterval(int beginWordRank, int endWordRank) {
        if (this.words == null) {
            this.words = this.buildWords();
        }
        return this.words.getTextInterval(beginWordRank, endWordRank);
    }

    @Override
    public int maxWordId() {
        return this.maxWordId;
    }

    @Override
    public int minWordId() {
        return this.minWordId;
    }

    @Override
    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        int shift;
        this.text.replace(beginIdx, endIdx, newText);
        WordsInterval wordsToDelete = this.newWordsInterval(0, this.nbSegment);
        if (this.wordsIntersecting(beginIdx, endIdx, wordsToDelete) > 0) {
            this.deleteWordSegments(wordsToDelete.beginWordRank, wordsToDelete.endWordRank);
        }
        if ((shift = newText.length() - endIdx + beginIdx) != 0 && wordsToDelete.beginWordRank != this.nbSegment) {
            this.moveGapBeginRank(wordsToDelete.beginWordRank);
            this.incrementIndexGap(shift);
        }
        ++this.modCount;
    }

    @Override
    public void setText(CharSequence newText) {
        this.text.setText(newText);
        this.deleteAllWordSegments();
        ++this.modCount;
    }

    @Override
    public int spaceAfterWord(int wordRank) {
        return this.wordBeginIndex(wordRank + 1) - this.wordEndIndex(wordRank);
    }

    @Override
    public int spaceBeforeWord(int wordRank) {
        return this.wordBeginIndex(wordRank) - this.wordEndIndex(wordRank - 1);
    }

    @Override
    public ISubTextPartition subTextPartition(int beginIdx, int endIdx) {
        return new EditableSubTextPartition(this, beginIdx, endIdx);
    }

    @Override
    public int wordBeginIndex(int wordRank) {
        if (wordRank == this.nbSegment) {
            return this.text.length();
        }
        return this.correctedIndex(wordRank, this.wordSegmentAt((int)wordRank).beginIdx);
    }

    @Override
    public int wordEndIndex(int wordRank) {
        if (wordRank == -1) {
            return 0;
        }
        return this.correctedIndex(wordRank, this.wordSegmentAt((int)wordRank).endIdx);
    }

    protected int correctedIndex(int wordRank, int index) {
        return wordRank < this.gapBeginRank ? index : index + this.indexGap;
    }

    @Override
    public int wordIdAt(int wordRank) {
        return this.wordSegmentAt((int)wordRank).id;
    }

    @Override
    public int wordLength(int wordRank) {
        WordSegment s = this.wordSegmentAt(wordRank);
        return s.endIdx - s.beginIdx;
    }

    @Override
    public int wordRankFromIndex(int index) {
        return this.wordRankAtIndex(index, 0, this.nbSegment - 1);
    }

    public int addWord(int id, int beginIndex, int endIndex) {
        if (beginIndex >= endIndex) {
            throw new RuntimeException("Length of word must be greater than 0");
        }
        WordsInterval wordsToDelete = this.newWordsInterval(0, this.nbSegment);
        int nbWordToDelete = this.wordsIntersecting(beginIndex, endIndex, wordsToDelete);
        int wordRank = wordsToDelete.beginWordRank;
        if (nbWordToDelete > 0) {
            this.deleteWordSegments(wordRank, wordsToDelete.endWordRank);
        }
        WordSegment newWordSegment = this.newWordSegment(id, beginIndex, endIndex);
        this.insertWordSegment(wordRank, newWordSegment);
        if (id > this.maxWordId) {
            this.maxWordId = id;
        }
        if (id < this.minWordId) {
            this.minWordId = id;
        }
        ++this.modCount;
        return wordRank;
    }

    public void deleteWord(int wordRank) {
        this.deleteWordSegment(wordRank);
        ++this.modCount;
    }

    public void deleteWords(int beginWordRank, int endWordRank) {
        this.deleteWordSegments(beginWordRank, endWordRank);
        ++this.modCount;
    }

    public void deleteAllWords() {
        this.deleteAllWordSegments();
        ++this.modCount;
    }

    protected WordSegment newWordSegment(int id, int beginIdx, int endIdx) {
        return new WordSegment(id, beginIdx, endIdx);
    }

    protected WordSegment wordSegmentAt(int wordRank) {
        return (WordSegment)EditBuffer.getElementAt((Object[])this.segments, (int)this.segmentHoleIdx, (int)this.nbSegment, (int)wordRank);
    }

    protected void insertWordSegment(int wordRank, WordSegment segment) {
        this.segments = (WordSegment[])EditBuffer.insert((Object[])this.segments, (int)this.segmentHoleIdx, (int)this.nbSegment, (int)wordRank, (int)1);
        this.segments[wordRank] = segment;
        this.segmentHoleIdx = wordRank + 1;
        ++this.nbSegment;
        if (wordRank > this.gapBeginRank) {
            segment.beginIdx -= this.indexGap;
            segment.endIdx -= this.indexGap;
        } else {
            this.setIndexGap(this.gapBeginRank + 1, this.indexGap);
        }
        if (this.words != null) {
            this.words.insert(wordRank, segment.id);
        }
    }

    protected void deleteWordSegment(int wordRank) {
        this.segments = (WordSegment[])EditBuffer.delete((Object[])this.segments, (int)this.segmentHoleIdx, (int)this.nbSegment, (int)wordRank, (int)1);
        this.segmentHoleIdx = wordRank;
        --this.nbSegment;
        if (wordRank < this.gapBeginRank) {
            this.setIndexGap(this.gapBeginRank - 1, this.indexGap);
        }
        if (this.words != null) {
            if (this.nbSegment > 0) {
                this.words.delete(wordRank);
            } else {
                this.words = null;
            }
        }
    }

    protected void deleteWordSegments(int beginWordRank, int endWordRank) {
        int toDelete = endWordRank - beginWordRank;
        this.segments = (WordSegment[])EditBuffer.delete((Object[])this.segments, (int)this.segmentHoleIdx, (int)this.nbSegment, (int)beginWordRank, (int)toDelete);
        this.segmentHoleIdx = beginWordRank;
        this.nbSegment -= toDelete;
        if (endWordRank <= this.gapBeginRank) {
            this.setIndexGap(this.gapBeginRank - toDelete, this.indexGap);
        } else if (beginWordRank <= this.gapBeginRank) {
            this.setIndexGap(beginWordRank, this.indexGap);
        }
        if (this.words != null) {
            if (this.nbSegment > 0) {
                this.words.delete(beginWordRank, endWordRank);
            } else {
                this.words = null;
            }
        }
    }

    protected void deleteAllWordSegments() {
        this.segments = (WordSegment[])EditBuffer.delete((Object[])this.segments, (int)this.segmentHoleIdx, (int)this.nbSegment, (int)0, (int)this.nbSegment);
        this.nbSegment = 0;
        this.segmentHoleIdx = 0;
        this.clearIndexGap();
        this.words = null;
    }

    protected int wordRankAtIndex(int index, int low, int high) {
        while (low <= high) {
            int middleRank = low + high >> 1;
            WordSegment middleSegment = this.wordSegmentAt(middleRank);
            if (index < this.correctedIndex(middleRank, middleSegment.beginIdx)) {
                high = middleRank - 1;
                continue;
            }
            if (index >= this.correctedIndex(middleRank, middleSegment.endIdx)) {
                low = middleRank + 1;
                continue;
            }
            return middleRank;
        }
        return ~low;
    }

    protected WordsInterval newWordsInterval(int beginWordRank, int endWordRank) {
        return new WordsInterval(beginWordRank, endWordRank);
    }

    protected int wordsIntersecting(int beginIdx, int endIdx, WordsInterval interval) {
        int low = interval.beginWordRank;
        int high = interval.endWordRank - 1;
        while (low <= high) {
            int middle = low + high >> 1;
            WordSegment middleSegment = this.wordSegmentAt(middle);
            if (this.correctedIndex(middle, middleSegment.endIdx) <= beginIdx) {
                low = middle + 1;
                continue;
            }
            if (this.correctedIndex(middle, middleSegment.beginIdx) >= endIdx) {
                high = middle - 1;
                continue;
            }
            low = this.wordRankAtIndex(beginIdx, low, middle);
            high = this.wordRankAtIndex(endIdx, middle, high);
            int n = interval.beginWordRank = low < 0 ? ~low : low;
            interval.endWordRank = high < 0 ? ~high : (this.wordBeginIndex(high) == endIdx ? high : high + 1);
            return interval.endWordRank - interval.beginWordRank;
        }
        interval.beginWordRank = interval.endWordRank = low;
        return 0;
    }

    protected void clearIndexGap() {
        this.gapBeginRank = this.nbSegment;
        this.indexGap = 0;
    }

    protected void setIndexGap(int newGapBeginRank, int newIndexGap) {
        if (newGapBeginRank == this.nbSegment || newIndexGap == 0) {
            this.gapBeginRank = this.nbSegment;
            this.indexGap = 0;
        } else {
            this.gapBeginRank = newGapBeginRank;
            this.indexGap = newIndexGap;
        }
    }

    protected void incrementIndexGap(int indexGapIncrement) {
        this.setIndexGap(this.gapBeginRank, this.indexGap + indexGapIncrement);
    }

    protected void moveGapBeginRank(int newGapBeginRank) {
        int gap = this.indexGap;
        if (gap != 0) {
            int rank = this.gapBeginRank;
            if (rank < newGapBeginRank) {
                do {
                    this.shiftWord(rank++, gap);
                } while (rank < newGapBeginRank);
            } else if (rank > newGapBeginRank) {
                gap = -gap;
                do {
                    this.shiftWord(--rank, gap);
                } while (rank > newGapBeginRank);
            }
        }
        this.gapBeginRank = newGapBeginRank;
    }

    protected void shiftWord(int wordRank, int idxShift) {
        WordSegment wordSegment = this.wordSegmentAt(wordRank);
        wordSegment.beginIdx += idxShift;
        wordSegment.endIdx += idxShift;
    }

    protected static class WordsInterval {
        protected int beginWordRank;
        protected int endWordRank;

        protected WordsInterval(int begin, int end) {
            this.beginWordRank = begin;
            this.endWordRank = end;
        }
    }
}

