/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.engine.turbo.core.AppendedDictionary;
import com.ibm.pdp.engine.turbo.core.IWord;
import com.ibm.pdp.engine.turbo.core.SharedWord;
import com.ibm.pdp.engine.turbo.core.Word;
import java.util.NoSuchElementException;

public class Dictionary {
    protected int nbWord;
    protected Word[] wordsById;
    protected SharedWord[] wordsByHash;
    protected int minCategory;
    protected int maxCategory;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public int nbOfWord() {
        return this.nbWord;
    }

    public int getMinWordCategory() {
        return this.minCategory;
    }

    public int getMaxWordCategory() {
        return this.maxCategory;
    }

    public boolean isWordDefined(int wordId) {
        return wordId < this.nbWord;
    }

    public IWord getWordFromId(int wordId) {
        if (wordId >= this.nbWord) {
            throw new NoSuchElementException("Wrong word id");
        }
        return this.wordsById[wordId];
    }

    public int wordLength(int wordId) {
        if (wordId >= this.nbWord) {
            throw new NoSuchElementException("Wrong word id");
        }
        return this.wordsById[wordId].length();
    }

    public IWord getWord(CharSequence text, TextToken token) {
        if (this.nbWord == 0) {
            return null;
        }
        SharedWord word = this.wordsByHash[this.indexFromHashCode(token.hash, this.wordsByHash.length)];
        while (word != null) {
            if (token.match(text, word.category, word.ignoreCase, word.hash, (CharSequence)word)) {
                return word;
            }
            word = word.next;
        }
        return null;
    }

    public IWord addWord(CharSequence text, TextToken token) {
        IWord word = this.getWord(text, token);
        return word == null ? this.addNewWord(text, token) : word;
    }

    public Dictionary newAppendedDictionary() {
        return new AppendedDictionary(this);
    }

    protected SharedWord addNewWord(CharSequence text, TextToken token) {
        int newWordId = this.newWordId();
        SharedWord newWord = this.newWord(newWordId, text, token);
        this.insertNewWord(newWord);
        return newWord;
    }

    protected int newWordId() {
        int newWordId = this.nbOfWord();
        return newWordId;
    }

    protected SharedWord newWord(int newWordId, CharSequence text, TextToken token) {
        char[] chars;
        if (text != null) {
            int startIdx = token.beginIdx;
            int wordLength = token.endIdx - startIdx;
            chars = new char[wordLength];
            int i = 0;
            while (i < wordLength) {
                chars[i] = text.charAt(startIdx + i);
                ++i;
            }
        } else {
            chars = null;
        }
        return new SharedWord(newWordId, token.category, token.ignoreCase, token.hash, chars);
    }

    protected void insertNewWord(SharedWord newWord) {
        int category = newWord.category;
        if (category < this.minCategory) {
            this.minCategory = category;
        }
        if (category > this.maxCategory) {
            this.maxCategory = category;
        }
        this.resizeTableIfNecessary();
        int tableIdx = this.indexFromHashCode(newWord.hash, this.wordsByHash.length);
        newWord.next = this.wordsByHash[tableIdx];
        this.wordsByHash[tableIdx] = newWord;
        if (this.wordsById == null) {
            this.wordsById = new SharedWord[8];
        } else if (this.wordsById.length == this.nbWord) {
            SharedWord[] newWordsById = new SharedWord[this.nbWord + (this.nbWord >> 4) + 8];
            System.arraycopy(this.wordsById, 0, newWordsById, 0, this.nbWord);
            this.wordsById = newWordsById;
        }
        this.wordsById[this.nbWord++] = newWord;
    }

    protected int indexFromHashCode(int h, int sup) {
        return h >= 0 ? h % sup : sup + h % sup - 1;
    }

    protected void resizeTableIfNecessary() {
        if (this.wordsByHash == null) {
            this.wordsByHash = new SharedWord[11];
            return;
        }
        int length = this.wordsByHash.length;
        if (this.nbWord < 3 * (length >> 2)) {
            return;
        }
        this.resizeWordTable(1 + length << 1);
    }

    protected void resizeWordTable(int newLength) {
        SharedWord[] table = this.wordsByHash;
        int length = table.length;
        SharedWord[] newTable = new SharedWord[newLength];
        int idx = 0;
        while (idx < length) {
            SharedWord word = table[idx];
            while (word != null) {
                SharedWord nextWord = word.next;
                int newIdx = this.indexFromHashCode(word.hash, newLength);
                word.next = newTable[newIdx];
                newTable[newIdx] = word;
                word = nextWord;
            }
            ++idx;
        }
        this.wordsByHash = newTable;
    }
}

