/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.DetailNodesBits32;
import com.ibm.pdp.util.diff.DifferenceNature;

public class DetailedChangesBits32
implements IDetailedChanges {
    protected int[] details;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailedChangesBits32(int nbOfDifferences) {
        this.details = this.newIntArray(nbOfDifferences);
        this.setNbOfDifferences(nbOfDifferences);
    }

    @Override
    public int getNbOfDifferences() {
        return this.details[0];
    }

    protected void setNbOfDifferences(int nbOfDifferences) {
        this.details[0] = nbOfDifferences;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.details[1 + (diffRank << 2)];
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.details[1 + (diffRank << 2)] = modifiedBeginIndex;
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.details[2 + (diffRank << 2)];
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.details[2 + (diffRank << 2)] = modifiedEndIndex;
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.details[3 + (diffRank << 2)];
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.details[3 + (diffRank << 2)] = referenceBeginIndex;
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.details[4 + (diffRank << 2)];
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.details[4 + (diffRank << 2)] = referenceEndIndex;
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifferenceKind(diffRank, diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifferenceKind(diffRank));
    }

    protected int[] newIntArray(int nbOfChanges) {
        return new int[nbOfChanges + (nbOfChanges << 2) + (15 + nbOfChanges >> 4)];
    }

    protected int getDifferenceKind(int diffRank) {
        int nbOfDifferences = this.getNbOfDifferences();
        return this.details[(nbOfDifferences << 2) + (15 + nbOfDifferences >> 4) + diffRank];
    }

    protected void setDifferenceKind(int diffRank, int difference) {
        int nbOfDifferences = this.getNbOfDifferences();
        this.details[(nbOfDifferences << 2) + (15 + nbOfDifferences >> 4) + diffRank] = difference;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        DetailNodesBits32 node = new DetailNodesBits32(segment, this.details);
        segment.setDetailedChanges(node);
        return node.textNode(segment, diffRank);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Segment.appendDetails(this, builder);
        return builder.toString();
    }
}

