/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.DetailNodesBits16;
import com.ibm.pdp.util.diff.DifferenceNature;

public class DetailedChangesBits16
implements IDetailedChanges {
    protected static final int LowMask = 65535;
    protected static final int HighMask = -65536;
    protected static final int IndexShift = 16;
    protected int[] details;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailedChangesBits16(int nbOfDifferences) {
        this.details = this.newIntArray(nbOfDifferences);
        this.setNbOfDifferences(nbOfDifferences);
    }

    @Override
    public int getNbOfDifferences() {
        return this.getShortAt(0);
    }

    protected void setNbOfDifferences(int nbOfDifferences) {
        this.setShortAt(0, nbOfDifferences);
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.getShortAt(1 + (diffRank << 2));
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.setShortAt(1 + (diffRank << 2), modifiedBeginIndex);
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.getShortAt(2 + (diffRank << 2));
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.setShortAt(2 + (diffRank << 2), modifiedEndIndex);
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.getShortAt(3 + (diffRank << 2));
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.setShortAt(3 + (diffRank << 2), referenceBeginIndex);
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.getShortAt(4 + (diffRank << 2));
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.setShortAt(4 + (diffRank << 2), referenceEndIndex);
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifference(diffRank));
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifference(diffRank, diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifference(diffRank));
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifference(diffRank));
    }

    protected int[] newIntArray(int nbOfChanges) {
        int nbOfBitPairs = 8 + (nbOfChanges << 5) + nbOfChanges;
        return new int[15 + nbOfBitPairs >> 4];
    }

    protected int getShortAt(int shortRank) {
        return shortRank % 2 == 0 ? this.details[shortRank >> 1] & 0xFFFF : this.details[shortRank >> 1] >>> 16;
    }

    protected void setShortAt(int shortRank, int shortValue) {
        int idx = shortRank >> 1;
        this.details[idx] = shortRank % 2 == 0 ? this.details[idx] & 0xFFFF0000 | shortValue : this.details[idx] & 0xFFFF | shortValue << 16;
    }

    protected int getDifference(int diffRank) {
        int nbOfDifferences = this.getNbOfDifferences();
        return this.getBitPairAt(diffRank + (nbOfDifferences << 5) + 8);
    }

    protected void setDifference(int diffRank, int difference) {
        int nbOfDifferences = this.getNbOfDifferences();
        this.setBitPairAt(diffRank + (nbOfDifferences << 5) + 8, difference);
    }

    protected int getBitPairAt(int bitPairRank) {
        return this.details[bitPairRank >> 4] >> (bitPairRank % 16 << 1) & 3;
    }

    protected void setBitPairAt(int bitPairRank, int bitPairValue) {
        int idx = bitPairRank >> 4;
        int shift = bitPairRank % 16 << 1;
        int mask = ~(3 << shift);
        this.details[idx] = this.details[idx] & mask | bitPairValue << shift;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        DetailNodesBits16 node = new DetailNodesBits16(segment, this.details);
        segment.setDetailedChanges(node);
        return node.textNode(segment, diffRank);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Segment.appendDetails(this, builder);
        return builder.toString();
    }
}

