/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.DetailNodes2Bits3;
import com.ibm.pdp.util.diff.DifferenceNature;

public class DetailedChanges2Bits3
implements IDetailedChanges {
    protected int details;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public int getNbOfDifferences() {
        return 2;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.getTripleBitAt(diffRank << 2);
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.setTripleBitAt(diffRank << 2, modifiedBeginIndex);
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.getTripleBitAt(1 + (diffRank << 2));
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.setTripleBitAt(1 + (diffRank << 2), modifiedEndIndex);
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.getTripleBitAt(2 + (diffRank << 2));
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.setTripleBitAt(2 + (diffRank << 2), referenceBeginIndex);
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.getTripleBitAt(3 + (diffRank << 2));
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.setTripleBitAt(3 + (diffRank << 2), referenceEndIndex);
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifferenceKind(diffRank, diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifferenceKind(diffRank));
    }

    protected int getDifferenceKind(int diffRank) {
        int shift = 24 + (diffRank << 1);
        return this.details >> shift & 3;
    }

    protected void setDifferenceKind(int diffRank, int difference) {
        int shift = 24 + (diffRank << 1);
        int mask = ~(3 << shift);
        this.details = this.details & mask | difference << shift;
    }

    protected int getTripleBitAt(int tripleBitRank) {
        return this.details >> tripleBitRank * 3 & 7;
    }

    protected void setTripleBitAt(int tripleBitRank, int tripleBitValue) {
        int shift = tripleBitRank * 3;
        int mask = ~(7 << shift);
        this.details = this.details & mask | tripleBitValue << shift;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        DetailNodes2Bits3 node = new DetailNodes2Bits3(segment, this.details);
        segment.setDetailedChanges(node);
        return node.textNode(segment, diffRank);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Segment.appendDetails(this, builder);
        return builder.toString();
    }
}

