/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.DetailNodeBits7;
import com.ibm.pdp.util.diff.DifferenceNature;

public class DetailedChangeBits7
implements IDetailedChanges {
    protected int details;
    protected static final int Mask = -805306369;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public int getNbOfDifferences() {
        return 1;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.getSevenBitAt(0);
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.setSevenBitAt(0, modifiedBeginIndex);
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.getSevenBitAt(1);
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.setSevenBitAt(1, modifiedEndIndex);
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.getSevenBitAt(2);
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.setSevenBitAt(2, referenceBeginIndex);
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.getSevenBitAt(3);
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.setSevenBitAt(3, referenceEndIndex);
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifferenceKind());
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifferenceKind(diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifferenceKind());
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifferenceKind());
    }

    protected int getDifferenceKind() {
        return this.details >> 28;
    }

    protected void setDifferenceKind(int difference) {
        this.details = this.details & 0xCFFFFFFF | difference << 28;
    }

    protected int getSevenBitAt(int sevenBitRank) {
        return this.details >> sevenBitRank * 7 & 0x7F;
    }

    protected void setSevenBitAt(int sevenBitRank, int sevenBitValue) {
        int shift = sevenBitRank * 7;
        int mask = ~(127 << shift);
        this.details = this.details & mask | sevenBitValue << shift;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        DetailNodeBits7 node = new DetailNodeBits7(segment, this.details);
        segment.setDetailedChanges(node);
        return node;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Segment.appendDetails(this, builder);
        return builder.toString();
    }
}

