/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.DetailNodeBits16;
import com.ibm.pdp.util.diff.DifferenceNature;

public class DetailedChangeBits16
implements IDetailedChanges {
    protected static final int LowMask = 65535;
    protected static final int HighMask = -65536;
    protected int modified;
    protected int reference;
    protected DifferenceNature nature;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public int getNbOfDifferences() {
        return 1;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.modified & 0xFFFF;
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.modified = this.modified & 0xFFFF0000 | modifiedBeginIndex;
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.modified >>> 16;
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.modified = this.modified & 0xFFFF | modifiedEndIndex << 16;
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.reference & 0xFFFF;
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.reference = this.reference & 0xFFFF0000 | referenceBeginIndex;
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.reference >>> 16;
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.reference = this.reference & 0xFFFF | referenceEndIndex << 16;
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return this.nature;
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.nature = diffNature;
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.nature.ordinal());
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.nature.ordinal());
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        DetailNodeBits16 node = new DetailNodeBits16(segment, this.modified, this.reference, this.nature);
        segment.setDetailedChanges(node);
        return node;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Segment.appendDetails(this, builder);
        return builder.toString();
    }
}

