/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.turbo.core.GeneratedChangePosition;
import com.ibm.pdp.engine.turbo.core.GeneratedInfoChange;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import java.util.ArrayList;
import java.util.List;

public class BeginTagAtIndexIntoTag
extends GeneratedInfoChange {
    protected int index;
    protected String tagToOpen;
    protected String includingTag;
    protected List<String> properties;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public BeginTagAtIndexIntoTag(int index, String tagToOpen, String includingTag) {
        this.index = index;
        this.tagToOpen = tagToOpen;
        this.includingTag = includingTag;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(name);
        this.properties.add(value);
    }

    @Override
    public GeneratedChangePosition getPosition() {
        return GeneratedChangePosition.TEXT_CONVERT;
    }

    @Override
    public boolean acceptTagName(String tagName) {
        return this.includingTag.equals(tagName);
    }

    @Override
    public TagConversionMode tagConversionMode(String tagName) {
        return null;
    }

    @Override
    public int beginIndex() {
        return this.index;
    }

    @Override
    public int endIndex() {
        return this.index;
    }

    @Override
    public boolean acceptInterval(int beginIdx, int endIdx) {
        return this.index >= beginIdx && this.index <= endIdx;
    }

    @Override
    public boolean process(IGeneratedInfoFactory factory) {
        factory.beginTag(this.tagToOpen);
        int p = 0;
        while (p < this.properties.size()) {
            factory.setProperty(this.properties.get(p), this.properties.get(p + 1));
            p += 2;
        }
        return false;
    }

    public String toString() {
        return "At index " + this.index + ", open tag " + this.tagToOpen + "\n";
    }
}

