/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.engine.turbo.core.BasicSubTextPartition;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.IWord;
import com.ibm.pdp.util.ints.ArrayIntSequence;
import com.ibm.pdp.util.ints.IntSequence;
import java.util.Arrays;

public class BasicTextPartition
implements ITextPartition {
    protected int modCount;
    protected ITextPartitioner partitioner;
    protected Dictionary dictionary;
    protected CharSequence text;
    protected IntSequence words;
    protected int[] wordIdx;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public BasicTextPartition() {
    }

    public BasicTextPartition(Dictionary dict, ITextPartitioner part) {
        this.dictionary = dict;
        this.partitioner = part;
        this.text = "";
        this.partitioner.setText(this.text);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public ITextPartitioner getTextPartitioner() {
        return this.partitioner;
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    public void setDictionary(Dictionary newDictionary) {
        this.clearWords();
        this.dictionary = newDictionary;
    }

    public void setTextPartitioner(ITextPartitioner newPartitioner) {
        this.clearWords();
        this.partitioner = newPartitioner;
        newPartitioner.setText(this.text);
    }

    @Override
    public void setText(CharSequence newText) {
        ++this.modCount;
        this.clearWords();
        this.text = newText;
        if (this.partitioner != null) {
            this.partitioner.setText(newText);
        }
    }

    @Override
    public int getTextLength() {
        return this.text.length();
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public CharSequence getTextInterval(int beginIdx, int endIdx) {
        return this.text.subSequence(beginIdx, endIdx);
    }

    @Override
    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        ++this.modCount;
        int textLength = this.text.length();
        int nbRemoved = endIdx - beginIdx;
        int nbAdded = newText.length();
        StringBuilder builder = new StringBuilder(textLength - nbRemoved + nbAdded);
        builder.append(this.text, 0, beginIdx);
        builder.append(newText);
        builder.append(this.text, endIdx, textLength);
        this.setText(builder.toString());
    }

    @Override
    public int getWordsCount() {
        if (this.words == null) {
            this.computeWords();
        }
        return this.words.length();
    }

    @Override
    public IntSequence getWords() {
        if (this.words == null) {
            this.computeWords();
        }
        return this.words;
    }

    @Override
    public int wordIdAt(int rank) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.words.intAt(rank);
    }

    @Override
    public IntSequence getWordsInterval(int beginWordRank, int endWordRank) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.words.subSequence(beginWordRank, endWordRank);
    }

    @Override
    public int wordBeginIndex(int wordRank) {
        if (this.words == null) {
            this.computeWords();
        }
        return wordRank == this.words.length() ? this.text.length() : this.wordBeginIdx(wordRank);
    }

    @Override
    public int wordEndIndex(int wordRank) {
        if (this.words == null) {
            this.computeWords();
        }
        if (wordRank == -1) {
            return 0;
        }
        return this.wordEndIdx(wordRank);
    }

    @Override
    public int wordLength(int wordRank) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.wordEndIdx(wordRank) - this.wordBeginIdx(wordRank);
    }

    @Override
    public int spaceBeforeWord(int wordRank) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.spaceBefore(wordRank);
    }

    @Override
    public int spaceAfterWord(int wordRank) {
        return this.spaceBeforeWord(wordRank + 1);
    }

    @Override
    public int wordRankFromIndex(int index) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.wordAtIndex(index);
    }

    protected int wordRankFromIndex(int index, int low, int high) {
        if (this.words == null) {
            this.computeWords();
        }
        return this.wordAtIndex(index, low, high);
    }

    @Override
    public int minWordId() {
        return 0;
    }

    @Override
    public int maxWordId() {
        return (char)(this.dictionary.nbOfWord() - 1);
    }

    @Override
    public ISubTextPartition subTextPartition(int beginIdx, int endIdx) {
        if (beginIdx < 0 || beginIdx > endIdx || endIdx > this.text.length()) {
            throw new IndexOutOfBoundsException("Wrong indexes interval");
        }
        return new BasicSubTextPartition(this, beginIdx, endIdx);
    }

    protected void computeWords() {
        int initialNbOfWord = this.text.length() >> 6;
        int[] wordSequence = new int[initialNbOfWord];
        int[] wordIndexes = new int[initialNbOfWord << 1];
        int wordCount = 0;
        TextToken token = this.partitioner.newToken();
        while (this.partitioner.nextToken(token)) {
            IWord word = this.dictionary.addWord(this.text, token);
            if (wordSequence.length == wordCount) {
                wordSequence = Arrays.copyOf(wordSequence, wordCount + (wordCount >> 4) + 4);
                wordIndexes = Arrays.copyOf(wordIndexes, wordSequence.length << 1);
            }
            wordIndexes[wordCount << 1] = token.beginIdx;
            wordIndexes[1 + (wordCount << 1)] = token.endIdx;
            wordSequence[wordCount++] = word.getId();
        }
        if (wordSequence.length > wordCount) {
            this.words = new ArrayIntSequence(Arrays.copyOf(wordSequence, wordCount));
            this.wordIdx = Arrays.copyOf(wordIndexes, wordCount << 1);
        } else {
            this.words = new ArrayIntSequence(wordSequence);
            this.wordIdx = wordIndexes;
        }
    }

    protected int wordId(int wordRank) {
        return this.words.intAt(wordRank);
    }

    protected IWord word(int wordRank) {
        return this.dictionary.getWordFromId(this.words.intAt(wordRank));
    }

    protected int wordBeginIdx(int wordRank) {
        return this.wordIdx[wordRank << 1];
    }

    protected int wordEndIdx(int wordRank) {
        return this.wordIdx[1 + (wordRank << 1)];
    }

    protected int spaceBefore(int wordRank) {
        int fromIdx = wordRank == 0 ? 0 : this.wordEndIdx(wordRank - 1);
        int toIdx = wordRank == this.words.length() ? this.text.length() : this.wordBeginIdx(wordRank);
        return toIdx - fromIdx;
    }

    protected void clearWords() {
        this.words = null;
        this.wordIdx = null;
    }

    protected int wordAtIndex(int index) {
        return this.wordAtIndex(index, 0, this.words.length() - 1);
    }

    protected int wordAtIndex(int index, int low, int high) {
        while (low <= high) {
            int middle = low + high >> 1;
            if (index < this.wordBeginIdx(middle)) {
                high = middle - 1;
                continue;
            }
            if (index >= this.wordEndIdx(middle)) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return ~low;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int idx = 0;
        int nbWord = this.getWordsCount();
        int rank = 0;
        while (rank < nbWord) {
            int nextWordIdx = this.wordBeginIndex(rank);
            if (nextWordIdx > idx) {
                builder.append(this.text, idx, nextWordIdx);
            }
            idx = this.wordEndIdx(rank);
            builder.append('[');
            builder.append(this.text, nextWordIdx, idx);
            builder.append(']');
            ++rank;
        }
        if (idx < this.text.length()) {
            builder.append(this.text, idx, this.text.length());
        }
        return builder.toString();
    }
}

