/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.AtomicSegment;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import java.util.Iterator;

public class AtomicTagSegment
extends AtomicSegment {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TagProperties properties;
    protected IGeneratedTag tag;
    protected Segment[] subSegments;

    protected AtomicTagSegment() {
    }

    protected AtomicTagSegment(UserChangeSet userChangeSet, IGeneratedTag generatedTag) {
        super(userChangeSet);
        this.tag = generatedTag;
        this.beginIdx = this.tag.getBeginIndex();
    }

    protected AtomicTagSegment(UserChangeSet userChangeSet, HierarchicSegment parentSegment, IGeneratedTag generatedTag) {
        super(userChangeSet, parentSegment);
        this.tag = generatedTag;
        this.beginIdx = this.tag.getBeginIndex();
    }

    @Override
    public TagProperties getTagProperties() {
        if (this.properties == null) {
            this.properties = this.newTagProperties();
        }
        return this.properties;
    }

    protected TagProperties newTagProperties() {
        return new TagProperties((Segment)this, this.tag);
    }

    @Override
    public boolean isTagged() {
        return true;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public boolean isFirstPart() {
        return false;
    }

    @Override
    public boolean isMiddlePart() {
        return false;
    }

    @Override
    public boolean isLastPart() {
        return false;
    }

    @Override
    public Segment previousBrother() {
        return this.changeSet.getAtomAt(this.rank - 1);
    }

    @Override
    public Segment nextBrother() {
        return this.changeSet.getAtomAt(this.rank + 1);
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return this.tag;
    }

    @Override
    public IGeneratedTag fromTag() {
        return this.tag;
    }

    @Override
    public IGeneratedTag toTag() {
        return this.tag;
    }

    @Override
    public String fromTagName() {
        return this.tag.getName();
    }

    @Override
    public String toTagName() {
        return this.tag.getName();
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public Segment enclosingSegment() {
        if (this.enclosing.dirtySubSegments()) {
            this.computeEnclosingSegment();
        }
        return this.enclosing;
    }

    protected void computeEnclosingSegment() {
        this.findInSubHierarchy(this.parent != null ? this.parent : this.changeSet.topSegment);
    }

    protected boolean findInSubHierarchy(Segment head) {
        Segment[] subs;
        boolean found = false;
        Segment[] segmentArray = subs = head.subSegments();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Segment sub = segmentArray[n2];
            if (sub == this || sub.isSyntactic() && this.findInSubHierarchy(sub)) {
                found = true;
            }
            ++n2;
        }
        return found;
    }

    @Override
    public boolean isLeaf() {
        if (this.subSegments == null) {
            this.computeSubSegments();
        }
        return this.subSegments.length == 0;
    }

    @Override
    public Segment[] subSegments() {
        if (this.subSegments == null) {
            this.computeSubSegments();
        }
        return this.subSegments;
    }

    protected void computeSubSegments() {
        this.subSegments = this.buildSubSegments();
    }

    protected Segment[] buildSubSegments() {
        SyntacticTag tag;
        int end;
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        int nbOfSubTags = 0;
        int begin = this.beginIndex();
        Iterator<SyntacticTag> subtags = si.subTags(begin, end = this.endIndex());
        if (subtags.hasNext()) {
            tag = subtags.next();
            if (tag.beginIndex() == begin && tag.endIndex() == end && !this.isGeneratedBlank()) {
                end = this.endIndex();
                subtags = si.subTags(++begin, end);
            } else if (tag.isToInsertInEditTree()) {
                ++nbOfSubTags;
            }
        }
        while (subtags.hasNext()) {
            tag = subtags.next();
            if (!tag.isToInsertInEditTree() || tag.beginIndex() == begin && tag.endIndex() == end) continue;
            ++nbOfSubTags;
        }
        if (nbOfSubTags == 0) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        Segment[] subSegments = new Segment[1 + (nbOfSubTags << 1)];
        int count = 0;
        Segment previous = this;
        subtags = si.subTags(begin, end);
        while (subtags.hasNext()) {
            SyntacticTag tag2 = subtags.next();
            if (!tag2.isToInsertInEditTree() || tag2.beginIndex() == begin && tag2.endIndex() == end && !this.isGeneratedBlank()) continue;
            SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(this, this, tag2, this.rank, this.rank);
            subSegments[count++] = this.changeSet.newSyntacticPartSegment(this, this, previous, tagSegment, this.rank);
            subSegments[count++] = tagSegment;
            previous = tagSegment;
        }
        subSegments[count] = this.changeSet.newSyntacticPartSegment(this, this, previous, this, this.rank);
        return subSegments;
    }

    @Override
    protected boolean dirtySubSegments() {
        return this.subSegments == null;
    }

    @Override
    protected void touchSubSegments() {
        if (this.subSegments == null) {
            return;
        }
        Segment[] segmentArray = this.subSegments;
        int n = this.subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment subSegment = segmentArray[n2];
            if (subSegment.isSyntactic() && subSegment.isTagged()) {
                this.changeSet.syntacticTagNameToSegment.remove(subSegment.enclosingTagName());
                subSegment.touchSubSegments();
            }
            ++n2;
        }
        this.subSegments = null;
    }

    @Override
    protected void touchSyntacticSegments(int newSegmentStatus) {
        this.subSegments = newSegmentStatus < 2 ? EMPTY_SEGMENT_ARRAY : null;
    }

    @Override
    public int generatedBeginIndex() {
        return this.tag.getBeginIndex();
    }

    @Override
    public int generatedEndIndex() {
        return this.tag.getEndIndex();
    }

    @Override
    public int generatedLength() {
        return this.tag.getEndIndex() - this.tag.getBeginIndex();
    }

    @Override
    public CharSequence generatedText() {
        return this.tag.getGeneratedInfo().getText().subSequence(this.tag.getBeginIndex(), this.tag.getEndIndex());
    }

    @Override
    public String toString() {
        return String.valueOf(this.enclosingTagName()) + " [" + this.beginIndex() + ", " + this.endIndex() + "]" + "\n" + super.toString();
    }
}

