/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.AtomicSegment;
import com.ibm.pdp.engine.turbo.core.Segment;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AtomicSegmentIterator
implements Iterator<Segment> {
    protected Object[] atom;
    protected int nextRank;
    protected int endRank;
    protected boolean reverse;
    protected AtomicSegment found;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected AtomicSegmentIterator() {
    }

    protected AtomicSegmentIterator(Object[] atomArray, Segment startSegment, boolean includeStartSegment, Segment stopSegment, boolean includeStopSegment, boolean reverseOrder) {
        int startRank;
        int n = startSegment != null ? (includeStartSegment ? (reverseOrder ? startSegment.maxRank() : startSegment.minRank()) : (reverseOrder ? startSegment.maxRank() - 1 : startSegment.minRank() + 1)) : (startRank = -1);
        int stopRank = stopSegment != null ? (includeStopSegment ? (reverseOrder ? stopSegment.minRank() : stopSegment.maxRank()) : (reverseOrder ? stopSegment.minRank() + 1 : stopSegment.maxRank() - 1)) : -1;
        this.init(atomArray, startRank, stopRank, reverseOrder);
    }

    protected AtomicSegmentIterator(AtomicSegment[] atomArray, int startRank, int stopRank, boolean reverseOrder) {
        this.init(atomArray, startRank, stopRank, reverseOrder);
    }

    protected void init(Object[] atomArray, int startRank, int stopRank, boolean reverseOrder) {
        this.atom = atomArray;
        int n = startRank > -1 ? startRank : (this.nextRank = reverseOrder ? atomArray.length - 1 : 0);
        this.endRank = stopRank > -1 ? stopRank : (reverseOrder ? 0 : atomArray.length - 1);
        this.reverse = reverseOrder;
    }

    @Override
    public boolean hasNext() {
        return this.found != null || !(this.reverse ? !this.findBackward() : !this.findForward());
    }

    @Override
    public AtomicSegment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("SegmentIterator.next");
        }
        AtomicSegment toReturn = this.found;
        this.found = null;
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("SegmentIterator.remove");
    }

    protected boolean findForward() {
        if (this.nextRank > this.endRank) {
            this.found = null;
            return false;
        }
        this.found = (AtomicSegment)this.atom[this.nextRank++];
        return true;
    }

    protected boolean findBackward() {
        if (this.nextRank < this.endRank) {
            this.found = null;
            return false;
        }
        this.found = (AtomicSegment)this.atom[this.nextRank--];
        return true;
    }
}

