/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.tree.internal.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.IntSequenceDifferencer;
import com.ibm.pdp.util.ints.IntSequence;

public abstract class AtomicSegment
extends Segment {
    protected int level;
    protected int rank;
    protected int beginIdx;
    protected int status;
    protected IDetailedChanges detailedChanges;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected AtomicSegment() {
    }

    protected AtomicSegment(UserChangeSet userChangeSet) {
        super(userChangeSet);
        this.enclosing = userChangeSet.topSegment;
    }

    protected AtomicSegment(UserChangeSet userChangeSet, HierarchicSegment parentSegment) {
        super(userChangeSet, parentSegment);
        if (parentSegment != null) {
            this.level = parentSegment.generatedLevel() + 1;
            this.enclosing = parentSegment;
        } else {
            this.enclosing = userChangeSet.topSegment;
        }
    }

    @Override
    public int generatedLevel() {
        return this.level;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String enclosingTagName() {
        IGeneratedTag parentTag = this.enclosingTag();
        return parentTag != null ? parentTag.getName() : null;
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public int nbOfTaggedSons() {
        return 0;
    }

    @Override
    public Segment[] sons() {
        return null;
    }

    @Override
    public boolean isAncestorOf(Segment segment) {
        return false;
    }

    @Override
    public Segment firstAtom() {
        return this;
    }

    @Override
    public Segment lastAtom() {
        return this;
    }

    @Override
    public Segment previousAtom() {
        return this.rank > 0 ? this.changeSet.getAtomAt(this.rank - 1) : null;
    }

    @Override
    public Segment nextAtom() {
        return this.rank < this.changeSet.nbAtom - 1 ? this.changeSet.getAtomAt(this.rank + 1) : null;
    }

    @Override
    public boolean isSyntactic() {
        return false;
    }

    @Override
    public int minRank() {
        return this.rank;
    }

    @Override
    public int maxRank() {
        return this.rank;
    }

    @Override
    public int beginIndex() {
        return this.changeSet.beginIndex(this);
    }

    @Override
    public int endIndex() {
        return this.changeSet.endIndex(this);
    }

    @Override
    public void setBeginIndex(int newBeginIndex) {
        this.changeSet.changeBeginIndex(this, newBeginIndex);
    }

    @Override
    public int length() {
        return this.changeSet.length(this);
    }

    @Override
    public void setText(CharSequence newText) {
        this.changeSet.replaceText(this, newText);
    }

    @Override
    public ChangeNature getChangeNature() {
        this.detailedChanges();
        return AtomicSegment.changeNatureFromStatus(this.status);
    }

    @Override
    public ChangeNature getSubtreesChangeNature() {
        return ChangeNature.Unchanged;
    }

    @Override
    public ChangeNature getTreeChangeNature() {
        return this.getChangeNature();
    }

    @Override
    protected int getSegmentStatus() {
        return this.status;
    }

    protected void setSegmentStatus(int segmentStatus) {
        this.touchSyntacticSegments(segmentStatus);
        this.detailedChanges = null;
        if (this.node != null && this.isPart()) {
            ((ITextNode)this.node).setLabel(null);
        }
        this.status = segmentStatus;
    }

    protected abstract void touchSyntacticSegments(int var1);

    protected int getSubtreesStatus() {
        return 0;
    }

    @Override
    protected int getTreeStatus() {
        return this.status;
    }

    @Override
    public void setChangeNature(ChangeNature newNature) {
        int oldChangeLevel;
        int newChangeLevel = newNature.changeLevel();
        int n = this.status <= 2 ? this.status : (oldChangeLevel = this.status == 6 ? 3 : 2);
        if (newChangeLevel != oldChangeLevel) {
            this.changeSet.declareNewChangeLevel(this.beginIndex(), this.endIndex(), newChangeLevel);
        }
        this.changeStatus(newNature.ordinal());
    }

    protected boolean touch(boolean dirty) {
        return this.changeStatus(dirty ? 6 : 0);
    }

    protected boolean changeStatus(int newStatus) {
        int oldStatus = this.status;
        if (oldStatus == newStatus) {
            return false;
        }
        this.setSegmentStatus(newStatus);
        this.updateAncestorsStatus(oldStatus, newStatus);
        return true;
    }

    protected void updateAncestorsStatus(int oldSegmentStatus, int newSegmentStatus) {
        if (this.parent == null) {
            this.changeSet.updateRootSegmentStatus(oldSegmentStatus, newSegmentStatus);
        } else if (this.isPart()) {
            this.parent.updatePartStatus(oldSegmentStatus, newSegmentStatus);
        } else {
            this.parent.updateSubtreeStatus(oldSegmentStatus, newSegmentStatus);
        }
    }

    @Override
    public IDetailedChanges detailedChanges() {
        if (this.detailedChanges == null) {
            this.computeDetailedChanges();
        }
        return this.detailedChanges;
    }

    @Override
    public void setDetailedChanges(IDetailedChanges newDetails) {
        this.detailedChanges = newDetails;
    }

    protected void computeDetailedChanges() {
        if (this.status != 2) {
            return;
        }
        ISubTextPartition modified = this.changeSet.partition.subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition reference = this.changeSet.generatedPartition.subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        int modifiedwordCount = modified.getWordsCount();
        int referenceWordCount = reference.getWordsCount();
        if (modifiedwordCount == 0) {
            if (referenceWordCount == 0) {
                if (Strings.sameCharSequences((CharSequence)modified.getText(), (CharSequence)reference.getText())) {
                    this.changeStatus(0);
                } else {
                    this.changeStatus(1);
                }
                return;
            }
            this.changeStatus(3);
            return;
        }
        if (referenceWordCount == 0) {
            this.changeStatus(4);
            return;
        }
        IntSequenceDifferencer wordsDifferencer = Ints.newIntSequenceDifferencer((IntSequence)reference.getWords(), (IntSequence)modified.getWords());
        int nbDifferences = 0;
        int nbRemovedWords = 0;
        int nbAddedWords = 0;
        DiffCursor wordDiff = wordsDifferencer.newDiffCursor();
        while (wordDiff.searchNextDifference()) {
            nbRemovedWords += wordDiff.getReferenceEndIndex() - wordDiff.getReferenceBeginIndex();
            nbAddedWords += wordDiff.getModifiedEndIndex() - wordDiff.getModifiedBeginIndex();
            ++nbDifferences;
        }
        if (nbDifferences == 0) {
            if (Strings.sameCharSequences((CharSequence)modified.getText(), (CharSequence)reference.getText())) {
                this.changeStatus(0);
            } else {
                this.changeStatus(1);
            }
            return;
        }
        if (AtomicSegment.isReplacement(referenceWordCount, nbRemovedWords, nbAddedWords, nbDifferences)) {
            this.changeStatus(5);
            return;
        }
        int maxValue = Math.max(Math.max(modified.getTextLength(), reference.getTextLength()), nbDifferences);
        this.detailedChanges = AtomicSegment.buildDetailedChanges(modified, reference, nbDifferences, maxValue, wordsDifferencer.newDiffCursor());
    }

    @Override
    public boolean restoreGeneratedText() {
        return this.status != 0 && this.changeSet.restoreGeneratedText(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("genBeginIndex:");
        sb.append(this.generatedBeginIndex());
        sb.append("  BeginIndex:");
        sb.append(this.beginIndex());
        sb.append("\n");
        sb.append("gen :");
        sb.append(this.generatedText());
        sb.append("\ntext:");
        if (this.beginIndex() == -1) {
            sb.append("Unknown");
        } else if (this.endIndex() == -1) {
            sb.append("next BeginIndex =-1");
        } else {
            sb.append(this.getText());
        }
        return sb.toString();
    }
}

