/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.AtomicSegment;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;

public class AtomicPartSegment
extends AtomicSegment {
    protected Segment fromSegment;
    protected Segment toSegment;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected AtomicPartSegment() {
    }

    protected AtomicPartSegment(UserChangeSet userChangeSet, Segment beginSegment, Segment endSegment) {
        super(userChangeSet);
        this.fromSegment = beginSegment;
        this.toSegment = endSegment;
        this.beginIdx = this.generatedBeginIndex();
    }

    protected AtomicPartSegment(UserChangeSet userChangeSet, HierarchicSegment parentSegment, Segment beginSegment, Segment endSegment) {
        super(userChangeSet, parentSegment);
        this.fromSegment = beginSegment;
        this.toSegment = endSegment;
        this.beginIdx = this.generatedBeginIndex();
    }

    @Override
    public TagProperties getTagProperties() {
        return this.enclosingSegment().getTagProperties();
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public boolean isPart() {
        return true;
    }

    @Override
    public boolean isFirstPart() {
        return this.toSegment != null && this.fromSegment == this.parent;
    }

    @Override
    public boolean isMiddlePart() {
        return this.fromSegment != null && this.toSegment != null && this.fromSegment.parent == this.toSegment.parent;
    }

    @Override
    public boolean isLastPart() {
        return this.fromSegment != null && this.toSegment == this.parent;
    }

    @Override
    public String enclosingTagName() {
        return this.enclosingSegment().enclosingTagName();
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return this.parent != null ? this.parent.enclosingTag() : null;
    }

    @Override
    public IGeneratedTag fromTag() {
        return this.fromSegment != null ? this.fromSegment.enclosingTag() : null;
    }

    @Override
    public IGeneratedTag toTag() {
        return this.toSegment != null ? this.toSegment.enclosingTag() : null;
    }

    @Override
    public String fromTagName() {
        return this.fromSegment != null ? this.fromSegment.enclosingTagName() : null;
    }

    @Override
    public String toTagName() {
        return this.toSegment != null ? this.toSegment.enclosingTagName() : null;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public Segment enclosingSegment() {
        if (this.enclosing.dirtySubSegments()) {
            this.computeEnclosingSegment();
        }
        return this.enclosing;
    }

    protected void computeEnclosingSegment() {
        this.findInSubHierarchy(this.parent != null ? this.parent : this.changeSet.topSegment);
    }

    protected boolean findInSubHierarchy(Segment head) {
        Segment[] subs;
        boolean found = false;
        Segment[] segmentArray = subs = head.subSegments();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Segment sub = segmentArray[n2];
            if (sub == this || sub.isSyntactic() && this.findInSubHierarchy(sub)) {
                found = true;
            }
            ++n2;
        }
        return found;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Segment[] subSegments() {
        return EMPTY_SEGMENT_ARRAY;
    }

    @Override
    protected boolean dirtySubSegments() {
        return false;
    }

    @Override
    protected void touchSubSegments() {
    }

    @Override
    protected void touchSyntacticSegments(int newSegmentStatus) {
        this.enclosing = this.parent != null ? this.parent : this.changeSet.topSegment;
        this.enclosing.touchSubSegments();
    }

    @Override
    public int generatedBeginIndex() {
        if (this.fromSegment == null) {
            return 0;
        }
        return this.fromSegment == this.parent ? this.parent.generatedBeginIndex() : this.fromSegment.generatedEndIndex();
    }

    @Override
    public int generatedEndIndex() {
        if (this.toSegment == null) {
            return this.fromSegment.enclosingTag().getEndIndex();
        }
        return this.toSegment == this.parent ? this.parent.generatedEndIndex() : this.toSegment.generatedBeginIndex();
    }

    @Override
    public int generatedLength() {
        if (this.fromSegment == null || this.toSegment == null) {
            return 0;
        }
        int start = this.fromSegment == this.parent ? this.parent.generatedBeginIndex() : this.fromSegment.generatedEndIndex();
        int stop = this.toSegment == this.parent ? this.parent.generatedEndIndex() : this.toSegment.generatedBeginIndex();
        return stop - start;
    }

    @Override
    public CharSequence generatedText() {
        if (this.fromSegment == null || this.toSegment == null) {
            return "";
        }
        int start = this.fromSegment == this.parent ? this.parent.generatedBeginIndex() : this.fromSegment.generatedEndIndex();
        int stop = this.toSegment == this.parent ? this.parent.generatedEndIndex() : this.toSegment.generatedBeginIndex();
        return this.enclosingTag().getGeneratedInfo().getText().subSequence(start, stop);
    }

    @Override
    public Segment previousBrother() {
        return this.fromSegment != this.parent ? this.fromSegment : null;
    }

    @Override
    public Segment nextBrother() {
        return this.toSegment != this.parent ? this.toSegment : null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.enclosingTagName()) + "(" + this.fromTagName() + ".." + this.toTagName() + ") [" + this.beginIndex() + ", " + this.endIndex() + "]" + "\n" + super.toString();
    }
}

