/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.IWord;

public class AppendedDictionary
extends Dictionary {
    protected int startWordId;
    protected Dictionary reference;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public AppendedDictionary(Dictionary referenceDictionary) {
        this.reference = referenceDictionary;
        this.startWordId = referenceDictionary.nbOfWord();
    }

    @Override
    public int nbOfWord() {
        return this.startWordId + super.nbOfWord();
    }

    @Override
    public int getMinWordCategory() {
        return Math.min(this.minCategory, this.reference.getMinWordCategory());
    }

    @Override
    public int getMaxWordCategory() {
        return Math.max(this.maxCategory, this.reference.getMaxWordCategory());
    }

    @Override
    public IWord getWord(CharSequence text, TextToken atom) {
        IWord word = super.getWord(text, atom);
        return word == null ? this.reference.getWord(text, atom) : word;
    }

    public boolean isWordDefined(char wordId) {
        return wordId < this.nbOfWord();
    }

    public IWord getWordFromId(char wordId) {
        return wordId < this.startWordId ? this.reference.getWordFromId(wordId) : super.getWordFromId(this.shiftWordId(wordId));
    }

    public int wordLength(char wordId) {
        return wordId < this.startWordId ? this.reference.wordLength(wordId) : super.wordLength(this.shiftWordId(wordId));
    }

    protected char shiftWordId(char externalWordId) {
        return (char)(externalWordId - this.startWordId);
    }
}

