/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.util.ints.IntSequence;
import java.util.ConcurrentModificationException;

public abstract class AbstractSubTextPartition
implements ISubTextPartition {
    protected ITextPartition partition;
    protected int idxShift;
    protected int length;
    protected int wordShift;
    protected int nbWord;
    protected int firstWordBeginIdx;
    protected int lastWordEndIdx;
    protected int savedModCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public AbstractSubTextPartition() {
    }

    public AbstractSubTextPartition(ITextPartition mainPartition, int beginIndex, int endIndex) {
        if (mainPartition instanceof AbstractSubTextPartition) {
            AbstractSubTextPartition subPartition = (AbstractSubTextPartition)mainPartition;
            this.partition = subPartition.partition;
            this.idxShift = subPartition.idxShift + beginIndex;
        } else {
            this.partition = mainPartition;
            this.idxShift = beginIndex;
        }
        this.length = endIndex - beginIndex;
        this.initializeWordInfo();
    }

    protected void initializeWordInfo() {
        int endRank;
        int beginIdx = this.idxShift;
        int endIdx = beginIdx + this.length;
        int beginRank = this.partition.wordRankFromIndex(beginIdx);
        if (beginRank < 0) {
            beginRank ^= 0xFFFFFFFF;
        }
        if (this.length == 0) {
            this.wordShift = beginRank;
            this.nbWord = 0;
            this.lastWordEndIdx = 0;
            this.firstWordBeginIdx = 0;
            this.savedModCount = this.getModificationCount();
            return;
        }
        this.firstWordBeginIdx = this.partition.wordBeginIndex(beginRank) - beginIdx;
        if (this.firstWordBeginIdx < 0) {
            this.firstWordBeginIdx = 0;
        }
        if ((endRank = this.partition.wordRankFromIndex(endIdx)) < 0) {
            endRank ^= 0xFFFFFFFF;
        } else if (this.partition.wordBeginIndex(endRank) < endIdx) {
            ++endRank;
        }
        if (endRank > beginRank) {
            this.lastWordEndIdx = this.partition.wordEndIndex(endRank - 1) - beginIdx;
            if (this.lastWordEndIdx > this.length) {
                this.lastWordEndIdx = this.length;
            }
        } else {
            this.lastWordEndIdx = this.length;
        }
        this.wordShift = beginRank;
        this.nbWord = endRank - beginRank;
        this.savedModCount = this.getModificationCount();
    }

    @Override
    public ITextPartition getMainPartition() {
        return this.partition;
    }

    @Override
    public int getBeginIndex() {
        return this.idxShift;
    }

    @Override
    public int getEndIndex() {
        return this.idxShift + this.length;
    }

    @Override
    public int getBeginWordRank() {
        return this.wordShift;
    }

    @Override
    public int getEndWordRank() {
        return this.wordShift + this.nbWord;
    }

    @Override
    public char charAt(int index) {
        this.checkConcurrentModification();
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Wrong char index");
        }
        return this.partition.charAt(this.idxShift + index);
    }

    @Override
    public CharSequence getText() {
        this.checkConcurrentModification();
        return this.partition.getTextInterval(this.idxShift, this.idxShift + this.length);
    }

    @Override
    public CharSequence getTextInterval(int begin, int end) {
        this.checkConcurrentModification();
        if (begin < 0 || begin > end || end > this.length) {
            throw new IndexOutOfBoundsException("Wrong text interval");
        }
        return this.partition.getTextInterval(this.idxShift + begin, this.idxShift + end);
    }

    @Override
    public int getTextLength() {
        return this.length;
    }

    @Override
    public IntSequence getWords() {
        this.checkConcurrentModification();
        return this.partition.getWordsInterval(this.wordShift, this.wordShift + this.nbWord);
    }

    @Override
    public int getWordsCount() {
        return this.nbWord;
    }

    @Override
    public IntSequence getWordsInterval(int beginRank, int endRank) {
        this.checkConcurrentModification();
        if (beginRank < 0 || beginRank > endRank || endRank > this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word interval");
        }
        return this.partition.getWordsInterval(this.wordShift + beginRank, this.wordShift + endRank);
    }

    @Override
    public int spaceAfterWord(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < -1 || wordRank >= this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        if (wordRank == -1) {
            return this.firstWordBeginIdx;
        }
        if (wordRank == this.nbWord - 1) {
            return this.length - this.lastWordEndIdx;
        }
        return this.partition.spaceAfterWord(this.wordShift + wordRank);
    }

    @Override
    public int spaceBeforeWord(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < 0 || wordRank > this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        if (wordRank == 0) {
            return this.firstWordBeginIdx;
        }
        if (wordRank == this.nbWord) {
            return this.length - this.lastWordEndIdx;
        }
        return this.partition.spaceBeforeWord(this.wordShift + wordRank);
    }

    @Override
    public int wordBeginIndex(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < 0 || wordRank > this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        if (wordRank == this.nbWord) {
            return this.length;
        }
        if (wordRank == 0) {
            return this.firstWordBeginIdx;
        }
        return this.partition.wordBeginIndex(this.wordShift + wordRank) - this.idxShift;
    }

    @Override
    public int wordEndIndex(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < -1 || wordRank >= this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        if (wordRank == -1) {
            return 0;
        }
        if (wordRank == this.nbWord - 1) {
            return this.lastWordEndIdx;
        }
        return this.partition.wordEndIndex(this.wordShift + wordRank) - this.idxShift;
    }

    @Override
    public int wordIdAt(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < 0 || wordRank >= this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        return this.partition.wordIdAt(this.wordShift + wordRank);
    }

    @Override
    public int minWordId() {
        return this.partition.minWordId();
    }

    @Override
    public int maxWordId() {
        return this.partition.maxWordId();
    }

    @Override
    public int wordLength(int wordRank) {
        this.checkConcurrentModification();
        if (wordRank < 0 || wordRank >= this.nbWord) {
            throw new IndexOutOfBoundsException("Wrong word rank");
        }
        if (wordRank == 0) {
            if (this.nbWord == 1) {
                return this.lastWordEndIdx - this.firstWordBeginIdx;
            }
            return this.partition.wordEndIndex(this.wordShift) - this.firstWordBeginIdx - this.idxShift;
        }
        if (wordRank == this.nbWord - 1) {
            return this.lastWordEndIdx + this.idxShift - this.partition.wordBeginIndex(this.wordShift + this.nbWord - 1);
        }
        return this.partition.wordLength(this.wordShift + wordRank);
    }

    @Override
    public int wordRankFromIndex(int index) {
        this.checkConcurrentModification();
        if (index == this.length) {
            return ~this.nbWord;
        }
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException("Wrong char index");
        }
        int realWordRank = this.realWordRankFromIndex(index + this.idxShift, this.wordShift, this.wordShift + this.nbWord - 1);
        return realWordRank < 0 ? realWordRank + this.wordShift : realWordRank - this.wordShift;
    }

    protected int realWordRankFromIndex(int realIndex, int low, int high) {
        return this.partition.wordRankFromIndex(realIndex);
    }

    @Override
    public void setText(CharSequence newText) {
        this.checkConcurrentModification();
        this.partition.replaceText(this.idxShift, this.idxShift + this.length, newText);
        this.length = newText.length();
        this.initializeWordInfo();
    }

    @Override
    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        this.checkConcurrentModification();
        if (beginIdx < 0 || beginIdx > endIdx || endIdx > this.length) {
            throw new IndexOutOfBoundsException("Wrong text interval");
        }
        this.partition.replaceText(beginIdx + this.idxShift, endIdx + this.idxShift, newText);
        this.length += newText.length() - endIdx + beginIdx;
        this.initializeWordInfo();
    }

    @Override
    public ISubTextPartition subTextPartition(int beginIdx, int endIdx) {
        if (beginIdx < 0 || beginIdx > endIdx || endIdx > this.length) {
            throw new IndexOutOfBoundsException("Wrong text interval");
        }
        return this.partition.subTextPartition(this.idxShift + beginIdx, this.idxShift + endIdx);
    }

    protected void checkConcurrentModification() {
        if (this.savedModCount != this.getModificationCount()) {
            throw new ConcurrentModificationException("Disabled sub-partition : main partition has been modified");
        }
    }

    protected abstract int getModificationCount();
}

