/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.extension.IExtensionManager;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.serialize.TextProcessorGeneralDeserializer;
import com.ibm.pdp.engine.turbo.serialize.TextProcessorGeneralSerializer;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class EngineFactory
implements IEngineFactory {
    protected static final String GENERATED_INFO = "GeneratedInfo";
    protected static final String TAG = "Tag";
    protected static final String NAME = "name";
    protected static final String TEXT = "Text";
    protected static final String TEXT_PROCESSOR = "TextProcessor";
    protected static final char EOF = '\uffff';
    protected static final char[] specials = new char[]{'<', '>', '&', '\"'};
    protected static final String[] replacements = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    protected int readIndex;
    protected StringBuilder readBuffer;
    protected String[] lines;
    protected StringBuilder currentLine;
    protected IExtensionManager extensionMgr;
    protected static final int BUFFER_SIZE = 100000;
    protected char[] buffer = null;
    protected int bufferIndex = 0;
    protected int bufferSize = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IGeneratedInfoFactory newGeneratedInfoFactory() {
        return new GenInfoFactory();
    }

    public IGeneratedInfo readGeneratedInfo(InputStream is) {
        this.buffer = null;
        this.bufferIndex = 0;
        this.bufferSize = -1;
        InputStreamReader in = new InputStreamReader(is);
        this.readBuffer = new StringBuilder();
        this.currentLine = new StringBuilder();
        this.lines = new String[]{"", "", ""};
        this.readIndex = 0;
        IGeneratedInfo generatedInfo = this.readGeneratedInfoChars(in);
        this.readBuffer = null;
        this.currentLine = null;
        this.lines = null;
        try {
            ((Reader)in).close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
        return generatedInfo;
    }

    protected IGeneratedInfo readGeneratedInfoChars(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        IGeneratedInfoFactory factory = this.newGeneratedInfoFactory();
        this.readGeneratedInfoConstruct(in, factory);
        return factory.createGeneratedInfo();
    }

    public void writeGeneratedInfo(IGeneratedInfo generatedInfo, OutputStream out) {
        PrintWriter printer = new PrintWriter(out);
        this.writeGeneratedInfoChars(generatedInfo, printer);
        printer.flush();
    }

    protected void writeGeneratedInfoChars(IGeneratedInfo generatedInfo, PrintWriter printer) {
        this.writeGeneratedHeader(generatedInfo, printer);
        this.writeTagsAndText(generatedInfo, printer);
        this.writeGeneratedFooter(printer);
    }

    public ITextProcessor newTextProcessor() {
        return new TextProcessor(this);
    }

    public IExtensionManager getExtensionManager() {
        return this.extensionMgr;
    }

    public void setExtensionManager(IExtensionManager extensionManager) {
        this.extensionMgr = extensionManager;
    }

    protected RuntimeException unexpected(char received, char expected) {
        throw new RuntimeException(this.makeMessage(received, expected));
    }

    protected String makeMessage(char received, char expected) {
        StringBuilder message = new StringBuilder();
        message.append("Unexpected character found '").append(received).append("' at index ");
        message.append(this.readIndex).append(" when character '").append(expected).append("' was expected.");
        message.append(Strings.getLineSeparator());
        this.appendCurrentLines(message);
        return message.toString();
    }

    protected RuntimeException unexpectedEof(char expected, String[] storedLines) {
        throw new RuntimeException(this.makeEofMessage(expected, storedLines));
    }

    protected String makeEofMessage(char expected, String[] storedLines) {
        StringBuilder message = new StringBuilder();
        message.append("End of stream reached when character '").append(expected).append("' was expected.");
        if (storedLines != null && storedLines.length > 0) {
            message.append(Strings.getLineSeparator());
            this.appendStoredLines(storedLines, message);
        }
        return message.toString();
    }

    protected RuntimeException unexpected(String received, String expected) {
        throw new RuntimeException(this.makeMessage(received, expected));
    }

    protected RuntimeException unexpectedEof(String expected, String[] storedLines) {
        throw new RuntimeException(this.makeEofMessage(expected, storedLines));
    }

    protected String makeMessage(String received, String expected) {
        StringBuilder message = new StringBuilder();
        message.append("Unexpected string found \"").append(received).append("\" at index ");
        message.append(this.readIndex).append(" when \"").append(expected).append("\" was expected.");
        message.append(Strings.getLineSeparator());
        this.appendCurrentLines(message);
        return message.toString();
    }

    protected String makeEofMessage(String expected, String[] storedLines) {
        StringBuilder message = new StringBuilder();
        message.append("End of stream reached when '").append(expected).append("' was expected.");
        if (storedLines != null && storedLines.length > 0) {
            message.append(Strings.getLineSeparator());
            this.appendStoredLines(storedLines, message);
        }
        return message.toString();
    }

    protected void appendCurrentLines(StringBuilder builder) {
        this.appendStoredLines(this.lines, builder);
        if (!this.isBlank(this.currentLine)) {
            builder.append(">>> ").append((CharSequence)this.currentLine).append(Strings.getLineSeparator());
        }
    }

    protected String[] cloneCurrentLines() {
        int count = this.lines.length;
        ArrayList<String> copiedLines = new ArrayList<String>(count + 1);
        int i = 0;
        while (i < count) {
            String line = this.lines[i];
            if (!this.isBlank(line)) {
                copiedLines.add(line);
            }
            ++i;
        }
        if (!this.isBlank(this.currentLine)) {
            copiedLines.add(this.currentLine.toString());
        }
        String[] result = new String[copiedLines.size()];
        copiedLines.toArray(result);
        return result;
    }

    protected void appendStoredLines(String[] storedLines, StringBuilder builder) {
        int count = storedLines.length;
        int i = 0;
        while (i < count) {
            String line = storedLines[i];
            if (!this.isBlank(line)) {
                builder.append(">>> ").append(line).append(Strings.getLineSeparator());
            }
            ++i;
        }
    }

    protected char readNextChar(Reader in) {
        char c = this.readNextChar0(in);
        if (c == '\n' || c == '\r' || c == '\uffff') {
            if (!this.isBlank(this.currentLine)) {
                this.storeCurrentLine();
            }
            this.currentLine.setLength(0);
        } else {
            this.currentLine.append(c);
        }
        return c;
    }

    protected char readNextChar0(Reader in) {
        try {
            if (this.buffer == null) {
                this.buffer = new char[100000];
            }
            ++this.readIndex;
            if (this.bufferIndex >= this.bufferSize) {
                this.bufferSize = in.read(this.buffer);
                this.bufferIndex = 0;
                if (this.bufferSize == -1) {
                    this.buffer = null;
                    this.bufferIndex = 0;
                    this.bufferSize = -1;
                    return (char)this.bufferSize;
                }
            }
            return this.buffer[this.bufferIndex++];
        }
        catch (IOException ioe) {
            throw Util.rethrow((Throwable)ioe);
        }
    }

    protected boolean isBlank(CharSequence line) {
        int length = line.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void storeCurrentLine() {
        int lastIdx = this.lines.length - 1;
        System.arraycopy(this.lines, 1, this.lines, 0, lastIdx);
        this.lines[lastIdx] = this.currentLine.toString();
    }

    protected char nextNotWhiteChar(Reader in) {
        char nextChar;
        while ((nextChar = this.readNextChar(in)) != '\uffff' && Character.isWhitespace(nextChar)) {
        }
        return nextChar;
    }

    protected char forwardToWhiteChar(Reader in) {
        char nextChar;
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(in)) != '\uffff') {
            if (Character.isWhitespace(nextChar)) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        return nextChar;
    }

    protected char forwardToChar(char search, Reader in) {
        char nextChar;
        String[] storedLines = this.cloneCurrentLines();
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(in)) != '\uffff') {
            if (nextChar == search) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        throw this.unexpectedEof(search, storedLines);
    }

    protected char forwardToWhiteOrChar(char search, Reader in) {
        char nextChar;
        String[] storedLines = this.cloneCurrentLines();
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(in)) != '\uffff') {
            if (nextChar == search || Character.isWhitespace(nextChar)) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        throw this.unexpectedEof(search, storedLines);
    }

    protected int appendChar(char c, StringBuilder buffer, int specialStartIdx) {
        buffer.append(c);
        if (c == '&') {
            return buffer.length() - 1;
        }
        if (c == ';' && specialStartIdx != -1) {
            String specialFound = buffer.substring(specialStartIdx);
            int i = 0;
            while (i < replacements.length) {
                if (specialFound.equals(replacements[i])) {
                    buffer.setLength(specialStartIdx);
                    buffer.append(specials[i]);
                    break;
                }
                ++i;
            }
            specialStartIdx = -1;
        }
        return specialStartIdx;
    }

    protected void readGeneratedInfoConstruct(Reader in, IGeneratedInfoFactory factory) {
        this.readGeneratedInfoHeader(in, factory);
        this.readTaggedText(in, factory);
        this.readGeneratedInfoFooter(in);
    }

    protected void readGeneratedInfoHeader(Reader in, IGeneratedInfoFactory factory) {
        char c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(GENERATED_INFO)) {
            throw this.unexpected(this.readBuffer.toString(), GENERATED_INFO);
        }
        if (c != '>') {
            this.readProperties(in, factory);
        }
    }

    protected Properties readProperties(Reader in) {
        String name;
        Properties props = null;
        while ((name = this.readPropertyName(in)).length() > 0) {
            if (props == null) {
                props = new Properties();
            }
            if (!this.addPropertyValue(name, in, props)) break;
        }
        return props;
    }

    protected String readPropertyName(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c == '>') {
            return "";
        }
        if (c == '\uffff') {
            throw this.unexpectedEof('>', this.lines);
        }
        if (c == '=') {
            throw this.unexpected(c, '>');
        }
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('=', in);
        if (c != '=' && (c = this.nextNotWhiteChar(in)) != '=') {
            throw this.unexpected(c, '=');
        }
        return this.readBuffer.toString();
    }

    protected boolean addPropertyValue(String name, Reader in, Properties props) {
        char c = this.nextNotWhiteChar(in);
        if (c == '>') {
            props.setProperty(name, "");
            return false;
        }
        if (c == '\uffff') {
            this.unexpectedEof('>', this.lines);
        }
        this.readBuffer.setLength(0);
        boolean readNextOne = true;
        if (c == '\"') {
            this.forwardToChar('\"', in);
        } else {
            this.readBuffer.append(c);
            readNextOne = this.forwardToWhiteOrChar('>', in) != '>';
        }
        props.setProperty(name, this.readBuffer.toString());
        return readNextOne;
    }

    protected void readProperties(Reader in, IGeneratedInfoFactory factory) {
        String name;
        while ((name = this.readPropertyName(in)).length() != 0 && this.setPropertyValue(name, in, factory)) {
        }
    }

    protected boolean setPropertyValue(String propertyName, Reader in, IGeneratedInfoFactory factory) {
        char c = this.nextNotWhiteChar(in);
        if (c == '>') {
            factory.setProperty(propertyName, "");
            return false;
        }
        if (c == '\uffff') {
            this.unexpectedEof('>', this.lines);
        }
        this.readBuffer.setLength(0);
        boolean readNextOne = true;
        if (c == '\"') {
            this.forwardToChar('\"', in);
        } else {
            this.readBuffer.append(c);
            readNextOne = this.forwardToWhiteOrChar('>', in) != '>';
        }
        factory.setProperty(propertyName, this.readBuffer.toString());
        return readNextOne;
    }

    protected void skipProperties(Reader in) {
        while (this.readPropertyName(in).length() > 0 && this.skipPropertyValue(in)) {
        }
    }

    protected boolean skipPropertyValue(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c == '>') {
            return false;
        }
        if (c == '\uffff') {
            this.unexpectedEof('>', this.lines);
        }
        this.readBuffer.setLength(0);
        boolean readNextOne = true;
        if (c == '\"') {
            this.forwardToChar('\"', in);
        } else {
            this.readBuffer.append(c);
            readNextOne = this.forwardToWhiteOrChar('>', in) != '>';
        }
        return readNextOne;
    }

    protected void readTaggedText(Reader in, IGeneratedInfoFactory factory) {
        char c = this.nextNotWhiteChar(in);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
        while (true) {
            this.readBuffer.setLength(0);
            this.forwardToChar('<', in);
            if (this.readBuffer.length() != 0) {
                factory.appendText((CharSequence)this.readBuffer);
            }
            if ((c = this.nextNotWhiteChar(in)) == '/') break;
            this.readBuffer.setLength(0);
            this.readBuffer.append(c);
            c = this.forwardToWhiteChar(in);
            if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
                throw this.unexpected(this.readBuffer.toString(), TAG);
            }
            this.readTag(in, factory);
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    protected void readGeneratedInfoFooter(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(in);
        if (c != '/') {
            throw this.unexpected(c, '/');
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(GENERATED_INFO)) {
            throw this.unexpected(this.readBuffer.toString(), GENERATED_INFO);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    protected void readTag(Reader in, IGeneratedInfoFactory factory) {
        this.readTagHeader(in, factory);
        this.readTagBody(in, factory);
        this.readTagFooter(in, factory);
    }

    protected void readTagHeader(Reader in, IGeneratedInfoFactory factory) {
        String propertyName;
        Properties props = null;
        boolean foundTagName = false;
        while ((propertyName = this.readPropertyName(in)).length() > 0) {
            if (propertyName.equalsIgnoreCase(NAME)) {
                if (foundTagName) {
                    throw new RuntimeException("Duplicate name property for tag at index " + this.readIndex + ".");
                }
                foundTagName = true;
                if (this.beginTag(in, props, factory)) continue;
                break;
            }
            if (!foundTagName) {
                if (props == null) {
                    props = new Properties();
                }
                if (this.addPropertyValue(propertyName, in, props)) continue;
                break;
            }
            if (!this.setPropertyValue(propertyName, in, factory)) break;
        }
        if (!foundTagName) {
            throw new RuntimeException("Found a tag without name property at index " + this.readIndex + ".");
        }
    }

    protected boolean beginTag(Reader in, Properties props, IGeneratedInfoFactory factory) {
        char c = this.nextNotWhiteChar(in);
        if (c == '>') {
            throw new RuntimeException("Tag name must not be blank (index " + this.readIndex + ")");
        }
        if (c == '\uffff') {
            this.unexpectedEof('>', this.lines);
        }
        this.readBuffer.setLength(0);
        boolean readNextOne = true;
        if (c == '\"') {
            this.forwardToChar('\"', in);
        } else {
            this.readBuffer.append(c);
            readNextOne = this.forwardToWhiteOrChar('>', in) != '>';
        }
        String tagName = this.readBuffer.toString().trim();
        if (tagName.length() == 0) {
            throw new RuntimeException("Tag name must not be blank (index " + this.readIndex + ")");
        }
        if (props != null) {
            factory.beginTag(tagName, props);
        } else {
            factory.beginTag(tagName);
        }
        return readNextOne;
    }

    protected void readTagBody(Reader in, IGeneratedInfoFactory factory) {
        while (true) {
            char c;
            this.readBuffer.setLength(0);
            this.forwardToChar('<', in);
            if (this.readBuffer.length() != 0) {
                factory.appendText((CharSequence)this.readBuffer);
            }
            if ((c = this.nextNotWhiteChar(in)) == '/') {
                return;
            }
            this.readBuffer.setLength(0);
            this.readBuffer.append(c);
            c = this.forwardToWhiteChar(in);
            if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
                throw this.unexpected(this.readBuffer.toString(), TAG);
            }
            this.readTag(in, factory);
        }
    }

    protected void readTagFooter(Reader in, IGeneratedInfoFactory factory) {
        char c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
            throw this.unexpected(this.readBuffer.toString(), TAG);
        }
        if (c != '>') {
            this.skipProperties(in);
        }
        factory.endTag();
    }

    protected void writeGeneratedHeader(IGeneratedInfo generated, PrintWriter printer) {
        printer.print('<');
        printer.print(GENERATED_INFO);
        this.writeGeneratedProperties(generated, printer);
        printer.println('>');
    }

    protected void writeGeneratedFooter(PrintWriter printer) {
        printer.print("</");
        printer.print(GENERATED_INFO);
        printer.println('>');
    }

    protected void writeGeneratedProperties(IGeneratedInfo generated, PrintWriter printer) {
        Iterator names = generated.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            printer.print(' ');
            this.writeText(name, printer);
            printer.print("=\"");
            this.writeText(generated.getProperty(name), printer);
            printer.print('\"');
        }
    }

    protected void writeTagProperties(IGeneratedTag tag, PrintWriter printer) {
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            printer.print(' ');
            this.writeText(name, printer);
            printer.print("=\"");
            this.writeText(tag.getProperty(name), printer);
            printer.print('\"');
        }
    }

    protected void writeTagsAndText(IGeneratedInfo generated, PrintWriter printer) {
        printer.print("<Text>");
        this.writeTag(generated.getRootTag(), generated.getText(), printer);
        printer.println("</Text>");
    }

    protected void writeTag(IGeneratedTag tag, CharSequence text, PrintWriter printer) {
        printer.print("<");
        printer.print(TAG);
        printer.print(" name=\"");
        printer.print(tag.getName());
        printer.print('\"');
        this.writeTagProperties(tag, printer);
        printer.print('>');
        int index = tag.getBeginIndex();
        Iterator subTags = tag.sons();
        while (subTags.hasNext()) {
            IGeneratedTag subTag = (IGeneratedTag)subTags.next();
            this.writeText(text.subSequence(index, subTag.getBeginIndex()), printer);
            this.writeTag(subTag, text, printer);
            index = subTag.getEndIndex();
        }
        this.writeText(text.subSequence(index, tag.getEndIndex()), printer);
        printer.print("</");
        printer.print(TAG);
        printer.print(">");
    }

    protected void writeText(CharSequence text, PrintWriter printer) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            block3: {
                char c = text.charAt(i);
                int s = specials.length - 1;
                while (s >= 0) {
                    if (c == specials[s]) {
                        printer.print(replacements[s]);
                        break block3;
                    }
                    --s;
                }
                printer.print(c);
            }
            ++i;
        }
    }

    protected void writeProcessorHeader(ITextProcessor processor, PrintWriter printer) {
        printer.print('<');
        printer.print(TEXT_PROCESSOR);
        printer.println('>');
    }

    protected void writeProcessorBody(ITextProcessor processor, PrintWriter printer) {
        this.writeGeneratedInfoChars(processor.getGeneratedInfo(), printer);
        printer.print("<Text>");
        this.writeText(processor.getText(), printer);
        printer.println("</Text>");
    }

    protected void writeProcessorFooter(PrintWriter printer) {
        printer.print("</");
        printer.print(TEXT_PROCESSOR);
        printer.println('>');
    }

    protected void readTextProcessor(Reader in, ITextProcessor processor) {
        this.readProcessorHeader(in);
        IGeneratedInfo generatedInfo = this.readGeneratedInfoChars(in);
        CharSequence text = this.readText(in);
        this.readProcessorFooter(in);
        processor.setGeneratedInfo(generatedInfo);
        processor.setText(text);
    }

    protected void readProcessorHeader(Reader in) {
        char c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT_PROCESSOR)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT_PROCESSOR);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    protected CharSequence readText(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
        this.readBuffer.setLength(0);
        this.forwardToChar('<', in);
        String text = this.readBuffer.toString();
        c = this.nextNotWhiteChar(in);
        if (c != '/') {
            throw this.unexpected(c, '/');
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
        return text;
    }

    protected void readProcessorFooter(Reader in) {
        char c = this.nextNotWhiteChar(in);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(in);
        if (c != '/') {
            throw this.unexpected(c, '/');
        }
        c = this.nextNotWhiteChar(in);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', in);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT_PROCESSOR)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT_PROCESSOR);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(in)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    public void loadTextProcessor(ITextProcessor processor, XMLStreamReader xmlReader) {
        TextProcessorGeneralDeserializer tpgd = new TextProcessorGeneralDeserializer();
        tpgd.deserialize(processor, xmlReader);
    }

    public void writeTextProcessor(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        TextProcessorGeneralSerializer tpgs = new TextProcessorGeneralSerializer();
        tpgs.serialize(processor, xmlWriter);
    }
}

