/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import java.util.Iterator;

public class UserChangesMgrTest {
    protected UserChangesMgr changesMgr;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void test() {
        GeneratedCodeMgr mgr = new GeneratedCodeMgr();
        this.generate(mgr);
        this.useGeneratedInfo(mgr);
    }

    public void generate(GeneratedCodeMgr mgr) {
        mgr.beginTag("Presentation");
        mgr.appendText("Bonjour,");
        mgr.endTag("Presentation");
        mgr.appendText("\n");
        mgr.beginTag("Phrase");
        mgr.beginTag("Sujet");
        mgr.beginTag("Article");
        mgr.appendText("Le");
        mgr.endTag("Article");
        mgr.appendText("   ");
        mgr.beginTag("Adjectif");
        mgr.appendText("petit");
        mgr.endTag("Adjectif");
        mgr.appendText("   ");
        mgr.beginTag("Nom");
        mgr.appendText("chat");
        mgr.endTag("Nom");
        mgr.endTag("Sujet");
        mgr.appendText("   ");
        mgr.beginTag("Verbe");
        mgr.appendText("est");
        mgr.endTag("Verbe");
        mgr.appendText("   ");
        mgr.beginTag("Attribut du sujet");
        mgr.appendText("mort");
        mgr.endTag("Attribut du sujet");
        mgr.appendText(".");
        mgr.endTag("Phrase");
        mgr.appendText("\n");
        mgr.beginTag("Conclusion");
        mgr.appendText("Rien \u00e0 p\u00e9ter.");
        mgr.endTag("Conclusion");
    }

    public void useGeneratedInfo(GeneratedInfo gi) {
        System.out.println("Etape 1:");
        this.changesMgr = new UserChangesMgr();
        this.changesMgr.setGeneratedInfo(gi);
        this.show();
        System.out.println("Segments(11, 11, false, true, false)=");
        Iterator segments = this.changesMgr.segments(11, 11, false, true, false);
        StringBuffer buffer = new StringBuffer();
        this.showSegments(segments, buffer);
        System.out.println(buffer);
        System.out.println("\nEtape 2:");
        this.changesMgr.setTextAt(gi.getTag("Sujet"), -1, "Le ");
        this.changesMgr.setTextAt(gi.getTag("Sujet"), 0, "chien");
        this.changesMgr.setTextAt(gi.getTag("Sujet"), 1, " de chirac ");
        this.show();
        System.out.println("\nEtape 3:");
        this.changesMgr.setTextAt(gi.getTag("Sujet"), 0, null);
        this.changesMgr.setTextAt(gi.getTag("Sujet"), -1, null);
        this.changesMgr.setTextAt(gi.getTag("Sujet"), 1, null);
        this.changesMgr.setTextAt(gi.getTag("Article"), -1, "Un ");
        this.changesMgr.setTextAt(gi.getTag("Article"), 0, "ou deux");
        this.changesMgr.setTextAt(gi.getTag("Article"), 1, " ou trois ");
        this.changesMgr.setTextAt(gi.getTag("Adjectif"), -1, " petit ");
        this.changesMgr.setTextAt(gi.getTag("Adjectif"), 0, "moyen");
        this.changesMgr.setTextAt(gi.getTag("Adjectif"), 1, " ou gros ");
        this.changesMgr.setTextAt(gi.getTag("Verbe"), 0, "est (sont)");
        this.show();
        System.out.println("\nEtape 4:");
        this.changesMgr.setTextAt(gi.getTag("Root"), -1, "Citation:");
        this.changesMgr.setTextAt(gi.getTag("Root"), 1, "Fin de citation.");
        this.show();
        int len = this.changesMgr.length();
        System.out.println("Noeuds entre " + len / 5 + " et " + 4 * (len / 5) + ":");
        Iterator nodesInInterval = this.changesMgr.includedNodes(len / 5, 4 * (len / 5), false);
        while (nodesInInterval.hasNext()) {
            System.out.println(nodesInInterval.next());
        }
    }

    public void show() {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(buffer);
        buffer.append('\n');
        Iterator nodes = this.changesMgr.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
        buffer.append("Texte complet :\n");
        buffer.append(this.changesMgr.text());
        buffer.append('\n');
        System.out.println(buffer);
        buffer.setLength(0);
        buffer.append("Tous les segments =\n");
        Iterator segments = this.changesMgr.segments(null, null, false, false, false);
        this.showSegments(segments, buffer);
        buffer.append('\n');
        buffer.append("Segments non vides =\n");
        segments = this.changesMgr.segments(null, null, false, true, false);
        this.showSegments(segments, buffer);
        buffer.append('\n');
        buffer.append("Segments collationn\u00e9s =\n");
        segments = this.changesMgr.segments(null, null, true, false, false);
        this.showSegments(segments, buffer);
        buffer.append('\n');
        buffer.append("Segments collationn\u00e9s et non vides =\n");
        segments = this.changesMgr.segments(null, null, true, true, false);
        this.showSegments(segments, buffer);
        buffer.append('\n');
        System.out.println(buffer);
    }

    public void showNodes(StringBuffer buffer) {
        Iterator nodes = this.changesMgr.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            int i = 0;
            while (i < node.getDepth()) {
                buffer.append("    ");
                ++i;
            }
            buffer.append(node);
            buffer.append('\n');
        }
    }

    public void showNode(TextNode node, StringBuffer buffer) {
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']');
        Iterator children = node.children(false);
        if (children.hasNext()) {
            buffer.append("(");
            while (children.hasNext()) {
                TextNode son = (TextNode)children.next();
                buffer.append(son);
                if (!children.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append("\n\"").append(node.text()).append("\"\n");
        if (!node.text().equals(this.changesMgr.text().subSequence(node.startIndex(), node.stopIndex()))) {
            throw new RuntimeException("Erreur de reconstitution du texte.");
        }
        buffer.append("\n");
    }

    public void showSegments(Iterator segments, StringBuffer buffer) {
        while (segments.hasNext()) {
            buffer.append(segments.next());
            buffer.append('\n');
        }
    }

    public static void main(String[] args) {
        new UserChangesMgrTest().test();
    }
}

