/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import java.util.Random;

public class TstBits {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static int bitCount(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    private static int countBit(long value) {
        int count = 0;
        while (value != 0L) {
            if (value < 0L) {
                ++count;
            }
            value <<= 1;
        }
        return count;
    }

    public static void main(String[] args) {
        int size = 1000;
        Random r = new Random(System.currentTimeMillis());
        long[] values = new long[size];
        int i = 0;
        while (i < size) {
            values[i] = r.nextLong();
            ++i;
        }
        int count = size;
        int total1 = 0;
        long start = System.currentTimeMillis();
        while (--count > 0) {
            int i2 = 0;
            while (i2 < size) {
                TstBits.bitCount(values[i2]);
                ++i2;
            }
        }
        long stop = System.currentTimeMillis();
        long time1 = stop - start;
        count = size;
        int total2 = 0;
        start = System.currentTimeMillis();
        while (--count > 0) {
            int i3 = 0;
            while (i3 < 1000) {
                TstBits.countBit(values[i3]);
                ++i3;
            }
        }
        stop = System.currentTimeMillis();
        long time2 = stop - start;
        System.out.println("Time1=" + time1 + " Total1=" + total1 + " Time2=" + time2 + " Total2=" + total2);
    }
}

