/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import java.util.Random;

public class TextEventHandlerTest1 {
    protected static long seed;
    protected static String handlerClassName;
    protected static boolean patternRecognition;
    protected static boolean checkConsistency;
    protected static Random rand;
    protected static int testCount;
    protected static final int averageSegmentLength = 10;
    protected static final int blanksRate = 15;
    protected static final String blanks = "          ";
    protected TextEventHandler handler;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        testCount = 1;
    }

    public static void main(String[] args) {
        seed = System.currentTimeMillis();
        handlerClassName = "com.ibm.vap.pdp.editor.core.TextChangeHandler";
        TextEventHandlerTest1.analyzeArgs(args);
        UserChangesMgr.findBestMatchVersion = 1;
        while (UserChangesMgr.findBestMatchVersion <= 1) {
            UserChangesMgr.reuseBestMatchCount = 0;
            UserChangesMgr.findBestMatchCount = 0;
            rand = new Random(seed);
            testCount = 0;
            try {
                System.out.println("Start TextEventHandler1 test :\n    class=" + handlerClassName + "\n    seed=" + seed + "\n    patternRecognition=" + patternRecognition + "\n    consistencyCheck=" + checkConsistency + "\n    bestMatchVersion=" + UserChangesMgr.findBestMatchVersion);
                long start = System.currentTimeMillis();
                TextEventHandler handler = (TextEventHandler)TextEventHandlerTest1.instanciate(handlerClassName);
                TextEventHandlerTest1 tester = new TextEventHandlerTest1();
                tester.setTextEventHandler(handler);
                tester.test();
                long stop = System.currentTimeMillis();
                System.out.println("Stop TextEventHandler1 test, " + testCount + " tests performed, time=" + (stop - start));
            }
            catch (Throwable t) {
                System.err.println("Error executing test #" + testCount);
                t.printStackTrace();
            }
            System.out.println();
            ++UserChangesMgr.findBestMatchVersion;
        }
    }

    protected static void analyzeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            TextEventHandlerTest1.analyzeArg(args[i]);
            ++i;
        }
    }

    protected static void analyzeArg(String arg) {
        String lowerCaseArg = arg.toLowerCase();
        if (lowerCaseArg.startsWith("seed=")) {
            seed = Long.parseLong(arg.substring(5));
            return;
        }
        if (lowerCaseArg.startsWith("class=")) {
            handlerClassName = arg.substring(6);
            return;
        }
        if (lowerCaseArg.startsWith("patternrecognition=")) {
            char yesOrNo = lowerCaseArg.charAt(19);
            switch (yesOrNo) {
                case 'o': 
                case 't': 
                case 'y': {
                    patternRecognition = true;
                }
            }
            return;
        }
        if (lowerCaseArg.startsWith("checkconsistency=")) {
            char yesOrNo = lowerCaseArg.charAt(19);
            switch (yesOrNo) {
                case 'o': 
                case 't': 
                case 'y': {
                    checkConsistency = true;
                }
            }
            return;
        }
        if (lowerCaseArg.startsWith("bestmatchversion=")) {
            UserChangesMgr.findBestMatchVersion = Integer.parseInt(arg.substring(17));
            return;
        }
    }

    protected static Object instanciate(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void setTextEventHandler(TextEventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public void test() {
        int usr = 0;
        while (usr < 70) {
            UserChangesMgr ucm = new UserChangesMgr();
            ucm.setAutomaticPatternRecognition(patternRecognition);
            this.handler.setSourceCodeMixer(ucm);
            int gen = 0;
            while (gen < 10) {
                GeneratedInfo generated = this.makeGenerated((usr + 1) * (usr + 1));
                if (checkConsistency) {
                    ucm.concistencyCheck();
                }
                ucm.setGeneratedInfo(generated);
                int chg = 0;
                while (chg < 5) {
                    if (checkConsistency) {
                        ucm.concistencyCheck();
                    }
                    this.makeChange();
                    if (checkConsistency) {
                        ucm.concistencyCheck();
                    }
                    ++chg;
                }
                ++gen;
            }
            Iterator rootNodes = ucm.rootNodes(false);
            while (rootNodes.hasNext()) {
                TextNode node = (TextNode)rootNodes.next();
                node.restoreGeneratedCode();
            }
            if (checkConsistency) {
                ucm.concistencyCheck();
            }
            Iterator segments = ucm.segments(null, null, true, true, false);
            while (segments.hasNext()) {
                TextSegment segment = (TextSegment)segments.next();
                if (!segment.isUserCode()) continue;
                throw new RuntimeException("Restore generated code failed");
            }
            ++usr;
        }
    }

    protected GeneratedInfo makeGenerated(int length) {
        GeneratedCodeMgr generated = new GeneratedCodeMgr();
        Object tagName = "Root";
        int tagCount = 0;
        int level = 0;
        int idx = 0;
        while (idx < length || level > 0) {
            int r = rand.nextInt(10);
            if (r == 0) {
                r = rand.nextInt(length);
                if (level == 0 || r >= idx) {
                    ++level;
                    tagName = (String)tagName + "." + ++tagCount;
                    tagCount = 0;
                    generated.beginTag((String)tagName);
                    continue;
                }
                generated.endTag((String)tagName);
                int dot = ((String)tagName).lastIndexOf(46);
                tagCount = Integer.parseInt(((String)tagName).substring(dot + 1));
                tagName = ((String)tagName).substring(0, dot);
                --level;
                continue;
            }
            if (rand.nextInt(15) == 0) {
                generated.appendText(blanks.substring(0, 1 + rand.nextInt(blanks.length())));
                continue;
            }
            char c = (char)(rand.nextInt(15) == 0 ? 32 : 65 + rand.nextInt(26));
            generated.appendText(Character.toString(c));
            ++idx;
        }
        return generated;
    }

    protected void makeChange() {
        CharSequence text = this.handler.getSourceCodeMixer().text();
        int totalLength = text.length();
        int start = 0;
        int stop = 0;
        int removeLength = 0;
        String toInsert = "";
        switch (rand.nextInt(3)) {
            case 0: {
                removeLength = 0;
                start = stop = rand.nextInt(totalLength + 1);
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
                break;
            }
            case 1: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                break;
            }
            case 2: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
            }
        }
        StringBuffer result = new StringBuffer(totalLength - removeLength + toInsert.length());
        result.append(text.subSequence(0, start));
        result.append(toInsert);
        result.append(text.subSequence(stop, totalLength));
        this.handler.replaceText(start, stop, toInsert);
        this.check(result);
    }

    /*
     * Unable to fully structure code
     */
    protected void check(StringBuffer buf) {
        text = this.handler.getSourceCodeMixer().text();
        len = text.length();
        if (buf.length() == len) ** GOTO lbl7
        throw new RuntimeException("Wrong length at test #" + TextEventHandlerTest1.testCount);
lbl-1000:
        // 1 sources

        {
            if (text.charAt(len) == buf.charAt(len)) continue;
            throw new RuntimeException("Wrong text at test #" + TextEventHandlerTest1.testCount);
lbl7:
            // 2 sources

            ** while (--len >= 0)
        }
lbl8:
        // 1 sources

        ++TextEventHandlerTest1.testCount;
    }

    protected String makeTextToInsert(int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(rand.nextInt(15) != 0 ? 97 + rand.nextInt(26) : 32);
            ++i;
        }
        return String.valueOf(chars);
    }

    protected void printTags(GeneratedInfo generated) {
        StringBuffer buffer = new StringBuffer();
        this.showTags(generated, buffer);
        System.out.println(buffer);
    }

    protected void printNodes(SourceCodeMixer mixer) {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(mixer, buffer);
        System.out.println(buffer);
    }

    protected void showTags(GeneratedInfo generated, StringBuffer buffer) {
        this.showTag(generated.getRootTag(), buffer);
    }

    protected void showTag(GeneratedTag tag, StringBuffer buffer) {
        int i = 0;
        while (i < tag.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(tag).append('\n');
        Iterator subTags = tag.sons().iterator();
        while (subTags.hasNext()) {
            this.showTag((GeneratedTag)subTags.next(), buffer);
        }
    }

    protected void showNodes(SourceCodeMixer mixer, StringBuffer buffer) {
        Iterator nodes = mixer.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
    }

    protected void showNode(TextNode node, StringBuffer buffer) {
        int i = 0;
        while (i < node.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']').append('\n');
    }
}

