/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;

public class SimplifyUnitTest {
    public static final String text = "int f( int x, int y )\n{\n    if ( x < 0 ) x = -x;\n    if ( y < 0 ) y = -y;\n\n    if ( x < y )\n    {\n        int swap = y;\n        y = x;\n        x = swap;\n    }\n\n    return x*x - y*y;\n}\n";
    public static final int[][] tagIndexes;
    public static final int[][][][] changeIndexes;
    public static final String[][][] newText;
    protected static long seed;
    protected static String handlerClassName;
    protected static Random rand;
    protected TextEventHandler handler;
    protected int testCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[20];
        nArray[1] = 28;
        nArray[2] = 41;
        nArray[3] = -48;
        nArray[4] = -48;
        nArray[5] = 53;
        nArray[6] = 66;
        nArray[7] = -73;
        nArray[8] = -73;
        nArray[9] = 79;
        nArray[10] = 106;
        nArray[11] = -119;
        nArray[12] = 128;
        nArray[13] = -134;
        nArray[14] = 143;
        nArray[15] = -152;
        nArray[16] = -158;
        nArray[17] = 164;
        nArray[18] = -181;
        nArray[19] = -183;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 28;
        nArray2[2] = -48;
        nArray2[3] = 49;
        nArray2[4] = 53;
        nArray2[5] = -73;
        nArray2[6] = 79;
        nArray2[7] = -158;
        nArray2[8] = 164;
        nArray2[9] = -181;
        nArray2[10] = -182;
        nArray2[11] = -183;
        nArrayArray[1] = nArray2;
        tagIndexes = nArrayArray;
        int[][][][] nArrayArray2 = new int[2][][][];
        int[][][] nArrayArray3 = new int[16][][];
        nArrayArray3[0] = new int[][]{{41, 42}, {66, 67}};
        nArrayArray3[1] = new int[][]{{28, 29}, {53, 54}, {41, 42}, {66, 67}};
        nArrayArray3[2] = new int[][]{{79, 80}};
        nArrayArray3[3] = new int[][]{{79, 80}, {106, 107}};
        nArrayArray3[4] = new int[][]{{79, 80}, {128, 129}};
        nArrayArray3[5] = new int[][]{{79, 80}, {143, 144}};
        nArrayArray3[6] = new int[][]{{79, 80}, {106, 107}, {128, 129}};
        nArrayArray3[7] = new int[][]{{79, 80}, {106, 107}, {143, 144}};
        nArrayArray3[8] = new int[][]{{79, 80}, {128, 129}, {143, 144}};
        nArrayArray3[9] = new int[][]{{79, 80}, {106, 107}, {128, 129}, {143, 144}};
        nArrayArray3[10] = new int[][]{{24, 158}};
        int[][] nArrayArray4 = new int[4][];
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray4[0] = nArray3;
        nArrayArray4[1] = new int[]{135, 137};
        nArrayArray4[2] = new int[]{120, 122};
        nArrayArray4[3] = new int[]{98, 100};
        nArrayArray3[11] = nArrayArray4;
        int[][] nArrayArray5 = new int[3][];
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray5[0] = nArray4;
        nArrayArray5[1] = new int[]{46, 47};
        nArrayArray5[2] = new int[]{120, 128};
        nArrayArray3[12] = nArrayArray5;
        int[][] nArrayArray6 = new int[1][];
        int[] nArray5 = new int[2];
        nArray5[1] = 183;
        nArrayArray6[0] = nArray5;
        nArrayArray3[13] = nArrayArray6;
        int[][] nArrayArray7 = new int[1][];
        int[] nArray6 = new int[2];
        nArray6[1] = 183;
        nArrayArray7[0] = nArray6;
        nArrayArray3[14] = nArrayArray7;
        nArrayArray3[15] = new int[][]{{106, 181}, {28, 73}};
        nArrayArray2[0] = nArrayArray3;
        int[][][] nArrayArray8 = new int[1][][];
        int[][] nArrayArray9 = new int[1][];
        int[] nArray7 = new int[2];
        nArray7[1] = 1;
        nArrayArray9[0] = nArray7;
        nArrayArray8[0] = nArrayArray9;
        nArrayArray2[1] = nArrayArray8;
        changeIndexes = nArrayArray2;
        newText = new String[][][]{{{"x", "y"}, {"i", "i", "X", "Y"}, {"i"}, {"i", "I"}, {"i", "Y"}, {"i", "X"}, {"i", "I", "Y"}, {"i", "I", "X"}, {"i", "Y", "X"}, {"i", "I", "Y", "X"}, {"    if ( x < 0 ) x = -x;\n    if ( y < 0 ) y = -y;\n\n    if ( x < y )\n    {\n        int swap = y;\n        y = x;\n        x = swap;\n    }"}, {"i", "", "", ""}, {"i", "X", ""}, {"int f( int x, int y )\n{\n    Insertion1\n    if ( x < 0 ) x = -x;\n    Insertion2\n    if ( y < 0 ) y = -y;\n    Insertion3\n    if ( x < y )\n    {\n        Insertion4\n        int swap = y;\n        Insertion5\n        y = x;\n        Insertion6\n        x = swap;\n        Insertion7\n    }\n    Insertion8\n    return x*x - y*y;\n    Insertion9\n}\n"}, {"int f( int x, int y )\n{\n    Insertion1\n    if ( x < 0 ) Insertion2 x = -x; Insertion3\n    Insertion4\n    if ( y < 0 ) Insertion5 y = -y; Insertion6\n    Insertion7\n    if ( x < y )\n    {\n        Insertion8\n        int swap = y;\n        Insertion9\n        y = x;\n        Insertion10\n        x = swap;\n        Insertion11\n    }\n    Insertion12\n    return x*x - y*y;\n    Insertion13\n}\n"}, {"Insertion7\n        int swap = y;\n        Insertion8\n        y = x;\n        Insertion9\n        x = swap;\n        Insertion10\n    }\n    Insertion11\n    return x*x - y*y;\n    Insertion12", "Insertion1\n    if ( x < 0 ) Insertion2 x = -x; Insertion3\n    Insertion4\n    if ( y < 0 ) Insertion5 y = -y; Insertion6"}}, {{"i"}}};
    }

    public TextEventHandler getTextEventHandler() {
        return this.handler;
    }

    public static void main(String[] args) {
        seed = System.currentTimeMillis();
        handlerClassName = "com.ibm.vap.pdp.editor.core.DummyHandler";
        SimplifyUnitTest.analyzeArgs(args);
        rand = new Random(seed);
        long start = System.currentTimeMillis();
        try {
            System.out.println("Start simplify test, class=" + handlerClassName + ", seed=" + seed);
            TextEventHandler handler = (TextEventHandler)SimplifyUnitTest.instanciate(handlerClassName);
            SimplifyUnitTest tester = new SimplifyUnitTest();
            tester.setTextEventHandler(handler);
            tester.test();
            System.out.println("Stop simplify test, time=" + (System.currentTimeMillis() - start));
        }
        catch (Throwable t) {
            t.printStackTrace(new PrintStream(System.out));
        }
    }

    protected static void analyzeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            SimplifyUnitTest.analyzeArg(args[i]);
            ++i;
        }
    }

    protected static void analyzeArg(String arg) {
        if (arg.startsWith("seed=")) {
            seed = Long.parseLong(arg.substring(5));
        } else if (arg.startsWith("class=")) {
            handlerClassName = arg.substring(6);
        }
    }

    protected static Object instanciate(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void setTextEventHandler(TextEventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public void test() {
        this.testCount = 0;
        int count = 0;
        while (count < tagIndexes.length) {
            GeneratedInfo generated = this.makeGenerated(tagIndexes[count]);
            System.out.println("Generated code :");
            System.out.println(generated.getText());
            this.printTags(generated);
            UserChangesMgr scm = new UserChangesMgr();
            scm.setAutomaticPatternRecognition(false);
            scm.setGeneratedInfo(generated);
            this.handler.setSourceCodeMixer(scm);
            this.applyChanges(count);
            ++count;
        }
    }

    protected GeneratedInfo makeGenerated(int[] indexes) {
        GeneratedCodeMgr generated = new GeneratedCodeMgr();
        Object tagName = "Root";
        int tagCount = 0;
        int index = 0;
        int count = 0;
        while (count < indexes.length) {
            boolean isClosing;
            int nextIndex = indexes[count];
            boolean bl = isClosing = nextIndex < 0;
            if (isClosing) {
                nextIndex = -nextIndex;
            }
            generated.appendText(text.subSequence(index, nextIndex));
            if (!isClosing) {
                tagName = (String)tagName + "." + ++tagCount;
                tagCount = 0;
                generated.beginTag((String)tagName);
            } else {
                generated.endTag((String)tagName);
                int dot = ((String)tagName).lastIndexOf(46);
                tagCount = Integer.parseInt(((String)tagName).substring(dot + 1));
                tagName = ((String)tagName).substring(0, dot);
            }
            index = nextIndex;
            ++count;
        }
        generated.appendText(text.subSequence(index, text.length()));
        return generated;
    }

    protected void printTags(GeneratedInfo generated) {
        StringBuffer buffer = new StringBuffer();
        this.showTags(generated, buffer);
        System.out.println(buffer);
    }

    protected void printNodes(SourceCodeMixer mixer) {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(mixer, buffer);
        System.out.println(buffer);
    }

    protected void showTags(GeneratedInfo generated, StringBuffer buffer) {
        this.showTag(generated.getRootTag(), buffer);
    }

    protected void showTag(GeneratedTag tag, StringBuffer buffer) {
        int i = 0;
        while (i < tag.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(tag).append(" = ");
        this.showText(tag.getText(), buffer);
        buffer.append("\n");
        Iterator subTags = tag.sons().iterator();
        while (subTags.hasNext()) {
            this.showTag((GeneratedTag)subTags.next(), buffer);
        }
    }

    protected void showText(CharSequence text, StringBuffer buffer) {
        buffer.append('\"');
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        buffer.append('\"');
    }

    protected void showNodes(SourceCodeMixer mixer, StringBuffer buffer) {
        Iterator nodes = mixer.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
    }

    protected void showNode(TextNode node, StringBuffer buffer) {
        int i = 0;
        while (i < node.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']');
        if (node.isUserChange()) {
            buffer.append(" = ");
            this.showText(node.text(), buffer);
        }
        buffer.append('\n');
    }

    protected boolean openTag(int level, int maxLevel, int index, int maxIndex) {
        if (level == 0) {
            return true;
        }
        if (level == maxLevel) {
            return false;
        }
        switch (rand.nextInt(3)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return rand.nextInt(maxIndex) > index;
    }

    protected void applyChanges(int count) {
        int nbChangeSequences = changeIndexes[count].length;
        int i = 0;
        while (i < nbChangeSequences) {
            System.out.println("-------------------------------------------------------------------");
            int nbChanges = changeIndexes[count][i].length;
            int j = 0;
            while (j < nbChanges) {
                CharSequence text = this.handler.getSourceCodeMixer().text();
                int start = changeIndexes[count][i][j][0];
                int stop = changeIndexes[count][i][j][1];
                String chars = newText[count][i][j];
                CharSequence replacedChars = text.subSequence(start, stop);
                System.out.println("Replace interval [" + start + "," + stop + "]=\"" + String.valueOf(replacedChars) + "\" with \"" + String.valueOf(chars) + "\".");
                this.handler.replaceText(start, stop, chars);
                ++j;
            }
            System.out.println("\nBefore simplify =");
            System.out.println(this.handler.getSourceCodeMixer().text());
            this.printNodes(this.handler.getSourceCodeMixer());
            String textBeforeSimplify = this.handler.getSourceCodeMixer().text().toString();
            boolean simplified1 = this.handler.getSourceCodeMixer().doPatternRecognition();
            if (simplified1) {
                System.out.println("After simplify overrides :");
                this.printNodes(this.handler.getSourceCodeMixer());
            } else {
                System.out.println("No way to simplify overrides.");
            }
            this.check(textBeforeSimplify, ++this.testCount);
            this.handler.getSourceCodeMixer().clearAllChanges();
            ++i;
        }
    }

    protected void concistencyCheck() {
        ((UserChangesMgr)this.handler.getSourceCodeMixer()).concistencyCheck();
    }

    /*
     * Unable to fully structure code
     */
    protected void check(CharSequence result, int testCount) {
        text = this.handler.getSourceCodeMixer().text();
        len = text.length();
        if (result.length() == len) ** GOTO lbl9
        System.out.println(text);
        throw new RuntimeException("Wrong length test #" + testCount);
lbl-1000:
        // 1 sources

        {
            if (text.charAt(len) == result.charAt(len)) continue;
            System.out.println(text);
            throw new RuntimeException("Wrong text at test #" + testCount);
lbl9:
            // 2 sources

            ** while (--len >= 0)
        }
lbl10:
        // 1 sources

    }
}

