/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import java.util.Random;

public class SimplifyTest {
    public static final int MAX_GAP = 1000;
    public static final String line = "0123456789          ABCDEFGHIJKLMNOPQRSTUVWXYZ              abcdefghijklmnopqrstuvwxyz             \n";
    public static final int lineLength = "0123456789          ABCDEFGHIJKLMNOPQRSTUVWXYZ              abcdefghijklmnopqrstuvwxyz             \n".length();
    protected static long seed;
    protected static String handlerClassName;
    protected static Random rand;
    protected TextEventHandler handler;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextEventHandler getTextEventHandler() {
        return this.handler;
    }

    public static void main(String[] args) {
        seed = System.currentTimeMillis();
        handlerClassName = "com.ibm.vap.pdp.editor.core.DummyHandler";
        SimplifyTest.analyzeArgs(args);
        rand = new Random(seed);
        long start = System.currentTimeMillis();
        try {
            System.out.println("Start simplify test, class=" + handlerClassName + ", seed=" + seed);
            TextEventHandler handler = (TextEventHandler)SimplifyTest.instanciate(handlerClassName);
            SimplifyTest tester = new SimplifyTest();
            tester.setTextEventHandler(handler);
            tester.test();
            System.out.println("Stop simplify test, time=" + (System.currentTimeMillis() - start));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void analyzeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            SimplifyTest.analyzeArg(args[i]);
            ++i;
        }
    }

    protected static void analyzeArg(String arg) {
        if (arg.startsWith("seed=")) {
            seed = Long.parseLong(arg.substring(5));
        } else if (arg.startsWith("class=")) {
            handlerClassName = arg.substring(6);
        }
    }

    protected static Object instanciate(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void setTextEventHandler(TextEventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public void test() {
        int testCount = 0;
        int nbLine = 1;
        while (nbLine <= 25) {
            int count = 0;
            while (count < 3) {
                GeneratedInfo generated = this.makeGenerated(nbLine);
                this.printTags(generated);
                UserChangesMgr scm = new UserChangesMgr();
                scm.setAutomaticPatternRecognition(false);
                scm.setGeneratedInfo(generated);
                this.handler.setSourceCodeMixer(scm);
                this.applyChanges(++testCount);
                ++count;
            }
            nbLine *= 5;
        }
    }

    protected GeneratedInfo makeGenerated(int nbLine) {
        GeneratedCodeMgr generated = new GeneratedCodeMgr();
        Object tagName = "Root";
        int tagCount = 0;
        int level = 0;
        int maxIndex = nbLine * lineLength;
        int maxLevel = this.bitLength(maxIndex);
        int index = 0;
        while (true) {
            int gap = this.chooseValueDecreasingProbability(Math.min(maxIndex - index + 1, 1000));
            this.appendText(index, gap, generated);
            if (index + gap == maxIndex && level == 0 && rand.nextInt(3) == 0) break;
            if (this.openTag(level, maxLevel, index, maxIndex)) {
                ++level;
                tagName = (String)tagName + "." + ++tagCount;
                tagCount = 0;
                generated.beginTag((String)tagName);
            } else {
                generated.endTag((String)tagName);
                int dot = ((String)tagName).lastIndexOf(46);
                tagCount = Integer.parseInt(((String)tagName).substring(dot + 1));
                tagName = ((String)tagName).substring(0, dot);
                --level;
            }
            index += gap;
        }
        return generated;
    }

    protected void printTags(GeneratedInfo generated) {
        StringBuffer buffer = new StringBuffer();
        this.showTags(generated, buffer);
        System.out.println(buffer);
    }

    protected void printNodes(SourceCodeMixer mixer) {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(mixer, buffer);
        System.out.println(buffer);
    }

    protected void showTags(GeneratedInfo generated, StringBuffer buffer) {
        this.showTag(generated.getRootTag(), buffer);
    }

    protected void showTag(GeneratedTag tag, StringBuffer buffer) {
        int i = 0;
        while (i < tag.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(tag).append('\n');
        Iterator subTags = tag.sons().iterator();
        while (subTags.hasNext()) {
            this.showTag((GeneratedTag)subTags.next(), buffer);
        }
    }

    protected void showNodes(SourceCodeMixer mixer, StringBuffer buffer) {
        Iterator nodes = mixer.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
    }

    protected void showNode(TextNode node, StringBuffer buffer) {
        int i = 0;
        while (i < node.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']').append('\n');
    }

    protected void appendText(int index, int length, GeneratedCodeMgr generated) {
        if (index >= lineLength) {
            index %= lineLength;
        }
        while (index + length > lineLength) {
            generated.appendText(line.subSequence(index, lineLength));
            length -= lineLength - index;
            index = 0;
        }
        if (length > 0) {
            generated.appendText(line.subSequence(index, index + length));
        }
    }

    protected boolean openTag(int level, int maxLevel, int index, int maxIndex) {
        if (level == 0) {
            return true;
        }
        if (level == maxLevel) {
            return false;
        }
        switch (rand.nextInt(3)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return rand.nextInt(maxIndex) > index;
    }

    protected void applyChanges(int testCount) {
        int nbChanges = 3;
        StringBuffer result = new StringBuffer();
        int i = 1;
        while (i <= nbChanges) {
            CharSequence text = this.handler.getSourceCodeMixer().text();
            int totalLength = text.length();
            int nbChars = this.chooseChangeLength(totalLength);
            int replacedLength = this.chooseChangeLength(totalLength);
            int start = rand.nextInt(totalLength - replacedLength);
            int stop = start + replacedLength;
            CharSequence chars = this.makeText(nbChars);
            System.out.println("Replace interval [" + start + "," + stop + "] with " + chars.length() + " chars.");
            result.setLength(0);
            result.ensureCapacity(totalLength - replacedLength + nbChars);
            result.append(text.subSequence(0, start));
            result.append(chars);
            result.append(text.subSequence(stop, totalLength));
            this.handler.replaceText(start, stop, chars);
            this.handler.getSourceCodeMixer().doPatternRecognition();
            this.check(result, i, testCount);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void check(StringBuffer buf, int changeCount, int testCount) {
        text = this.handler.getSourceCodeMixer().text();
        len = text.length();
        if (buf.length() == len) ** GOTO lbl7
        throw new RuntimeException("Wrong length at change #" + changeCount + " of test #" + testCount);
lbl-1000:
        // 1 sources

        {
            if (text.charAt(len) == buf.charAt(len)) continue;
            throw new RuntimeException("Wrong text at change #" + changeCount + " of test #" + testCount);
lbl7:
            // 2 sources

            ** while (--len >= 0)
        }
lbl8:
        // 1 sources

    }

    protected void applyOneChange() {
        CharSequence text = this.handler.getSourceCodeMixer().text();
        int totalLength = text.length();
        int nbChars = this.chooseChangeLength(totalLength);
        int replacedLength = this.chooseChangeLength(totalLength);
        int start = rand.nextInt(totalLength - replacedLength);
        int stop = start + replacedLength;
        CharSequence chars = this.makeText(nbChars);
        StringBuffer result = new StringBuffer(totalLength - replacedLength + nbChars);
        result.append(text.subSequence(0, start));
        result.append(chars);
        result.append(text.subSequence(stop, totalLength));
        this.handler.replaceText(start, stop, chars);
    }

    protected int chooseChangeLength(int maxLength) {
        return this.chooseValueDecreasingProbability(maxLength, 5);
    }

    protected int chooseValueDecreasingProbability(int maxValue) {
        return this.chooseValueDecreasingProbability(maxValue, this.bitLength(maxValue) / 2);
    }

    protected int bitLength(int value) {
        if (value < 0) {
            value = -value;
        }
        int count = 0;
        while (value > 0) {
            value >>= 1;
            ++count;
        }
        return count;
    }

    protected int chooseValueDecreasingProbability(int maxValue, int decreaseProbability) {
        int minValue = rand.nextInt(maxValue);
        while (decreaseProbability-- > 0) {
            minValue = Math.min(rand.nextInt(maxValue), minValue);
        }
        return minValue;
    }

    protected CharSequence makeText(int length) {
        StringBuffer buffer = new StringBuffer(length);
        while (length-- > 0) {
            buffer.append(line.charAt(rand.nextInt(lineLength)));
        }
        return buffer.toString();
    }
}

