/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import java.util.Iterator;

public class ReconciliationTest {
    protected UserChangesMgr changesMgr;
    protected GeneratedCodeMgr generated1;
    protected GeneratedCodeMgr generated2;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void test() {
        this.changesMgr = new UserChangesMgr();
        this.generated1 = new GeneratedCodeMgr();
        this.generate1(this.generated1);
        this.changesMgr.setGeneratedInfo(this.generated1);
        this.show("Premier g\u00e9n\u00e9r\u00e9 :");
        this.generated2 = new GeneratedCodeMgr();
        this.generate2(this.generated2);
        this.changesMgr.setGeneratedInfo(this.generated2);
        this.show("Second g\u00e9n\u00e9r\u00e9 :");
        this.changesMgr.setGeneratedInfo(this.generated1);
        this.addUserCode();
        this.show("Apr\u00e8s insertions utilisateur dans le premier g\u00e9n\u00e9r\u00e9 :");
        this.changesMgr.setGeneratedInfo(this.generated2);
        this.show("Apr\u00e8s changement de g\u00e9n\u00e9r\u00e9 :");
        this.changesMgr.setGeneratedInfo(this.generated1);
        this.show("Apr\u00e8s reprise du premier g\u00e9n\u00e9r\u00e9 :");
    }

    public void generate1(GeneratedCodeMgr mgr) {
        mgr.beginTag("Presentation");
        mgr.appendText("Bonjour,");
        mgr.endTag("Presentation");
        mgr.appendText("\n");
        mgr.beginTag("Phrase");
        mgr.beginTag("Sujet");
        mgr.beginTag("Article");
        mgr.appendText("Le");
        mgr.endTag("Article");
        mgr.appendText("   ");
        mgr.beginTag("Adjectif");
        mgr.appendText("petit");
        mgr.endTag("Adjectif");
        mgr.appendText("   ");
        mgr.beginTag("Nom");
        mgr.appendText("chat");
        mgr.endTag("Nom");
        mgr.endTag("Sujet");
        mgr.appendText("   ");
        mgr.beginTag("Verbe");
        mgr.appendText("est");
        mgr.endTag("Verbe");
        mgr.appendText("   ");
        mgr.beginTag("Attribut du sujet");
        mgr.appendText("mort");
        mgr.endTag("Attribut du sujet");
        mgr.appendText(".");
        mgr.endTag("Phrase");
        mgr.appendText("\n");
        mgr.beginTag("Conclusion");
        mgr.appendText("Rien \u00e0 p\u00e9ter.");
        mgr.endTag("Conclusion");
    }

    public void generate2(GeneratedCodeMgr mgr) {
        mgr.beginTag("Conclusion");
        mgr.appendText("Rien \u00e0 p\u00e9ter.");
        mgr.endTag("Conclusion");
        mgr.appendText("\n");
        mgr.beginTag("Phrase");
        mgr.beginTag("Sujet");
        mgr.beginTag("Article");
        mgr.appendText("Le");
        mgr.endTag("Article");
        mgr.appendText("   ");
        mgr.beginTag("Nom");
        mgr.appendText("chat");
        mgr.endTag("Nom");
        mgr.endTag("Sujet");
        mgr.appendText("   ");
        mgr.beginTag("Verbe");
        mgr.appendText("est");
        mgr.endTag("Verbe");
        mgr.appendText("   ");
        mgr.beginTag("Attribut du sujet");
        mgr.appendText("   ");
        mgr.appendText("mort");
        mgr.endTag("Attribut du sujet");
        mgr.appendText(".");
        mgr.endTag("Phrase");
        mgr.appendText("\n");
        mgr.beginTag("Presentation");
        mgr.appendText("Bonjour,");
        mgr.endTag("Presentation");
    }

    public void addUserCode() {
        GeneratedInfo gi = this.changesMgr.getGeneratedInfo();
        this.changesMgr.setTextAt(gi.getTag("Article"), 0, "Le");
        this.changesMgr.setTextAt(gi.getTag("Adjectif"), 0, "chien");
        this.changesMgr.setTextAt(gi.getTag("Nom"), 0, "de chirac");
        this.changesMgr.setTextAt(gi.getTag("Presentation"), -1, "Citation:");
        this.changesMgr.setTextAt(gi.getTag("Conclusion"), 1, "Fin de citation.");
    }

    public void show(String title) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(title).append('\n');
        buffer.append("Texte complet :\n");
        buffer.append(this.changesMgr.text());
        buffer.append('\n');
        this.showNodes(buffer);
        buffer.append('\n');
        Iterator nodes = this.changesMgr.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
        System.out.println(buffer);
    }

    public void showNodes(StringBuffer buffer) {
        Iterator nodes = this.changesMgr.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            int i = 0;
            while (i < node.getDepth()) {
                buffer.append("    ");
                ++i;
            }
            buffer.append(node);
            buffer.append('\n');
        }
    }

    public void showNode(TextNode node, StringBuffer buffer) {
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']');
        Iterator children = node.children(false);
        if (children.hasNext()) {
            buffer.append("(");
            while (children.hasNext()) {
                TextNode son = (TextNode)children.next();
                buffer.append(son);
                if (!children.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append("\n\"").append(node.text()).append("\"\n");
        if (!node.text().toString().equals(this.changesMgr.text().subSequence(node.startIndex(), node.stopIndex()))) {
            throw new RuntimeException("Erreur de reconstitution du texte.");
        }
        buffer.append("\n");
    }

    public static void main(String[] args) {
        new ReconciliationTest().test();
    }
}

