/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import java.util.Random;

public class RecognitionTest {
    protected static long seed;
    protected static String handlerClassName;
    protected static Random rand;
    public static int testCount;
    protected static long gatheredChars;
    protected static long totalChars;
    protected static final int averageSegmentLength = 10;
    protected static final int blanksRate = 15;
    protected static final String blanks = "          ";
    protected TextEventHandler handler;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        testCount = 1;
        gatheredChars = 0L;
        totalChars = 0L;
    }

    public static void main(String[] args) {
        seed = System.currentTimeMillis();
        handlerClassName = "com.ibm.vap.pdp.editor.core.DummyHandler";
        RecognitionTest.analyzeArgs(args);
        rand = new Random(seed);
        long start = System.currentTimeMillis();
        try {
            System.out.println("Start Recognition test, class=" + handlerClassName + ", seed=" + seed);
            TextEventHandler handler = (TextEventHandler)RecognitionTest.instanciate(handlerClassName);
            RecognitionTest tester = new RecognitionTest();
            tester.setTextEventHandler(handler);
            tester.test();
            System.out.println("Stop Recognition test, " + testCount + " tests performed, " + gatheredChars + "/" + totalChars + " gathered chars (" + 100L * gatheredChars / totalChars + "%), time=" + (System.currentTimeMillis() - start));
        }
        catch (Throwable t) {
            System.err.println("Error executing test #" + testCount);
            t.printStackTrace();
        }
    }

    protected static void analyzeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            RecognitionTest.analyzeArg(args[i]);
            ++i;
        }
    }

    protected static void analyzeArg(String arg) {
        if (arg.startsWith("seed=")) {
            seed = Long.parseLong(arg.substring(5));
        } else if (arg.startsWith("class=")) {
            handlerClassName = arg.substring(6);
        }
    }

    protected static Object instanciate(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void setTextEventHandler(TextEventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public void test() {
        int usr = 0;
        while (usr < 30) {
            UserChangesMgr ucm = new UserChangesMgr();
            ucm.setAutomaticPatternRecognition(false);
            this.handler.setSourceCodeMixer(ucm);
            int gen = 0;
            while (gen < 30) {
                GeneratedInfo generated = this.makeGenerated((usr + 1) * (usr + 1));
                ucm.setGeneratedInfo(generated);
                int chg = 0;
                while (chg < 5) {
                    this.makeChange();
                    ++chg;
                }
                String textBefore = ucm.text().toString();
                int userCharsBefore = this.countUserChars(ucm);
                ucm.doPatternRecognition();
                this.checkRecognition(textBefore, userCharsBefore);
                ++gen;
            }
            ++usr;
        }
    }

    protected int countUserChars(UserChangesMgr ucm) {
        int count = 0;
        Iterator segments = ucm.segments(null, null, true, true, false);
        while (segments.hasNext()) {
            TextSegment segment = (TextSegment)segments.next();
            if (!segment.isUserCode()) continue;
            count += segment.length();
        }
        return count;
    }

    protected void checkRecognition(String textBefore, int userCharsBefore) {
        UserChangesMgr ucm = (UserChangesMgr)this.handler.getSourceCodeMixer();
        if (!ucm.text().toString().equals(textBefore)) {
            throw new RuntimeException("Wrong text after recognition at test #" + testCount);
        }
        int userCharsAfter = this.countUserChars(ucm);
        totalChars += (long)textBefore.length();
        gatheredChars += (long)(userCharsBefore - userCharsAfter);
        ++testCount;
    }

    protected GeneratedInfo makeGenerated(int length) {
        GeneratedCodeMgr generated = new GeneratedCodeMgr();
        Object tagName = "Root";
        int tagCount = 0;
        int level = 0;
        int idx = 0;
        while (idx < length || level > 0) {
            int r = rand.nextInt(10);
            if (r == 0) {
                r = rand.nextInt(length);
                if (level == 0 || r >= idx) {
                    ++level;
                    tagName = (String)tagName + "." + ++tagCount;
                    tagCount = 0;
                    generated.beginTag((String)tagName);
                    continue;
                }
                generated.endTag((String)tagName);
                int dot = ((String)tagName).lastIndexOf(46);
                tagCount = Integer.parseInt(((String)tagName).substring(dot + 1));
                tagName = ((String)tagName).substring(0, dot);
                --level;
                continue;
            }
            if (rand.nextInt(15) == 0) {
                generated.appendText(blanks.substring(0, 1 + rand.nextInt(blanks.length())));
                continue;
            }
            char c = (char)(rand.nextInt(15) == 0 ? 32 : 65 + rand.nextInt(26));
            generated.appendText(Character.toString(c));
            ++idx;
        }
        return generated;
    }

    protected void makeChange() {
        CharSequence text = this.handler.getSourceCodeMixer().text();
        int totalLength = text.length();
        int start = 0;
        int stop = 0;
        int removeLength = 0;
        CharSequence toInsert = "";
        switch (rand.nextInt(4)) {
            case 0: {
                removeLength = 0;
                start = stop = rand.nextInt(totalLength + 1);
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
                break;
            }
            case 1: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                break;
            }
            case 2: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
                break;
            }
            case 3: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                toInsert = text.subSequence(start, stop).toString();
            }
        }
        StringBuffer result = new StringBuffer(totalLength - removeLength + toInsert.length());
        result.append(text.subSequence(0, start));
        result.append(toInsert);
        result.append(text.subSequence(stop, totalLength));
        this.handler.replaceText(start, stop, toInsert);
        this.check(result);
    }

    /*
     * Unable to fully structure code
     */
    protected void check(StringBuffer buf) {
        text = this.handler.getSourceCodeMixer().text();
        len = text.length();
        if (buf.length() == len) ** GOTO lbl7
        throw new RuntimeException("Wrong length at test #" + RecognitionTest.testCount);
lbl-1000:
        // 1 sources

        {
            if (text.charAt(len) == buf.charAt(len)) continue;
            throw new RuntimeException("Wrong text at test #" + RecognitionTest.testCount);
lbl7:
            // 2 sources

            ** while (--len >= 0)
        }
lbl8:
        // 1 sources

        ++RecognitionTest.testCount;
    }

    protected CharSequence makeTextToInsert(int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(rand.nextInt(15) != 0 ? 97 + rand.nextInt(26) : 32);
            ++i;
        }
        return String.valueOf(chars);
    }

    protected void printTags(GeneratedInfo generated) {
        StringBuffer buffer = new StringBuffer();
        this.showTags(generated, buffer);
        System.out.println(buffer);
    }

    protected void printNodes(SourceCodeMixer mixer) {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(mixer, buffer);
        System.out.println(buffer);
    }

    protected void showTags(GeneratedInfo generated, StringBuffer buffer) {
        this.showTag(generated.getRootTag(), buffer);
    }

    protected void showTag(GeneratedTag tag, StringBuffer buffer) {
        int i = 0;
        while (i < tag.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(tag).append('\n');
        Iterator subTags = tag.sons().iterator();
        while (subTags.hasNext()) {
            this.showTag((GeneratedTag)subTags.next(), buffer);
        }
    }

    protected void showNodes(SourceCodeMixer mixer, StringBuffer buffer) {
        Iterator nodes = mixer.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
    }

    protected void showNode(TextNode node, StringBuffer buffer) {
        int i = 0;
        while (i < node.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']').append('\n');
    }
}

