/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import java.util.Iterator;

public class GeneratedCodeMgrTest {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        new GeneratedCodeMgrTest().test();
    }

    public void test() {
        GeneratedCodeMgr mgr = new GeneratedCodeMgr();
        this.generate(mgr);
        GeneratedCodeMgrTest.useGeneratedInfo(mgr);
    }

    public void generate(GeneratedCodeMgr mgr) {
        mgr.beginTag("Presentation");
        mgr.appendText("Bonjour,");
        mgr.endTag("Presentation");
        mgr.appendText("\n");
        mgr.beginTag("Phrase");
        mgr.beginTag("Sujet");
        mgr.beginTag("Article");
        mgr.appendText("Le");
        mgr.endTag("Article");
        mgr.appendText("   ");
        mgr.beginTag("Adjectif");
        mgr.appendText("petit");
        mgr.endTag("Adjectif");
        mgr.appendText("   ");
        mgr.beginTag("Nom");
        mgr.appendText("chat");
        mgr.endTag("Nom");
        mgr.endTag("Sujet");
        mgr.appendText("   ");
        mgr.beginTag("Verbe");
        mgr.appendText("est");
        mgr.endTag("Verbe");
        mgr.appendText("   ");
        mgr.beginTag("Attribut du sujet");
        mgr.appendText("mort");
        mgr.endTag("Attribut du sujet");
        mgr.appendText(".");
        mgr.endTag("Phrase");
        mgr.appendText("\n");
        mgr.beginTag("Conclusion");
        mgr.appendText("Rien \u00e0 p\u00e9ter.");
        mgr.endTag("Conclusion");
    }

    public static void useGeneratedInfo(GeneratedInfo gi) {
        StringBuffer buffer = new StringBuffer();
        GeneratedCodeMgrTest.showTags(gi, buffer);
        buffer.append('\n');
        for (GeneratedTag tag : gi.tags()) {
            GeneratedCodeMgrTest.showTag(tag, buffer);
        }
        System.out.println(buffer);
    }

    public static void showTags(GeneratedInfo gi, StringBuffer buffer) {
        for (GeneratedTag tag : gi.tags()) {
            int i = 0;
            while (i < tag.getDepth()) {
                buffer.append("    ");
                ++i;
            }
            buffer.append(tag.getName());
            buffer.append('\n');
        }
    }

    public static void showTag(GeneratedTag tag, StringBuffer buffer) {
        buffer.append(tag.getName()).append('[').append(tag.getStartRank()).append('-').append(tag.nbBlanksBefore()).append(',').append(tag.getStopRank()).append('+').append(tag.nbBlanksAfter()).append(']');
        if (!tag.sons().isEmpty()) {
            buffer.append("(");
            Iterator tags = tag.sons().iterator();
            while (tags.hasNext()) {
                GeneratedTag son = (GeneratedTag)tags.next();
                buffer.append(son.getName());
                if (!tags.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append("\n");
        buffer.append('\"');
        buffer.append(tag.getText());
        buffer.append('\"');
        buffer.append("\n\n");
    }
}

