/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.draft.changes.AnchorProposal;
import com.ibm.pdp.engine.draft.changes.NodeAnchor;
import com.ibm.pdp.engine.draft.changes.ReconcileExtension;
import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.engine.draft.test.BatchGenerator;
import com.ibm.pdp.engine.draft.test.BatchProgramDesign;
import com.ibm.pdp.engine.extension.IReconcileExtension;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class EditionEngineTest {
    protected static long seed;
    protected static String handlerClassName;
    protected static boolean patternRecognition;
    protected static boolean checkConsistency;
    protected static Random rand;
    public static int testCount;
    protected static final int averageSegmentLength = 10;
    protected static final int blanksRate = 15;
    protected static final String blanks = "          ";
    protected TextEventHandler handler;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        patternRecognition = true;
        testCount = 0;
    }

    public static void main(String[] args) {
        seed = System.currentTimeMillis();
        handlerClassName = "com.ibm.pdp.engine.draft.editor.core.TextChangeHandler";
        EditionEngineTest.analyzeArgs(args);
        UserChangesMgr.findBestMatchVersion = 1;
        while (UserChangesMgr.findBestMatchVersion <= 1) {
            UserChangesMgr.reuseBestMatchCount = 0;
            UserChangesMgr.findBestMatchCount = 0;
            UserChangesMgr.maxStepCount = 10000000L;
            rand = new Random(seed);
            testCount = 0;
            try {
                System.out.println("Start edition engine test :\n    class=" + handlerClassName + "\n    seed=" + seed + "\n    patternRecognition=" + patternRecognition + "\n    consistencyCheck=" + checkConsistency + "\n    bestMatchVersion=" + UserChangesMgr.findBestMatchVersion + "\n    maxStoredMatchings=" + UserChangesMgr.maxStoredMatchings);
                long start = System.currentTimeMillis();
                TextEventHandler handler = (TextEventHandler)EditionEngineTest.instanciate(handlerClassName);
                EditionEngineTest tester = new EditionEngineTest();
                tester.setTextEventHandler(handler);
                tester.test();
                long stop = System.currentTimeMillis();
                System.out.println("Best match : " + UserChangesMgr.reuseBestMatchCount + " / " + UserChangesMgr.findBestMatchCount);
                System.out.println("Stop edition engine test, " + testCount + " tests performed, time=" + (stop - start));
            }
            catch (Throwable t) {
                System.err.println("Error executing test #" + testCount);
                t.printStackTrace();
            }
            System.out.println();
            ++UserChangesMgr.findBestMatchVersion;
        }
    }

    protected static void analyzeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            EditionEngineTest.analyzeArg(args[i]);
            ++i;
        }
    }

    protected static void analyzeArg(String arg) {
        String lowerCaseArg = arg.toLowerCase();
        if (lowerCaseArg.startsWith("seed=")) {
            seed = Long.parseLong(EditionEngineTest.propertyValue(arg));
            return;
        }
        if (lowerCaseArg.startsWith("class=")) {
            handlerClassName = EditionEngineTest.propertyValue(arg);
            return;
        }
        if (lowerCaseArg.startsWith("patternrecognition=")) {
            char yesOrNo = EditionEngineTest.propertyValue(lowerCaseArg).charAt(0);
            switch (yesOrNo) {
                case 'o': 
                case 't': 
                case 'y': {
                    patternRecognition = true;
                }
            }
            return;
        }
        if (lowerCaseArg.startsWith("checkconsistency=")) {
            char yesOrNo = EditionEngineTest.propertyValue(lowerCaseArg).charAt(0);
            switch (yesOrNo) {
                case 'o': 
                case 't': 
                case 'y': {
                    checkConsistency = true;
                }
            }
            return;
        }
        if (lowerCaseArg.startsWith("bestmatchversion=")) {
            UserChangesMgr.findBestMatchVersion = Integer.parseInt(EditionEngineTest.propertyValue(arg));
            return;
        }
        if (lowerCaseArg.startsWith("maxstoredmatchings=")) {
            UserChangesMgr.maxStoredMatchings = Integer.parseInt(EditionEngineTest.propertyValue(arg));
            return;
        }
    }

    protected static String propertyValue(String nameAndValue) {
        int equalIndex = nameAndValue.indexOf(61);
        return equalIndex >= 0 ? nameAndValue.substring(equalIndex + 1) : "";
    }

    protected static Object instanciate(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void setTextEventHandler(TextEventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public void test() {
        int usr = 0;
        while (usr < 10) {
            UserChangesMgr scm = new UserChangesMgr();
            scm.setReconcileExtension(new EglAnchorChooser());
            this.handler.setSourceCodeMixer(scm);
            int gen = 0;
            while (gen < 20) {
                GeneratedInfo generated = this.makeGenerated(2 * usr + 1);
                scm.setAutomaticPatternRecognition(patternRecognition);
                scm.setGeneratedInfo(generated);
                int chg = 0;
                while (chg < 10) {
                    this.makeChange();
                    ++chg;
                }
                ++gen;
            }
            Iterator rootNodes = scm.rootNodes(false);
            while (rootNodes.hasNext()) {
                TextNode node = (TextNode)rootNodes.next();
                node.restoreGeneratedCode();
            }
            Iterator segments = scm.segments(null, null, true, true, false);
            while (segments.hasNext()) {
                TextSegment segment = (TextSegment)segments.next();
                if (!segment.isUserCode()) continue;
                throw new RuntimeException("Restore generated code failed");
            }
            ++usr;
        }
    }

    protected GeneratedInfo makeGenerated(int nbFiles) {
        BatchProgramDesign design = new BatchProgramDesign();
        design.setName("TestProgram");
        int nbInputFiles = 1 + (nbFiles + 1) / 2;
        nbInputFiles -= rand.nextInt(2 + nbInputFiles / 8);
        if (nbInputFiles > 0) {
            Object[] inputFiles = new String[nbInputFiles];
            int f = 0;
            while (f < nbInputFiles) {
                inputFiles[f] = "In" + f;
                ++f;
            }
            this.shuffle(inputFiles);
            f = 0;
            while (f < nbInputFiles) {
                design.addInputFile((String)inputFiles[f]);
                ++f;
            }
        }
        int nbOutputFiles = 1 + nbFiles / 2;
        if ((nbOutputFiles -= rand.nextInt(2 + nbOutputFiles / 8)) > 0) {
            Object[] outputFiles = new String[nbOutputFiles];
            int f = 0;
            while (f < nbOutputFiles) {
                outputFiles[f] = "Out" + f;
                ++f;
            }
            this.shuffle(outputFiles);
            f = 0;
            while (f < nbOutputFiles) {
                design.addOutputFile((String)outputFiles[f]);
                ++f;
            }
        }
        return new BatchGenerator(design).generate();
    }

    protected void shuffle(Object[] array) {
        if (array.length < 2) {
            return;
        }
        int nbSwap = rand.nextInt(4 + array.length / 8);
        while (nbSwap > 0) {
            int rightIdx;
            int leftIdx = rand.nextInt(array.length);
            if (leftIdx != (rightIdx = rand.nextInt(array.length))) {
                Object tmp = array[leftIdx];
                array[leftIdx] = array[rightIdx];
                array[rightIdx] = tmp;
            }
            --nbSwap;
        }
    }

    protected void makeChange() {
        CharSequence text = this.handler.getSourceCodeMixer().text();
        int totalLength = text.length();
        int start = 0;
        int stop = 0;
        int removeLength = 0;
        String toInsert = "";
        switch (rand.nextInt(4)) {
            case 0: {
                removeLength = 0;
                start = stop = rand.nextInt(totalLength + 1);
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
                break;
            }
            case 1: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                break;
            }
            case 2: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                toInsert = this.makeTextToInsert(rand.nextInt(1 + totalLength / 10));
                break;
            }
            case 3: {
                removeLength = rand.nextInt(1 + totalLength / 10);
                start = rand.nextInt(totalLength - removeLength);
                stop = start + removeLength;
                toInsert = text.subSequence(start, stop).toString();
            }
        }
        StringBuffer result = new StringBuffer(totalLength - removeLength + toInsert.length());
        result.append(text.subSequence(0, start));
        result.append(toInsert);
        result.append(text.subSequence(stop, totalLength));
        this.handler.replaceText(start, stop, toInsert);
        this.check(result);
    }

    /*
     * Unable to fully structure code
     */
    protected void check(StringBuffer buf) {
        if (EditionEngineTest.checkConsistency) {
            ((UserChangesMgr)this.handler.getSourceCodeMixer()).concistencyCheck();
        }
        text = this.handler.getSourceCodeMixer().text();
        len = text.length();
        if (buf.length() == len) ** GOTO lbl9
        throw new RuntimeException("Wrong length at test #" + EditionEngineTest.testCount);
lbl-1000:
        // 1 sources

        {
            if (text.charAt(len) == buf.charAt(len)) continue;
            throw new RuntimeException("Wrong text at test #" + EditionEngineTest.testCount);
lbl9:
            // 2 sources

            ** while (--len >= 0)
        }
lbl10:
        // 1 sources

        ++EditionEngineTest.testCount;
    }

    protected String makeTextToInsert(int length) {
        CharSequence text = this.handler.getSourceCodeMixer().text();
        int idx = rand.nextInt(text.length() - length);
        return text.subSequence(idx, idx + length).toString();
    }

    protected void printTags(GeneratedInfo generated) {
        StringBuffer buffer = new StringBuffer();
        this.showTags(generated, buffer);
        System.out.println(buffer);
    }

    protected void printNodes(SourceCodeMixer mixer) {
        StringBuffer buffer = new StringBuffer();
        this.showNodes(mixer, buffer);
        System.out.println(buffer);
    }

    protected void showTags(GeneratedInfo generated, StringBuffer buffer) {
        this.showTag(generated.getRootTag(), buffer);
    }

    protected void showTag(GeneratedTag tag, StringBuffer buffer) {
        int i = 0;
        while (i < tag.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(tag).append('\n');
        Iterator subTags = tag.sons().iterator();
        while (subTags.hasNext()) {
            this.showTag((GeneratedTag)subTags.next(), buffer);
        }
    }

    protected void showNodes(SourceCodeMixer mixer, StringBuffer buffer) {
        Iterator nodes = mixer.nodes(false);
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            this.showNode(node, buffer);
        }
    }

    protected void showNode(TextNode node, StringBuffer buffer) {
        int i = 0;
        while (i < node.getDepth()) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(node).append('[').append(node.startIndex()).append(',').append(node.stopIndex()).append(']').append('\n');
    }

    static class EglAnchorChooser
    implements ReconcileExtension,
    IReconcileExtension {
        @Override
        public int getInvocationCondition() {
            return 2;
        }

        @Override
        public void reconciliationStart() {
        }

        @Override
        public NodeAnchor findNewAnchor(AnchorProposal proposal) {
            return (NodeAnchor)proposal.proposedNewAnchors().next();
        }

        @Override
        public void reconciliationStop() {
        }

        public List<IReconcileTextInterval> dispatchReconcileTextIntervals(List<IReconcileLocationInterval> reconcileLocationIntervals, List<IReconcileTextInterval> reconcileTextIntervals, List<IProblem> problems, ITextAnalyzer textAnalyzer) {
            return null;
        }

        public Iterator<IProblem.IQuickFixAction> actions(IProblem problem) {
            return null;
        }

        public List<IProblem> validateReconcileProblems(List<IProblem> problems) {
            return problems;
        }
    }
}

