/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchProgramDesign {
    protected String name;
    protected Map fileFromName;
    protected List inputFiles = new ArrayList();
    protected List outputFiles = new ArrayList();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public BatchProgramDesign() {
        this.fileFromName = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public InOutFile addInputFile(String fileName, int idx) {
        if (this.fileFromName.containsKey(fileName)) {
            throw new RuntimeException("File already declared");
        }
        InOutFile file = this.newFile();
        file.setName(fileName);
        this.inputFiles.add(idx, file);
        this.fileFromName.put(fileName, file);
        return file;
    }

    public InOutFile addInputFile(String fileName) {
        return this.addInputFile(fileName, this.inputFiles.size());
    }

    public InOutFile addOutputFile(String fileName, int idx) {
        if (this.fileFromName.containsKey(fileName)) {
            throw new RuntimeException("File already declared");
        }
        InOutFile file = this.newFile();
        file.setName(fileName);
        this.outputFiles.add(idx, file);
        this.fileFromName.put(fileName, file);
        return file;
    }

    public InOutFile addOutputFile(String fileName) {
        return this.addOutputFile(fileName, this.outputFiles.size());
    }

    public InOutFile moveFileUp(String fileName) {
        InOutFile file = (InOutFile)this.fileFromName.get(fileName);
        if (file == null) {
            return null;
        }
        int idx = this.inputFiles.indexOf(file);
        if (idx >= 0) {
            if (idx > 0) {
                this.inputFiles.remove(idx);
                this.inputFiles.add(idx - 1, file);
            }
            return file;
        }
        idx = this.outputFiles.indexOf(file);
        if (idx > 0) {
            this.outputFiles.remove(idx);
            this.outputFiles.add(idx - 1, file);
        }
        return file;
    }

    public InOutFile moveFileDown(String fileName) {
        InOutFile file = (InOutFile)this.fileFromName.get(fileName);
        if (file == null) {
            return null;
        }
        int idx = this.inputFiles.indexOf(file);
        if (idx >= 0) {
            if (idx < this.inputFiles.size() - 1) {
                this.inputFiles.remove(idx);
                this.inputFiles.add(idx + 1, file);
            }
            return file;
        }
        idx = this.outputFiles.indexOf(file);
        if (idx < this.outputFiles.size() - 1) {
            this.outputFiles.remove(idx);
            this.outputFiles.add(idx + 1, file);
        }
        return file;
    }

    public boolean removeFile(String fileName) {
        InOutFile file = (InOutFile)this.fileFromName.remove(fileName);
        return file != null && (this.inputFiles.remove(file) || this.outputFiles.remove(file));
    }

    public Iterator inputFiles() {
        return this.inputFiles.iterator();
    }

    public int nbInputFiles() {
        return this.inputFiles.size();
    }

    public Iterator outputFiles() {
        return this.outputFiles.iterator();
    }

    public int nbOutputFiles() {
        return this.outputFiles.size();
    }

    public InOutFile getFileFromName(String fileName) {
        return (InOutFile)this.fileFromName.get(fileName);
    }

    public InOutFile renameFile(String oldName, String newName) {
        if (this.fileFromName.containsKey(newName)) {
            throw new RuntimeException("New file already exist");
        }
        InOutFile file = (InOutFile)this.fileFromName.remove(oldName);
        if (file == null) {
            throw new RuntimeException("Old file doesn't exist");
        }
        file.setName(newName);
        this.fileFromName.put(newName, file);
        return file;
    }

    protected InOutFile newFile() {
        return new InOutFile();
    }

    public static class InOutFile {
        protected String name;

        public String getName() {
            return this.name;
        }

        protected void setName(String newName) {
            this.name = newName;
        }
    }
}

