/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.test;

import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.test.BatchProgramDesign;
import com.ibm.pdp.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class BatchGenerator {
    private static String EOL = System.getProperty("line.separator");
    protected static final boolean GENER_ETIQ = true;
    protected static final String BEGIN_MARK = "/*<";
    public static final int CHAR_BEFORE = "/*<".length();
    protected static final String END_MARK = ">*/";
    public static final int CHAR_AFTER = ">*/".length();
    public static final String RESCUE_MARK = "RESCUE";
    public static final int RESCUE_LENGTH = "RESCUE".length();
    protected BatchProgramDesign design;
    protected GeneratedCodeMgr gen;
    protected List tagStack = new ArrayList();
    protected Properties defaultProperties;
    protected Properties strictFormattingProperties;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public BatchGenerator(BatchProgramDesign batchProgramDesign) {
        this.design = batchProgramDesign;
        this.defaultProperties = new Properties();
        this.defaultProperties.setProperty("freeFormatting", "true");
        this.defaultProperties.setProperty("ignoreCase", "true");
        this.strictFormattingProperties = new Properties();
        this.strictFormattingProperties.setProperty("freeFormatting", "false");
        this.strictFormattingProperties.setProperty("ignoreCase", "false");
    }

    public GeneratedInfo generate() {
        this.gen = new GeneratedCodeMgr();
        this.gen.setProperties(this.defaultProperties);
        this.genHeaders().nl().genProgram().nl();
        return this.gen;
    }

    public static void main(String[] args) {
        System.out.println("Start BatchGenerator test");
        BatchProgramDesign design = new BatchProgramDesign();
        design.setName("MyFirstBatchProgram");
        design.addInputFile("InFile1");
        design.addInputFile("InFile2");
        design.addOutputFile("OutFile1");
        BatchGenerator generator = new BatchGenerator(design);
        GeneratedInfo generatedInfo = generator.generate();
        BatchGenerator.copyGeneratedInfo(generatedInfo);
        BatchGenerator.compareGeneratedInfo(generatedInfo, "src/com/ibm/vap/pdp/test/GeneratedInfo1.txt");
        BatchGenerator.compareGeneratedInfo(generatedInfo, "src/com/ibm/vap/pdp/test/GeneratedInfo2.txt");
        System.out.println("Stop BatchGenerator test");
    }

    protected static void printGeneratedInfo(GeneratedInfo mgr) {
        ((GeneratedCodeMgr)mgr).writeTo(new PrintWriter(System.out));
    }

    protected static void copyGeneratedInfo(GeneratedInfo gi) {
        GeneratedCodeMgr mgr = (GeneratedCodeMgr)gi;
        StringWriter writer = new StringWriter();
        mgr.writeTo(new PrintWriter(writer));
        String xml = ((Object)writer).toString();
        GeneratedCodeMgr mgr2 = new GeneratedCodeMgr();
        mgr2.readFrom(new StringReader(xml));
        StringWriter writer2 = new StringWriter();
        mgr2.writeTo(new PrintWriter(writer2));
        String xml2 = ((Object)writer2).toString();
        if (!xml2.equals(xml)) {
            throw new RuntimeException("Wrong xml read or write");
        }
    }

    protected static void compareGeneratedInfo(GeneratedInfo gi, String filename) {
        GeneratedCodeMgr readMgr = new GeneratedCodeMgr();
        readMgr.readFrom(BatchGenerator.getFileReader(filename));
        StringWriter writer1 = new StringWriter();
        readMgr.writeTo(new PrintWriter(writer1));
        String xml1 = ((Object)writer1).toString();
        StringWriter writer2 = new StringWriter();
        ((GeneratedCodeMgr)gi).writeTo(new PrintWriter(writer2));
        String xml2 = ((Object)writer2).toString();
        if (!xml2.equals(xml1)) {
            throw new RuntimeException("Generated info is different from content of file '" + filename + "'");
        }
    }

    protected static Reader getFileReader(String filename) {
        try {
            return new InputStreamReader(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw Util.rethrow((Throwable)fnfe);
        }
    }

    protected BatchGenerator genHeaders() {
        this.open("Package declaration").add("package progs;").close().nl().nl();
        this.open("Import declarations").add("import data.*;").close().nl();
        return this;
    }

    protected BatchGenerator genProgram() {
        String progName = this.design.getName();
        this.open("Program " + progName);
        this.open("Program declaration").add("Program ").add(progName).add(" Type BasicProgram").close().nl();
        this.genCurrentRowDeclaration();
        this.genSynchroVars();
        this.genMain();
        this.genInitialize();
        this.genInitFunc();
        this.genEndOfInput();
        this.genProcessCurrentInput();
        this.genSynchroFunction();
        this.genFetchNextInput();
        this.genFetchNextFunc();
        this.genCloseFiles();
        this.open("Program end").add("end").close();
        this.close().nl();
        return this;
    }

    protected BatchGenerator genCurrentRowDeclaration() {
        String fileName;
        BatchProgramDesign.InOutFile tmp;
        Iterator inputIter = this.design.inputFiles();
        Iterator outputIter = this.design.outputFiles();
        if (inputIter.hasNext() || outputIter.hasNext()) {
            this.nl().tab().open("Files rows declarations");
        }
        boolean first = true;
        while (inputIter.hasNext()) {
            tmp = (BatchProgramDesign.InOutFile)inputIter.next();
            fileName = tmp.getName();
            if (!first) {
                this.nl().tab();
            }
            this.open("Current " + fileName + " row def");
            this.add(fileName).add("CurrentRow ").add(fileName).add(";");
            this.close();
            first = false;
        }
        while (outputIter.hasNext()) {
            tmp = (BatchProgramDesign.InOutFile)outputIter.next();
            fileName = tmp.getName();
            if (!first) {
                this.nl().tab();
            }
            this.open("Current " + fileName + " row def");
            this.add(fileName).add("CurrentRow ").add(fileName).add(";");
            this.close();
            first = false;
        }
        if (!first) {
            this.close().nl();
        }
        return this;
    }

    protected BatchGenerator genSynchroVars() {
        if (this.design.nbInputFiles() < 2) {
            return this;
        }
        this.nl().tab().open("Declarations for files selection");
        this.open("High value constant");
        this.add("const level1HighValue char(10) =");
        this.close();
        this.add(" ");
        this.open("High value", this.strictFormattingProperties).add("\"ZZZZZZZZZZ\"").close();
        this.open("High value constant end").add(";").close();
        this.close();
        Iterator it = this.design.inputFiles();
        this.nl().tab();
        boolean first = true;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().tab();
            }
            this.open(fileName + " select flag 1");
            this.add("is").add(fileName).add("Level1Selected char(1);");
            this.close();
            first = false;
        }
        this.close().nl();
        return this;
    }

    protected BatchGenerator genMain() {
        this.nl().tab().open("Main").add("function main()").nl();
        this.tab().tab().add("initialize();").nl();
        this.tab().tab().add("while ( endOfInput() != \"Y\" )").nl();
        this.tab().tab().tab().add("processCurrentInput();").nl();
        this.tab().tab().tab().add("fetchNextInput();").nl();
        this.tab().tab().add("end").nl();
        this.tab().tab().add("closeFiles();").nl();
        this.tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genInitialize() {
        this.nl().tab().open("Initialize files").add("function initialize()");
        Iterator it = this.design.inputFiles();
        if (it.hasNext()) {
            this.nl().tab().tab();
        }
        this.open("Initializations");
        boolean first = true;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().tab().tab();
            }
            this.open("Initialize " + fileName).add("initialize").add(fileName).add("();").close();
            first = false;
        }
        this.close();
        this.nl().tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genInitFunc() {
        Iterator it = this.design.inputFiles();
        if (it.hasNext()) {
            this.nl();
        }
        boolean first = true;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().nl();
            }
            this.tab().open("Initialize " + fileName + " function");
            this.add("function initialize").add(fileName).add("()").nl();
            this.tab().tab().add("get next ").add(fileName).add("CurrentRow;").nl();
            this.tab().add("end").close().nl();
            first = false;
        }
        if (!first) {
            this.nl();
        }
        return this;
    }

    protected BatchGenerator genEndOfInput() {
        this.nl().tab().open("End of input");
        this.add("function endOfInput() returns (char(1))").nl();
        if (this.design.nbInputFiles() == 0) {
            this.tab().tab().open("The end").add("return (\"Y\");").close().nl();
        } else {
            this.tab().tab().add("if ( ");
            Iterator it = this.design.inputFiles();
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            this.open("EOF condition");
            String fileName = tmp.getName();
            this.open("Check " + fileName + " EOF").add(fileName).add("CurrentRow is endOfFile").close();
            while (it.hasNext()) {
                tmp = (BatchProgramDesign.InOutFile)it.next();
                fileName = tmp.getName();
                this.nl().tab().tab().tab().tab();
                this.open("Check " + fileName + " EOF").add("&& ").add(fileName).add("CurrentRow is endOfFile").close();
            }
            this.close().add(" )").nl();
            this.tab().tab().tab().open("The end").add("return (\"Y\");").close().nl();
            this.tab().tab().add("else").nl();
            this.tab().tab().tab().add("return (\"N\");").nl();
            this.tab().tab().add("end").nl();
        }
        this.tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genProcessCurrentInput() {
        this.nl().tab().open("Process Input").add("function processCurrentInput()").nl();
        if (this.design.nbInputFiles() > 1) {
            this.tab().tab().open("Compute selections").add("calculateLevel1SelectedFlags();").close().nl();
        } else {
            this.open("Compute selections").close();
        }
        this.tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genSynchroFunction() {
        if (this.design.nbInputFiles() > 1) {
            this.genL1SelectIndic();
            this.genMinForL1();
        }
        return this;
    }

    protected BatchGenerator genL1SelectIndic() {
        this.nl().tab().open("Calculate selected flags 1").add("function calculateLevel1SelectedFlags()").nl();
        this.tab().tab().add("minLevel1 char(10) = calculateMinForLevel1();");
        Iterator it = this.design.inputFiles();
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            this.nl().nl().tab().tab();
            this.open("Set selected flag " + fileName + " 1");
            this.add("if ( ").add(fileName).add("CurrentRow is endOfFile");
            this.add(" && ").add(fileName).add("CurrentRow.custId == minLevel1 )").nl();
            this.tab().tab().tab();
            this.open("Select " + fileName + " 1");
            this.add("is").add(fileName).add("Level1Selected = \"Y\";");
            this.close().nl();
            this.tab().tab().add("else").nl();
            this.tab().tab().tab().open("Unselect " + fileName + " 1");
            this.add("is").add(fileName).add("Level1Selected = \"N\";");
            this.close().nl();
            this.tab().tab().add("end").close();
        }
        this.nl().tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genMinForL1() {
        this.nl().tab().open("Calculate min 1").add("function calculateMinForLevel1()").nl();
        this.tab().tab().add("minLevel1 char(10) = level1HighValue;").nl();
        Iterator it = this.design.inputFiles();
        this.nl().tab().tab();
        boolean first = true;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().nl().tab().tab();
            }
            this.open("Check min " + fileName + " 1").add("if ( ");
            this.add(fileName).add("CurrentRow is endOfFile && ").add(fileName).add("CurrentRow.custId < minLevel1 )").nl();
            this.tab().tab().tab().add("minLevel1 = ").add(fileName).add("CurrentRow.custId;").nl();
            this.tab().tab().add("end").close();
            first = false;
        }
        this.nl().tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genFetchNextInput() {
        this.nl().tab().open("Fetch next input rows").add("function fetchNextInput()");
        Iterator it = this.design.inputFiles();
        if (it.hasNext()) {
            this.nl().tab().tab();
        }
        this.open("Fetch next for all input files");
        boolean first = true;
        boolean selections = this.design.nbInputFiles() > 1;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().nl().tab().tab();
            }
            if (selections) {
                this.open("Fetch next selected " + fileName);
                this.add("if ( is").add(fileName).add("Level1Selected == \"Y\" )").nl().tab().tab().tab();
            }
            this.open("Call fetch next " + fileName).add("fetchNextFor").add(fileName).add("();").close();
            if (selections) {
                this.nl().tab().tab().add("end").close();
            }
            first = false;
        }
        this.close();
        this.nl().tab().add("end").close().nl().nl();
        return this;
    }

    protected BatchGenerator genFetchNextFunc() {
        Iterator it = this.design.inputFiles();
        if (it.hasNext()) {
            this.nl().tab();
        }
        boolean first = true;
        while (it.hasNext()) {
            BatchProgramDesign.InOutFile tmp = (BatchProgramDesign.InOutFile)it.next();
            String fileName = tmp.getName();
            if (!first) {
                this.nl().nl().nl().tab();
            }
            this.open("FetchNext for " + fileName).add("function fetchNextFor").add(fileName).add("()").nl();
            this.tab().tab().add("get next ").add(fileName).add("CurrentRow;").nl();
            this.tab().add("end").close();
            first = false;
        }
        if (!first) {
            this.nl().nl();
        }
        return this;
    }

    protected BatchGenerator genCloseFiles() {
        String fileName;
        BatchProgramDesign.InOutFile tmp;
        this.nl().tab().open("Close files").add("function closeFiles()");
        Iterator it = this.design.inputFiles();
        String baseName = "CloseFile ";
        if (it.hasNext()) {
            this.nl().tab().tab();
        }
        this.open("Close for all files");
        boolean first = true;
        while (it.hasNext()) {
            tmp = (BatchProgramDesign.InOutFile)it.next();
            fileName = tmp.getName();
            if (!first) {
                this.nl().tab().tab();
            }
            this.open(baseName + fileName).add("close ").add(fileName).add("CurrentRow;").close();
            first = false;
        }
        it = this.design.outputFiles();
        while (it.hasNext()) {
            tmp = (BatchProgramDesign.InOutFile)it.next();
            fileName = tmp.getName();
            if (!first) {
                this.nl().tab().tab();
            }
            this.open(baseName + fileName).add("close ").add(fileName).add("CurrentRow;").close();
        }
        this.close();
        return this;
    }

    protected BatchGenerator add(String text) {
        this.gen.appendText(text);
        return this;
    }

    protected BatchGenerator nl() {
        this.gen.appendText(EOL);
        return this;
    }

    protected BatchGenerator tab() {
        this.gen.appendText("\t");
        return this;
    }

    protected BatchGenerator open(String tagName) {
        return this.open(tagName, null);
    }

    protected BatchGenerator open(String tagName, Properties properties) {
        this.gen.beginTag(tagName, properties);
        this.tagStack.add(tagName);
        return this;
    }

    protected BatchGenerator close() {
        String tagName = (String)this.tagStack.remove(this.tagStack.size() - 1);
        this.gen.endTag(tagName);
        return this;
    }

    protected BatchGenerator genTail() {
        return this;
    }
}

