/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.generator;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.draft.api.PdpGeneratedInfoFactory;
import java.util.Iterator;
import java.util.Properties;

public class GeneratedInfoControler {
    protected Properties hiddenTagProperties;
    protected IGeneratedInfoFactory factory;
    protected CharSequence text;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratedInfoControler() {
        this(new PdpGeneratedInfoFactory());
    }

    public GeneratedInfoControler(IGeneratedInfoFactory generatedInfoFactory) {
        this.factory = generatedInfoFactory;
    }

    public IGeneratedInfo control(IGeneratedInfo toControl) {
        if (toControl.getProperty("doNotControl") != null) {
            return toControl;
        }
        Properties properties = new Properties();
        Iterator names = toControl.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            properties.setProperty(name, toControl.getProperty(name));
        }
        this.factory.setProperties(properties);
        this.hiddenTagProperties = new Properties();
        this.hiddenTagProperties.setProperty("hidden", "true");
        this.text = toControl.getText();
        IGeneratedTag root = toControl.getRootTag();
        this.factory.beginTag(root.getName(), this.extractProperties(root));
        boolean ok = this.control(root);
        this.factory.endTag();
        IGeneratedInfo controled = this.factory.createGeneratedInfo();
        if (ok) {
            controled = toControl;
        }
        controled.setProperty("doNotControl", "true");
        return controled;
    }

    protected boolean control(IGeneratedTag tag) {
        Iterator sons = tag.sons();
        if (!sons.hasNext()) {
            this.factory.appendText(this.text.subSequence(tag.getBeginIndex(), tag.getEndIndex()));
            return true;
        }
        boolean ok = true;
        IGeneratedTag previousTag = null;
        int previousIdx = tag.getBeginIndex();
        do {
            IGeneratedTag nextTag;
            if (!this.control(previousTag, previousIdx, (nextTag = (IGeneratedTag)sons.next()).getBeginIndex(), nextTag)) {
                ok = false;
            }
            this.factory.beginTag(nextTag.getName(), this.extractProperties(nextTag));
            if (!this.control(nextTag)) {
                ok = false;
            }
            this.factory.endTag();
            previousTag = nextTag;
            previousIdx = previousTag.getEndIndex();
        } while (sons.hasNext());
        if (!this.control(previousTag, previousIdx, tag.getEndIndex(), null)) {
            ok = false;
        }
        return ok;
    }

    protected Properties extractProperties(IGeneratedTag tag) {
        Properties properties = new Properties();
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            properties.setProperty(name, tag.getProperty(name));
        }
        return properties;
    }

    protected boolean control(IGeneratedTag previousTag, int previousIdx, int nextIdx, IGeneratedTag nextTag) {
        int firstNonBlankIdx = this.findNextNonBlankChar(previousIdx, nextIdx);
        if (firstNonBlankIdx >= nextIdx) {
            this.factory.appendText(this.text.subSequence(previousIdx, nextIdx));
            return true;
        }
        if (firstNonBlankIdx > previousIdx) {
            this.factory.appendText(this.text.subSequence(previousIdx, firstNonBlankIdx));
        }
        int newTagEndIdx = this.findPreviousNonBlankChar(firstNonBlankIdx, nextIdx) + 1;
        this.addHiddenTag(previousTag, firstNonBlankIdx, newTagEndIdx, nextTag);
        if (newTagEndIdx < nextIdx) {
            this.factory.appendText(this.text.subSequence(newTagEndIdx, nextIdx));
        }
        return false;
    }

    protected int findNextNonBlankChar(int beginIdx, int endIdx) {
        while (beginIdx < endIdx) {
            if (!Character.isWhitespace(this.text.charAt(beginIdx))) break;
            ++beginIdx;
        }
        return beginIdx;
    }

    protected int findPreviousNonBlankChar(int beginIdx, int endIdx) {
        while (beginIdx < endIdx) {
            if (!Character.isWhitespace(this.text.charAt(--endIdx))) break;
        }
        return endIdx;
    }

    protected void addHiddenTag(IGeneratedTag previousTag, int beginIdx, int endIdx, IGeneratedTag nextTag) {
        StringBuilder name;
        if (previousTag == null) {
            name = new StringBuilder(2 + nextTag.getName().length());
            name.append("..").append(nextTag.getName());
        } else if (nextTag == null) {
            name = new StringBuilder(previousTag.getName().length() + 2);
            name.append(previousTag.getName()).append("..");
        } else {
            name = new StringBuilder(previousTag.getName().length() + 2 + nextTag.getName().length());
            name.append(previousTag.getName()).append("..").append(nextTag.getName());
        }
        this.factory.beginTag(name.toString(), this.hiddenTagProperties);
        this.factory.appendText(this.text.subSequence(beginIdx, endIdx));
        this.factory.endTag();
    }
}

