/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.generator;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.draft.api.PdpGeneratedInfo;
import com.ibm.pdp.engine.draft.api.PdpGeneratedTag;
import com.ibm.pdp.engine.draft.changes.MatchingExtension;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class GeneratedCodeMgr
implements GeneratedInfo,
Serializable {
    protected Properties properties;
    protected Tag rootTag;
    protected Map<String, GeneratedTag> tagsByName = new HashMap<String, GeneratedTag>();
    protected List<GeneratedTag> tags = new ArrayList<GeneratedTag>();
    protected StringBuffer text;
    protected boolean filteredContent;
    protected CharSequence filteredText;
    private static final String TAG = "tag";
    private static final String GENERATED_INFO = "GeneratedInfo";
    private static final String TEXT = "Text";
    protected transient int currentIndex;
    protected transient int tagCount;
    protected transient int nextStopRank = 1;
    protected transient List<GeneratedTag> tagStack = new ArrayList<GeneratedTag>();
    protected transient Tag previousEndedTag;
    protected transient int blankCount;
    protected IGeneratedInfo wrapper;
    protected static String[] freeFormattingNames = new String[]{"freeFormatting", "FreeFormatting", "FREE_FORMATTING", "free_formatting", "freeformatting", "FREEFORMATTING", "Free_Formatting"};
    protected static String[] ignoreCaseNames = new String[]{"ignoreCase", "IgnoreCase", "IGNORE_CASE", "ignore_case", "ignorecase", "IGNORECASE", "Ignore_Case"};
    protected static String[] changeControlNames = new String[]{"changeControl", "ChangeControl", "CHANGE_CONTROl", "change_control", "changecontrol", "CHANGECONTROL", "Change_Control"};
    protected static char[] specials = new char[]{'<', '>', '&', '\"'};
    protected static String[] replacements = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    protected static final char EOF = '\uffff';
    protected static int readIndex;
    protected StringBuffer readBuffer;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public IGeneratedInfo wrap() {
        if (this.wrapper == null) {
            this.wrapper = new PdpGeneratedInfo(this);
        }
        return this.wrapper;
    }

    public static void main(String[] args) {
        String filename = "E:\\CUST01.cblpdp";
        String result = "E:\\out_CUST01.cblpdp";
        GeneratedCodeMgr readMgr = new GeneratedCodeMgr();
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        try {
            isr = new InputStreamReader(new FileInputStream(filename));
            osw = new OutputStreamWriter(new FileOutputStream(result));
        }
        catch (FileNotFoundException fnfe) {
            throw Util.rethrow((Throwable)fnfe);
        }
        readMgr.readFrom(isr);
        StringWriter writer1 = new StringWriter();
        readMgr.writeTo(new PrintWriter(writer1));
        String xml1 = ((Object)writer1).toString();
        try {
            osw.write(xml1);
            osw.flush();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public GeneratedCodeMgr() {
        this.text = new StringBuffer();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public String getProperty(String name) {
        return this.properties != null ? this.properties.getProperty(name) : null;
    }

    protected void createRootTag() {
        this.rootTag = new RootTag(this, "Root", 0, 0, ++this.tagCount, this.nextStopRank);
        this.tags.add(this.rootTag);
        this.tagsByName.put("Root", this.rootTag);
        this.tagStack.add(this.rootTag);
    }

    public void appendText(CharSequence textSegment) {
        if (this.rootTag == null) {
            throw new RuntimeException("A root tag must include the whole text");
        }
        int segmentLength = textSegment.length();
        int i = 0;
        while (i < segmentLength) {
            char c = textSegment.charAt(i);
            this.text.append(c);
            if (Character.isWhitespace(c)) {
                if (this.previousEndedTag != null) {
                    ++this.previousEndedTag.nbBlanksAfter;
                }
                ++this.blankCount;
            } else {
                this.previousEndedTag = null;
                this.blankCount = 0;
            }
            ++i;
        }
        this.currentIndex += segmentLength;
        this.updateEnclosingTagsStopIndexes();
    }

    protected void updateEnclosingTagsStopIndexes() {
        for (Tag tag : this.tagStack) {
            tag.stop = this.currentIndex;
        }
    }

    public void beginTag(String name) {
        this.startTag(name, null);
    }

    public void beginTag(String name, Properties properties) {
        this.startTag(name, properties);
    }

    protected Tag startTag(String name, Properties properties) {
        Tag newTag;
        if (this.tagsByName.containsKey(name)) {
            throw new RuntimeException("Already existing tag name \"" + name + "\"");
        }
        if (this.rootTag == null) {
            RootTag rootTag = new RootTag(this, name, this.currentIndex, this.currentIndex, ++this.tagCount, this.nextStopRank);
            v1 = rootTag;
        } else {
            v1 = newTag = new Tag(name, properties, this.currentIndex, this.currentIndex, ++this.tagCount, this.nextStopRank);
        }
        if (this.blankCount > 0) {
            newTag.nbBlanksBefore = this.blankCount;
            this.blankCount = 0;
        }
        this.previousEndedTag = null;
        if (this.rootTag == null) {
            this.rootTag = newTag;
        } else {
            this.currentParent().addSon(newTag);
        }
        this.tags.add(newTag);
        this.tagsByName.put(name, newTag);
        this.tagStack.add(newTag);
        return newTag;
    }

    public Tag currentParent() {
        return (Tag)this.tagStack.get(this.tagStack.size() - 1);
    }

    public void endTag(String name) {
        if (this.rootTag == null) {
            throw new RuntimeException("Tag should start before it ends");
        }
        Tag tagToClose = this.currentParent();
        if (!name.equals(tagToClose.getName())) {
            throw new RuntimeException("Current enclosing tag is \"" + tagToClose.getName() + "\" not \"" + name + "\"");
        }
        this.tagStack.remove(this.tagStack.size() - 1);
        this.previousEndedTag = tagToClose;
        this.blankCount = 0;
        this.nextStopRank = tagToClose.stopRank + 1;
    }

    @Override
    public GeneratedTag getTag(String name) {
        return this.tagsByName.get(name);
    }

    @Override
    public GeneratedTag getRootTag() {
        return this.rootTag;
    }

    @Override
    public List tags() {
        return this.tags;
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public boolean hasFilteredContent() {
        return this.filteredContent;
    }

    @Override
    public CharSequence getFilteredText() {
        if (this.filteredText == null) {
            this.filteredText = this.computeFilteredText();
        }
        return this.filteredText;
    }

    @Override
    public CharSequence getFilteredText(MatchingExtension extension) {
        if (this.filteredText == null) {
            this.filteredText = this.computeFilteredText(extension);
        }
        return this.filteredText;
    }

    protected CharSequence computeFilteredText(MatchingExtension extension) {
        StringBuffer filtered = new StringBuffer(this.text.length());
        this.filteredContent = this.appendFilteredText(this.rootTag, extension, filtered);
        return this.filteredContent ? filtered : this.text;
    }

    protected boolean appendFilteredText(Tag tag, MatchingExtension extension, StringBuffer filtered) {
        tag.filteredStart = filtered.length();
        boolean filteredContent = false;
        boolean freeFormatting = tag.isFreeFormatting();
        boolean ignoreCase = tag.isIgnoreCase();
        int index = tag.start;
        for (Tag tag2 : tag.sons) {
            int nextSubTagStart = tag2.start;
            while (index < nextSubTagStart) {
                if (!this.appendFilteredChar(freeFormatting, ignoreCase, index++, extension, filtered)) continue;
                filteredContent = true;
            }
            if (this.appendFilteredText(tag2, extension, filtered)) {
                filteredContent = true;
            }
            index = tag2.stop;
        }
        while (index < tag.stop) {
            if (!this.appendFilteredChar(freeFormatting, ignoreCase, index++, extension, filtered)) continue;
            filteredContent = true;
        }
        tag.filteredStop = filtered.length();
        tag.filteredContent = filteredContent;
        return filteredContent;
    }

    protected boolean appendFilteredChar(boolean freeFormatting, boolean caseInsensitive, int idx, MatchingExtension extension, StringBuffer filtered) {
        if (freeFormatting && !extension.isSignificantReferenceChar(idx)) {
            return true;
        }
        if (caseInsensitive) {
            filtered.append(Character.toLowerCase(this.text.charAt(idx)));
            return true;
        }
        filtered.append(this.text.charAt(idx));
        return false;
    }

    protected CharSequence computeFilteredText() {
        StringBuffer filtered = new StringBuffer(this.text.length());
        this.filteredContent = this.appendFilteredText(this.rootTag, filtered);
        return this.filteredContent ? filtered : this.text;
    }

    protected boolean appendFilteredText(Tag tag, StringBuffer filtered) {
        tag.filteredStart = filtered.length();
        boolean filteredContent = false;
        boolean freeFormatting = tag.isFreeFormatting();
        boolean ignoreCase = tag.isIgnoreCase();
        int index = tag.start;
        for (Tag tag2 : tag.sons) {
            int nextSubTagStart = tag2.start;
            while (index < nextSubTagStart) {
                if (!this.appendFilteredChar(freeFormatting, ignoreCase, this.text.charAt(index++), filtered)) continue;
                filteredContent = true;
            }
            if (this.appendFilteredText(tag2, filtered)) {
                filteredContent = true;
            }
            index = tag2.stop;
        }
        while (index < tag.stop) {
            if (!this.appendFilteredChar(freeFormatting, ignoreCase, this.text.charAt(index++), filtered)) continue;
            filteredContent = true;
        }
        tag.filteredStop = filtered.length();
        tag.filteredContent = filteredContent;
        return filteredContent;
    }

    protected boolean appendFilteredChar(boolean freeFormatting, boolean caseInsensitive, char c, StringBuffer filtered) {
        if (freeFormatting && Character.isWhitespace(c)) {
            return true;
        }
        if (caseInsensitive) {
            filtered.append(Character.toLowerCase(c));
            return true;
        }
        filtered.append(c);
        return false;
    }

    @Override
    public CharSequence getText(String tagName) {
        GeneratedTag tag = this.tagsByName.get(tagName);
        if (tag == null) {
            throw new RuntimeException("Unknown tag of name \"" + tagName + "\"");
        }
        return tag.getText();
    }

    @Override
    public void renameTag(String oldTagName, String newTagName) {
        Tag tag = (Tag)this.tagsByName.get(oldTagName);
        if (tag == null) {
            return;
        }
        if (this.tagsByName.containsKey(newTagName)) {
            throw new RuntimeException("Can't rename tag : new tag name already in use");
        }
        this.tagsByName.remove(oldTagName);
        tag.name = newTagName;
        this.tagsByName.put(newTagName, tag);
    }

    public void writeTo(PrintWriter stream) {
        this.writeHeader(stream);
        this.writeTagsAndText(stream);
        this.writeFooter(stream);
    }

    protected void writeHeader(PrintWriter stream) {
        stream.print("<GeneratedInfo");
        this.writeProperties(this.properties, stream);
        stream.println('>');
    }

    protected void writeFooter(PrintWriter stream) {
        stream.println("</GeneratedInfo>");
    }

    protected void writeProperties(Properties properties, PrintWriter stream) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            stream.print(' ');
            this.writeText(entry.getKey().toString(), stream);
            stream.print("=\"");
            this.writeText(entry.getValue().toString(), stream);
            stream.print('\"');
        }
    }

    protected void writeTagsAndText(PrintWriter stream) {
        int index = 0;
        stream.print("<Text>");
        for (Tag tag : this.rootTag.sons) {
            this.writeText(this.text.substring(index, tag.start), stream);
            this.writeTag(tag, stream);
            index = tag.stop;
        }
        this.writeText(this.text.substring(index), stream);
        stream.println("</Text>");
    }

    protected void writeTag(Tag tag, PrintWriter stream) {
        stream.print("<");
        stream.print(TAG);
        stream.print(" name=\"");
        stream.print(tag.name);
        stream.print('\"');
        this.writeProperties(tag.properties, stream);
        stream.print('>');
        int index = tag.start;
        for (Tag tag2 : tag.sons) {
            this.writeText(this.text.substring(index, tag2.start), stream);
            this.writeTag(tag2, stream);
            index = tag2.stop;
        }
        this.writeText(this.text.substring(index, tag.stop), stream);
        stream.print("</");
        stream.print(TAG);
        stream.print(">");
    }

    protected void writeText(String text, PrintWriter stream) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            block3: {
                char c = text.charAt(i);
                int s = specials.length - 1;
                while (s >= 0) {
                    if (c == specials[s]) {
                        stream.print(replacements[s]);
                        break block3;
                    }
                    --s;
                }
                stream.print(c);
            }
            ++i;
        }
    }

    public void readFrom(Reader reader) {
        readIndex = 0;
        this.readBuffer = new StringBuffer();
        char c = this.nextNotWhiteChar(reader);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        this.readGeneratedInfo(reader);
    }

    protected RuntimeException unexpected(char received, char expected) {
        if (received == '\uffff') {
            throw new RuntimeException("End of stream reached at index " + readIndex + " when character '" + expected + "' was expected.");
        }
        throw new RuntimeException("Unexpected character found '" + received + "' at index " + readIndex + " when '" + expected + "' was expected.");
    }

    protected RuntimeException unexpected(String received, String expected) {
        if (received.length() == 0) {
            throw new RuntimeException("End of stream reached at index " + readIndex + " when \"" + expected + "\" was expected.");
        }
        throw new RuntimeException("Unexpected string found \"" + received + "\" at index " + readIndex + " when \"" + expected + "\" was expected.");
    }

    protected char readNextChar(Reader reader) {
        try {
            ++readIndex;
            return (char)reader.read();
        }
        catch (IOException ioe) {
            throw Util.rethrow((Throwable)ioe);
        }
    }

    protected char nextNotWhiteChar(Reader reader) {
        char nextChar;
        while ((nextChar = this.readNextChar(reader)) != '\uffff' && Character.isWhitespace(nextChar)) {
        }
        return nextChar;
    }

    protected char forwardToWhiteChar(Reader reader) {
        char nextChar;
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(reader)) != '\uffff') {
            if (Character.isWhitespace(nextChar)) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        return nextChar;
    }

    protected char forwardToChar(char search, Reader reader) {
        char nextChar;
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(reader)) != '\uffff') {
            if (nextChar == search) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        throw this.unexpected(nextChar, search);
    }

    protected char forwardToWhiteOrChar(char search, Reader reader) {
        char nextChar;
        int specialStartIdx = -1;
        while ((nextChar = this.readNextChar(reader)) != '\uffff') {
            if (nextChar == search || Character.isWhitespace(nextChar)) {
                return nextChar;
            }
            specialStartIdx = this.appendChar(nextChar, this.readBuffer, specialStartIdx);
        }
        throw this.unexpected(nextChar, search);
    }

    protected int appendChar(char c, StringBuffer buffer, int specialStartIdx) {
        this.readBuffer.append(c);
        if (c == '&') {
            return this.readBuffer.length() - 1;
        }
        if (c == ';' && specialStartIdx != -1) {
            String specialFound = this.readBuffer.substring(specialStartIdx);
            int i = 0;
            while (i < replacements.length) {
                if (specialFound.equals(replacements[i])) {
                    this.readBuffer.setLength(specialStartIdx);
                    this.readBuffer.append(specials[i]);
                    break;
                }
                ++i;
            }
            specialStartIdx = -1;
        }
        return specialStartIdx;
    }

    protected void readGeneratedInfo(Reader reader) {
        this.readGeneratedInfoHeader(reader);
        this.readTaggedText(reader);
        this.readGeneratedInfoFooter(reader);
    }

    protected void readGeneratedInfoHeader(Reader reader) {
        char c = this.nextNotWhiteChar(reader);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', reader);
        if (!this.readBuffer.toString().equalsIgnoreCase(GENERATED_INFO)) {
            throw this.unexpected(this.readBuffer.toString(), GENERATED_INFO);
        }
        if (c != '>') {
            this.setProperties(this.readProperties(reader));
        }
    }

    protected Properties readProperties(Reader reader) {
        String name;
        Properties props = new Properties();
        while ((name = this.readPropertyName(reader)).length() != 0 && this.addPropertyValue(name, reader, props)) {
        }
        return props.isEmpty() ? null : props;
    }

    protected String readPropertyName(Reader reader) {
        char c = this.nextNotWhiteChar(reader);
        if (c == '>') {
            return "";
        }
        if (c == '\uffff') {
            throw this.unexpected(c, '>');
        }
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('=', reader);
        if (c != '=' && (c = this.nextNotWhiteChar(reader)) != '=') {
            throw this.unexpected(c, '=');
        }
        return this.readBuffer.toString();
    }

    protected boolean addPropertyValue(String name, Reader reader, Properties props) {
        char c = this.nextNotWhiteChar(reader);
        if (c == '>') {
            return false;
        }
        if (c == '\uffff') {
            this.unexpected(c, '>');
        }
        this.readBuffer.setLength(0);
        boolean readNextOne = true;
        if (c == '\"') {
            this.forwardToChar('\"', reader);
        } else {
            this.readBuffer.append(c);
            readNextOne = this.forwardToWhiteOrChar('>', reader) != '>';
        }
        props.setProperty(name, this.readBuffer.toString());
        return readNextOne;
    }

    protected void readTaggedText(Reader reader) {
        char c = this.nextNotWhiteChar(reader);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(reader);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', reader);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(reader)) != '>') {
            throw this.unexpected(c, '>');
        }
        while (true) {
            this.readBuffer.setLength(0);
            this.forwardToChar('<', reader);
            if (this.readBuffer.length() != 0) {
                this.appendText(this.readBuffer);
            }
            if ((c = this.nextNotWhiteChar(reader)) == '/') break;
            this.readBuffer.setLength(0);
            this.readBuffer.append(c);
            c = this.forwardToWhiteChar(reader);
            if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
                throw this.unexpected(this.readBuffer.toString(), TAG);
            }
            this.readTag(reader);
        }
        c = this.nextNotWhiteChar(reader);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', reader);
        if (!this.readBuffer.toString().equalsIgnoreCase(TEXT)) {
            throw this.unexpected(this.readBuffer.toString(), TEXT);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(reader)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    protected void readGeneratedInfoFooter(Reader reader) {
        char c = this.nextNotWhiteChar(reader);
        if (c != '<') {
            throw this.unexpected(c, '<');
        }
        c = this.nextNotWhiteChar(reader);
        if (c != '/') {
            throw this.unexpected(c, '/');
        }
        c = this.nextNotWhiteChar(reader);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', reader);
        if (!this.readBuffer.toString().equalsIgnoreCase(GENERATED_INFO)) {
            throw this.unexpected(this.readBuffer.toString(), GENERATED_INFO);
        }
        if (c != '>' && (c = this.nextNotWhiteChar(reader)) != '>') {
            throw this.unexpected(c, '>');
        }
    }

    protected void readTag(Reader reader) {
        this.readTagHeader(reader);
        this.readTagBody(reader);
        this.readTagFooter(reader);
    }

    protected void readTagHeader(Reader reader) {
        Properties props = this.readProperties(reader);
        if (props == null || !props.containsKey("name")) {
            throw new RuntimeException("Name of tag expected at index " + readIndex + ".");
        }
        String name = (String)props.remove("name");
        if (props.isEmpty()) {
            this.beginTag(name);
        } else {
            this.beginTag(name, props);
        }
    }

    protected void readTagBody(Reader reader) {
        while (true) {
            char c;
            this.readBuffer.setLength(0);
            this.forwardToChar('<', reader);
            if (this.readBuffer.length() != 0) {
                this.appendText(this.readBuffer);
            }
            if ((c = this.nextNotWhiteChar(reader)) == '/') {
                return;
            }
            this.readBuffer.setLength(0);
            this.readBuffer.append(c);
            c = this.forwardToWhiteChar(reader);
            if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
                throw this.unexpected(this.readBuffer.toString(), TAG);
            }
            this.readTag(reader);
        }
    }

    protected void readTagFooter(Reader reader) {
        String footerName;
        Properties footerProp;
        char c = this.nextNotWhiteChar(reader);
        this.readBuffer.setLength(0);
        this.readBuffer.append(c);
        c = this.forwardToWhiteOrChar('>', reader);
        if (!this.readBuffer.toString().equalsIgnoreCase(TAG)) {
            throw this.unexpected(this.readBuffer.toString(), TAG);
        }
        String name = this.currentParent().getName();
        if (c != '>' && (footerProp = this.readProperties(reader)) != null && (footerName = footerProp.getProperty("name")) != null && !footerName.equals(name)) {
            throw this.unexpected(footerName, name);
        }
        this.endTag(name);
    }

    protected static class RootTag
    extends Tag {
        protected GeneratedCodeMgr mgr;

        public RootTag(GeneratedCodeMgr manager, String tagName, int startIndex, int stopIndex, int startCount, int stopCount) {
            super(tagName, manager.properties, startIndex, stopIndex, startCount, stopCount);
            this.mgr = manager;
            this.initFormatProperties();
        }

        @Override
        public RootTag getRootTag() {
            return this;
        }

        @Override
        public GeneratedInfo getGeneratedInfo() {
            return this.mgr;
        }

        @Override
        protected void setStopRank(int newStopRank) {
            this.stopRank = newStopRank;
        }
    }

    public static class Tag
    implements GeneratedTag,
    Serializable {
        protected String name;
        protected Properties properties;
        protected int start;
        protected int stop;
        protected int nbBlanksBefore;
        protected int nbBlanksAfter;
        protected int startRank;
        protected int stopRank;
        protected boolean freeFormatting;
        protected boolean ignoreCase;
        protected int changeControl;
        protected boolean filteredContent;
        protected int filteredStart;
        protected int filteredStop;
        protected int depth;
        protected Tag parent;
        protected Tag previousTag;
        protected Tag nextTag;
        protected List<GeneratedTag> sons;
        protected transient CharSequence[] tokens;
        protected transient int tokensTotalLength;
        protected IGeneratedTag wrapper;

        public Tag(String tagName, Properties props, int startIndex, int stopIndex, int startCount, int stopCount) {
            this.name = tagName;
            this.properties = props;
            this.start = startIndex;
            this.stop = stopIndex;
            this.startRank = startCount;
            this.stopRank = stopCount;
            this.sons = new ArrayList<GeneratedTag>();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getProperty(String name) {
            String value = this.properties != null ? this.properties.getProperty(name) : null;
            return value == null ? this.getDefaultProperty(name) : value;
        }

        protected String getDefaultProperty(String name) {
            return this.parent != null ? this.parent.getProperty(name) : null;
        }

        protected boolean isPropertySet(String name) {
            boolean isSet;
            boolean bl = isSet = this.properties != null ? this.properties.containsKey(name) : false;
            return isSet || this.parent != null && this.parent.isPropertySet(name);
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public boolean isFreeFormatting() {
            return this.freeFormatting;
        }

        @Override
        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        @Override
        public int getChangeControl() {
            return this.changeControl;
        }

        @Override
        public boolean hasFilteredContent() {
            return this.filteredContent;
        }

        @Override
        public int getStartIndex() {
            return this.start;
        }

        @Override
        public int getFilteredStartIndex() {
            return this.filteredStart;
        }

        @Override
        public int getStartRank() {
            return this.startRank;
        }

        @Override
        public int getStopIndex() {
            return this.stop;
        }

        @Override
        public int getFilteredStopIndex() {
            return this.filteredStop;
        }

        @Override
        public int getStopRank() {
            return this.stopRank;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public GeneratedTag getParent() {
            return this.parent;
        }

        @Override
        public CharSequence getText() {
            return this.getGeneratedInfo().getText().subSequence(this.start, this.stop);
        }

        @Override
        public int length() {
            return this.stop - this.start;
        }

        @Override
        public int filteredLength() {
            return this.filteredStop - this.filteredStart;
        }

        @Override
        public CharSequence getFilteredText() {
            return this.getGeneratedInfo().getFilteredText().subSequence(this.filteredStart, this.filteredStop);
        }

        @Override
        public CharSequence getFilteredText(MatchingExtension extension) {
            return this.getGeneratedInfo().getFilteredText(extension).subSequence(this.filteredStart, this.filteredStop);
        }

        @Override
        public int nbBlanksBefore() {
            return this.nbBlanksBefore;
        }

        @Override
        public CharSequence getBlanksBefore() {
            return this.getGeneratedInfo().getText().subSequence(this.start - this.nbBlanksBefore, this.start);
        }

        @Override
        public int nbBlanksAfter() {
            return this.nbBlanksAfter;
        }

        @Override
        public CharSequence getBlanksAfter() {
            return this.getGeneratedInfo().getText().subSequence(this.stop, this.stop + this.nbBlanksAfter);
        }

        @Override
        public GeneratedTag previousTag() {
            return this.previousTag;
        }

        @Override
        public GeneratedTag nextTag() {
            return this.nextTag;
        }

        @Override
        public boolean areBlanksBeforeShared() {
            return this.previousTag != null && this.previousTag.stop + this.previousTag.nbBlanksAfter >= this.start - this.nbBlanksBefore;
        }

        @Override
        public boolean areBlanksAfterShared() {
            return this.nextTag != null && this.nextTag.start - this.nextTag.nbBlanksBefore <= this.stop + this.nbBlanksAfter;
        }

        @Override
        public List sons() {
            return this.sons;
        }

        @Override
        public GeneratedInfo getGeneratedInfo() {
            return this.getRootTag().getGeneratedInfo();
        }

        @Override
        public boolean isAncestorOf(GeneratedTag tag) {
            return this.startRank < tag.getStartRank() && this.stopRank > tag.getStopRank();
        }

        @Override
        public boolean isInSameBranch(GeneratedTag tag) {
            return this.startRank < tag.getStartRank() ? this.stopRank > tag.getStopRank() : this.stopRank < tag.getStopRank();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.name).append('[').append(this.start);
            if (this.nbBlanksBefore > 0) {
                buffer.append('-').append(this.nbBlanksBefore);
            }
            buffer.append(',').append(this.stop);
            if (this.nbBlanksAfter > 0) {
                buffer.append('+').append(this.nbBlanksAfter);
            }
            buffer.append(']');
            return buffer.toString();
        }

        protected RootTag getRootTag() {
            return this.parent.getRootTag();
        }

        protected void addSon(Tag newSon) {
            if (!this.sons.isEmpty()) {
                Tag previous = (Tag)this.sons.get(this.sons.size() - 1);
                previous.nextTag = newSon;
                newSon.previousTag = previous;
            }
            this.sons.add(newSon);
            newSon.depth = this.depth + 1;
            newSon.parent = this;
            this.setStopRank(newSon.stopRank + 1);
            newSon.initFormatProperties();
        }

        protected void initFormatProperties() {
            this.initFreeFormattingProperty();
            this.initIgnoreCaseProperty();
            this.initChangeControlProperty();
        }

        protected void initFreeFormattingProperty() {
            String freeFormattingValue = null;
            int i = 0;
            while (i < freeFormattingNames.length) {
                if (this.isPropertySet(freeFormattingNames[i])) {
                    freeFormattingValue = this.getProperty(freeFormattingNames[i]);
                }
                ++i;
            }
            int firstChar = freeFormattingValue != null && freeFormattingValue.length() > 0 ? (int)Character.toLowerCase(freeFormattingValue.charAt(0)) : 0;
            this.freeFormatting = firstChar == 121 || firstChar == 111 || firstChar == 116 || firstChar == 118;
        }

        protected void initIgnoreCaseProperty() {
            String ignoreCaseValue = null;
            int i = 0;
            while (i < ignoreCaseNames.length) {
                if (this.isPropertySet(ignoreCaseNames[i])) {
                    ignoreCaseValue = this.getProperty(ignoreCaseNames[i]);
                }
                ++i;
            }
            int firstChar = ignoreCaseValue != null && ignoreCaseValue.length() > 0 ? (int)Character.toLowerCase(ignoreCaseValue.charAt(0)) : 0;
            this.ignoreCase = firstChar == 121 || firstChar == 111 || firstChar == 116 || firstChar == 118;
        }

        protected void initChangeControlProperty() {
            String changeControlValue = null;
            int i = 0;
            while (i < changeControlNames.length) {
                if (this.isPropertySet(changeControlNames[i])) {
                    changeControlValue = this.getProperty(changeControlNames[i]);
                }
                ++i;
            }
            this.changeControl = changeControlValue == null ? 0 : (changeControlValue.equalsIgnoreCase("warning") ? 1 : (changeControlValue.equalsIgnoreCase("error") ? 2 : 0));
        }

        @Override
        public int tokensTotalLength() {
            this.tokens();
            return this.tokensTotalLength;
        }

        @Override
        public CharSequence[] tokens() {
            if (this.tokens == null) {
                this.tokens = new CharSequence[this.sons.size() + 1];
                this.tokensTotalLength = this.computeTokens(this.tokens);
            }
            return this.tokens;
        }

        protected int computeTokens(CharSequence[] tokens) {
            if (this.sons.isEmpty()) {
                tokens[0] = this.getText();
                return tokens[0].length();
            }
            CharSequence generatedText = this.getGeneratedInfo().getText();
            int index = this.start;
            int tokenCount = 0;
            int totalLength = 0;
            for (Tag tag : this.sons) {
                int subTagStart = tag.start - tag.nbBlanksBefore;
                String nextToken = subTagStart > index ? generatedText.subSequence(index, subTagStart) : "";
                tokens[tokenCount++] = nextToken;
                totalLength += nextToken.length();
                index = tag.stop + tag.nbBlanksAfter;
            }
            CharSequence charSequence = generatedText.subSequence(index, this.stop);
            tokens[tokenCount++] = charSequence;
            return totalLength += charSequence.length();
        }

        protected void setStopRank(int newStopRank) {
            this.stopRank = newStopRank;
            this.parent.setStopRank(newStopRank + 1);
        }

        @Override
        public IGeneratedTag wrap() {
            if (this.wrapper == null) {
                this.wrapper = new PdpGeneratedTag(this);
            }
            return this.wrapper;
        }
    }
}

