/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.editor.core;

import com.ibm.pdp.engine.draft.changes.AnchorProposal;
import com.ibm.pdp.engine.draft.changes.MatchingExtension;
import com.ibm.pdp.engine.draft.changes.NodeAnchor;
import com.ibm.pdp.engine.draft.changes.ReconcileExtension;
import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextInterval;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.changes.TextSegmentExtremity;
import com.ibm.pdp.engine.draft.editor.core.DefaultMatchingContext;
import com.ibm.pdp.engine.draft.editor.core.IgnoreSpaceMatchingExtension;
import com.ibm.pdp.engine.draft.generator.GeneratedInfo;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.engine.internal.ITextSegment;
import com.ibm.pdp.util.Converter;
import com.ibm.pdp.util.FilterPredicate;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.containers.ArraySortedSet;
import com.ibm.pdp.util.containers.ListSortedSet;
import com.ibm.pdp.util.containers.OrderedHashedSet;
import com.ibm.pdp.util.containers.OrderedSet;
import com.ibm.pdp.util.iterators.ReverseListIterator;
import com.ibm.pdp.util.iterators.TwoWayIterator;
import com.ibm.pdp.util.sort.AbstractRangeComparator;
import com.ibm.pdp.util.sort.RangeComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class UserChangesMgr
implements SourceCodeMixer,
Serializable {
    private static final String EOL = System.getProperty("line.separator");
    public static int findBestMatchVersion = 1;
    public static int findBestMatchCount = 0;
    public static int reuseBestMatchCount = 0;
    public static int maxStoredMatchings = 10000;
    public static int minStoredWeight = 200;
    public static long maxStepCount = 1000000000L;
    protected GeneratedInfo generated;
    protected ListSortedSet extremities;
    protected ListSortedSet userExtremities;
    protected transient int length = -1;
    protected transient StringBuffer compoundText;
    protected boolean autoPatternRecognition = true;
    protected boolean mustSimplifyChanges = false;
    protected transient MatchingExtension matchingExtension;
    protected static final Comparator extremityComparator = new ExtremityComparator();
    protected static final FilterPredicate startExtremityOnly = new FilterPredicate(){

        public boolean accept(Object o) {
            return ((TextSegmentExtremity)o).isStart();
        }
    };
    protected static final FilterPredicate stopExtremityOnly = new FilterPredicate(){

        public boolean accept(Object o) {
            return ((TextSegmentExtremity)o).isStop();
        }
    };
    protected static final Converter extremityToNodeConverter = new Converter(){

        public Object convert(Object source) {
            return ((TextSegmentExtremity)source).getNode();
        }
    };
    protected static final FilterPredicate withWarningPredicate = new FilterPredicate(){

        public boolean accept(Object o) {
            TextSegmentExtremity extremity = (TextSegmentExtremity)o;
            return extremity.isStart() && extremity.getNode().hasWarnings();
        }
    };
    protected transient IndexComputer computer = this.newIndexComputer();
    protected transient Simplifier simplifier;
    protected transient ReconcileExtension reconcileExtension;
    protected static String[] reconcileExtensionName = new String[]{"reconcileExtension", "IReconcileExtension", "reconcileextension", "RECONCILEEXTENSION", "reconcile_extension", "RECONCILE_EXTENSION", "Reconcile_Extension"};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public UserChangesMgr() {
        this.extremities = this.newExtremitySortedSet();
        this.userExtremities = this.newExtremitySortedSet();
        this.compoundText = new StringBuffer();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.length = -1;
        this.compoundText = new StringBuffer();
        this.computer = this.newIndexComputer();
    }

    @Override
    public GeneratedInfo getGeneratedInfo() {
        return this.generated;
    }

    @Override
    public void setGeneratedInfo(GeneratedInfo newGeneratedInfo) {
        this.connectReconcileExtension(newGeneratedInfo);
        if (this.simplifier != null) {
            this.simplifier.allMatchingsStore.resetTags(newGeneratedInfo);
            this.simplifier.multiMatchingsStore.resetTags(newGeneratedInfo);
        }
        if (this.generated == null || this.userExtremities.isEmpty()) {
            this.initialize(newGeneratedInfo);
            return;
        }
        Reconciliator reconciliator = new Reconciliator(this, newGeneratedInfo);
        reconciliator.reconciliate();
        this.generated = newGeneratedInfo;
        this.extremities = reconciliator.getNewExtremities();
        this.userExtremities = reconciliator.getNewUserExtremities();
        this.length = -1;
        this.compoundText.setLength(0);
        if (this.matchingExtension != null) {
            this.matchingExtension.setMatchingContext(new DefaultMatchingContext(this));
        }
        this.simplifyUserChanges();
    }

    protected void connectReconcileExtension(GeneratedInfo newGeneratedInfo) {
        String extensionClassName = null;
        int i = 0;
        while (i < reconcileExtensionName.length) {
            extensionClassName = newGeneratedInfo.getProperty(reconcileExtensionName[i]);
            if (extensionClassName != null) break;
            ++i;
        }
        if (extensionClassName == null) {
            return;
        }
        if (extensionClassName.length() == 0) {
            this.setReconcileExtension(null);
            return;
        }
        ReconcileExtension currentExtension = this.getReconcileExtension();
        if (currentExtension != null && currentExtension.getClass().getName().equals(extensionClassName)) {
            return;
        }
        try {
            Class extensionClass = Util.classForName((String)extensionClassName);
            this.setReconcileExtension((ReconcileExtension)extensionClass.newInstance());
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    protected void showWarnings() {
        System.out.println("Warnings -----------------------");
        Iterator nodes = this.nodesWithWarning();
        while (nodes.hasNext()) {
            TextNode node = (TextNode)nodes.next();
            Iterator warnings = node.warnings();
            while (warnings.hasNext()) {
                String warning = (String)warnings.next();
                System.out.println(node.toString() + " : " + warning);
            }
        }
    }

    protected void initialize(GeneratedInfo gi) {
        this.generated = gi;
        this.extremities.clear();
        this.length = -1;
        this.compoundText.setLength(0);
        this.makeExtremities(gi, this.extremities);
    }

    protected void makeExtremities(GeneratedInfo gi, ListSortedSet extrems) {
        this.createNodeHierarchy(null, gi.getRootTag(), extrems);
    }

    protected void createNodeHierarchy(Node parent, GeneratedTag tag, ListSortedSet extrems) {
        Node node = this.newNode(parent, tag, 0);
        extrems.add((Object)node.getHead());
        extrems.add((Object)node.getTail());
        for (GeneratedTag subTag : tag.sons()) {
            this.createNodeHierarchy(node, subTag, extrems);
        }
    }

    @Override
    public void setTextAt(GeneratedTag tag, int position, CharSequence text) {
        Node anchorNode;
        if (position == -1 && tag.areBlanksBeforeShared()) {
            tag = tag.previousTag();
            position = 1;
        }
        if ((anchorNode = (Node)this.getNodeAtPosition(tag, 0, false)) == null) {
            throw new RuntimeException("Can't set text on/before/after an unknown tag");
        }
        if (anchorNode.hasUserChangeAncestor()) {
            throw new RuntimeException("Can' set text on/before/after a squashed tag");
        }
        if (position == 0) {
            if (text != null) {
                this.overrideNode(anchorNode, text);
            } else {
                this.restoreNode(anchorNode);
            }
            return;
        }
        Node node = (Node)this.getNodeAtPosition(tag, position, true);
        if (text != null) {
            if (node == null) {
                this.insertUserNode(tag, anchorNode.parent, position, text);
            } else {
                this.changeText(node, text);
            }
        } else if (node != null) {
            this.removeUserNode(node);
        }
    }

    protected void overrideNode(Node node, CharSequence text) {
        if (node.text == null) {
            int nbRemoved = this.removeSubUserNodes(node);
            node.mixedContentCount = 0;
            this.changeAncestorsMixedContentCount(node, 1 - nbRemoved);
            this.userExtremities.add((Object)node.getHead());
            this.userExtremities.add((Object)node.getTail());
        }
        this.changeText(node, text);
    }

    protected int removeSubUserNodes(Node ancestor) {
        ListSortedSet subNodesToRemove = this.userExtremities.subSet(this.newIncludedExtremitiesComparator(ancestor));
        for (TextSegmentExtremity extrem : subNodesToRemove) {
            Node node = (Node)extrem.getNode();
            if (extrem.isStart()) {
                if (node.isOverride()) {
                    node.text = null;
                    node.blankIndicator = 0;
                    node.cleanWarnings();
                    node.mixedContentCount = 0;
                }
                Node parent = node.parent;
                while (parent != null && parent != ancestor) {
                    --parent.mixedContentCount;
                    parent = parent.parent;
                }
            }
            if (!node.isInsertion()) continue;
            this.extremities.remove((Object)extrem);
        }
        int nbRemoved = subNodesToRemove.size() / 2;
        subNodesToRemove.clear();
        return nbRemoved;
    }

    protected void restoreNode(Node node) {
        if (node.text == null) {
            return;
        }
        this.decrementAncestorsMixedContentCount(node);
        this.userExtremities.remove((Object)node.getHead());
        this.userExtremities.remove((Object)node.getTail());
        node.text = null;
        node.blankIndicator = 0;
        node.reindent = false;
        node.cleanWarnings();
        this.length = -1;
        this.compoundText.setLength(0);
        if (this.matchingExtension != null) {
            this.matchingExtension.textChanged(0, null, null);
        }
    }

    protected Node insertUserNode(GeneratedTag tag, Node parent, int position, CharSequence text) {
        if (position == -1 && tag.areBlanksBeforeShared()) {
            throw new RuntimeException("Strictly forbidden");
        }
        Node node = this.newNode(parent, tag, position);
        this.extremities.add((Object)node.getHead());
        this.extremities.add((Object)node.getTail());
        this.userExtremities.add((Object)node.getHead());
        this.userExtremities.add((Object)node.getTail());
        this.incrementAncestorsMixedContentCount(node);
        node.text = text;
        node.blankIndicator = 0;
        this.length = -1;
        this.compoundText.setLength(0);
        return node;
    }

    protected void changeText(Node node, CharSequence newText) {
        node.text = newText;
        node.blankIndicator = 0;
        node.reindent = false;
        this.length = -1;
        this.compoundText.setLength(0);
    }

    protected Node removeUserNode(Node node) {
        this.extremities.remove((Object)node.getHead());
        this.extremities.remove((Object)node.getTail());
        this.userExtremities.remove((Object)node.getHead());
        this.userExtremities.remove((Object)node.getTail());
        this.decrementAncestorsMixedContentCount(node);
        this.length = -1;
        this.compoundText.setLength(0);
        return node;
    }

    protected void incrementAncestorsMixedContentCount(Node node) {
        while ((node = node.parent) != null) {
            ++node.mixedContentCount;
        }
    }

    protected void decrementAncestorsMixedContentCount(Node node) {
        while ((node = node.parent) != null) {
            --node.mixedContentCount;
        }
    }

    protected void changeAncestorsMixedContentCount(Node node, int diff) {
        while ((node = node.parent) != null) {
            node.mixedContentCount += diff;
        }
    }

    public int length() {
        this.computeIndexes();
        return this.length;
    }

    @Override
    public CharSequence text() {
        if (this.compoundText.length() == 0 && this.length != 0) {
            this.computer.computeFullText();
        }
        return this.compoundText.toString();
    }

    @Override
    public TextNode getNodeAtPosition(GeneratedTag tag, int position, boolean userCodeOnly) {
        if (position == -1 && tag.areBlanksBeforeShared()) {
            tag = tag.previousTag();
            position = 1;
        }
        TextSegmentExtremity tmp = this.newExtremity(tag, position, true);
        return (TextNode)(userCodeOnly || position != 0 ? this.userExtremities : this.extremities).get((Object)tmp);
    }

    @Override
    public Iterator rootNodes(boolean reverseOrder) {
        return this.nodesOnTag(this.generated.getRootTag(), reverseOrder);
    }

    public Iterator nodesOnTag(GeneratedTag tag, boolean reverseOrder) {
        TextNode last;
        boolean lastIsInsert;
        ListSortedSet extrems = tag != this.generated.getRootTag() ? this.extremities.subSet((Object)this.newExtremity(tag, -1, true), true, (Object)this.newExtremity(tag, 1, false), true) : this.extremities;
        Iterator iter = extrems.iterator();
        TextNode first = ((TextSegmentExtremity)iter.next()).getNode();
        boolean firstIsInsert = first.getPosition() == -1;
        TextNode second = null;
        if (firstIsInsert) {
            iter.next();
            second = ((TextSegmentExtremity)iter.next()).getNode();
        }
        boolean bl = lastIsInsert = (last = ((TextSegmentExtremity)extrems.last()).getNode()).getPosition() == 1;
        List<TextNode> lst = firstIsInsert ? (lastIsInsert ? Arrays.asList(first, second, last) : Arrays.asList(first, second)) : (lastIsInsert ? Arrays.asList(first, last) : Collections.singletonList(first));
        return reverseOrder ? new ReverseListIterator(lst.listIterator(lst.size()), lst.size()) : lst.iterator();
    }

    @Override
    public Iterator nodes(boolean byStopOrder) {
        return this.nodesFromExtremities(this.extremities, byStopOrder);
    }

    protected Iterator subNodesOf(TextNode node, boolean byStopOrder) {
        return this.nodesFromExtremities(this.extremities.subSet(this.newIncludedExtremitiesComparator(node)), byStopOrder);
    }

    protected Iterator nodesFromExtremities(ListSortedSet extremities, boolean byStopOrder) {
        return byStopOrder ? Iterators.convertIterator((Iterator)Iterators.filterIterator((Iterator)extremities.reverseIterator(), (FilterPredicate)stopExtremityOnly), (Converter)extremityToNodeConverter) : Iterators.filterIterator((Iterator)extremities.iterator(), (FilterPredicate)startExtremityOnly);
    }

    @Override
    public Iterator userChanges(boolean reverseOrder) {
        return Iterators.filterIterator((Iterator)(reverseOrder ? this.userExtremities.reverseIterator() : this.userExtremities.iterator()), (FilterPredicate)startExtremityOnly);
    }

    @Override
    public Iterator nodesWithWarning() {
        return Iterators.filterIterator((Iterator)this.extremities.iterator(), (FilterPredicate)withWarningPredicate);
    }

    @Override
    public Iterator segments(int startIndex, int stopIndex, boolean collate, boolean skipEmpty, boolean reverseOrder) {
        if (collate) {
            return this.collatedSegments(startIndex, stopIndex, skipEmpty, reverseOrder);
        }
        ListSortedSet extremsInside = this.extremitiesInInterval(startIndex, stopIndex);
        if (extremsInside.isEmpty()) {
            return this.newSegmentIter(this.extremityBefore(startIndex), extremsInside, this.extremityAfter(stopIndex), collate, skipEmpty, reverseOrder);
        }
        TextSegmentExtremity first = (TextSegmentExtremity)extremsInside.first();
        TextSegmentExtremity last = (TextSegmentExtremity)extremsInside.last();
        first = this.previousExtremity(first);
        last = this.nextExtremity(last);
        return this.newSegmentIter(first, extremsInside, last, collate, skipEmpty, reverseOrder);
    }

    protected Iterator collatedSegments(int startIndex, int stopIndex, boolean skipEmpty, boolean reverseOrder) {
        ListSortedSet extremsInside = this.userExtremitiesInInterval(startIndex, stopIndex);
        if (extremsInside.isEmpty()) {
            TextSegmentExtremity last;
            TextSegmentExtremity first = this.userExtremityBefore(startIndex);
            if (first == null) {
                first = (TextSegmentExtremity)this.extremities.first();
            }
            if ((last = this.userExtremityAfter(stopIndex)) == null) {
                last = (TextSegmentExtremity)this.extremities.last();
            }
            return this.newSegmentIter(first, extremsInside, last, true, skipEmpty, reverseOrder);
        }
        TextSegmentExtremity first = (TextSegmentExtremity)extremsInside.first();
        TextSegmentExtremity last = (TextSegmentExtremity)extremsInside.last();
        if ((first = this.previousUserExtremity(first)) == null) {
            first = (TextSegmentExtremity)this.extremities.first();
        }
        if ((last = this.nextUserExtremity(last)) == null) {
            last = (TextSegmentExtremity)this.extremities.last();
        }
        return this.newSegmentIter(first, extremsInside, last, true, skipEmpty, reverseOrder);
    }

    @Override
    public TextSegmentExtremity previousExtremity(TextSegmentExtremity extremity) {
        TwoWayIterator iter = this.extremities.iteratorFrom((Object)extremity, true);
        return iter.hasPrevious() ? (TextSegmentExtremity)iter.previous() : null;
    }

    @Override
    public TextSegmentExtremity nextExtremity(TextSegmentExtremity extremity) {
        TwoWayIterator iter = this.extremities.iteratorFrom((Object)extremity, false);
        return iter.hasNext() ? (TextSegmentExtremity)iter.next() : null;
    }

    @Override
    public TextSegmentExtremity extremityBefore(int index) {
        ListSortedSet extremsBefore = this.extremitiesInInterval(-1, index);
        return extremsBefore.isEmpty() ? null : (TextSegmentExtremity)extremsBefore.last();
    }

    @Override
    public TextSegmentExtremity extremityAfter(int index) {
        ListSortedSet extremsAfter = this.extremitiesInInterval(index, -1);
        return extremsAfter.isEmpty() ? null : (TextSegmentExtremity)extremsAfter.first();
    }

    protected TextSegmentExtremity previousUserExtremity(TextSegmentExtremity extremity) {
        TwoWayIterator iter = this.userExtremities.iteratorFrom((Object)extremity, true);
        return iter.hasPrevious() ? (TextSegmentExtremity)iter.previous() : null;
    }

    protected TextSegmentExtremity nextUserExtremity(TextSegmentExtremity extremity) {
        TwoWayIterator iter = this.userExtremities.iteratorFrom((Object)extremity, false);
        return iter.hasNext() ? (TextSegmentExtremity)iter.next() : null;
    }

    protected TextSegmentExtremity userExtremityBefore(int index) {
        ListSortedSet extremsBefore = this.userExtremitiesInInterval(-1, index);
        return extremsBefore.isEmpty() ? null : (TextSegmentExtremity)extremsBefore.last();
    }

    protected TextSegmentExtremity userExtremityAfter(int index) {
        ListSortedSet extremsAfter = this.userExtremitiesInInterval(index, -1);
        return extremsAfter.isEmpty() ? null : (TextSegmentExtremity)extremsAfter.first();
    }

    @Override
    public Iterator segments(TextSegmentExtremity head, TextSegmentExtremity tail, boolean collate, boolean skipEmpty, boolean reverseOrder) {
        if (collate) {
            return this.collatedSegments(head, tail, collate, skipEmpty, reverseOrder);
        }
        ListSortedSet extrems = this.extremities.subSet((Object)head, true, (Object)tail, true);
        return this.newSegmentIter(null, extrems, null, collate, skipEmpty, reverseOrder);
    }

    protected Iterator collatedSegments(TextSegmentExtremity head, TextSegmentExtremity tail, boolean collate, boolean skipEmpty, boolean reverseOrder) {
        ListSortedSet extrems = this.userExtremities.subSet((Object)head, false, (Object)tail, false);
        if (head == null) {
            head = (TextSegmentExtremity)this.extremities.first();
        }
        if (tail == null) {
            tail = (TextSegmentExtremity)this.extremities.last();
        }
        return this.newSegmentIter(head, extrems, tail, collate, skipEmpty, reverseOrder);
    }

    protected boolean computeIndexes(TextNode node) {
        return this.computeIndexes();
    }

    protected boolean computeIndexes() {
        if (this.length != -1) {
            return false;
        }
        this.length = this.computer.computeAllIndexes();
        return true;
    }

    @Override
    public Iterator includedNodes(int start, int stop, boolean byStopOrder) {
        ListSortedSet extrems = this.extremitiesInInterval(start, stop);
        if (extrems.isEmpty()) {
            return extrems.iterator();
        }
        if (byStopOrder) {
            final Object first = extrems.first();
            FilterPredicate predicate = new FilterPredicate(){

                public boolean accept(Object o) {
                    TextSegmentExtremity extrem = (TextSegmentExtremity)o;
                    return extrem.isStop() && extremityComparator.compare(first, extrem.getNode().getHead()) <= 0;
                }
            };
            return Iterators.convertIterator((Iterator)Iterators.filterIterator((Iterator)extrems.reverseIterator(), (FilterPredicate)predicate), (Converter)extremityToNodeConverter);
        }
        final Object last = extrems.last();
        FilterPredicate predicate = new FilterPredicate(){

            public boolean accept(Object o) {
                TextSegmentExtremity extrem = (TextSegmentExtremity)o;
                return extrem.isStart() && extremityComparator.compare(extrem.getNode().getTail(), last) <= 0;
            }
        };
        return Iterators.filterIterator((Iterator)extrems.iterator(), (FilterPredicate)predicate);
    }

    @Override
    public TextNode includingNode(int start, int stop) {
        if (start == stop) {
            return this.includingNode(start);
        }
        TextNode leftNode = ((TextSegment)this.segments(start, start, false, true, true).next()).getIncludingNode();
        TextNode rightNode = ((TextSegment)this.segments(stop, stop, false, true, false).next()).getIncludingNode();
        return leftNode.commonAncestorWith(rightNode);
    }

    protected TextNode includingNode(int index) {
        ListSortedSet extrems = this.extremitiesInInterval(index, index);
        if (extrems.isEmpty()) {
            TextSegmentExtremity previousExtremity = this.extremityBefore(index);
            return previousExtremity.isStart() ? previousExtremity.getNode() : previousExtremity.getNode().getParent();
        }
        int minDepth = Integer.MAX_VALUE;
        TextNode foundNode = null;
        Iterator iter = extrems.iterator();
        while (iter.hasNext()) {
            TextNode node = ((TextSegmentExtremity)iter.next()).getNode();
            if (node.getDepth() >= minDepth) continue;
            foundNode = node;
            minDepth = node.getDepth();
        }
        return foundNode;
    }

    protected ListSortedSet extremitiesInInterval(int start, int stop) {
        ListSortedSet subSet = this.extremities.subSet(this.newIndexRangeComparator(start, stop));
        return subSet;
    }

    public ListSortedSet userExtremitiesInInterval(int start, int stop) {
        ListSortedSet subSet = this.userExtremities.subSet(this.newIndexRangeComparator(start, stop));
        return subSet;
    }

    protected ListSortedSet reduceExtremitiesSubSet(ListSortedSet subSet, int start, int stop) {
        if (subSet.isEmpty()) {
            return subSet;
        }
        Iterator headIter = subSet.iterator();
        TextSegmentExtremity first = (TextSegmentExtremity)headIter.next();
        first = first.index() == start ? this.findFirstExtremityWithLowerDepth(first, headIter) : null;
        TwoWayIterator tailIter = subSet.reverseIterator();
        TextSegmentExtremity last = (TextSegmentExtremity)tailIter.next();
        TextSegmentExtremity textSegmentExtremity = last = last.index() == stop ? this.findLastExtremityWithLowerDepth(last, (Iterator)tailIter) : null;
        if (first == null && last == null) {
            return subSet;
        }
        boolean firstIncluded = first != null && first.isStart();
        boolean lastIncluded = last != null && last.isStop();
        return subSet.subSet((Object)first, firstIncluded, (Object)last, lastIncluded);
    }

    protected TextSegmentExtremity findFirstExtremityWithLowerDepth(TextSegmentExtremity first, Iterator iter) {
        int index = first.index();
        int minDepth = first.getNode().getDepth();
        while (iter.hasNext()) {
            TextSegmentExtremity extrem = (TextSegmentExtremity)iter.next();
            if (extrem.index() != index) {
                return first;
            }
            int depth = extrem.getNode().getDepth();
            if (depth >= minDepth) continue;
            minDepth = depth;
            first = extrem;
        }
        return first;
    }

    protected TextSegmentExtremity findLastExtremityWithLowerDepth(TextSegmentExtremity last, Iterator iter) {
        int index = last.index();
        int minDepth = last.getNode().getDepth();
        while (iter.hasNext()) {
            TextSegmentExtremity extrem = (TextSegmentExtremity)iter.next();
            if (extrem.index() != index) {
                return last;
            }
            int depth = extrem.getNode().getDepth();
            if (depth > minDepth) continue;
            minDepth = depth;
            last = extrem;
        }
        return last;
    }

    protected ListSortedSet newExtremitySortedSet() {
        return new ArraySortedSet(extremityComparator);
    }

    protected Node newNode(Node parent, GeneratedTag tag, int position) {
        return parent == null ? new RootNode(this, tag, position) : new Node(parent, tag, position);
    }

    protected TextSegmentExtremity newExtremity(GeneratedTag tag, int position, boolean isStart) {
        return new TmpExtremity(tag, position, isStart);
    }

    protected RangeComparator newIncludedExtremitiesComparator(TextNode node) {
        return new IncludedExtremitiesRangeComparator(node);
    }

    protected RangeComparator newIndexRangeComparator(int startIndex, int stopIndex) {
        return new IndexRangeComparator(startIndex, stopIndex);
    }

    protected IndexComputer newIndexComputer() {
        return new IndexComputer(this);
    }

    protected Iterator newChildrenIterator(GeneratedTag parent, boolean reverseOrder) {
        return new ChildrenIterator(this, parent, reverseOrder);
    }

    protected Iterator newSegmentIter(TextSegmentExtremity first, ListSortedSet extrems, TextSegmentExtremity last, boolean collate, boolean skipEmpty, boolean reverse) {
        return collate ? (reverse ? new ReverseCollatedSegmentIter(first, extrems, last, skipEmpty) : new CollatedSegmentIter(first, extrems, last, skipEmpty)) : (reverse ? new ReverseSegmentIter(first, extrems, last, skipEmpty) : new SegmentIter(first, extrems, last, skipEmpty));
    }

    @Override
    public boolean isAutomaticPatternRecognition() {
        return this.autoPatternRecognition;
    }

    @Override
    public void setAutomaticPatternRecognition(boolean newValue) {
        this.autoPatternRecognition = newValue;
    }

    @Override
    public boolean doPatternRecognition() {
        if (this.simplifier == null) {
            this.simplifier = new Simplifier(this);
        }
        return this.simplifier.simplify();
    }

    public boolean simplifyInsertions() {
        if (this.simplifier == null) {
            this.simplifier = new Simplifier(this);
        }
        return this.simplifier.simplifyInsertions();
    }

    protected boolean simplifyUserChanges() {
        this.mustSimplifyChanges = false;
        return this.autoPatternRecognition ? this.doPatternRecognition() : this.simplifyInsertions();
    }

    public void checkSimplifyUserChanges() {
        if (this.mustSimplifyChanges) {
            this.simplifyUserChanges();
        }
    }

    protected boolean sequenceEquals(CharSequenceInterval left, int leftIdx, CharSequence right, int rightIdx, int len) {
        while (len-- > 0) {
            if (left.charAt(leftIdx++) == right.charAt(rightIdx++)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean sequenceEquals(CharSequence left, CharSequence right) {
        len = left.length();
        if (right.length() == len) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (left.charAt(len) == right.charAt(len)) continue;
            return false;
lbl6:
            // 2 sources

            ** while (--len >= 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    @Override
    public TextInterval manageInterval(int start, int stop) {
        return null;
    }

    @Override
    public void clearAllChanges() {
        for (TextSegmentExtremity extremity : this.userExtremities) {
            Node node = (Node)extremity.getNode();
            if (node.isInsertion()) {
                this.extremities.remove((Object)extremity);
                if (!extremity.isStop()) continue;
                this.decrementAncestorsMixedContentCount(node);
                continue;
            }
            if (!extremity.isStop()) continue;
            node.text = null;
            node.blankIndicator = 0;
            node.cleanWarnings();
            this.decrementAncestorsMixedContentCount(node);
        }
        this.userExtremities.clear();
        this.length = -1;
        this.compoundText.setLength(0);
        this.mustSimplifyChanges = false;
    }

    public void concistencyCheck() {
        int startCount = 0;
        int stopCount = 0;
        Iterator iter = this.extremities.iterator();
        ArrayList<TextSegmentExtremity> stack = new ArrayList<TextSegmentExtremity>();
        int inUserNodeCount = 0;
        while (iter.hasNext()) {
            TextSegmentExtremity extrem = (TextSegmentExtremity)iter.next();
            if (extrem.isStart()) {
                stack.add(extrem);
                ++startCount;
                this.checkNode((Node)extrem.getNode());
                if (!extrem.getNode().isUserChange()) continue;
                if (inUserNodeCount != 0) {
                    throw new RuntimeException("User node included in another user node");
                }
                inUserNodeCount = 1;
                continue;
            }
            TextSegmentExtremity lastStart = (TextSegmentExtremity)stack.get(stack.size() - 1);
            if (extrem.getNode() != lastStart.getNode()) {
                throw new RuntimeException("Wrong end extremity");
            }
            if (extrem.getNode().isUserChange() && --inUserNodeCount < 0) {
                throw new RuntimeException("End of user node with no corresponding begin");
            }
            stack.remove(stack.size() - 1);
            ++stopCount;
        }
        if (startCount != stopCount) {
            throw new RuntimeException("Not the same number of start and stop");
        }
    }

    protected void checkNode(Node node) {
        ListSortedSet includedUserExtremities = this.userExtremities.subSet(this.newIncludedExtremitiesComparator(node));
        if (!node.hasUserChangeAncestor() && 2 * node.mixedContentCount != includedUserExtremities.size()) {
            throw new RuntimeException("Wrong included count");
        }
    }

    public void clearStoredMatchings() {
        this.simplifier = null;
    }

    @Override
    public ReconcileExtension getReconcileExtension() {
        return this.reconcileExtension;
    }

    @Override
    public void setReconcileExtension(ReconcileExtension newReconcileExtension) {
        this.reconcileExtension = newReconcileExtension;
    }

    @Override
    public void setMatchingExtension(MatchingExtension newMatchingExtension) {
        if (newMatchingExtension == this.matchingExtension) {
            return;
        }
        if (this.matchingExtension != null) {
            throw new RuntimeException("Change pas de matching extension quand c'est pas utile !!!");
        }
        this.matchingExtension = newMatchingExtension;
        this.matchingExtension.setMatchingContext(new DefaultMatchingContext(this));
        this.simplifier = null;
    }

    @Override
    public MatchingExtension getMatchingExtension() {
        if (this.matchingExtension == null) {
            this.matchingExtension = new IgnoreSpaceMatchingExtension();
            this.matchingExtension.setMatchingContext(new DefaultMatchingContext(this));
        }
        return this.matchingExtension;
    }

    protected static class Anchor
    implements Comparable,
    NodeAnchor {
        protected GeneratedTag tag;
        protected int position;
        protected List warnings;

        public Anchor() {
        }

        public Anchor(GeneratedTag anchorTag, int relativePosition) {
            this.tag = anchorTag;
            this.position = relativePosition;
        }

        @Override
        public GeneratedTag getTag() {
            return this.tag;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public List getWarnings() {
            return this.warnings;
        }

        @Override
        public void setWarnings(List list) {
            this.warnings = list;
        }

        @Override
        public CharSequence generatedText() {
            switch (this.position) {
                case -1: {
                    return this.tag.getBlanksBefore();
                }
                case 0: {
                    return this.tag.getText();
                }
                case 1: {
                    return this.tag.getBlanksAfter();
                }
            }
            return null;
        }

        public int compareTo(Object o) {
            Anchor anchor = (Anchor)o;
            if (anchor.tag == this.tag) {
                return this.position - anchor.position;
            }
            if (this.tag.isAncestorOf(anchor.tag)) {
                return this.position != 1 ? -1 : 1;
            }
            if (anchor.tag.isAncestorOf(this.tag)) {
                return anchor.position != 1 ? 1 : -1;
            }
            return this.tag.getStartRank() - anchor.tag.getStartRank();
        }

        protected void addWarning(String warning) {
            if (this.warnings == null) {
                this.warnings = new ArrayList();
            }
            this.warnings.add(warning);
        }
    }

    protected static class AnchorChooserProposal
    implements AnchorProposal {
        protected Reconciliator reconcilator;
        protected Anchor nodeAnchor;
        protected CharSequence nodeText;
        protected List proposals;

        public AnchorChooserProposal(Reconciliator rcl, TextNode node, List anchors) {
            this.reconcilator = rcl;
            this.nodeAnchor = new Anchor(node.getTag(), node.getPosition());
            this.nodeText = node.text();
            this.proposals = anchors;
        }

        @Override
        public GeneratedInfo getOldGeneratedInfo() {
            return this.reconcilator.oldGenerated;
        }

        @Override
        public NodeAnchor getOldAnchor() {
            return this.nodeAnchor;
        }

        @Override
        public CharSequence getUserText() {
            return this.nodeText;
        }

        @Override
        public GeneratedInfo getNewGeneratedInfo() {
            return this.reconcilator.newGenerated;
        }

        @Override
        public Iterator proposedNewAnchors() {
            return this.proposals.iterator();
        }

        @Override
        public NodeAnchor newAnchor(GeneratedTag tag, int position, List warnings) {
            if (tag.getGeneratedInfo() != this.reconcilator.newGenerated) {
                throw new RuntimeException("Invalid tag : must belong the the new generated info");
            }
            if (position != 0 && position != -1 && position != 1) {
                throw new RuntimeException("Invalid position");
            }
            Anchor newAnchor = new Anchor(tag, position);
            newAnchor.warnings = warnings;
            return newAnchor;
        }

        @Override
        public void addUserNode(NodeAnchor anchor, CharSequence text) {
            this.reconcilator.addNodeToNewPosition((Anchor)anchor, text);
        }
    }

    protected static class CharSequenceInterval
    implements CharSequence,
    Cloneable,
    Serializable {
        protected CharSequence text;
        protected int startIdx;
        protected int stopIdx;
        protected int hash;

        protected CharSequenceInterval() {
        }

        protected CharSequenceInterval(CharSequence fullText, int startIndex, int stopIndex) {
            this.text = fullText;
            this.startIdx = startIndex;
            this.stopIdx = stopIndex;
        }

        protected CharSequenceInterval(CharSequenceInterval parentInterval, int startIndex, int stopIndex) {
            this.text = parentInterval.text;
            this.startIdx = parentInterval.startIdx + startIndex;
            this.stopIdx = parentInterval.startIdx + stopIndex;
        }

        @Override
        public int length() {
            return this.stopIdx - this.startIdx;
        }

        @Override
        public char charAt(int idx) {
            return this.text.charAt(this.startIdx + idx);
        }

        @Override
        public CharSequence subSequence(int begin, int end) {
            return this.text.subSequence(this.startIdx + begin, this.startIdx + end);
        }

        public CharSequenceInterval subSequenceInterval(int begin, int end) {
            return new CharSequenceInterval(this.text, this.startIdx + begin, this.startIdx + end);
        }

        public CharSequence toCharSequence() {
            return this.text.subSequence(this.startIdx, this.stopIdx);
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            CharSequence sequence = (CharSequence)obj;
            int len = sequence.length();
            if (len != this.stopIdx - this.startIdx) {
                return false;
            }
            int i = this.stopIdx;
            while (--len >= 0) {
                if (this.text.charAt(--i) == sequence.charAt(len)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            int idx = this.startIdx;
            int max = this.stopIdx;
            int h = 0;
            while (idx < max) {
                h = 31 * h + this.text.charAt(idx++);
            }
            this.hash = h;
            return h;
        }

        @Override
        public String toString() {
            return this.text.subSequence(this.startIdx, this.stopIdx).toString();
        }
    }

    protected static class ChildrenIterator
    implements Iterator {
        protected SourceCodeMixer mgr;
        protected ListIterator tagsIter;
        protected boolean reverse;
        protected GeneratedTag nextTag;
        protected int nextPosition;
        protected TextNode nextNode;

        public ChildrenIterator(SourceCodeMixer mixer, GeneratedTag parent, boolean reverseOrder) {
            this.mgr = mixer;
            this.reverse = reverseOrder;
            if (reverseOrder) {
                this.tagsIter = parent.sons().listIterator(parent.sons().size());
                this.nextTag = this.tagsIter.hasPrevious() ? this.tagsIter.previous() : null;
                this.nextPosition = 1;
            } else {
                this.tagsIter = parent.sons().listIterator();
                this.nextTag = this.tagsIter.hasNext() ? this.tagsIter.next() : null;
                this.nextPosition = -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null || this.fetchNext();
        }

        protected boolean fetchNext() {
            while (this.nextTag != null) {
                this.nextNode = this.mgr.getNodeAtPosition(this.nextTag, this.nextPosition, false);
                if (this.reverse) {
                    if (--this.nextPosition < -1) {
                        this.nextPosition = 1;
                        if (this.tagsIter.hasPrevious()) {
                            this.nextTag = (GeneratedTag)this.tagsIter.previous();
                            if (this.nextTag.areBlanksAfterShared()) {
                                --this.nextPosition;
                            }
                        } else {
                            this.nextTag = null;
                        }
                    }
                } else if (++this.nextPosition > 1) {
                    this.nextPosition = -1;
                    if (this.tagsIter.hasNext()) {
                        this.nextTag = (GeneratedTag)this.tagsIter.next();
                        if (this.nextTag.areBlanksBeforeShared()) {
                            ++this.nextPosition;
                        }
                    } else {
                        this.nextTag = null;
                    }
                }
                if (this.nextNode == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("UserChangesMgr.ChildrenIterator");
            }
            TextNode found = this.nextNode;
            this.nextNode = null;
            return found;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("UserChangesMgr.ChildrenIterator.remove");
        }
    }

    protected static class CollatedSegmentIter
    extends SegmentIter {
        public CollatedSegmentIter() {
        }

        public CollatedSegmentIter(TextSegmentExtremity firstExtrem, ListSortedSet extremities, TextSegmentExtremity lastExtrem, boolean skipEmptySegments) {
            super(firstExtrem, extremities, lastExtrem, skipEmptySegments);
        }

        @Override
        protected void makeNextSegment() {
            if (this.tail == null) {
                return;
            }
            boolean userCode = this.isUserCode(this.head, this.tail);
            this.nextSegment = this.newSegment(this.head, this.tail, userCode, false);
            while (this.findNextSegment()) {
                if (this.isUserCode(this.head, this.tail) != userCode) {
                    return;
                }
                this.nextSegment.tail = this.tail;
                this.nextSegment.atomic = false;
                if (this.nextSegment.includingNode == null) continue;
                this.nextSegment.includingNode = this.nextSegment.includingNode.commonAncestorWith(this.tail.getNode());
            }
        }
    }

    protected static class ExtremityComparator
    implements Comparator,
    Serializable {
        protected ExtremityComparator() {
        }

        public int compare(Object o1, Object o2) {
            GeneratedTag rightTag;
            if (o1 == o2) {
                return 0;
            }
            TextSegmentExtremity left = (TextSegmentExtremity)o1;
            TextSegmentExtremity right = (TextSegmentExtremity)o2;
            TextNode leftNode = left.getNode();
            TextNode rightNode = right.getNode();
            GeneratedTag leftTag = leftNode.getTag();
            if (leftTag == (rightTag = rightNode.getTag())) {
                int cmp = leftNode.getPosition() - rightNode.getPosition();
                return cmp == 0 ? (left.isStart() ? 0 : 1) - (right.isStart() ? 0 : 1) : cmp;
            }
            if (leftTag.isAncestorOf(rightTag)) {
                switch (leftNode.getPosition()) {
                    case -1: {
                        return -1;
                    }
                    case 0: {
                        return left.isStart() ? -1 : 1;
                    }
                    case 1: {
                        return 1;
                    }
                }
            }
            if (rightTag.isAncestorOf(leftTag)) {
                switch (rightNode.getPosition()) {
                    case -1: {
                        return 1;
                    }
                    case 0: {
                        return right.isStart() ? 1 : -1;
                    }
                    case 1: {
                        return -1;
                    }
                }
            }
            return leftTag.getStartRank() - rightTag.getStartRank();
        }
    }

    protected static class IncludedExtremitiesRangeComparator
    extends AbstractRangeComparator {
        protected TextNode ancestor;
        protected GeneratedTag ancestorTag;

        public IncludedExtremitiesRangeComparator(TextNode node) {
            this.ancestor = node;
            this.ancestorTag = node.getTag();
        }

        public int compareWithRange(Object o) {
            TextSegmentExtremity extremity = (TextSegmentExtremity)o;
            TextNode node = extremity.getNode();
            GeneratedTag tag = node.getTag();
            if (this.ancestorTag.isAncestorOf(tag)) {
                return -this.ancestor.getPosition();
            }
            if (tag == this.ancestorTag || tag.isAncestorOf(this.ancestorTag)) {
                switch (node.getPosition()) {
                    case -1: {
                        return -1;
                    }
                    case 0: {
                        return extremity.isStart() ? -1 : 1;
                    }
                    case 1: {
                        return 1;
                    }
                }
            }
            return tag.getStartRank() - this.ancestorTag.getStartRank();
        }
    }

    protected static class IndexComputer {
        protected UserChangesMgr mgr;

        public IndexComputer(UserChangesMgr manager) {
            this.mgr = manager;
        }

        public int computeAllIndexes() {
            Iterator extremities = this.mgr.extremities.iterator();
            TextSegmentExtremity extremity = (TextSegmentExtremity)extremities.next();
            Node node = (Node)extremity.getNode();
            node.start = 0;
            boolean override = node.isOverride();
            int index = override ? node.text.length() : 0;
            while (extremities.hasNext()) {
                TextSegmentExtremity nextExtremity = (TextSegmentExtremity)extremities.next();
                Node nextNode = (Node)nextExtremity.getNode();
                if (override && nextNode != node) {
                    if (!extremity.isStart()) continue;
                    nextNode.start = nextNode.stop = index;
                    continue;
                }
                if (!override) {
                    index += this.distance(extremity, nextExtremity);
                }
                if (nextExtremity.isStart()) {
                    nextNode.start = index;
                } else {
                    nextNode.stop = index;
                }
                extremity = nextExtremity;
                node = nextNode;
                boolean bl = override = extremity.isStart() && node.isOverride();
                if (!override) continue;
                index += node.text.length();
            }
            return index;
        }

        protected int distance(TextSegmentExtremity from, TextSegmentExtremity to) {
            TextNode fromNode = from.getNode();
            TextNode toNode = to.getNode();
            GeneratedTag fromTag = fromNode.getTag();
            GeneratedTag toTag = toNode.getTag();
            if (from.isStart()) {
                if (to.isStop()) {
                    return fromNode.isUserChange() ? fromNode.length() : fromTag.length();
                }
                int generatedGap = toTag.getStartIndex() - fromTag.getStartIndex();
                return toNode.getPosition() == -1 ? generatedGap - toTag.nbBlanksBefore() : generatedGap;
            }
            if (to.isStop()) {
                int generatedGap = toTag.getStopIndex() - fromTag.getStopIndex();
                return fromNode.getPosition() == 1 ? generatedGap - fromTag.nbBlanksAfter() : generatedGap;
            }
            int fromPosition = fromNode.getPosition();
            int toPosition = toNode.getPosition();
            if (fromPosition == -1 || toPosition == 1) {
                return 0;
            }
            int gap = toTag.getStartIndex() - fromTag.getStopIndex();
            if (fromPosition == 1) {
                gap -= fromTag.nbBlanksAfter();
            }
            if (toPosition == -1) {
                gap -= toTag.nbBlanksBefore();
            }
            return gap > 0 ? gap : 0;
        }

        public void computeFullText() {
            boolean quickJump;
            StringBuffer buffer = this.mgr.compoundText;
            buffer.setLength(0);
            Iterator extremities = this.mgr.extremities.iterator();
            TextSegmentExtremity extremity = (TextSegmentExtremity)extremities.next();
            Node node = (Node)extremity.getNode();
            boolean bl = quickJump = node.isUserChange() || !node.includeUserChange();
            if (quickJump) {
                this.append(buffer, node.isUserChange() ? node.text : node.tag.getText());
            }
            while (extremities.hasNext()) {
                TextSegmentExtremity nextExtremity = (TextSegmentExtremity)extremities.next();
                Node nextNode = (Node)nextExtremity.getNode();
                if (quickJump && nextNode != node) continue;
                if (!quickJump) {
                    this.append(buffer, this.chars(extremity, nextExtremity));
                }
                extremity = nextExtremity;
                node = nextNode;
                boolean bl2 = quickJump = extremity.isStart() && (node.isUserChange() || !node.includeUserChange());
                if (!quickJump) continue;
                this.append(buffer, node.isUserChange() ? node.text : node.tag.getText());
            }
        }

        protected void append(StringBuffer buffer, CharSequence chars) {
            int len = chars.length();
            buffer.ensureCapacity(buffer.length() + len);
            int i = 0;
            while (i < len) {
                buffer.append(chars.charAt(i));
                ++i;
            }
        }

        protected CharSequence chars(TextSegmentExtremity from, TextSegmentExtremity to) {
            Node fromNode = (Node)from.getNode();
            Node toNode = (Node)to.getNode();
            GeneratedTag fromTag = fromNode.getTag();
            GeneratedTag toTag = toNode.getTag();
            if (from.isStart()) {
                if (to.isStop()) {
                    return fromNode.isUserChange() ? fromNode.text : fromTag.getText();
                }
                int start = fromTag.getStartIndex();
                int stop = toNode.position == -1 ? toTag.getStartIndex() - toTag.nbBlanksBefore() : toTag.getStartIndex();
                return this.mgr.getGeneratedInfo().getText().subSequence(start, stop);
            }
            if (to.isStop()) {
                int start = fromNode.position == 1 ? fromTag.getStopIndex() + fromTag.nbBlanksAfter() : fromTag.getStopIndex();
                int stop = toTag.getStopIndex();
                return this.mgr.getGeneratedInfo().getText().subSequence(start, stop);
            }
            int fromPosition = fromNode.position;
            int toPosition = toNode.position;
            if (fromPosition == -1 || toPosition == 1) {
                return "";
            }
            int start = fromTag.getStopIndex();
            if (fromPosition == 1) {
                start += fromTag.nbBlanksAfter();
            }
            int stop = toTag.getStartIndex();
            if (toPosition == -1) {
                stop -= toTag.nbBlanksBefore();
            }
            return stop > start ? this.mgr.getGeneratedInfo().getText().subSequence(start, stop) : "";
        }
    }

    protected static class IndexRangeComparator
    extends AbstractRangeComparator {
        protected int start;
        protected int stop;

        protected IndexRangeComparator() {
            this(-1, -1);
        }

        protected IndexRangeComparator(int startIndex, int stopIndex) {
            this.start = startIndex;
            this.stop = stopIndex;
        }

        public boolean isLeftLimited() {
            return this.start >= 0;
        }

        public boolean isRightLimited() {
            return this.stop >= 0;
        }

        protected int compareRangeWithIndex(int index) {
            return this.start >= 0 && index < this.start ? -1 : (this.stop >= 0 && index > this.stop ? 1 : 0);
        }

        public int compareWithRange(Object o) {
            return this.compareRangeWithIndex(((TextSegmentExtremity)o).index());
        }
    }

    protected static class Interval
    implements TextInterval {
        protected UserChangesMgr mgr;
        protected int start;
        protected int stop;

        protected Interval(int startIndex, int stopIndex) {
            this.start = startIndex;
            this.stop = stopIndex;
        }

        @Override
        public int startIndex() {
            return this.start;
        }

        @Override
        public int stopIndex() {
            return this.stop;
        }

        @Override
        public CharSequence text() {
            return this.mgr.text().subSequence(this.start, this.stop);
        }

        protected void updateFromUserChange(int changeStart, int changeStop, CharSequence newText) {
            if (changeStart >= this.stop) {
                return;
            }
            int len = newText.length();
            int shift = len - changeStop + changeStart;
            if (changeStop <= this.start) {
                this.start += shift;
                this.stop += shift;
                return;
            }
            if (changeStart <= this.start && changeStop >= this.stop) {
                this.start = this.stop = changeStart + len;
                return;
            }
            if (changeStop >= this.stop) {
                this.stop = changeStart;
                return;
            }
            this.start = changeStart + len;
            this.stop += shift;
        }

        protected void updateFromModelChange(ListSortedSet oldExtremities, ListSortedSet newExtremities) {
        }
    }

    public static class Node
    implements TextNode,
    TextSegmentExtremity,
    Serializable {
        protected Node parent;
        protected GeneratedTag tag;
        protected int position;
        protected CharSequence text;
        protected int blankIndicator;
        protected boolean reindent;
        protected transient int start;
        protected transient int stop;
        protected int mixedContentCount;
        protected TextSegmentExtremity tail;
        protected boolean isParentOfHiddenOverride;
        protected boolean isParentOfHiddenReindent;
        protected List warnings;
        protected List oldNodes;
        protected List lostNodes;

        public List getWarnings() {
            return this.warnings;
        }

        public Node() {
        }

        public Node(Node parentNode, GeneratedTag anchor, int hook) {
            this.parent = parentNode;
            this.tag = anchor;
            this.position = hook;
            this.tail = new StopExtremity(this);
        }

        @Override
        public GeneratedTag getTag() {
            return this.tag;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public boolean isHidden() {
            if (this.isPureIndent()) {
                return true;
            }
            String hiddenProperty = this.getTag().getProperty("hidden");
            if (hiddenProperty != null && hiddenProperty.equals("true")) {
                if (this.getPosition() == 1 && this.getTag().areBlanksAfterShared()) {
                    return false;
                }
                return this.getPosition() != -1 || !this.getTag().areBlanksBeforeShared();
            }
            return false;
        }

        @Override
        public boolean isInsertion() {
            return this.position != 0;
        }

        @Override
        public boolean isOverride() {
            return this.position == 0 && this.text != null;
        }

        @Override
        public boolean isUserChange() {
            return this.position != 0 || this.text != null;
        }

        @Override
        public boolean isReindent() {
            return this.reindent;
        }

        @Override
        public TextNode getParent() {
            return this.parent;
        }

        @Override
        public int getDepth() {
            return this.tag.getDepth();
        }

        @Override
        public boolean hasChildren() {
            return this.position == 0 && !this.tag.sons().isEmpty();
        }

        @Override
        public boolean isAncestorOf(TextNode node) {
            return this.position == 0 && this.tag.isAncestorOf(node.getTag());
        }

        @Override
        public boolean isInSameBranch(TextNode node) {
            return this == node || this.isAncestorOf(node) || node.isAncestorOf(this);
        }

        @Override
        public boolean includeUserChange() {
            return this.mixedContentCount > 0;
        }

        @Override
        public boolean includeRealChange() {
            if (!this.includeUserChange()) {
                return false;
            }
            UserChangesMgr mgr = this.getManager();
            TwoWayIterator includedChanges = mgr.userExtremities.rangeIterator(mgr.newIncludedExtremitiesComparator(this));
            while (includedChanges.hasNext()) {
                TextSegmentExtremity extrem = (TextSegmentExtremity)includedChanges.next();
                if (!extrem.isStart() || extrem.getNode().isPureIndent() || extrem.getNode().isReindent()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasUserChangeAncestor() {
            Node ancestor = this.parent;
            while (ancestor != null) {
                if (ancestor.isUserChange()) {
                    return true;
                }
                ancestor = ancestor.parent;
            }
            return false;
        }

        @Override
        public Iterator children(boolean reverseOrder) {
            return this.position == 0 ? this.getManager().newChildrenIterator(this.tag, reverseOrder) : Collections.EMPTY_SET.iterator();
        }

        @Override
        public Iterator subNodes(boolean byStopOrder) {
            return this.getManager().subNodesOf(this, byStopOrder);
        }

        @Override
        public TextNode commonAncestorWith(TextNode node) {
            return this.commonAncestor(this, node);
        }

        protected TextNode commonAncestor(TextNode node1, TextNode node2) {
            int depth2;
            if (node1 == node2 || node1.isAncestorOf(node2)) {
                return node1;
            }
            if (node2.isAncestorOf(node1)) {
                return node2;
            }
            int depth1 = node1.getDepth();
            if (depth1 > (depth2 = node2.getDepth())) {
                do {
                    node1 = node1.getParent();
                } while (--depth1 > depth2);
            } else if (depth2 > depth1) {
                do {
                    node2 = node2.getParent();
                } while (--depth2 > depth1);
            }
            while (node1 != node2) {
                node1 = node1.getParent();
                node2 = node2.getParent();
            }
            return node1;
        }

        @Override
        public boolean restoreGeneratedCode() {
            return this.restoreGeneratedCode(true);
        }

        public boolean restoreGeneratedCode(boolean restoreMargins) {
            if (this.isOverride()) {
                if (restoreMargins) {
                    this.restoreMargins();
                }
                this.getManager().restoreNode(this);
                return true;
            }
            if (this.isInsertion()) {
                this.getManager().removeUserNode(this);
                this.position = 0;
                this.text = null;
                return true;
            }
            if (!this.includeUserChange()) {
                return false;
            }
            boolean restored = false;
            Iterator children = this.children(false);
            while (children.hasNext()) {
                restored |= ((Node)children.next()).restoreGeneratedCode();
            }
            return restored;
        }

        protected void restoreMargins() {
            TextNode margin = this.getManager().getNodeAtPosition(this.tag, -1, true);
            if (margin != null && margin.isPureIndent()) {
                margin.restoreGeneratedCode();
            }
            if ((margin = this.getManager().getNodeAtPosition(this.tag, 1, true)) != null && margin.isPureIndent()) {
                margin.restoreGeneratedCode();
            }
        }

        @Override
        public boolean isPureIndent() {
            return this.position != 0 && this.isBlank();
        }

        @Override
        public boolean isParentOfHiddenOverride() {
            return this.isParentOfHiddenOverride;
        }

        @Override
        public boolean isParentOfHiddenReindent() {
            return this.isParentOfHiddenReindent;
        }

        public boolean isBlank() {
            switch (this.blankIndicator) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
            int count = this.length();
            CharSequence txt = this.text();
            while (--count >= 0) {
                if (Character.isWhitespace(txt.charAt(count))) continue;
                this.blankIndicator = -1;
                return false;
            }
            this.blankIndicator = 1;
            return true;
        }

        @Override
        public boolean hasWarnings() {
            return this.hasChangeControlWarning() || this.hasReconcilationWarnings();
        }

        public boolean hasReconcilationWarnings() {
            return this.warnings != null && !this.warnings.isEmpty();
        }

        public boolean hasChangeControlWarning() {
            return this.position == 0 ? this.tag.getChangeControl() != 0 && this.text != null && !this.isReindent() : this.parent != null && this.parent.tag.getChangeControl() != 0 && !this.isPureIndent();
        }

        private boolean hasChangeControlError() {
            return this.position == 0 ? this.tag.getChangeControl() == 2 && this.text != null && !this.isReindent() : this.parent != null && this.parent.tag.getChangeControl() == 2 && !this.isPureIndent();
        }

        @Override
        public Iterator warnings() {
            boolean reconcilationWarning;
            boolean changeControlWarning = this.hasChangeControlWarning();
            boolean bl = reconcilationWarning = this.warnings != null && !this.warnings.isEmpty();
            if (!changeControlWarning && !reconcilationWarning) {
                return Collections.EMPTY_SET.iterator();
            }
            if (!reconcilationWarning) {
                return Collections.singleton("User change forbidden at this position").iterator();
            }
            if (!changeControlWarning) {
                return this.warnings.iterator();
            }
            return Iterators.catenateIterator((Iterator[])new Iterator[]{Collections.singleton("User change forbidden at this position").iterator(), this.warnings.iterator()});
        }

        public void checkNode() {
            this.getManager().checkNode(this);
        }

        @Override
        public void cleanWarnings() {
            this.oldNodes = null;
            this.lostNodes = null;
            this.warnings = null;
        }

        public void putText(CharSequence text) {
            this.getManager().changeText(this, text);
        }

        public void putGeneratedText() {
            this.getManager().changeText(this, this.getGeneratedText());
        }

        public void putReconciledText() {
            this.getManager().changeText(this, this.getReconciledText());
        }

        public void putLostText() {
            this.getManager().changeText(this, this.getLostText());
        }

        public CharSequence getReconciledText() {
            return this.getReconciledText(this.getGeneratedText());
        }

        protected CharSequence getReconciledText(CharSequence defaultText) {
            if (this.oldNodes != null) {
                StringBuilder reconciledText = null;
                Iterator nodes = this.oldNodes.iterator();
                Iterator losts = this.lostNodes != null ? this.lostNodes.iterator() : Iterators.emptyIterator();
                Node lostNode = losts.hasNext() ? (Node)losts.next() : null;
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    if (node != lostNode) {
                        if (reconciledText == null) {
                            reconciledText = new StringBuilder(node.text.length());
                        }
                        reconciledText.append(node.text);
                        continue;
                    }
                    Node node2 = lostNode = losts.hasNext() ? (Node)losts.next() : null;
                }
                if (reconciledText != null) {
                    return reconciledText.toString();
                }
            }
            return defaultText;
        }

        public CharSequence getGeneratedText() {
            int beginIdx = this.getHead().generatedIndex();
            int endIdx = this.getTail().generatedIndex();
            return this.getManager().generated.getText().subSequence(beginIdx, endIdx);
        }

        public CharSequence getLostText() {
            char last;
            if (this.oldNodes == null) {
                return this.text();
            }
            StringBuilder lostText = new StringBuilder();
            boolean hasLostText = false;
            Iterator nodes = this.oldNodes.iterator();
            Iterator losts = this.lostNodes != null ? this.lostNodes.iterator() : Iterators.emptyIterator();
            Node lostNode = losts.hasNext() ? (Node)losts.next() : null;
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (node != lostNode) {
                    lostText.append(node.text);
                    continue;
                }
                this.appendLostText(node, lostText);
                lostNode = losts.hasNext() ? (Node)losts.next() : null;
                hasLostText = true;
            }
            if (hasLostText && lostText.length() > 0 && (last = lostText.charAt(lostText.length() - 1)) != '\n' && last != '\r') {
                lostText.append(EOL);
            }
            return lostText.toString();
        }

        public boolean hasLostText() {
            return this.lostNodes != null && !this.lostNodes.isEmpty();
        }

        protected Node removedAncestor(Node oldNode) {
            GeneratedInfo generated = this.getManager().generated;
            while (oldNode.parent != null && generated.getTag(oldNode.parent.tag.getName()) == null) {
                oldNode = oldNode.parent;
            }
            return oldNode;
        }

        protected void appendLostText(Node node, StringBuilder builder) {
            char last;
            char first;
            CharSequence lostText = node.text();
            boolean insertEol = true;
            if (lostText.length() > 0 && ((first = lostText.charAt(0)) == '\r' || first == '\n')) {
                insertEol = false;
            }
            if (insertEol && builder.length() > 0 && ((last = builder.charAt(builder.length() - 1)) == '\n' || last == '\r')) {
                insertEol = false;
            }
            if (insertEol) {
                builder.append(System.getProperty("line.separator"));
            }
            builder.append(lostText);
        }

        @Override
        public TextSegmentExtremity getHead() {
            return this;
        }

        @Override
        public TextSegmentExtremity getTail() {
            return this.tail;
        }

        @Override
        public int startIndex() {
            this.getManager().computeIndexes(this);
            return this.start;
        }

        @Override
        public int stopIndex() {
            this.getManager().computeIndexes(this);
            return this.stop;
        }

        @Override
        public int length() {
            if (this.isUserChange()) {
                return this.text.length();
            }
            if (this.hasUserChangeAncestor()) {
                return 0;
            }
            if (!this.includeUserChange()) {
                return this.tag.getText().length();
            }
            this.getManager().computeIndexes(this);
            return this.stop - this.start;
        }

        @Override
        public boolean isEmpty() {
            return this.length() == 0;
        }

        @Override
        public CharSequence text() {
            if (this.isUserChange()) {
                return this.text;
            }
            if (this.hasUserChangeAncestor()) {
                return "";
            }
            if (!this.includeUserChange()) {
                return this.tag.getText();
            }
            this.getManager().computeIndexes(this);
            return this.start != this.stop ? this.getManager().text().subSequence(this.start, this.stop) : "";
        }

        @Override
        public boolean isAtomic() {
            return !this.hasChildren();
        }

        @Override
        public boolean isUserCode() {
            return this.isUserChange();
        }

        @Override
        public boolean isGeneratedCode() {
            return !this.isUserChange() && !this.includeUserChange();
        }

        @Override
        public TextNode getIncludingNode() {
            return this;
        }

        @Override
        public Iterator subSegments(boolean collate, boolean skipEmpty, boolean reverseOrder) {
            return this.getManager().segments(this, this.tail, collate, skipEmpty, reverseOrder);
        }

        @Override
        public TextNode getNode() {
            return this;
        }

        @Override
        public boolean isStart() {
            return true;
        }

        @Override
        public boolean isStop() {
            return false;
        }

        @Override
        public int index() {
            return this.startIndex();
        }

        @Override
        public int generatedIndex() {
            return this.position == 1 ? this.tag.getStopIndex() : (this.position == -1 ? this.tag.getStartIndex() - this.tag.nbBlanksBefore() : this.tag.getStartIndex());
        }

        public int compareTo(Object o) {
            return extremityComparator.compare(this, o);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void refreshParentHiddenAttributes() {
            iter = this.children(false);
            this.isParentOfHiddenReindent = false;
            this.isParentOfHiddenOverride = false;
            if (this.getPosition() == 0) ** GOTO lbl16
            return;
lbl-1000:
            // 1 sources

            {
                child = (TextNode)iter.next();
                if (!child.isHidden()) continue;
                if (!this.isParentOfHiddenReindent && (child.isPureIndent() || child.isReindent())) {
                    this.isParentOfHiddenReindent = true;
                }
                if (!child.isOverride()) continue;
                if (child.isReindent()) {
                    this.isParentOfHiddenReindent = true;
                    continue;
                }
                this.isParentOfHiddenOverride = true;
                return;
lbl16:
                // 4 sources

                ** while (iter.hasNext())
            }
lbl17:
            // 1 sources

        }

        public RootNode getRootNode() {
            return this.parent.getRootNode();
        }

        public UserChangesMgr getManager() {
            return this.parent.getManager();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            switch (this.getPosition()) {
                case -1: {
                    String hiddenProperty = this.getTag().getProperty("hidden");
                    if (hiddenProperty != null && hiddenProperty.equals("true") && this.getTag().areBlanksBeforeShared()) {
                        buffer.append('>');
                        buffer.append(this.getTag().previousTag().getName());
                        break;
                    }
                    buffer.append('<');
                    buffer.append(this.getTag().getName());
                    break;
                }
                case 1: {
                    String hiddenProperty = this.getTag().getProperty("hidden");
                    if (hiddenProperty != null && hiddenProperty.equals("true") && this.getTag().areBlanksAfterShared()) {
                        buffer.append('<');
                        buffer.append(this.getTag().nextTag().getName());
                        break;
                    }
                    buffer.append('>');
                    buffer.append(this.getTag().getName());
                    break;
                }
                case 0: {
                    this.refreshParentHiddenAttributes();
                    if (this.isOverride()) {
                        buffer.append((char)(this.reindent ? 126 : (this.text.length() == 0 ? 45 : 42)));
                    } else if (this.hasUserChangeAncestor()) {
                        buffer.append('x');
                    } else if (this.includeUserChange()) {
                        buffer.append('+');
                        if (this.isParentOfHiddenOverride) {
                            buffer.append('*');
                        } else if (this.isParentOfHiddenReindent) {
                            buffer.append('~');
                        }
                    } else if (this.isParentOfHiddenOverride) {
                        buffer.append('*');
                    } else if (this.isParentOfHiddenReindent) {
                        buffer.append('~');
                    } else {
                        buffer.append('=');
                    }
                    buffer.append(this.getTag().getName());
                }
            }
            return buffer.toString();
        }

        protected static class StopExtremity
        implements TextSegmentExtremity,
        Serializable {
            protected TextNode node;

            public StopExtremity(TextNode n) {
                this.node = n;
            }

            @Override
            public TextNode getNode() {
                return this.node;
            }

            @Override
            public int generatedIndex() {
                int position = this.node.getPosition();
                GeneratedTag tag = this.node.getTag();
                return position == -1 ? tag.getStartIndex() : (position == 1 ? tag.getStopIndex() + tag.nbBlanksAfter() : tag.getStopIndex());
            }

            @Override
            public int index() {
                return this.node.stopIndex();
            }

            @Override
            public boolean isStart() {
                return false;
            }

            @Override
            public boolean isStop() {
                return true;
            }

            public int compareTo(Object o) {
                return extremityComparator.compare(this, o);
            }
        }
    }

    protected static class Reconciliator {
        protected UserChangesMgr mgr;
        protected GeneratedInfo oldGenerated;
        protected GeneratedInfo newGenerated;
        protected ListSortedSet oldExtremities;
        protected ListSortedSet newExtremities;
        protected ListSortedSet oldUserExtremities;
        protected ListSortedSet newUserExtremities;

        public Reconciliator(UserChangesMgr changesMgr, GeneratedInfo newGeneratedInfo) {
            this.mgr = changesMgr;
            this.oldGenerated = changesMgr.generated;
            this.newGenerated = newGeneratedInfo;
            this.oldExtremities = changesMgr.extremities;
            this.newExtremities = changesMgr.newExtremitySortedSet();
            this.oldUserExtremities = changesMgr.userExtremities;
            this.newUserExtremities = changesMgr.newExtremitySortedSet();
        }

        public void reconciliate() {
            this.mgr.makeExtremities(this.newGenerated, this.newExtremities);
            if (this.oldGenerated == null) {
                return;
            }
            this.moveUserChanges();
            this.computeTexts();
        }

        public ListSortedSet getNewExtremities() {
            return this.newExtremities;
        }

        public ListSortedSet getNewUserExtremities() {
            return this.newUserExtremities;
        }

        protected void moveUserChanges() {
            ReconcileExtension extension = this.mgr.getReconcileExtension();
            if (extension != null) {
                extension.reconciliationStart();
            }
            for (TextSegmentExtremity e : this.oldUserExtremities) {
                if (!e.isStart()) continue;
                this.findNewPosition((Node)e.getNode());
            }
            if (extension != null) {
                extension.reconciliationStop();
            }
        }

        protected void findNewPosition(Node userNode) {
            if (userNode.oldNodes == null) {
                this.moveNode(userNode);
                return;
            }
            Iterator nodes = userNode.oldNodes.iterator();
            while (nodes.hasNext()) {
                this.findNewPosition((Node)nodes.next());
            }
        }

        protected void moveNode(Node userNode) {
            Anchor newAnchor;
            ListSortedSet newAnchors = this.findNewRegularPositions(userNode);
            if (newAnchors.isEmpty()) {
                newAnchors = this.findNewRescuePositions(userNode);
            }
            if ((newAnchor = this.chooseNewPosition(userNode, newAnchors)) != null) {
                this.moveNodeToNewPosition(userNode, newAnchor);
            }
        }

        protected ListSortedSet findNewRegularPositions(Node userNode) {
            Anchor alternateAnchor;
            ArraySortedSet anchors = new ArraySortedSet(2);
            Anchor anchor = this.newRegularAnchor(userNode);
            if (anchor != null) {
                anchors.add((Object)anchor);
            }
            if ((alternateAnchor = this.newAlternateAnchor(userNode)) != null) {
                anchors.add((Object)alternateAnchor);
            }
            if (anchors.size() > 1) {
                for (Anchor a : anchors) {
                    a.addWarning("Alternate positions exists");
                }
            }
            return anchors;
        }

        protected ListSortedSet findNewRescuePositions(Node userNode) {
            Anchor afterAllPrecedingAnchor;
            Anchor beforeAllFollowingAnchor;
            GeneratedTag newAncestor;
            ArraySortedSet anchors = new ArraySortedSet(2);
            GeneratedTag oldAncestor = this.searchExistingAncestor(userNode.tag);
            if (oldAncestor == null) {
                oldAncestor = userNode.getRootNode().getTag();
            }
            if ((newAncestor = this.newGenerated.getTag(oldAncestor.getName())) == null) {
                newAncestor = this.newGenerated.getRootTag();
            }
            if ((beforeAllFollowingAnchor = this.findNewPositionInsideUpDown(userNode, oldAncestor, newAncestor)) != null) {
                anchors.add((Object)beforeAllFollowingAnchor);
            }
            if ((afterAllPrecedingAnchor = this.findNewPositionInsideDownUp(userNode, oldAncestor, newAncestor)) != null) {
                anchors.add((Object)afterAllPrecedingAnchor);
            }
            anchors.size();
            for (Anchor a : anchors) {
                a.addWarning("User code has been lost");
            }
            return anchors;
        }

        protected Anchor newRegularAnchor(Node userNode) {
            Anchor newAnchor;
            String oldTagName = userNode.tag.getName();
            GeneratedTag newTag = this.newGenerated.getTag(oldTagName);
            if (newTag == null) {
                return null;
            }
            Anchor anchor = newAnchor = userNode.position == -1 && newTag.areBlanksBeforeShared() ? new Anchor(newTag.previousTag(), 1) : new Anchor(newTag, userNode.position);
            if (newAnchor.position == 0 && !this.mgr.sequenceEquals(userNode.getTag().getText(), newTag.getText())) {
                newAnchor.addWarning("Overriden generated code changed");
            }
            return newAnchor;
        }

        protected boolean sameParentNames(GeneratedTag leftTag, GeneratedTag rightTag) {
            leftTag = leftTag.getParent();
            rightTag = rightTag.getParent();
            if (leftTag == null || rightTag == null) {
                return leftTag == rightTag;
            }
            return leftTag.getName().equals(rightTag.getName());
        }

        protected Anchor newAlternateAnchor(Node userNode) {
            if (userNode.position == -1 && userNode.tag.areBlanksBeforeShared()) {
                String alternateOldTagName = userNode.tag.previousTag().getName();
                GeneratedTag alternateNewTag = this.newGenerated.getTag(alternateOldTagName);
                return alternateNewTag != null ? new Anchor(alternateNewTag, 1) : null;
            }
            if (userNode.position == 1 && userNode.tag.areBlanksAfterShared()) {
                String alternateOldTagName = userNode.tag.nextTag().getName();
                GeneratedTag alternateNewTag = this.newGenerated.getTag(alternateOldTagName);
                if (alternateNewTag == null) {
                    return null;
                }
                return alternateNewTag.areBlanksBeforeShared() ? new Anchor(alternateNewTag.previousTag(), 1) : new Anchor(alternateNewTag, -1);
            }
            return null;
        }

        protected Anchor findNewPositionForNode(Node userNode) {
            GeneratedTag oldAncestor = this.searchExistingAncestor(userNode.tag);
            return this.findNewPositionInside(userNode, oldAncestor);
        }

        protected GeneratedTag searchExistingAncestor(GeneratedTag oldTag) {
            GeneratedTag ancestor = oldTag.getParent();
            while (ancestor != null) {
                String ancestorName = ancestor.getName();
                if (this.newGenerated.getTag(ancestorName) != null) {
                    return ancestor;
                }
                ancestor = ancestor.getParent();
            }
            return null;
        }

        protected Anchor findNewPositionInside(Node userNode, GeneratedTag oldContainer) {
            GeneratedTag newContainer = this.newGenerated.getTag(oldContainer.getName());
            return this.findNewPositionInsideDownUp(userNode, oldContainer, newContainer);
        }

        protected Anchor findNewPositionInsideDownUp(Node userNode, GeneratedTag oldContainer, GeneratedTag newContainer) {
            Anchor newAnchor = newContainer.areBlanksBeforeShared() ? new Anchor(newContainer.previousTag(), 1) : new Anchor(newContainer, -1);
            ListIterator newSubTags = newContainer.sons().listIterator(newContainer.sons().size());
            while (newSubTags.hasPrevious()) {
                GeneratedTag newSubTag = (GeneratedTag)newSubTags.previous();
                if (this.userNodeWasAfterTag(userNode, newSubTag, oldContainer)) {
                    newAnchor.tag = newSubTag;
                    newAnchor.position = 1;
                    return newAnchor;
                }
                if (newSubTag.areBlanksBeforeShared()) {
                    newAnchor.tag = newSubTag.previousTag();
                    newAnchor.position = 1;
                    continue;
                }
                newAnchor.tag = newSubTag;
                newAnchor.position = -1;
            }
            return newAnchor;
        }

        protected boolean userNodeWasAfterTag(Node userNode, GeneratedTag newTag, GeneratedTag oldContainer) {
            GeneratedTag oldTag = oldContainer.getGeneratedInfo().getTag(newTag.getName());
            if (oldTag != null) {
                if (!oldContainer.isAncestorOf(oldTag)) {
                    return false;
                }
                return userNode.getTail().compareTo(this.mgr.newExtremity(oldTag, 0, true)) > 0;
            }
            Iterator newSubTags = newTag.sons().iterator();
            while (newSubTags.hasNext()) {
                if (!this.userNodeWasAfterTag(userNode, (GeneratedTag)newSubTags.next(), oldContainer)) continue;
                return true;
            }
            return false;
        }

        protected Anchor findNewPositionInsideUpDown(Node userNode, GeneratedTag oldContainer, GeneratedTag newContainer) {
            Anchor newAnchor = new Anchor(newContainer, 1);
            Iterator newSubTags = newContainer.sons().iterator();
            while (newSubTags.hasNext()) {
                GeneratedTag newSubTag;
                newAnchor.tag = newSubTag = (GeneratedTag)newSubTags.next();
                if (!this.userNodeWasBeforeTag(userNode, newSubTag, oldContainer)) continue;
                if (newSubTag.areBlanksBeforeShared()) {
                    newAnchor.tag = newSubTag.previousTag();
                } else {
                    newAnchor.position = -1;
                }
                return newAnchor;
            }
            return newAnchor;
        }

        protected boolean userNodeWasBeforeTag(Node userNode, GeneratedTag newTag, GeneratedTag oldContainer) {
            GeneratedTag oldTag = oldContainer.getGeneratedInfo().getTag(newTag.getName());
            if (oldTag != null) {
                if (!oldContainer.isAncestorOf(oldTag)) {
                    return false;
                }
                return userNode.getHead().compareTo(this.mgr.newExtremity(oldTag, 0, false)) < 0;
            }
            Iterator newSubTags = newTag.sons().iterator();
            while (newSubTags.hasNext()) {
                if (!this.userNodeWasBeforeTag(userNode, (GeneratedTag)newSubTags.next(), oldContainer)) continue;
                return true;
            }
            return false;
        }

        protected Anchor chooseNewPosition(Node userNode, ListSortedSet newAnchors) {
            int points;
            ArrayList newAnchorsByPreferedOrder = new ArrayList();
            if (userNode.isPureIndent() || userNode.isReindent()) {
                newAnchorsByPreferedOrder.addAll(newAnchors);
            } else {
                this.sortAnchorsByPreferedOrder(userNode, newAnchors, newAnchorsByPreferedOrder);
            }
            Anchor chosenAnchor = (Anchor)newAnchorsByPreferedOrder.get(0);
            ReconcileExtension extension = this.mgr.getReconcileExtension();
            if (extension != null && ((points = extension.getInvocationCondition()) == 0 || (points ^ 4) != 0 && this.containsWarning(newAnchorsByPreferedOrder) || (points ^ 1) != 0 && this.containsMovedWarning(newAnchorsByPreferedOrder) || (points ^ 2) != 0 && newAnchorsByPreferedOrder.size() > 1)) {
                chosenAnchor = (Anchor)extension.findNewAnchor(this.newAnchorProposal(userNode, newAnchorsByPreferedOrder));
            }
            return chosenAnchor;
        }

        protected boolean containsWarning(List anchorsList) {
            for (Anchor anchor : anchorsList) {
                if (anchor.warnings == null || anchor.warnings.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected boolean containsMovedWarning(List anchorsList) {
            for (Anchor anchor : anchorsList) {
                if (anchor.warnings == null || anchor.warnings.isEmpty()) continue;
                for (String warning : anchor.warnings) {
                    if (!warning.equals("User code has been moved")) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean sortAnchorsByPreferedOrder(Node userNode, ListSortedSet newAnchors, List anchorsByPreferedOrder) {
            if (newAnchors.isEmpty()) {
                return false;
            }
            boolean reordered = false;
            Iterator anchorsIter = newAnchors.iterator();
            Anchor anchor = (Anchor)anchorsIter.next();
            anchorsByPreferedOrder.add(anchor);
            int insertIdx = 1;
            Anchor realChangeAfter = this.findNewRealChangeAnchorAfter(anchor);
            while (realChangeAfter != null) {
                anchor.addWarning("User code has been re-ordered");
                reordered = true;
                if (!anchorsIter.hasNext()) break;
                anchor = (Anchor)anchorsIter.next();
                if (anchor.compareTo(realChangeAfter) >= 0) {
                    anchorsByPreferedOrder.add(0, anchor);
                    insertIdx = 1;
                    realChangeAfter = this.findNewRealChangeAnchorAfter(anchor);
                    continue;
                }
                anchorsByPreferedOrder.add(insertIdx++, anchor);
            }
            while (anchorsIter.hasNext()) {
                anchorsByPreferedOrder.add(insertIdx++, anchorsIter.next());
            }
            return reordered;
        }

        protected AnchorProposal newAnchorProposal(TextNode userNode, List proposedAnchors) {
            return new AnchorChooserProposal(this, userNode, proposedAnchors);
        }

        protected Anchor findNewRealChangeAnchorAfter(Anchor anchor) {
            TmpExtremity extrem = (TmpExtremity)this.mgr.newExtremity(anchor.tag, anchor.position, false);
            TwoWayIterator extremitiesAfter = this.newUserExtremities.iteratorFrom((Object)extrem, false);
            while (extremitiesAfter.hasNext()) {
                Node node;
                TextSegmentExtremity e = (TextSegmentExtremity)extremitiesAfter.next();
                if (!e.isStart() || !this.isRealChange(node = (Node)e.getNode())) continue;
                return new Anchor(node.tag, node.position);
            }
            return null;
        }

        protected int countRealUserChangesAfter(Anchor anchor) {
            int count = 0;
            TmpExtremity extrem = (TmpExtremity)this.mgr.newExtremity(anchor.tag, anchor.position, false);
            TwoWayIterator extremitiesAfter = this.newUserExtremities.iteratorFrom((Object)extrem, false);
            while (extremitiesAfter.hasNext()) {
                TextSegmentExtremity e = (TextSegmentExtremity)extremitiesAfter.next();
                if (!e.isStart() || !this.isRealChange((Node)e.getNode())) continue;
                ++count;
            }
            return count;
        }

        protected boolean isRealChange(Node newUserNode) {
            for (Node oldNode : newUserNode.oldNodes) {
                if (oldNode.isPureIndent() || oldNode.isReindent()) continue;
                return true;
            }
            return false;
        }

        protected void addNodeToNewPosition(Anchor anchor, CharSequence text) {
            if (anchor.position == -1 && anchor.tag.areBlanksBeforeShared()) {
                anchor.tag = anchor.tag.previousTag();
                anchor.position = 1;
            }
            Node anchorNode = this.getNewNodeAtPosition(anchor.tag, 0, false);
            Node userNode = this.mgr.newNode(anchorNode.parent, anchor.tag, anchor.position);
            userNode.text = text;
            this.moveNodeToNewPosition(userNode, anchor);
        }

        protected void moveNodeToNewPosition(Node userNode, Anchor newAnchor) {
            Node newNode;
            GeneratedTag newTag = newAnchor.tag;
            int newPosition = newAnchor.position;
            if (newPosition == -1 && newTag.areBlanksBeforeShared()) {
                throw new RuntimeException("Forbidden position");
            }
            if (userNode.isReindent() && newAnchor.warnings != null) {
                return;
            }
            Node anchorNode = this.getNewNodeAtPosition(newTag, 0, false);
            if (anchorNode.hasUserChangeAncestor()) {
                Node userChangeAncestor = anchorNode.parent;
                while (!userChangeAncestor.isUserChange()) {
                    userChangeAncestor = userChangeAncestor.parent;
                }
                newAnchor.tag = userChangeAncestor.tag;
                newAnchor.position = 1;
                this.moveNodeToNewPosition(userNode, newAnchor);
                return;
            }
            Node node = newNode = newPosition == 0 ? anchorNode : this.getNewNodeAtPosition(newTag, newPosition, true);
            if (newNode == null) {
                newNode = this.mgr.newNode(anchorNode.parent, newTag, newPosition);
                this.newExtremities.add((Object)newNode.getHead());
                this.newExtremities.add((Object)newNode.getTail());
            } else if (newNode.includeUserChange()) {
                Anchor destination = newTag.areBlanksBeforeShared() ? new Anchor(newTag.previousTag(), 1) : new Anchor(newTag, -1);
                this.moveIncludedUserNodes(newNode, destination);
            }
            if (userNode.isPureIndent()) {
                newAnchor.warnings = null;
            }
            if (newNode.oldNodes == null) {
                this.newUserExtremities.add((Object)newNode.getHead());
                this.newUserExtremities.add((Object)newNode.getTail());
                this.mgr.incrementAncestorsMixedContentCount(newNode);
                newNode.oldNodes = new ArrayList();
            }
            newNode.oldNodes.add(userNode);
            if (newAnchor.warnings != null) {
                if (newNode.warnings == null) {
                    newNode.warnings = new ArrayList();
                }
                boolean isLostNode = false;
                for (String warning : newAnchor.warnings) {
                    newNode.warnings.add(warning);
                    if (!"User code has been lost".equals(warning)) continue;
                    isLostNode = true;
                }
                if (isLostNode) {
                    if (newNode.lostNodes == null) {
                        newNode.lostNodes = new ArrayList();
                    }
                    newNode.lostNodes.add(userNode);
                }
            }
            newNode.text = "Temporary";
        }

        protected void moveIncludedUserNodes(Node userNode, Anchor newAnchor) {
            ListSortedSet includedUserExtremities = this.newUserExtremities.subSet(this.mgr.newIncludedExtremitiesComparator(userNode));
            ArrayList realNodes = new ArrayList(includedUserExtremities.size());
            for (TextSegmentExtremity e : includedUserExtremities) {
                if (e.isStop()) continue;
                this.copyRealNodeInto((Node)e.getNode(), realNodes);
            }
            this.removeUserNodes(includedUserExtremities);
            newAnchor.addWarning("User code has been moved");
            for (TextSegmentExtremity e : realNodes) {
                if (e.isStop()) continue;
                this.moveNodeToNewPosition((Node)e.getNode(), newAnchor);
            }
        }

        protected void copyRealNodeInto(Node node, List realNodes) {
            if (node.oldNodes == null) {
                realNodes.add(node);
                return;
            }
            Iterator oldNodes = node.oldNodes.iterator();
            while (oldNodes.hasNext()) {
                this.copyRealNodeInto((Node)oldNodes.next(), realNodes);
            }
        }

        protected int removeUserNodes(ListSortedSet subNodesToRemove) {
            for (TextSegmentExtremity extrem : subNodesToRemove) {
                Node node = (Node)extrem.getNode();
                if (extrem.isStart()) {
                    if (node.position == 0) {
                        node.text = null;
                        node.blankIndicator = 0;
                        node.oldNodes = null;
                        node.lostNodes = null;
                        node.warnings = null;
                        node.mixedContentCount = 0;
                    }
                    Node parent = node.parent;
                    while (parent != null) {
                        --parent.mixedContentCount;
                        parent = parent.parent;
                    }
                }
                if (node.position == 0) continue;
                this.newExtremities.remove((Object)extrem);
            }
            int nbRemoved = subNodesToRemove.size() / 2;
            subNodesToRemove.clear();
            return nbRemoved;
        }

        protected void printWarnings(Anchor anchor) {
            System.out.println("-------------------------------------");
            if (anchor.warnings == null) {
                return;
            }
            System.out.print(anchor.position == 0 ? "-" : (anchor.position < 0 ? "<" : ">"));
            System.out.println(anchor.tag.getName());
            Iterator iter = anchor.warnings.iterator();
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
        }

        protected Node getNewNodeAtPosition(GeneratedTag tag, int position, boolean userCodeOnly) {
            TextSegmentExtremity tmp = this.mgr.newExtremity(tag, position, true);
            return (Node)(userCodeOnly || position != 0 ? this.newUserExtremities : this.newExtremities).get((Object)tmp);
        }

        protected void computeTexts() {
            for (TextSegmentExtremity e : this.newUserExtremities) {
                if (e.isStop()) continue;
                Node newUserNode = (Node)e.getNode();
                if (newUserNode.oldNodes == null) continue;
                newUserNode.text = newUserNode.getReconciledText(this.newGeneratedText(newUserNode));
                if (!newUserNode.hasReconcilationWarnings()) {
                    newUserNode.lostNodes = null;
                    newUserNode.oldNodes = null;
                    continue;
                }
                this.cleanDuplicateReconciliationWarnings(newUserNode);
            }
        }

        protected CharSequence newGeneratedText(Node newUserNode) {
            int beginIdx = newUserNode.getHead().generatedIndex();
            int endIdx = newUserNode.getTail().generatedIndex();
            return this.newGenerated.getText().subSequence(beginIdx, endIdx);
        }

        protected void cleanDuplicateReconciliationWarnings(Node node) {
            if (!node.hasReconcilationWarnings()) {
                return;
            }
            HashSet<String> warnings = new HashSet<String>();
            Iterator iter = node.warnings.iterator();
            while (iter.hasNext()) {
                if (warnings.add((String)iter.next())) continue;
                iter.remove();
            }
        }

        protected CharSequence catenateTexts(List nodes) {
            if (nodes.isEmpty()) {
                return null;
            }
            if (nodes.size() == 1) {
                return ((Node)nodes.get((int)0)).text;
            }
            StringBuffer fullText = new StringBuffer();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                fullText.append(((Node)iter.next()).text);
            }
            return fullText;
        }
    }

    protected static class ReverseCollatedSegmentIter
    extends CollatedSegmentIter {
        public ReverseCollatedSegmentIter(TextSegmentExtremity firstExtrem, ListSortedSet extremities, TextSegmentExtremity lastExtrem, boolean skipEmptySegments) {
            this.first = lastExtrem;
            this.last = firstExtrem;
            this.extrems = extremities.reverseIterator();
            this.skipEmpty = skipEmptySegments;
            this.initialize();
        }

        @Override
        protected Segment newSegment(TextSegmentExtremity head, TextSegmentExtremity tail, boolean userCode, boolean atomic) {
            return super.newSegment(tail, head, userCode, atomic);
        }

        @Override
        protected boolean isUserCode(TextSegmentExtremity head, TextSegmentExtremity tail) {
            return super.isUserCode(tail, head);
        }

        @Override
        protected boolean isSegmentToSkip(TextSegmentExtremity head, TextSegmentExtremity tail) {
            return super.isSegmentToSkip(tail, head);
        }
    }

    protected static class ReverseSegmentIter
    extends SegmentIter {
        public ReverseSegmentIter(TextSegmentExtremity firstExtrem, ListSortedSet extremities, TextSegmentExtremity lastExtrem, boolean skipEmptySegments) {
            this.first = lastExtrem;
            this.last = firstExtrem;
            this.extrems = extremities.reverseIterator();
            this.skipEmpty = skipEmptySegments;
            this.initialize();
        }

        @Override
        protected Segment newSegment(TextSegmentExtremity head, TextSegmentExtremity tail, boolean userCode, boolean atomic) {
            return super.newSegment(tail, head, userCode, atomic);
        }

        @Override
        protected boolean isUserCode(TextSegmentExtremity head, TextSegmentExtremity tail) {
            return super.isUserCode(tail, head);
        }

        @Override
        protected boolean isSegmentToSkip(TextSegmentExtremity head, TextSegmentExtremity tail) {
            return super.isSegmentToSkip(tail, head);
        }
    }

    public static class RootNode
    extends Node {
        protected UserChangesMgr mgr;

        public RootNode(UserChangesMgr manager, GeneratedTag anchor, int hook) {
            super(null, anchor, hook);
            this.mgr = manager;
        }

        @Override
        public RootNode getRootNode() {
            return this;
        }

        @Override
        public UserChangesMgr getManager() {
            return this.mgr;
        }
    }

    protected static class Segment
    implements TextSegment,
    ITextSegment {
        protected TextSegmentExtremity head;
        protected TextSegmentExtremity tail;
        protected TextNode includingNode;
        protected boolean generatedCode;
        protected boolean userCode;
        protected boolean atomic;

        public Segment() {
        }

        public Segment(TextSegmentExtremity startExtremity, TextSegmentExtremity stopExtremity, TextNode ownerNode, boolean fullGeneratedCode, boolean fullUserCode, boolean atomicSegment) {
            this.head = startExtremity;
            this.tail = stopExtremity;
            this.includingNode = ownerNode;
            this.generatedCode = fullGeneratedCode;
            this.userCode = fullUserCode;
            this.atomic = atomicSegment;
        }

        @Override
        public TextSegmentExtremity getHead() {
            return this.head;
        }

        @Override
        public TextSegmentExtremity getTail() {
            return this.tail;
        }

        @Override
        public int length() {
            return this.tail.index() - this.head.index();
        }

        @Override
        public Iterator subSegments(boolean collate, boolean skipEmpty, boolean reverseOrder) {
            return this.getManager().segments(this.getHead(), this.getTail(), collate, skipEmpty, reverseOrder);
        }

        @Override
        public int startIndex() {
            return this.head.index();
        }

        @Override
        public int stopIndex() {
            return this.tail.index();
        }

        @Override
        public TextNode getIncludingNode() {
            return this.includingNode;
        }

        @Override
        public boolean isAtomic() {
            return this.atomic;
        }

        @Override
        public boolean isEmpty() {
            return this.head.index() == this.tail.index();
        }

        @Override
        public boolean isGeneratedCode() {
            return this.generatedCode;
        }

        @Override
        public boolean isUserCode() {
            return this.userCode;
        }

        @Override
        public boolean isPureIndent() {
            return this.head.isStart() && this.tail.isStop() && this.head.getNode() == this.tail.getNode() && this.head.getNode().isPureIndent();
        }

        @Override
        public CharSequence text() {
            return this.getManager().text().subSequence(this.head.index(), this.tail.index());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            TextSegment segment = (TextSegment)other;
            return segment.getHead() == this.head && segment.getTail() == this.tail;
        }

        public int hashCode() {
            return this.head.hashCode() ^ this.tail.hashCode();
        }

        protected UserChangesMgr getManager() {
            return ((Node)this.getHead().getNode()).getManager();
        }

        public String toString() {
            return this.fullText().subSequence(this.beginIndex(), this.endIndex()).toString();
        }

        public CharSequence generatedText() {
            int start = this.head.generatedIndex();
            int stop = this.tail.generatedIndex();
            return this.getManager().getGeneratedInfo().getText().subSequence(start, stop);
        }

        public boolean isEditable() {
            TextNode node = this.getIncludingNode();
            if (node == null) {
                return true;
            }
            int position = node.getPosition();
            return position == 0 ? node.getTag().getChangeControl() != 0 : node.getParent() != null && node.getParent().getTag().getChangeControl() != 0;
        }

        public boolean isFromMacro() {
            return this.generatedCode && this.includingNode.getTag().getProperty("msp") != null;
        }

        public boolean isGenerated() {
            boolean result;
            boolean bl = result = this.isGeneratedCode() || this.isUserCode() && this.isPureIndent();
            if (!result) {
                return this.isReformated();
            }
            return result;
        }

        public boolean isInserted() {
            return this.isModified() && this.getIncludingNode().isInsertion();
        }

        public boolean isModified() {
            return !this.isGenerated();
        }

        public boolean isReformated() {
            TextNode node = this.getIncludingNode();
            return node.isOverride() && node.isReindent();
        }

        public boolean isRemoved() {
            return this.isModified() && this.isEmpty();
        }

        public int beginIndex() {
            return this.startIndex();
        }

        public int endIndex() {
            return this.stopIndex();
        }

        public CharSequence fullText() {
            return this.getManager().text();
        }

        public char charAt(int index) {
            return this.fullText().charAt(this.beginIndex() + index);
        }

        public CharSequence subSequence(int start, int end) {
            return this.fullText().subSequence(this.beginIndex() + start, this.beginIndex() + end);
        }
    }

    protected static class SegmentIter
    implements Iterator {
        protected TextSegmentExtremity first;
        protected TextSegmentExtremity last;
        protected Iterator extrems;
        protected boolean skipEmpty;
        protected TextSegmentExtremity head;
        protected TextSegmentExtremity tail;
        protected Segment nextSegment;

        public SegmentIter() {
        }

        public SegmentIter(TextSegmentExtremity firstExtrem, ListSortedSet extremities, TextSegmentExtremity lastExtrem, boolean skipEmptySegments) {
            this.first = firstExtrem;
            this.last = lastExtrem;
            this.extrems = extremities.iterator();
            this.skipEmpty = skipEmptySegments;
            this.initialize();
        }

        protected void initialize() {
            TextSegmentExtremity textSegmentExtremity = this.first != null ? this.first : (this.tail = this.extrems.hasNext() ? (TextSegmentExtremity)this.extrems.next() : this.last);
            if (this.tail != null) {
                this.findNextSegment();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextSegment == null) {
                this.makeNextSegment();
            }
            return this.nextSegment != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("SegmentIter.next");
            }
            Segment segmentToReturn = this.nextSegment;
            this.nextSegment = null;
            return segmentToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SegmentIter.remove");
        }

        protected void makeNextSegment() {
            if (this.tail == null) {
                return;
            }
            this.nextSegment = this.newSegment(this.head, this.tail, this.isUserCode(this.head, this.tail), true);
            this.findNextSegment();
        }

        protected boolean findNextSegment() {
            do {
                if (this.tail == this.last) {
                    this.tail = null;
                    this.head = null;
                    return false;
                }
                this.head = this.tail;
                TextSegmentExtremity textSegmentExtremity = this.tail = this.extrems.hasNext() ? (TextSegmentExtremity)this.extrems.next() : this.last;
                if (this.tail != null) continue;
                this.head = null;
                return false;
            } while (this.isSegmentToSkip(this.head, this.tail));
            return true;
        }

        protected Segment newSegment(TextSegmentExtremity head, TextSegmentExtremity tail, boolean userCode, boolean atomic) {
            TextNode ownerNode = head.getNode().commonAncestorWith(tail.getNode());
            return new Segment(head, tail, ownerNode, !userCode, userCode, atomic);
        }

        protected boolean isUserCode(TextSegmentExtremity head, TextSegmentExtremity tail) {
            TextNode headNode = head.getNode();
            TextNode tailNode = tail.getNode();
            return head.isStart() && headNode.isUserChange() && !headNode.isReindent() || tail.isStop() && tailNode.isUserChange() && !tailNode.isReindent();
        }

        protected boolean isSegmentToSkip(TextSegmentExtremity head, TextSegmentExtremity tail) {
            if (this.skipEmpty && head.index() == tail.index()) {
                return true;
            }
            if (head.isStart() || tail.isStop()) {
                return false;
            }
            TextNode headNode = head.getNode();
            TextNode tailNode = tail.getNode();
            return headNode.getTag() == tailNode.getTag() && tailNode.getPosition() - headNode.getPosition() == 1;
        }
    }

    protected static class Simplifier
    implements Serializable {
        protected UserChangesMgr mgr;
        protected Comparator tagMatchingComparator;
        protected Comparator multiTagMatchingComparator;
        protected MatchingsStore multiMatchingsStore;
        protected MatchingsStore allMatchingsStore;
        protected long stepCount;
        protected static final TagMatching[] nullMatchingArray = new TagMatching[0];
        protected static final MultiTagMatching nullMultiMatching = new MultiTagMatching();
        protected int[] maxTotalValues;
        protected transient MatchingExtension extension;
        public final int BROWSE_MATCH_TYPE = 1;

        public Simplifier() {
        }

        public Simplifier(UserChangesMgr userChangesMgr) {
            this.mgr = userChangesMgr;
            this.multiMatchingsStore = new MatchingsStore();
            this.allMatchingsStore = new MatchingsStore();
            this.extension = userChangesMgr.getMatchingExtension();
        }

        public boolean simplify() {
            this.stepCount = 0L;
            boolean simplified1 = this.simplifyOverrides();
            boolean simplified2 = this.simplifyInsertions();
            boolean simplified3 = false;
            return simplified1 || simplified2 || simplified3;
        }

        public boolean simplifyOverrides() {
            boolean simplified = false;
            TextSegment firstNode = null;
            int index = -1;
            Iterator changes = this.mgr.userExtremities.iterator();
            while (changes.hasNext()) {
                TextSegmentExtremity change = (TextSegmentExtremity)changes.next();
                if (change.isStop()) continue;
                Node node = (Node)change.getNode();
                if (firstNode == null) {
                    if (!node.hasReconcilationWarnings()) {
                        firstNode = node;
                    }
                } else if (node.startIndex() != index || node.hasReconcilationWarnings()) {
                    ListSortedSet subsetToSimplify = (ListSortedSet)this.mgr.userExtremities.subSet((Object)firstNode.getHead(), (Object)node.getHead());
                    if (this.simplifyOverrides(subsetToSimplify)) {
                        changes = this.mgr.userExtremities.iteratorFrom((Object)node.getHead(), false);
                        simplified = true;
                    }
                    firstNode = node.hasReconcilationWarnings() ? null : node;
                }
                index = node.stopIndex();
            }
            if (firstNode != null && this.simplifyOverrides((ListSortedSet)this.mgr.userExtremities.tailSet((Object)firstNode.getHead()))) {
                simplified = true;
            }
            return simplified;
        }

        protected boolean simplifyOverrides(ListSortedSet subSetToSimplify) {
            TextNode[] overridenNodes = this.findOverridenNodes(subSetToSimplify);
            if (overridenNodes.length == 0) {
                return false;
            }
            GeneratedTag[] overridenTags = this.tagsFromNodes(overridenNodes);
            int startIndex = ((TextSegmentExtremity)subSetToSimplify.first()).index();
            int stopIndex = ((TextSegmentExtremity)subSetToSimplify.last()).index();
            CharSequenceInterval userCode = new CharSequenceInterval(this.mgr.text(), startIndex, stopIndex);
            MultiTagMatching bestMatch = this.findBestMatch(overridenTags, userCode);
            if (bestMatch == null) {
                return false;
            }
            return this.applyMatching(subSetToSimplify, bestMatch, userCode);
        }

        protected TextNode[] findOverridenNodes(ListSortedSet subSetToSimplify) {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>(subSetToSimplify.size() / 2);
            for (TextSegmentExtremity e : subSetToSimplify) {
                if (!e.isStart() || !e.getNode().isOverride()) continue;
                nodes.add(e.getNode());
            }
            TextNode[] result = new TextNode[nodes.size()];
            nodes.toArray(result);
            return result;
        }

        protected GeneratedTag[] tagsFromNodes(TextNode[] nodes) {
            int count = nodes.length;
            GeneratedTag[] tags = new GeneratedTag[count];
            while (--count >= 0) {
                tags[count] = nodes[count].getTag();
            }
            return tags;
        }

        protected TagMatching[][] findAllMatchings(GeneratedTag[] tags, CharSequenceInterval userCode) {
            int nbOfTags = tags.length;
            TagMatching[][] matchings = new TagMatching[nbOfTags][];
            boolean foundMatching = false;
            int i = 0;
            while (i < nbOfTags) {
                TagMatching[] foundMatchings = this.findAllMatchings(tags[i], userCode);
                if (foundMatchings != null) {
                    matchings[i] = foundMatchings;
                    foundMatching = true;
                }
                ++i;
            }
            return foundMatching ? matchings : null;
        }

        protected MultiTagMatching findBestMatch(GeneratedTag[] tags, CharSequenceInterval userCode) {
            ++findBestMatchCount;
            switch (findBestMatchVersion) {
                case 0: {
                    return this.findBestMatch0(tags, userCode);
                }
                case 1: {
                    return this.findBestMatch1(tags, userCode);
                }
                case 2: {
                    MultiTagMatching bestMatch0 = this.findBestMatch0(tags, userCode);
                    MultiTagMatching bestMatch1 = this.findBestMatch1(tags, userCode);
                    if (!this.sameMultiMatchings(bestMatch0, bestMatch1)) {
                        throw new RuntimeException("Wrong multi matchings");
                    }
                    return bestMatch1;
                }
            }
            return null;
        }

        protected boolean sameMultiMatchings(MultiTagMatching left, MultiTagMatching right) {
            if (left == null || right == null) {
                return left == right;
            }
            if (left.start != right.start || left.stop != right.stop || left.matchingLength != right.matchingLength) {
                return false;
            }
            int count = left.matchings.length;
            while (--count >= 0) {
                if (this.sameMatchings(left.matchings[count], right.matchings[count])) continue;
                return false;
            }
            return true;
        }

        protected MultiTagMatching findBestMatch1(GeneratedTag[] tags, CharSequenceInterval userCode) {
            String code = userCode.toString();
            MultiTagMatching best = this.multiMatchingsStore.getBestMatch(code, tags);
            if (best != null) {
                ++reuseBestMatchCount;
                return best != nullMultiMatching ? best : null;
            }
            long savedStepCount = this.stepCount;
            TagMatching[][] matchings = this.findAllMatchings(tags, userCode);
            if (matchings == null) {
                long weight = this.stepCount - savedStepCount;
                if (weight > (long)minStoredWeight) {
                    this.multiMatchingsStore.addBestMatch(code, tags, null);
                }
                return null;
            }
            best = this.chooseBestMatch(tags, matchings);
            long weight = this.stepCount - savedStepCount;
            if (weight > (long)minStoredWeight) {
                this.multiMatchingsStore.addBestMatch(code, tags, best);
            }
            return best;
        }

        protected MultiTagMatching findBestMatch0(GeneratedTag[] tags, CharSequenceInterval userCode) {
            TagMatching[][] matchings = this.findAllMatchings(tags, userCode);
            if (matchings == null) {
                return null;
            }
            return this.chooseBestMatch(tags, matchings);
        }

        protected int bestTotalMatchingLength(TagMatching[][] matchingsArray, int[] maxPossibleGain) {
            int nbElements = matchingsArray.length;
            int totalMatchingLength = 0;
            int m = nbElements - 1;
            while (m >= 0) {
                TagMatching[] matchings = matchingsArray[m];
                if (matchings != null) {
                    maxPossibleGain[m] = matchings[matchings.length - 1].matchingLength;
                    totalMatchingLength += maxPossibleGain[m];
                } else {
                    maxPossibleGain[m] = 0;
                }
                --m;
            }
            int total = totalMatchingLength;
            int i = 0;
            while (i < nbElements) {
                maxPossibleGain[i] = total -= maxPossibleGain[i];
                ++i;
            }
            return totalMatchingLength;
        }

        protected boolean bestMatchingsLimit(TagMatching[][] matchingsArray, int[] limits) {
            boolean all1 = true;
            int m = limits.length - 1;
            while (m >= 0) {
                TagMatching[] matchings = matchingsArray[m];
                if (matchings == null) {
                    limits[m] = -1;
                } else {
                    int idx = matchings.length - 1;
                    limits[m] = ~this.lowIndexOf(matchings[idx].matchingLength, 0, idx, matchings) - 1;
                    if (limits[m] != -1) {
                        all1 = false;
                    }
                }
                --m;
            }
            return all1;
        }

        protected boolean nextMatchingsLimit(TagMatching[][] matchingsArray, int[] limits) {
            boolean all1 = true;
            int m = limits.length - 1;
            while (m >= 0) {
                int idx;
                TagMatching[] matchings = matchingsArray[m];
                if (limits[m] != -1 && (limits[m] = ~this.lowIndexOf(matchings[idx].matchingLength, 0, idx = limits[m], matchings) - 1) != -1) {
                    all1 = false;
                }
                --m;
            }
            return all1;
        }

        protected int lowIndexOf(int matchingLength, int low, int high, TagMatching[] matchings) {
            while (low <= high) {
                int middle = low + high >> 1;
                if (matchings[middle].matchingLength == matchingLength) {
                    high = middle - 1;
                    continue;
                }
                low = middle + 1;
            }
            return ~low;
        }

        protected void showLevels(MultiTagMatching best, TagMatching[][] matchings) {
            System.out.print("Levels= ");
            int i = 0;
            while (i < best.length) {
                System.out.print(this.levelOf(best.matchings[i], matchings[i]));
                System.out.print(' ');
                ++i;
            }
            System.out.println();
        }

        protected int levelOf(TagMatching matching, TagMatching[] matchings) {
            if (matching == null) {
                return 0;
            }
            int matchingLength = Integer.MAX_VALUE;
            int level = 0;
            int i = matchings.length - 1;
            while (i >= 0) {
                if (matchings[i].matchingLength < matchingLength) {
                    ++level;
                    matchingLength = matchings[i].matchingLength;
                }
                if (matchings[i] == matching) {
                    return level;
                }
                --i;
            }
            return level;
        }

        protected TagMatching[][] selectMatchings(TagMatching[][] matchings) {
            long nbOfCombinations = this.countCombinations(matchings);
            return matchings;
        }

        protected long countCombinations(TagMatching[][] matchings) {
            long nbOfCombination = 1L;
            int i = 0;
            while (i < matchings.length) {
                if (matchings[i] != null) {
                    int n = 1 + matchings[i].length;
                    if (nbOfCombination > Long.MAX_VALUE / (long)n) {
                        return Long.MAX_VALUE;
                    }
                    nbOfCombination *= (long)n;
                }
                ++i;
            }
            return nbOfCombination;
        }

        protected MultiTagMatching chooseBestMatch(GeneratedTag[] tags, TagMatching[][] matchings) {
            int nbOfTags = tags.length;
            MultiTagMatching current = new MultiTagMatching(nbOfTags);
            MultiTagMatching best = new MultiTagMatching(nbOfTags);
            best.matchingLength = -1;
            int[] limits = new int[nbOfTags];
            this.bestMatchingsLimit(matchings, limits);
            boolean b = this.browseBestMatchings0(0, matchings, limits, current, best);
            if (!b) {
                int[] maxPossibleGain = new int[nbOfTags];
                this.bestTotalMatchingLength(matchings, maxPossibleGain);
                current = new MultiTagMatching(nbOfTags);
                this.browseMatchings(0, matchings, current, best, maxPossibleGain, nbOfTags, 1);
            }
            return best;
        }

        protected void browseMatchings(int level, TagMatching[][] matchingsArray, MultiTagMatching current, MultiTagMatching best, int[] maxPossibleGain, int size, int test) {
            MultiTagMatchingComparator comp;
            MultiTagMatching best1;
            MultiTagMatching current1;
            if (test == 0) {
                this.browseMatchings0(level, matchingsArray, current, best, maxPossibleGain);
                return;
            }
            if (test == 1) {
                this.browseMatchings1(level, matchingsArray, current, best, maxPossibleGain);
                return;
            }
            if (test == 2) {
                this.browseMatchings2(level, matchingsArray, current, best, maxPossibleGain, null);
                return;
            }
            if (test == 3) {
                int[] bestGain = new int[size];
                this.browseMatchings3(level, matchingsArray, current, best, maxPossibleGain, bestGain);
                return;
            }
            if (test == 10) {
                MultiTagMatching current0 = new MultiTagMatching(size);
                MultiTagMatching best0 = new MultiTagMatching(size);
                current1 = new MultiTagMatching(size);
                best1 = new MultiTagMatching(size);
                this.browseMatchings0(level, matchingsArray, current0, best0, maxPossibleGain);
                this.browseMatchings1(level, matchingsArray, current1, best1, maxPossibleGain);
                comp = new MultiTagMatchingComparator();
                if (comp.compare(best0, best1) == 0) {
                    best.copyFrom(best0);
                } else {
                    throw new RuntimeException("browsematchings(....) give two differents results");
                }
            }
            if (test == 12) {
                MultiTagMatching current2 = new MultiTagMatching(size);
                MultiTagMatching best2 = new MultiTagMatching(size);
                current1 = new MultiTagMatching(size);
                best1 = new MultiTagMatching(size);
                this.browseMatchings1(level, matchingsArray, current1, best1, maxPossibleGain);
                this.browseMatchings2(level, matchingsArray, current2, best2, maxPossibleGain, null);
                comp = new MultiTagMatchingComparator();
                if (comp.compare(best2, best1) == 0) {
                    best.copyFrom(best1);
                } else {
                    throw new RuntimeException("browsematchings(....) give two differents results");
                }
            }
            if (test == 13) {
                int[] bestGain = new int[size];
                MultiTagMatching current3 = new MultiTagMatching(size);
                MultiTagMatching best3 = new MultiTagMatching(size);
                MultiTagMatching current12 = new MultiTagMatching(size);
                MultiTagMatching best12 = new MultiTagMatching(size);
                this.browseMatchings1(level, matchingsArray, current12, best12, maxPossibleGain);
                this.browseMatchings3(level, matchingsArray, current3, best3, maxPossibleGain, bestGain);
                MultiTagMatchingComparator comp2 = new MultiTagMatchingComparator();
                if (comp2.compare(best3, best12) == 0) {
                    best.copyFrom(best12);
                } else {
                    throw new RuntimeException("browsematchings(....) give two differents results");
                }
            }
        }

        protected void browseMatchings0(int level, TagMatching[][] matchingsArray, MultiTagMatching current, MultiTagMatching best, int[] maxPossibleGain) {
            if (level == matchingsArray.length) {
                int cmp = this.compareMatchings(best, current);
                if (cmp < 0) {
                    best.copyFrom(current);
                }
                return;
            }
            TagMatching[] matchings = matchingsArray[level];
            if (matchings != null) {
                int nbOfMatchings = matchings.length;
                int m = nbOfMatchings - 1;
                while (m >= 0) {
                    TagMatching matching = matchings[m];
                    if (current.matchingLength + (matching != null ? matching.matchingLength : 0) + maxPossibleGain[level] < best.matchingLength) {
                        return;
                    }
                    if (current.addMatching(matching)) {
                        this.browseMatchings0(level + 1, matchingsArray, current, best, maxPossibleGain);
                        current.removeLastMatching();
                    }
                    ++this.stepCount;
                    --m;
                }
            }
            if (current.matchingLength + maxPossibleGain[level] < best.matchingLength) {
                return;
            }
            current.addMatching(null);
            this.browseMatchings0(level + 1, matchingsArray, current, best, maxPossibleGain);
            current.removeLastMatching();
            ++this.stepCount;
        }

        protected void browseMatchings1(int level, TagMatching[][] matchingsArray, MultiTagMatching current, MultiTagMatching best, int[] maxPossibleGain) {
            if (level == matchingsArray.length) {
                int cmp = this.compareMatchings(best, current);
                if (cmp < 0) {
                    best.copyFrom(current);
                }
                return;
            }
            TagMatching[] matchings = matchingsArray[level];
            if (matchings != null) {
                int nbOfMatchings = matchings.length;
                boolean firstMatchingAdded = false;
                int lastMatchingAddedSize = 0;
                int lastMatchingAddedStop = Integer.MAX_VALUE;
                int m = nbOfMatchings - 1;
                while (m >= 0) {
                    TagMatching matching = matchings[m];
                    if (current.matchingLength + (matching != null ? matching.matchingLength : 0) + maxPossibleGain[level] < best.matchingLength) {
                        return;
                    }
                    if (!(firstMatchingAdded && (current.matchingLength != 0 && matching.matchingLength == lastMatchingAddedSize || current.matchingLength != 0 && matching.stop >= lastMatchingAddedStop))) {
                        if (current.addMatching(matching)) {
                            firstMatchingAdded = true;
                            lastMatchingAddedSize = matching.matchingLength;
                            lastMatchingAddedStop = matching.stop;
                            this.browseMatchings1(level + 1, matchingsArray, current, best, maxPossibleGain);
                            current.removeLastMatching();
                        }
                        ++this.stepCount;
                    }
                    --m;
                }
            }
            if (current.matchingLength + maxPossibleGain[level] < best.matchingLength) {
                return;
            }
            current.addMatching(null);
            this.browseMatchings1(level + 1, matchingsArray, current, best, maxPossibleGain);
            current.removeLastMatching();
            ++this.stepCount;
        }

        protected int[] browseMatchings2(int level, TagMatching[][] matchingsArray, MultiTagMatching current, MultiTagMatching best, int[] maxPossibleGain, int[] sameLevelResults) {
            if (level == matchingsArray.length) {
                int cmp = this.compareMatchings(best, current);
                if (cmp < 0) {
                    best.copyFrom(current);
                }
                return null;
            }
            int[] results = sameLevelResults;
            int[] resultNextLevel = null;
            TagMatching[] matchings = matchingsArray[level];
            if (matchings != null) {
                int nbOfMatchings = matchings.length;
                boolean firstMatchingAdded = false;
                int lastMatchingAddedSize = 0;
                int lastMatchingAddedStop = Integer.MAX_VALUE;
                int m = nbOfMatchings - 1;
                while (m >= 0) {
                    TagMatching matching = matchings[m];
                    if (current.matchingLength + (matching != null ? matching.matchingLength : 0) + maxPossibleGain[level] < best.matchingLength) {
                        return results;
                    }
                    if (!(firstMatchingAdded && (current.matchingLength != 0 && matching.matchingLength == lastMatchingAddedSize || current.matchingLength != 0 && matching.stop >= lastMatchingAddedStop) || sameLevelResults != null && current.length > 1 && (matching.start >= sameLevelResults[0] || matching.stop >= sameLevelResults[1]))) {
                        if (current.addMatching(matching)) {
                            if (results == null) {
                                results = new int[]{matching.start, matching.stop};
                            }
                            if (sameLevelResults != null && results[0] > sameLevelResults[0] && results[1] > sameLevelResults[1]) {
                                results[0] = sameLevelResults[0];
                                results[1] = sameLevelResults[1];
                            }
                            firstMatchingAdded = true;
                            lastMatchingAddedSize = matching.matchingLength;
                            lastMatchingAddedStop = matching.stop;
                            resultNextLevel = this.browseMatchings2(level + 1, matchingsArray, current, best, maxPossibleGain, resultNextLevel);
                            current.removeLastMatching();
                        }
                        ++this.stepCount;
                    }
                    --m;
                }
            }
            if (current.matchingLength + maxPossibleGain[level] < best.matchingLength) {
                return results;
            }
            current.addMatching(null);
            this.browseMatchings2(level + 1, matchingsArray, current, best, maxPossibleGain, resultNextLevel);
            current.removeLastMatching();
            ++this.stepCount;
            return results;
        }

        protected void browseMatchings3(int level, TagMatching[][] matchingsArray, MultiTagMatching current, MultiTagMatching best, int[] maxPossibleGain, int[] bestGain) {
            block11: {
                if (level == matchingsArray.length) {
                    int cmp = this.compareMatchings(best, current);
                    if (cmp < 0) {
                        best.copyFrom(current);
                        TagMatching[] bestMatchs = best.matchings;
                        int total = 0;
                        int i = 0;
                        while (i < bestMatchs.length) {
                            if (bestMatchs[i] != null) {
                                total += bestMatchs[i].matchingLength;
                            }
                            bestGain[i] = total;
                            ++i;
                        }
                    }
                    return;
                }
                TagMatching[] matchings = matchingsArray[level];
                if (matchings == null) break block11;
                int nbOfMatchings = matchings.length;
                boolean firstMatchingAdded = false;
                int lastMatchingAddedSize = 0;
                int lastMatchingAddedStop = Integer.MAX_VALUE;
                int m = nbOfMatchings - 1;
                while (m >= 0) {
                    block12: {
                        TagMatching matching;
                        block13: {
                            int bestStop;
                            matching = matchings[m];
                            if (current.matchingLength + (matching != null ? matching.matchingLength : 0) + maxPossibleGain[level] < best.matchingLength) {
                                return;
                            }
                            if (firstMatchingAdded && (current.matchingLength != 0 && matching.matchingLength == lastMatchingAddedSize || current.matchingLength != 0 && matching.stop >= lastMatchingAddedStop)) break block12;
                            if (bestGain[bestGain.length - 1] == 0 || current.matchingLength + matching.matchingLength >= bestGain[level]) break block13;
                            TagMatching tagMatching = best.matchings[level];
                            int n = bestStop = tagMatching != null ? tagMatching.stop : best.getPreviousStop(level);
                            if (bestStop >= 0 && matching.stop > bestStop) break block12;
                        }
                        if (current.addMatching(matching)) {
                            firstMatchingAdded = true;
                            lastMatchingAddedSize = matching.matchingLength;
                            lastMatchingAddedStop = matching.stop;
                            this.browseMatchings3(level + 1, matchingsArray, current, best, maxPossibleGain, bestGain);
                            current.removeLastMatching();
                        }
                        ++this.stepCount;
                    }
                    --m;
                }
            }
            if (current.matchingLength + maxPossibleGain[level] < best.matchingLength) {
                return;
            }
            current.addMatching(null);
            this.browseMatchings3(level + 1, matchingsArray, current, best, maxPossibleGain, bestGain);
            current.removeLastMatching();
            ++this.stepCount;
        }

        protected boolean browseBestMatchings0(int level, TagMatching[][] matchings, int[] limits, MultiTagMatching current, MultiTagMatching best) {
            if (level == matchings.length) {
                best.copyFrom(current);
                return true;
            }
            TagMatching[] matching = matchings[level];
            if (matching == null) {
                current.addMatching(null);
                if (this.browseBestMatchings0(level + 1, matchings, limits, current, best)) {
                    return true;
                }
                current.removeLastMatching();
                ++this.stepCount;
                return false;
            }
            int max = matching.length - 1;
            int min = limits[level];
            int m = max;
            while (m > min) {
                if (current.addMatching(matching[m])) {
                    if (this.browseBestMatchings0(level + 1, matchings, limits, current, best)) {
                        return true;
                    }
                    current.removeLastMatching();
                }
                ++this.stepCount;
                --m;
            }
            return false;
        }

        protected boolean browseBestMatchings1(TagMatching[][] matchings, int[] limits, MultiTagMatching current, MultiTagMatching best) {
            int lastNoNullMatchingAddedIndex = -1;
            int i = 0;
            while (i < matchings.length) {
                TagMatching[] tagMatchings = matchings[i];
                if (tagMatchings == null) {
                    current.addMatching(null);
                    ++this.stepCount;
                } else {
                    boolean added = false;
                    int min = limits[i];
                    int j = tagMatchings.length - 1;
                    while (j > min) {
                        if (current.addMatching(tagMatchings[j])) {
                            lastNoNullMatchingAddedIndex = i;
                            added = true;
                            break;
                        }
                        ++this.stepCount;
                        --j;
                    }
                    if (!added) {
                        return false;
                    }
                }
                ++i;
            }
            best.copyFrom(current);
            if (lastNoNullMatchingAddedIndex == -1) {
                return true;
            }
            class StartPositionTagMatchingComparator
            implements Comparator<TagMatching> {
                StartPositionTagMatchingComparator() {
                }

                @Override
                public int compare(TagMatching t1, TagMatching t2) {
                    if (t2 == null) {
                        return 1;
                    }
                    if (t1 == null) {
                        return -1;
                    }
                    return this.compareMatchings(t1, t2);
                }

                protected int compareMatchings(TagMatching left, TagMatching right) {
                    int cmp = left.matchingLength - right.matchingLength;
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = left.start - right.start;
                    if (cmp != 0) {
                        return cmp;
                    }
                    return right.stop - right.start - (left.stop - left.start);
                }
            }
            StartPositionTagMatchingComparator comp1 = new StartPositionTagMatchingComparator();
            int indexToStart = lastNoNullMatchingAddedIndex - 1;
            boolean stopCompress = false;
            int i2 = 0;
            while (i2 < matchings.length) {
                TagMatching[] tagMatchings = matchings[i2];
                if (tagMatchings != null) {
                    int min = limits[i2];
                    int nbElementToSort = tagMatchings.length - 1 - min;
                    if (nbElementToSort == 1) {
                        indexToStart = i2 - 1;
                        stopCompress = true;
                        break;
                    }
                    Arrays.sort(tagMatchings, min + 1, tagMatchings.length, comp1);
                    if (current.matchings[i2] == tagMatchings[tagMatchings.length - 1]) {
                        indexToStart = i2 - 1;
                        stopCompress = true;
                        break;
                    }
                }
                ++i2;
            }
            MultiTagMatchingComparator comp = new MultiTagMatchingComparator();
            boolean first = true;
            int currentIndexForLastMatching = -1;
            do {
                if (!first && (currentIndexForLastMatching = this.shiftLastNoNullMatching(matchings, current, lastNoNullMatchingAddedIndex, currentIndexForLastMatching, limits, comp1)) == matchings[lastNoNullMatchingAddedIndex].length - 1) {
                    stopCompress = true;
                }
                boolean reevaluate = true;
                int i3 = indexToStart;
                while (i3 >= 0) {
                    TagMatching currentTagMatch;
                    TagMatching[] tagMatchings = matchings[i3];
                    if (tagMatchings != null && (currentTagMatch = current.matchings[i3]) != null) {
                        int min = limits[i3];
                        boolean replaced = false;
                        int j = tagMatchings.length - 1;
                        while (j > min) {
                            if (tagMatchings[j] == currentTagMatch) break;
                            if (current.replaceMatching(tagMatchings[j], i3)) {
                                replaced = true;
                                if (j != tagMatchings.length - 1) break;
                                stopCompress = true;
                                break;
                            }
                            --j;
                        }
                        if (!replaced && !first) {
                            reevaluate = false;
                            break;
                        }
                    }
                    --i3;
                }
                if (reevaluate && comp.compare(best, current) < 0) {
                    best.copyFrom(current);
                }
                first = false;
            } while (!stopCompress);
            return true;
        }

        private int shiftLastNoNullMatching(TagMatching[][] matchings, MultiTagMatching current, int lastNoNullMatchingAddedIndex, int nextIndexForLastMatching, int[] limits, Comparator<TagMatching> comp) {
            TagMatching lastTagMatching = current.matchings[lastNoNullMatchingAddedIndex];
            Object[] tagMatchings = matchings[lastNoNullMatchingAddedIndex];
            if (nextIndexForLastMatching == -1) {
                nextIndexForLastMatching = Simplifier.indexOf(lastTagMatching, limits[lastNoNullMatchingAddedIndex] + 1, tagMatchings.length - 1, tagMatchings, comp);
                if (nextIndexForLastMatching < 0) {
                    throw new RuntimeException("currentTagMatch not found");
                }
            } else {
                ++nextIndexForLastMatching;
            }
            current.replaceMatching(tagMatchings[nextIndexForLastMatching], lastNoNullMatchingAddedIndex);
            return nextIndexForLastMatching;
        }

        public static int indexOf(Object o, int low, int high, Object[] array, Comparator c) {
            while (low <= high) {
                int middle = low + high >> 1;
                int position = c.compare(o, array[middle]);
                if (position > 0) {
                    low = middle + 1;
                    continue;
                }
                if (position < 0) {
                    high = middle - 1;
                    continue;
                }
                return middle;
            }
            return ~low;
        }

        protected int compareMatchings(MultiTagMatching left, MultiTagMatching right) {
            return this.getMultiTagMatchingComparator().compare(left, right);
        }

        protected TagMatching[] findAllMatchings(GeneratedTag tag, CharSequenceInterval userCode) {
            ++findBestMatchCount;
            switch (findBestMatchVersion) {
                case 0: {
                    return this.findAllMatchings0(tag, userCode);
                }
                case 1: {
                    return this.findAllMatchings1(tag, userCode);
                }
                case 2: {
                    TagMatching[] matchings0 = this.findAllMatchings0(tag, userCode);
                    TagMatching[] matchings1 = this.findAllMatchings1(tag, userCode);
                    if (!this.sameMatchings(matchings0, matchings1)) {
                        throw new RuntimeException("Wrong matchings");
                    }
                    return matchings1;
                }
            }
            return null;
        }

        protected TagMatching[] findAllMatchings1(GeneratedTag tag, CharSequenceInterval userCode) {
            String code = userCode.toString();
            TagMatching[] allMatchings = this.allMatchingsStore.getAllMatchings(code, tag);
            if (allMatchings != null) {
                ++reuseBestMatchCount;
                return allMatchings != nullMatchingArray ? allMatchings : null;
            }
            long savedStepCount = this.stepCount;
            allMatchings = this.findAllMatchings0(tag, userCode);
            long weight = this.stepCount - savedStepCount;
            if (weight > (long)minStoredWeight) {
                this.allMatchingsStore.addAllMatchings(code, tag, allMatchings);
            }
            return allMatchings;
        }

        protected TagMatching[] findAllMatchingsLeaf(GeneratedTag tag, CharSequenceInterval userCode) {
            return tag.isFreeFormatting() ? (tag.isIgnoreCase() ? this.findAllMatchingsLeafIgnoreSpaceAndCase(tag, userCode) : this.findAllMatchingsLeafIgnoreSpace(tag, userCode)) : (tag.isIgnoreCase() ? this.findAllMatchingsLeafIgnoreCase(tag, userCode) : this.findAllMatchingsLeafBasic(tag, userCode));
        }

        protected TagMatching[] findAllMatchingsLeafBasic(GeneratedTag tag, CharSequenceInterval userCode) {
            int tagLength = tag.length();
            if (tagLength == 0) {
                return null;
            }
            CharSequence tagText = tag.getText();
            if (userCode.length() < tagLength) {
                return null;
            }
            ArraySortedSet matchings = new ArraySortedSet(this.getTagMatchingComparator());
            int max = userCode.length() - tagLength;
            int foundIndex = -1;
            int index = 0;
            while (index <= max) {
                foundIndex = this.findSubSequence(userCode, tagText, index);
                if (foundIndex < 0) break;
                TagMatching matching = this.newTagMatching(tag);
                matching.tokens = tag.tokens();
                matching.start = foundIndex;
                matching.stop = foundIndex + tagLength;
                matching.indexes = new int[]{foundIndex};
                matching.matchingLength = tagLength;
                matching.fullMatching = true;
                matchings.add((Object)matching);
                ++this.stepCount;
                index = foundIndex + 1;
            }
            if (matchings.isEmpty()) {
                return null;
            }
            Object[] result = new TagMatching[matchings.size()];
            matchings.toArray(result);
            return result;
        }

        protected TagMatching[] findAllMatchingsLeafIgnoreCase(GeneratedTag tag, CharSequenceInterval userCode) {
            int tagLength = tag.length();
            if (tagLength == 0) {
                return null;
            }
            CharSequence tagText = tag.getText();
            CharSequence lowerTagText = tag.getFilteredText(this.extension);
            if (userCode.length() < tagLength) {
                return null;
            }
            ArraySortedSet matchings = new ArraySortedSet(this.getTagMatchingComparator());
            int max = userCode.length() - tagLength;
            int foundIndex = -1;
            int index = 0;
            while (index <= max) {
                CharSequence[] charSequenceArray;
                foundIndex = this.findSubSequenceIgnoreCase(userCode, lowerTagText, index);
                if (foundIndex < 0) break;
                CharSequence foundText = userCode.subSequence(foundIndex, foundIndex + tagLength);
                TagMatching matching = this.newTagMatching(tag);
                if (this.mgr.sequenceEquals(foundText, tagText)) {
                    charSequenceArray = tag.tokens();
                } else {
                    CharSequence[] charSequenceArray2 = new CharSequence[1];
                    charSequenceArray = charSequenceArray2;
                    charSequenceArray2[0] = foundText;
                }
                matching.tokens = charSequenceArray;
                matching.start = foundIndex;
                matching.stop = foundIndex + tagLength;
                matching.indexes = new int[]{foundIndex};
                matching.matchingLength = tagLength;
                matching.fullMatching = true;
                matchings.add((Object)matching);
                ++this.stepCount;
                index = foundIndex + 1;
            }
            if (matchings.isEmpty()) {
                return null;
            }
            Object[] result = new TagMatching[matchings.size()];
            matchings.toArray(result);
            return result;
        }

        protected int findSubSequenceIgnoreCase(CharSequenceInterval sequence, CharSequence lowerSubSequence, int index) {
            int len = lowerSubSequence.length();
            if (len == 0) {
                return index <= sequence.length() ? index : -1;
            }
            char firstChar = lowerSubSequence.charAt(0);
            int max = sequence.length() - len;
            int i = index;
            while (i <= max) {
                ++this.stepCount;
                if (Character.toLowerCase(sequence.charAt(i)) == firstChar && this.sequenceEqualsIgnoreCase(sequence, i + 1, lowerSubSequence, 1, len - 1) && this.acceptCharSequenceMatching(sequence.text, sequence.startIdx + i, sequence.startIdx + i + len)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected boolean sequenceEqualsIgnoreCase(CharSequenceInterval left, int leftIdx, CharSequence lowerRight, int rightIdx, int len) {
            while (len-- > 0) {
                if (Character.toLowerCase(left.charAt(leftIdx++)) == lowerRight.charAt(rightIdx++)) continue;
                return false;
            }
            return true;
        }

        protected TagMatching[] findAllMatchingsLeafIgnoreSpace(GeneratedTag tag, CharSequenceInterval userCode) {
            int tagLength = tag.length();
            if (tagLength == 0) {
                return null;
            }
            CharSequenceInterval tagText = new CharSequenceInterval(this.mgr.generated.getText(), tag.getStartIndex(), tag.getStopIndex());
            CharSequence trimmedTagText = tag.getFilteredText(this.extension);
            int trimmedLength = trimmedTagText.length();
            if (userCode.length() < trimmedLength) {
                return null;
            }
            ArraySortedSet matchings = new ArraySortedSet(this.getTagMatchingComparator());
            int max = userCode.length() - trimmedLength;
            int[] foundIndexes = new int[2];
            int index = 0;
            while (index <= max) {
                if (!this.findSubSequenceIgnoreSpace(userCode, trimmedTagText, index, foundIndexes)) break;
                CharSequenceInterval foundText = userCode.subSequenceInterval(foundIndexes[0], foundIndexes[1]);
                int matchingLength = this.computeMatchingLength(tagText, foundText);
                TagMatching matching = this.newTagMatching(tag);
                matching.start = foundIndexes[0];
                matching.stop = foundIndexes[1];
                matching.indexes = new int[]{foundIndexes[0]};
                matching.matchingLength = matchingLength;
                matching.fullMatching = true;
                if (matchingLength != tagLength || foundText.length() != tagLength) {
                    matching.tokens = new CharSequence[]{foundText};
                    TagMatching extendedMatching = this.createExtendedMatching(matching, userCode);
                    if (extendedMatching != null) {
                        matchings.add((Object)extendedMatching);
                    }
                } else {
                    matching.tokens = tag.tokens();
                }
                matchings.add((Object)matching);
                ++this.stepCount;
                index = foundIndexes[0] + 1;
            }
            if (matchings.isEmpty()) {
                return null;
            }
            Object[] result = new TagMatching[matchings.size()];
            matchings.toArray(result);
            return result;
        }

        protected boolean findSubSequenceIgnoreSpace(CharSequenceInterval sequence, CharSequence trimmedSubSequence, int index, int[] foundIndexes) {
            int len = trimmedSubSequence.length();
            if (len == 0) {
                foundIndexes[0] = foundIndexes[1] = index;
                return index <= sequence.length();
            }
            char firstChar = trimmedSubSequence.charAt(0);
            int offset = sequence.startIdx;
            int max = sequence.length() - len;
            int i = index;
            while (i <= max) {
                int endIndex;
                ++this.stepCount;
                if (this.extension.isSignificantChar(offset + i) && sequence.charAt(i) == firstChar && (endIndex = this.sequenceEqualsIgnoreSpace(sequence, i + 1, trimmedSubSequence, 1, len - 1)) != -1 && this.acceptCharSequenceMatching(sequence.text, offset + i, offset + endIndex)) {
                    foundIndexes[0] = i;
                    foundIndexes[1] = endIndex;
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected int sequenceEqualsIgnoreSpace(CharSequenceInterval left, int leftIdx, CharSequence trimmedRight, int rightIdx, int count) {
            int leftMax = left.length();
            while (count > 0) {
                if (leftIdx == leftMax) {
                    return -1;
                }
                char nextNonBlank = left.charAt(leftIdx++);
                while (Character.isWhitespace(nextNonBlank)) {
                    if (leftIdx == leftMax) {
                        return -1;
                    }
                    nextNonBlank = left.charAt(leftIdx++);
                }
                if (nextNonBlank != trimmedRight.charAt(rightIdx++)) {
                    return -1;
                }
                --count;
            }
            return leftIdx;
        }

        protected TagMatching[] findAllMatchingsLeafIgnoreSpaceAndCase(GeneratedTag tag, CharSequenceInterval userCode) {
            int tagLength = tag.length();
            if (tagLength == 0) {
                return null;
            }
            CharSequenceInterval tagText = new CharSequenceInterval(this.mgr.generated.getText(), tag.getStartIndex(), tag.getStopIndex());
            CharSequence filteredTagText = tag.getFilteredText(this.extension);
            int filteredLength = filteredTagText.length();
            if (userCode.length() < filteredLength) {
                return null;
            }
            ArraySortedSet matchings = new ArraySortedSet(this.getTagMatchingComparator());
            int max = userCode.length() - filteredLength;
            int[] foundIndexes = new int[2];
            int index = 0;
            while (index <= max) {
                if (!this.findSubSequenceIgnoreSpaceAndCase(userCode, filteredTagText, index, foundIndexes)) break;
                CharSequenceInterval foundText = userCode.subSequenceInterval(foundIndexes[0], foundIndexes[1]);
                int matchingLength = this.computeMatchingWeight(tagText, foundText);
                TagMatching matching = this.newTagMatching(tag);
                matching.start = foundIndexes[0];
                matching.stop = foundIndexes[1];
                matching.indexes = new int[]{foundIndexes[0]};
                matching.matchingLength = matchingLength;
                matching.fullMatching = true;
                if (matchingLength != tagLength || foundText.length() != tagLength) {
                    matching.tokens = new CharSequence[]{foundText};
                    TagMatching extendedMatching = this.createExtendedMatching(matching, userCode);
                    if (extendedMatching != null) {
                        matchings.add((Object)extendedMatching);
                    }
                } else {
                    matching.tokens = tag.tokens();
                }
                matchings.add((Object)matching);
                ++this.stepCount;
                index = foundIndexes[0] + 1;
            }
            if (matchings.isEmpty()) {
                return null;
            }
            Object[] result = new TagMatching[matchings.size()];
            matchings.toArray(result);
            return result;
        }

        protected boolean findSubSequenceIgnoreSpaceAndCase(CharSequenceInterval sequence, CharSequence filteredSubSequence, int index, int[] foundIndexes) {
            int len = filteredSubSequence.length();
            if (len == 0) {
                foundIndexes[0] = foundIndexes[1] = index;
                return index <= sequence.length();
            }
            char firstChar = filteredSubSequence.charAt(0);
            int offset = sequence.startIdx;
            int max = sequence.length() - len;
            int i = index;
            while (i <= max) {
                int endIndex;
                ++this.stepCount;
                if (this.extension.isSignificantChar(offset + i) && Character.toLowerCase(sequence.charAt(i)) == firstChar && (endIndex = this.sequenceEqualsIgnoreSpaceAndCase(sequence, i + 1, filteredSubSequence, 1, len - 1)) != -1 && this.acceptCharSequenceMatching(sequence.text, offset + i, offset + endIndex)) {
                    foundIndexes[0] = i;
                    foundIndexes[1] = endIndex;
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        protected int sequenceEqualsIgnoreSpaceAndCase(CharSequenceInterval left, int leftIdx, CharSequence filteredRight, int rightIdx, int count) {
            offset = left.startIdx;
            leftMax = left.length();
            while (count > 0) {
                if (leftIdx != leftMax) ** GOTO lbl8
                return -1;
lbl-1000:
                // 1 sources

                {
                    if (++leftIdx != leftMax) continue;
                    return -1;
lbl8:
                    // 2 sources

                    ** while (!this.extension.isSignificantChar((int)(offset + leftIdx)))
                }
lbl9:
                // 1 sources

                if (Character.toLowerCase(left.charAt(leftIdx++)) != filteredRight.charAt(rightIdx++)) {
                    return -1;
                }
                --count;
            }
            return leftIdx;
        }

        protected int computeMatchingWeight(CharSequenceInterval tagText, CharSequenceInterval foundText) {
            int refOffset = tagText.startIdx;
            int offset = foundText.startIdx;
            int matchingLength = 0;
            int secondaryMatchingLength = 0;
            int tagTextIdx = 0;
            int foundTextIdx = 0;
            int foundTextLen = foundText.length();
            boolean forwardTagText = true;
            boolean forwardFoundText = true;
            char ttc = ' ';
            char ftc = ' ';
            boolean refCharSignificant = true;
            boolean foundCharSignificant = true;
            while (foundTextIdx < foundTextLen) {
                if (forwardTagText) {
                    refCharSignificant = this.extension.isSignificantReferenceChar(refOffset + tagTextIdx);
                    ttc = tagText.charAt(tagTextIdx++);
                }
                if (forwardFoundText) {
                    foundCharSignificant = this.extension.isSignificantChar(offset + foundTextIdx);
                    ftc = foundText.charAt(foundTextIdx++);
                }
                if (refCharSignificant == foundCharSignificant && ttc == ftc) {
                    ++matchingLength;
                    forwardFoundText = true;
                    forwardTagText = true;
                    continue;
                }
                if (refCharSignificant == foundCharSignificant && Character.toLowerCase(ttc) == Character.toLowerCase(ftc)) {
                    ++secondaryMatchingLength;
                    forwardFoundText = true;
                    forwardTagText = true;
                    continue;
                }
                forwardTagText = !refCharSignificant;
                boolean bl = forwardFoundText = !foundCharSignificant;
            }
            return matchingLength + 7 * secondaryMatchingLength / 8;
        }

        protected int computeMatchingLength(CharSequenceInterval tagText, CharSequenceInterval foundText) {
            int matchingLength = 0;
            int secondaryMatchingLength = 0;
            int tagTextIdx = 0;
            int foundTextIdx = 0;
            int foundTextLen = foundText.length();
            boolean forwardTagText = true;
            boolean forwardFoundText = true;
            char ttc = ' ';
            char ftc = ' ';
            while (foundTextIdx < foundTextLen) {
                if (forwardTagText) {
                    ttc = tagText.charAt(tagTextIdx++);
                }
                if (forwardFoundText) {
                    ftc = foundText.charAt(foundTextIdx++);
                }
                if (ttc == ftc) {
                    ++matchingLength;
                    forwardFoundText = true;
                    forwardTagText = true;
                    continue;
                }
                if (Character.toLowerCase(ttc) == Character.toLowerCase(ftc)) {
                    ++secondaryMatchingLength;
                    forwardFoundText = true;
                    forwardTagText = true;
                    continue;
                }
                forwardTagText = Character.isWhitespace(ttc);
                forwardFoundText = Character.isWhitespace(ftc);
            }
            return matchingLength + 7 * secondaryMatchingLength / 8;
        }

        protected TagMatching createExtendedMatching(TagMatching matching, CharSequenceInterval userCode) {
            CharSequence[] charSequenceArray;
            int offset = matching.tag.getStartIndex();
            CharSequence tagText = matching.tag.getText();
            int textLen = tagText.length();
            int matchingExtension = 0;
            int idx = 0;
            while (idx < textLen && !this.extension.isSignificantReferenceChar(offset + idx)) {
                ++idx;
            }
            int startIdx = matching.start;
            while (idx > 0 && startIdx > 0 && userCode.charAt(startIdx - 1) == tagText.charAt(idx - 1)) {
                --idx;
                --startIdx;
                ++matchingExtension;
            }
            idx = textLen;
            while (idx > 0 && !this.extension.isSignificantReferenceChar(offset + idx - 1)) {
                --idx;
            }
            int stopIdx = matching.stop;
            int userLen = userCode.length();
            while (idx < textLen && stopIdx < userLen && userCode.charAt(stopIdx) == tagText.charAt(idx)) {
                ++idx;
                ++stopIdx;
                ++matchingExtension;
            }
            if (matchingExtension == 0) {
                return null;
            }
            TagMatching extendedMatching = this.newTagMatching(matching.tag);
            extendedMatching.start = startIdx;
            extendedMatching.stop = stopIdx;
            extendedMatching.indexes = new int[]{startIdx};
            extendedMatching.matchingLength = matching.matchingLength + matchingExtension;
            extendedMatching.fullMatching = true;
            if (extendedMatching.matchingLength == textLen && stopIdx - startIdx == textLen) {
                charSequenceArray = matching.tag.tokens();
            } else {
                CharSequence[] charSequenceArray2 = new CharSequence[1];
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[0] = userCode.subSequence(startIdx, stopIdx);
            }
            extendedMatching.tokens = charSequenceArray;
            return extendedMatching;
        }

        protected TagMatching[] findAllMatchings0(GeneratedTag tag, CharSequenceInterval userCode) {
            if (tag.sons().isEmpty()) {
                return this.findAllMatchingsLeaf(tag, userCode);
            }
            CharSequence[] tokens = tag.tokens();
            int nbOfToken = tokens.length;
            int matchingLength = tag.tokensTotalLength();
            if (userCode.length() < matchingLength) {
                return null;
            }
            ArraySortedSet matchings = new ArraySortedSet(this.getTagMatchingComparator());
            int level = 0;
            int index = 0;
            int[] indexes = new int[tokens.length];
            block0: while (true) {
                int foundIndex;
                if ((foundIndex = this.findSubSequence(userCode, tokens[level], index)) < 0) {
                    if (level == 0) break;
                    index = 1 + indexes[--level];
                    while (tokens[level].length() == 0) {
                        if (level == 0) break block0;
                        index = 1 + indexes[--level];
                    }
                } else {
                    indexes[level] = foundIndex;
                    if (level == nbOfToken - 1) {
                        if (tokens[level].length() == 0) {
                            indexes[level] = userCode.length();
                        }
                        TagMatching matching = this.newTagMatching(tag);
                        matching.tokens = tokens;
                        matching.start = indexes[0];
                        matching.stop = indexes[level] + tokens[level].length();
                        matching.indexes = (int[])indexes.clone();
                        matching.matchingLength = matchingLength;
                        matching.fullMatching = true;
                        this.findSubTagMatchings(matching, userCode);
                        if (matching.matchingLength > 0) {
                            matchings.add((Object)matching);
                        }
                        index = indexes[level] + 1;
                    } else {
                        index = foundIndex + tokens[level].length();
                        ++level;
                    }
                }
                ++this.stepCount;
            }
            if (matchings.isEmpty()) {
                return null;
            }
            Object[] result = new TagMatching[matchings.size()];
            matchings.toArray(result);
            return result;
        }

        protected int addMatchingLengths(TagMatching[] matchings) {
            int total = 0;
            int count = matchings.length;
            while (--count >= 0) {
                TagMatching matching = matchings[count];
                if (matching == null) continue;
                total += matching.matchingLength;
            }
            return total;
        }

        protected boolean allFullMatchings(TagMatching[] matchings) {
            int count = matchings.length;
            while (--count >= 0) {
                TagMatching matching = matchings[count];
                if (matching != null && matching.fullMatching) continue;
                return false;
            }
            return true;
        }

        protected int findSubSequence(CharSequenceInterval sequence, CharSequence subSequence, int index) {
            int len = subSequence.length();
            if (len == 0) {
                return index <= sequence.length() ? index : -1;
            }
            char firstChar = subSequence.charAt(0);
            int max = sequence.length() - len;
            int i = index;
            while (i <= max) {
                ++this.stepCount;
                if (sequence.charAt(i) == firstChar && this.mgr.sequenceEquals(sequence, i + 1, subSequence, 1, len - 1) && this.acceptCharSequenceMatching(sequence.text, sequence.startIdx + i, sequence.startIdx + i + len)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected boolean acceptCharSequenceMatching(CharSequence text, int beginIdx, int endIdx) {
            return true;
        }

        protected void findSubTagMatchings(TagMatching parentMatching, CharSequenceInterval parentUserCode) {
            GeneratedTag parent = parentMatching.tag;
            int[] parentIndexes = parentMatching.indexes;
            CharSequence[] parentTokens = parentMatching.tokens;
            int nbOfSubTags = parent.sons().size();
            TagMatching[] subTagMatchings = new TagMatching[nbOfSubTags];
            int totalSubTagMatchingLength = 0;
            boolean fullMatching = true;
            int subTagIndex = 0;
            while (subTagIndex < nbOfSubTags) {
                ++this.stepCount;
                GeneratedTag subTag = (GeneratedTag)parent.sons().get(subTagIndex);
                int startIdx = parentIndexes[subTagIndex] + parentTokens[subTagIndex].length();
                int subTagSequenceLength = 1;
                while (subTagIndex + subTagSequenceLength < nbOfSubTags && parentTokens[subTagIndex + subTagSequenceLength].length() == 0) {
                    ++subTagSequenceLength;
                }
                if (subTagSequenceLength == 1) {
                    TagMatching subTagMatching;
                    int stopIdx = parentIndexes[subTagIndex + 1];
                    CharSequenceInterval userCode = new CharSequenceInterval(parentUserCode, startIdx, stopIdx);
                    subTagMatchings[subTagIndex] = subTagMatching = this.findBestMatch(subTag, userCode);
                    if (subTagMatching != null) {
                        totalSubTagMatchingLength += subTagMatching.matchingLength;
                        fullMatching &= subTagMatching.fullMatching;
                    } else {
                        fullMatching = false;
                    }
                } else {
                    GeneratedTag[] subTagsToMatch = new GeneratedTag[subTagSequenceLength];
                    parent.sons().subList(subTagIndex, subTagIndex + subTagSequenceLength).toArray(subTagsToMatch);
                    int stopIdx = parentIndexes[subTagIndex + subTagSequenceLength];
                    CharSequenceInterval userCode = new CharSequenceInterval(parentUserCode, startIdx, stopIdx);
                    MultiTagMatching sequenceMatching = this.findBestMatch(subTagsToMatch, userCode);
                    if (sequenceMatching == null) {
                        fullMatching = false;
                        int i = 1;
                        while (i < subTagSequenceLength) {
                            parentIndexes[subTagIndex + i] = stopIdx;
                            ++i;
                        }
                    } else {
                        TagMatching matching;
                        int emptyTokenIdx = stopIdx;
                        boolean nextNull = false;
                        int i = subTagSequenceLength - 1;
                        while (i > 0) {
                            TagMatching matching2 = sequenceMatching.matchings[i];
                            if (matching2 == null) {
                                nextNull = true;
                                fullMatching = false;
                            } else {
                                matching2 = this.copyMatching(matching2);
                                int[] indexes = matching2.indexes;
                                int count = indexes.length;
                                int shift = indexes[0];
                                while (--count >= 0) {
                                    int n = count;
                                    indexes[n] = indexes[n] - shift;
                                }
                                if (nextNull) {
                                    parentIndexes[subTagIndex + i + 1] = startIdx + matching2.stop;
                                    nextNull = false;
                                }
                                matching2.start = 0;
                                matching2.stop -= shift;
                                emptyTokenIdx = startIdx + shift;
                                subTagMatchings[subTagIndex + i] = matching2;
                                if (matching2 != null) {
                                    totalSubTagMatchingLength += matching2.matchingLength;
                                    fullMatching &= matching2.fullMatching;
                                } else {
                                    fullMatching = false;
                                }
                            }
                            parentIndexes[subTagIndex + i] = emptyTokenIdx;
                            --i;
                        }
                        subTagMatchings[subTagIndex] = matching = sequenceMatching.matchings[0];
                        if (matching != null) {
                            totalSubTagMatchingLength += matching.matchingLength;
                            fullMatching &= matching.fullMatching;
                            if (nextNull) {
                                parentIndexes[subTagIndex + 1] = startIdx + matching.stop;
                            }
                        } else {
                            fullMatching = false;
                        }
                    }
                }
                subTagIndex += subTagSequenceLength;
            }
            if (parentTokens[nbOfSubTags].length() == 0) {
                subTagIndex = nbOfSubTags - 1;
                int stopIndex = parentMatching.stop;
                while (subTagIndex >= 0) {
                    if (subTagMatchings[subTagIndex] != null) {
                        stopIndex = parentIndexes[subTagIndex] + parentTokens[subTagIndex].length() + subTagMatchings[subTagIndex].stop;
                        break;
                    }
                    if (parentTokens[subTagIndex].length() != 0) {
                        stopIndex = parentIndexes[subTagIndex] + parentTokens[subTagIndex].length();
                        break;
                    }
                    --subTagIndex;
                }
                while (++subTagIndex <= nbOfSubTags) {
                    parentIndexes[subTagIndex] = stopIndex;
                }
                parentMatching.stop = stopIndex;
            }
            if (parentTokens[0].length() == 0) {
                TagMatching firstSubTagMatching = subTagMatchings[0];
                if (firstSubTagMatching != null) {
                    firstSubTagMatching = this.copyMatching(firstSubTagMatching);
                    int[] indexes = firstSubTagMatching.indexes;
                    int count = indexes.length;
                    int shift = indexes[0];
                    while (--count >= 0) {
                        int n = count;
                        indexes[n] = indexes[n] - shift;
                    }
                    firstSubTagMatching.start = 0;
                    firstSubTagMatching.stop -= shift;
                    parentMatching.start = shift;
                    parentIndexes[0] = shift;
                    subTagMatchings[0] = firstSubTagMatching;
                } else {
                    parentMatching.start = parentIndexes[0] = parentIndexes[1];
                }
            }
            parentMatching.subTagMatchings = subTagMatchings;
            parentMatching.matchingLength += totalSubTagMatchingLength;
            parentMatching.fullMatching = fullMatching;
        }

        protected TagMatching copyMatching(TagMatching matching) {
            TagMatching newMatching = this.newTagMatching(matching.tag);
            newMatching.fullMatching = matching.fullMatching;
            newMatching.tokens = matching.tokens;
            newMatching.indexes = (int[])matching.indexes.clone();
            newMatching.matchingLength = matching.matchingLength;
            newMatching.start = matching.start;
            newMatching.stop = matching.stop;
            newMatching.subTagMatchings = matching.subTagMatchings;
            return newMatching;
        }

        protected boolean applyMatching(ListSortedSet subSetToSimplify, MultiTagMatching bestMatch, CharSequenceInterval userCode) {
            int[][] oldIndexes = new int[bestMatch.length][];
            int[][] newIndexes = new int[bestMatch.length][];
            List nodes = this.computeIndexesOfOverridenNodes(subSetToSimplify, bestMatch, oldIndexes, newIndexes);
            int overrideIndex = 0;
            int previousOverrideIndex = -1;
            int nodeIndex = 0;
            int previousNodeIndex = -1;
            GeneratedTag previousTag = null;
            for (Node node : nodes) {
                if (node.isOverride()) {
                    if (newIndexes[overrideIndex] != null) {
                        int oldStart = previousOverrideIndex != -1 ? oldIndexes[previousOverrideIndex][1] : 0;
                        int oldStop = oldIndexes[overrideIndex][0];
                        int newStart = previousOverrideIndex != -1 ? newIndexes[previousOverrideIndex][1] : 0;
                        int newStop = newIndexes[overrideIndex][0];
                        CharSequence newText = userCode.subSequence(newStart, newStop);
                        GeneratedTag tag = node.getTag();
                        this.moveTextToContainers(newText, previousTag, newStart - oldStart, nodes.subList(previousNodeIndex + 1, nodeIndex), tag, newStop - oldStop);
                        if (bestMatch.matchings[overrideIndex].tokens == tag.tokens()) {
                            this.mgr.restoreNode(node);
                            node.reindent = false;
                        } else {
                            this.mgr.changeText(node, bestMatch.matchings[overrideIndex].tokens[0]);
                            node.reindent = true;
                        }
                        if (!tag.sons().isEmpty()) {
                            this.applySubTagsMatchings(bestMatch.matchings[overrideIndex], userCode);
                        }
                        previousOverrideIndex = overrideIndex;
                        previousNodeIndex = nodeIndex;
                        previousTag = tag;
                    }
                    ++overrideIndex;
                }
                ++nodeIndex;
            }
            if (previousOverrideIndex != -1) {
                int oldStart = oldIndexes[previousOverrideIndex][1];
                int newStart = newIndexes[previousOverrideIndex][1];
                CharSequence newText = userCode.subSequence(newStart, userCode.length());
                this.moveTextToContainers(newText, previousTag, newStart - oldStart, nodes.subList(previousNodeIndex + 1, nodes.size()), null, 0);
            }
            return true;
        }

        protected void applySubTagsMatchings(TagMatching parentMatching, CharSequenceInterval parentUserCode) {
            List subTags = parentMatching.tag.sons();
            CharSequence[] parentTokens = parentMatching.tokens;
            int[] parentIndexes = parentMatching.indexes;
            TagMatching[] matchings = parentMatching.subTagMatchings;
            int nbOfSubTags = parentMatching.tag.sons().size();
            int subTagIdx = 0;
            while (subTagIdx < nbOfSubTags) {
                int startIdx = parentIndexes[subTagIdx] + parentTokens[subTagIdx].length();
                int stopIdx = parentIndexes[subTagIdx + 1];
                CharSequenceInterval userCode = new CharSequenceInterval(parentUserCode, startIdx, stopIdx);
                TagMatching matching = matchings[subTagIdx];
                GeneratedTag subTag = (GeneratedTag)subTags.get(subTagIdx);
                if (matching == null) {
                    boolean bl = overrideBlanksBefore = !subTag.areBlanksBeforeShared() || matchings[subTagIdx - 1] != null;
                    if (subTag.length() == 0) {
                        this.restoreEmptyTag(subTag, userCode, overrideBlanksBefore, true);
                    } else {
                        this.overrideTag(subTag, userCode, overrideBlanksBefore, true);
                    }
                } else {
                    overrideBlanksBefore = !subTag.areBlanksBeforeShared();
                    boolean overrideBlanksAfter = !subTag.areBlanksAfterShared() || matchings[subTagIdx + 1] != null;
                    this.applyTagMatching(matching, userCode, overrideBlanksBefore, overrideBlanksAfter);
                }
                ++subTagIdx;
            }
        }

        protected void restoreEmptyTag(GeneratedTag tag, CharSequenceInterval userCode, boolean overrideBlanksBefore, boolean overrideBlanksAfter) {
            int nbOfSubTags = tag.sons().size();
            CharSequence toInsertBefore = null;
            CharSequence toInsertAfter = null;
            CharSequence toReplace = null;
            if (!overrideBlanksBefore || !overrideBlanksAfter) {
                if (!overrideBlanksBefore) {
                    toInsertAfter = userCode.toCharSequence();
                } else if (!overrideBlanksAfter) {
                    toInsertBefore = userCode.toCharSequence();
                } else {
                    toReplace = userCode.toCharSequence();
                }
            } else {
                int len = userCode.length();
                int rightIdx = len - 1;
                while (rightIdx >= 0 && Character.isWhitespace(userCode.charAt(rightIdx))) {
                    --rightIdx;
                }
                if (rightIdx < 0) {
                    rightIdx = tag.nbBlanksAfter() < len ? len - tag.nbBlanksAfter() - 1 : -1;
                }
                toInsertBefore = userCode.subSequence(0, rightIdx + 1);
                toInsertAfter = userCode.subSequence(rightIdx + 1, len);
            }
            if (toInsertBefore != null && !this.mgr.sequenceEquals(toInsertBefore, tag.getBlanksBefore())) {
                this.mgr.setTextAt(tag, -1, toInsertBefore);
            }
            if (toReplace != null && toReplace.length() > 0) {
                this.mgr.setTextAt(tag, 0, toReplace);
            }
            if (toInsertAfter != null && !this.mgr.sequenceEquals(toInsertAfter, tag.getBlanksAfter())) {
                this.mgr.setTextAt(tag, 1, toInsertAfter);
            }
            if (nbOfSubTags > 0) {
                Node node = (Node)this.mgr.getNodeAtPosition(tag, 0, false);
                node.mixedContentCount = 0;
                for (GeneratedTag subTag : tag.sons()) {
                    this.restoreEmptyTag(subTag, new CharSequenceInterval("", 0, 0), !subTag.areBlanksBeforeShared(), true);
                }
            }
        }

        protected void overrideTag(GeneratedTag tag, CharSequenceInterval userCode, boolean overrideBlanksBefore, boolean overrideBlanksAfter) {
            if (!overrideBlanksBefore && !overrideBlanksAfter) {
                this.mgr.setTextAt(tag, 0, userCode.toCharSequence());
                return;
            }
            int len = userCode.length();
            int leftIdx = 0;
            if (overrideBlanksBefore) {
                while (leftIdx < len && Character.isWhitespace(userCode.charAt(leftIdx))) {
                    ++leftIdx;
                }
                CharSequence insertBefore = userCode.subSequence(0, leftIdx);
                if (!this.mgr.sequenceEquals(insertBefore, tag.getBlanksBefore())) {
                    this.mgr.setTextAt(tag, -1, insertBefore);
                }
            }
            int rightIdx = len - 1;
            if (overrideBlanksAfter) {
                while (rightIdx >= leftIdx && Character.isWhitespace(userCode.charAt(rightIdx))) {
                    --rightIdx;
                }
                CharSequence insertAfter = userCode.subSequence(rightIdx + 1, len);
                if (!this.mgr.sequenceEquals(insertAfter, tag.getBlanksAfter())) {
                    this.mgr.setTextAt(tag, 1, insertAfter);
                }
            }
            this.mgr.setTextAt(tag, 0, userCode.subSequence(leftIdx, rightIdx + 1));
        }

        protected void applyTagMatching(TagMatching matching, CharSequenceInterval userCode, boolean overrideBlanksBefore, boolean overrideBlanksAfter) {
            int stopIndex;
            CharSequence toInsertAfter;
            int startIndex;
            CharSequence toInsertBefore;
            GeneratedTag tag = matching.tag;
            int nbOfSubTags = tag.sons().size();
            if (overrideBlanksBefore && !this.mgr.sequenceEquals(toInsertBefore = userCode.subSequence(0, startIndex = matching.indexes[0]), tag.getBlanksBefore())) {
                this.mgr.setTextAt(tag, -1, toInsertBefore);
            }
            if (overrideBlanksAfter && !this.mgr.sequenceEquals(toInsertAfter = userCode.subSequence(stopIndex = matching.indexes[nbOfSubTags] + matching.tokens[nbOfSubTags].length(), userCode.length()), tag.getBlanksAfter())) {
                this.mgr.setTextAt(tag, 1, toInsertAfter);
            }
            Node node = (Node)this.mgr.getNodeAtPosition(tag, 0, false);
            node.mixedContentCount = 0;
            if (matching.tokens != tag.tokens()) {
                this.mgr.overrideNode(node, matching.tokens[0]);
                node.reindent = true;
            } else {
                node.reindent = false;
            }
            if (nbOfSubTags > 0) {
                this.applySubTagsMatchings(matching, userCode);
            }
        }

        protected List computeIndexesOfOverridenNodes(ListSortedSet subSetToSimplify, MultiTagMatching bestMatch, int[][] oldIndexes, int[][] newIndexes) {
            ArrayList<Node> nodes = new ArrayList<Node>(subSetToSimplify.size());
            int startIndex = ((TextSegmentExtremity)subSetToSimplify.first()).index();
            int nodeCount = 0;
            for (TextSegmentExtremity e : subSetToSimplify) {
                if (e.isStop()) continue;
                Node node = (Node)e.getNode();
                nodes.add(node);
                if (!node.isOverride()) continue;
                int[] interval = new int[]{node.start - startIndex, node.stop - startIndex};
                oldIndexes[nodeCount] = interval;
                if (bestMatch.matchings[nodeCount] != null) {
                    interval = new int[]{bestMatch.matchings[nodeCount].start, bestMatch.matchings[nodeCount].stop};
                    newIndexes[nodeCount] = interval;
                }
                ++nodeCount;
            }
            return nodes;
        }

        protected void moveTextBetween(CharSequence text, GeneratedTag leftTag, GeneratedTag rightTag) {
            if (leftTag != null) {
                if (leftTag.nbBlanksAfter() != 0) {
                    StringBuffer newText = new StringBuffer(text.length() + leftTag.nbBlanksAfter());
                    newText.append(text).append(leftTag.getBlanksAfter());
                    text = newText;
                }
                this.mgr.setTextAt(leftTag, 1, text);
            } else {
                if (rightTag.nbBlanksBefore() != 0) {
                    StringBuffer newText = new StringBuffer(rightTag.nbBlanksBefore() + text.length());
                    newText.append(rightTag.getBlanksBefore()).append(text);
                    text = newText;
                }
                this.mgr.setTextAt(rightTag, -1, text);
            }
        }

        protected void moveTextToContainers(CharSequence text, GeneratedTag leftTag, int leftShift, List containers, GeneratedTag rightTag, int rightShift) {
            if (leftShift == 0 && rightShift == 0) {
                return;
            }
            if (containers.isEmpty()) {
                this.moveTextBetween(text, leftTag, rightTag);
                return;
            }
            if (containers.size() == 1) {
                Node container = (Node)containers.get(0);
                this.mgr.changeText(container, text);
                return;
            }
            Iterator leftIter = containers.iterator();
            while (leftShift > 0 && leftIter.hasNext()) {
                Node container = (Node)leftIter.next();
                int containerLength = container.text.length();
                if (leftShift <= containerLength) {
                    this.mgr.changeText(container, container.text.subSequence(leftShift, containerLength));
                    leftShift = 0;
                    continue;
                }
                this.mgr.changeText(container, "");
                leftShift -= containerLength;
            }
            if (leftShift > 0) {
                rightShift -= leftShift;
                leftShift = 0;
            }
            ListIterator rightIter = containers.listIterator(containers.size());
            while (rightShift < 0 && rightIter.hasPrevious()) {
                Node container = (Node)rightIter.previous();
                int containerLength = container.text.length();
                if (-rightShift <= containerLength) {
                    this.mgr.changeText(container, container.text.subSequence(0, container.length() + rightShift));
                    rightShift = 0;
                    continue;
                }
                this.mgr.changeText(container, "");
                rightShift += containerLength;
            }
            if (rightShift < 0) {
                leftShift -= rightShift;
                rightShift = 0;
            }
            if (leftShift < 0) {
                Node container = (Node)containers.get(0);
                StringBuffer newText = new StringBuffer(container.text.length() - leftShift);
                newText.append(text.subSequence(0, -leftShift)).append(container.text);
                this.mgr.changeText(container, newText);
            }
            if (rightShift > 0) {
                Node container = (Node)containers.get(containers.size() - 1);
                StringBuffer newText = new StringBuffer(container.text.length() + rightShift);
                newText.append(container.text()).append(text.subSequence(text.length() - rightShift, text.length()));
                this.mgr.changeText(container, newText);
            }
        }

        protected boolean startsWith(CharSequence text, CharSequence start) {
            int len = start.length();
            if (text.length() < len) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (text.charAt(i) != start.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean simplifyOverrides(TextNode userNode) {
            if (!userNode.isOverride()) {
                return false;
            }
            CharSequenceInterval userCode = new CharSequenceInterval(userNode.text(), 0, userNode.length());
            TagMatching bestMatch = this.findBestMatch(userNode.getTag(), userCode);
            if (bestMatch == null) {
                return false;
            }
            return this.applyMatching(userNode, bestMatch, userCode);
        }

        protected TagMatching findBestMatch(GeneratedTag tag, CharSequenceInterval userCode) {
            TagMatching[] matchings = this.findAllMatchings(tag, userCode);
            return matchings != null ? matchings[matchings.length - 1] : null;
        }

        protected boolean sameMatchings(TagMatching[] left, TagMatching[] right) {
            if (left == null || right == null) {
                return left == right;
            }
            int count = left.length;
            while (--count >= 0) {
                if (this.sameMatchings(left[count], right[count])) continue;
                return false;
            }
            return true;
        }

        protected boolean sameMatchings(TagMatching left, TagMatching right) {
            if (left == null || right == null) {
                return left == right;
            }
            if (left.fullMatching != right.fullMatching || left.start != right.start || left.stop != right.stop || left.matchingLength != right.matchingLength) {
                return false;
            }
            int count = left.indexes.length;
            while (--count >= 0) {
                if (left.indexes[count] == right.indexes[count]) continue;
                return false;
            }
            if (left.subTagMatchings == null || right.subTagMatchings == null) {
                return left.subTagMatchings == right.subTagMatchings;
            }
            count = left.subTagMatchings.length;
            while (--count >= 0) {
                if (this.sameMatchings(left.subTagMatchings[count], right.subTagMatchings[count])) continue;
                return false;
            }
            return true;
        }

        protected int compareMatchings(TagMatching left, TagMatching right) {
            return this.getTagMatchingComparator().compare(left, right);
        }

        protected boolean applyMatching(TextNode overridenNode, TagMatching bestMatch, CharSequenceInterval userCode) {
            return false;
        }

        protected int restoreNode(TextNode userNode, int[] matching) {
            GeneratedTag tag = userNode.getTag();
            CharSequence userCode = userNode.text();
            if (tag.sons().isEmpty()) {
                int generatedCodeStart = matching[0];
                int generatedCodeStop = matching[0] + userCode.length();
                if (generatedCodeStart > 0) {
                    this.moveTextBefore(tag, userCode.subSequence(0, generatedCodeStart));
                }
                if (generatedCodeStop < userCode.length()) {
                    this.moveTextAfter(tag, userCode.subSequence(generatedCodeStop, userCode.length()));
                }
                this.mgr.setTextAt(tag, 0, null);
                return 1;
            }
            CharSequence generatedText = tag.getGeneratedInfo().getText();
            int index = 0;
            int sequenceIndex = 0;
            int sonIndex = 0;
            while (sonIndex < tag.sons().size()) {
                GeneratedTag subTag = (GeneratedTag)tag.sons().get(sonIndex);
                CharSequence nextPieceOfCode = generatedText.subSequence(index, subTag.getStartIndex() - subTag.nbBlanksBefore());
                if (nextPieceOfCode.length() > 0) {
                    int matchingIndex = matching[sequenceIndex++];
                    if (sonIndex == 0 && matchingIndex > 0) {
                        this.moveTextBefore(tag, userCode.subSequence(index, matchingIndex));
                    }
                }
                index = subTag.getStopIndex() + subTag.nbBlanksAfter();
            }
            return 0;
        }

        protected void moveTextBefore(GeneratedTag tag, CharSequence text) {
            TextNode alreadyExistingNode = this.mgr.getNodeAtPosition(tag, -1, true);
            StringBuffer codeToInsert = null;
            if (alreadyExistingNode == null) {
                codeToInsert = new StringBuffer(tag.nbBlanksBefore() + text.length());
                codeToInsert.append(tag.getBlanksBefore()).append(text);
            } else {
                codeToInsert = new StringBuffer(alreadyExistingNode.length() + text.length());
                codeToInsert.append(alreadyExistingNode.text()).append(text);
            }
            this.mgr.setTextAt(tag, -1, codeToInsert);
        }

        protected void moveTextAfter(GeneratedTag tag, CharSequence text) {
            TextNode alreadyExistingNode = this.mgr.getNodeAtPosition(tag, 1, true);
            StringBuffer codeToInsert = null;
            if (alreadyExistingNode == null) {
                codeToInsert = new StringBuffer(text.length() + tag.nbBlanksAfter());
                codeToInsert.append(text).append(tag.getBlanksAfter());
            } else {
                codeToInsert = new StringBuffer(text.length() + alreadyExistingNode.length());
                codeToInsert.append(text).append(alreadyExistingNode.text());
            }
            this.mgr.setTextAt(tag, 1, codeToInsert);
        }

        public boolean simplifyInsertions() {
            boolean simplified = false;
            TextSegment firstNode = null;
            int index = -1;
            Iterator changes = this.mgr.userExtremities.iterator();
            while (changes.hasNext()) {
                TextSegmentExtremity change = (TextSegmentExtremity)changes.next();
                if (change.isStop()) continue;
                Node node = (Node)change.getNode();
                if (firstNode == null) {
                    if (!node.hasReconcilationWarnings()) {
                        firstNode = node;
                    }
                } else if (node.startIndex() != index || node.hasReconcilationWarnings()) {
                    ListSortedSet subsetToSimplify = (ListSortedSet)this.mgr.userExtremities.subSet((Object)firstNode.getHead(), (Object)node.getHead());
                    if (this.simplifyInsertions(subsetToSimplify)) {
                        changes = this.mgr.userExtremities.iteratorFrom((Object)node.getHead(), false);
                        simplified = true;
                    }
                    firstNode = node.hasReconcilationWarnings() ? null : node;
                }
                index = node.stopIndex();
            }
            if (firstNode != null && this.simplifyInsertions((ListSortedSet)this.mgr.userExtremities.tailSet((Object)firstNode.getHead()))) {
                simplified = true;
            }
            return simplified;
        }

        protected boolean simplifyInsertions(ListSortedSet subSetToSimplify) {
            boolean simplified = false;
            ArrayList nodes = new ArrayList(subSetToSimplify.size());
            int bitfield = this.copyNodesInto(subSetToSimplify, nodes);
            if ((bitfield & 1) != 0 && (bitfield & 4) != 0) {
                simplified |= this.moveNonBlankCharsIntoOverridenNodes(nodes);
            }
            if ((bitfield & 2) != 0) {
                simplified |= this.trimBlanksArroundOverridenNodes(nodes);
            }
            simplified |= this.restoreIndentations(nodes);
            simplified |= this.removeNeedlessNodes(nodes);
            if (this.moveIndentsToOverrides(nodes)) {
                this.removeNeedlessNodes(nodes);
                simplified = true;
            }
            return simplified;
        }

        protected int copyNodesInto(ListSortedSet set, List nodes) {
            int bitfield = 0;
            for (TextSegmentExtremity e : set) {
                if (e.isStop()) continue;
                Node node = (Node)e.getNode();
                if (node.isOverride()) {
                    bitfield |= 1;
                    if (node.text.length() > 0 && (Character.isWhitespace(node.text.charAt(0)) || Character.isWhitespace(node.text.charAt(node.text.length() - 1)))) {
                        bitfield |= 2;
                    }
                }
                if (node.isInsertion() && this.containsNonBlankChar(node.text)) {
                    bitfield |= 4;
                }
                nodes.add(node);
            }
            return bitfield;
        }

        protected boolean containsNonBlankChar(CharSequence text) {
            int len = text.length();
            while (--len >= 0) {
                if (Character.isWhitespace(text.charAt(len))) continue;
                return true;
            }
            return false;
        }

        protected boolean trimBlanksArroundOverridenNodes(List nodes) {
            boolean simplified = false;
            Node previousInsertion = null;
            int previousOverrideIdx = -1;
            CharSequence blanksToTransfer = null;
            int nodeIdx = 0;
            while (nodeIdx < nodes.size()) {
                Node node = (Node)nodes.get(nodeIdx);
                if (node.isInsertion()) {
                    if (blanksToTransfer != null) {
                        StringBuffer newText = new StringBuffer(blanksToTransfer.length() + node.text.length());
                        newText.append(blanksToTransfer).append(node.text);
                        this.mgr.changeText(node, newText);
                        previousOverrideIdx = -1;
                        blanksToTransfer = null;
                        simplified = true;
                    }
                    previousInsertion = node;
                } else {
                    CharSequence blanksAtEnd;
                    CharSequence blanksAtBeginning;
                    Node newNode;
                    StringBuffer newText;
                    if (blanksToTransfer != null) {
                        Node previousOverridenNode = (Node)nodes.get(previousOverrideIdx);
                        newText = new StringBuffer(blanksToTransfer.length() + previousOverridenNode.tag.nbBlanksAfter());
                        newText.append(blanksToTransfer).append(previousOverridenNode.tag.getBlanksAfter());
                        newNode = this.mgr.insertUserNode(previousOverridenNode.tag, previousOverridenNode.parent, 1, newText);
                        nodes.add(previousOverrideIdx + 1, newNode);
                        ++nodeIdx;
                        previousInsertion = newNode;
                        previousOverrideIdx = -1;
                        blanksToTransfer = null;
                        simplified = true;
                    }
                    if ((blanksAtBeginning = this.blanksAtBeginning(node.text)).length() > 0 && !node.reindent && !node.hasWarnings() && this.blanksAtBeginning(node.tag.getText()).length() == 0) {
                        if (previousInsertion != null) {
                            newText = new StringBuffer(previousInsertion.text.length() + blanksAtBeginning.length());
                            newText.append(previousInsertion.text).append(blanksAtBeginning);
                            this.mgr.changeText(previousInsertion, newText);
                            this.mgr.changeText(node, node.text.subSequence(blanksAtBeginning.length(), node.text.length()));
                            simplified = true;
                        } else if (blanksAtBeginning.length() != node.text.length()) {
                            newText = new StringBuffer(node.tag.nbBlanksBefore() + blanksAtBeginning.length());
                            newText.append(node.tag.getBlanksBefore()).append(blanksAtBeginning);
                            this.mgr.setTextAt(node.tag, -1, newText);
                            newNode = (Node)this.mgr.getNodeAtPosition(node.tag, -1, true);
                            nodes.add(nodeIdx, newNode);
                            ++nodeIdx;
                            this.mgr.changeText(node, node.text.subSequence(blanksAtBeginning.length(), node.text.length()));
                            simplified = true;
                        }
                    }
                    if ((blanksAtEnd = this.blanksAtEnd(node.text)).length() > 0 && !node.reindent && !node.hasWarnings() && this.blanksAtEnd(node.tag.getText()).length() == 0) {
                        previousOverrideIdx = nodeIdx;
                        blanksToTransfer = blanksAtEnd;
                        this.mgr.changeText(node, node.text.subSequence(0, node.text.length() - blanksAtEnd.length()));
                    }
                    previousInsertion = null;
                }
                ++nodeIdx;
            }
            if (blanksToTransfer != null) {
                Node previousOverrideNode = (Node)nodes.get(previousOverrideIdx);
                StringBuffer newText = new StringBuffer(blanksToTransfer.length() + previousOverrideNode.tag.nbBlanksAfter());
                newText.append(blanksToTransfer).append(previousOverrideNode.tag.getBlanksAfter());
                Node newNode = this.mgr.insertUserNode(previousOverrideNode.tag, previousOverrideNode.parent, 1, newText);
                nodes.add(previousOverrideIdx + 1, newNode);
                previousOverrideIdx = -1;
                blanksToTransfer = null;
                simplified = true;
            }
            return simplified;
        }

        protected boolean moveNonBlankCharsIntoOverridenNodes(List nodes) {
            boolean simplified = false;
            int i = 0;
            while (i < nodes.size()) {
                Node node = (Node)nodes.get(i);
                if (node.isOverride() && !node.reindent && !node.hasWarnings()) {
                    CharSequence insertion;
                    CharSequence blanksAtEnd;
                    Node nextNode;
                    CharSequence insertion2;
                    CharSequence blanksAtBeginning;
                    Node previousNode;
                    StringBuffer newText = null;
                    Node node2 = previousNode = i > 0 ? (Node)nodes.get(i - 1) : null;
                    if (previousNode != null && previousNode.isInsertion() && (blanksAtBeginning = this.blanksAtBeginning(insertion2 = previousNode.text)).length() != insertion2.length() && !previousNode.hasWarnings()) {
                        newText = new StringBuffer(insertion2.length() - blanksAtBeginning.length() + node.text.length());
                        newText.append(insertion2.subSequence(blanksAtBeginning.length(), insertion2.length())).append(node.text);
                        this.mgr.changeText(previousNode, blanksAtBeginning);
                    }
                    Node node3 = nextNode = i < nodes.size() - 1 ? (Node)nodes.get(i + 1) : null;
                    if (nextNode != null && nextNode.isInsertion() && (blanksAtEnd = this.blanksAtEnd(insertion = nextNode.text)).length() != insertion.length() && !nextNode.hasWarnings()) {
                        if (newText == null) {
                            newText = new StringBuffer(insertion.length() - blanksAtEnd.length() + node.text.length());
                            newText.append(node.text).append(insertion.subSequence(0, insertion.length() - blanksAtEnd.length()));
                        } else {
                            newText.append(insertion.subSequence(0, insertion.length() - blanksAtEnd.length()));
                        }
                        this.mgr.changeText(nextNode, blanksAtEnd);
                    }
                    if (newText != null) {
                        this.mgr.changeText(node, newText);
                        simplified = true;
                    }
                }
                ++i;
            }
            return simplified;
        }

        protected CharSequence blanksAtBeginning(CharSequence text) {
            int len = text.length();
            int leftIdx = 0;
            while (leftIdx < len && Character.isWhitespace(text.charAt(leftIdx))) {
                ++leftIdx;
            }
            return text.subSequence(0, leftIdx);
        }

        protected CharSequence blanksAtEnd(CharSequence text) {
            int len = text.length();
            int rightIdx = len - 1;
            while (rightIdx >= 0 && Character.isWhitespace(text.charAt(rightIdx))) {
                --rightIdx;
            }
            return text.subSequence(rightIdx + 1, len);
        }

        protected boolean restoreIndentations(List nodes) {
            boolean simplified = false;
            Iterator iter = nodes.iterator();
            Node previousNode = (Node)iter.next();
            CharSequence generatedText = this.generatedText(previousNode);
            CharSequence text = previousNode.text();
            CharSequence blanksToRemoveFromPreviousNode = this.blanksToRemoveAtEnd(generatedText, text);
            CharSequence blanksToAddToPreviousNode = this.blanksToAddAtEnd(generatedText, text);
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                generatedText = this.generatedText(node);
                text = node.text();
                if (generatedText.length() == 0 && text.length() == 0) continue;
                CharSequence blanksToAddAtBegin = this.blanksToAddAtBegin(generatedText, text);
                CharSequence blanksToRemoveAtBegin = this.blanksToRemoveAtBegin(generatedText, text);
                boolean transfered = false;
                if (blanksToRemoveFromPreviousNode != null && blanksToAddAtBegin != null) {
                    transfered = this.transferBlanksForward(previousNode, blanksToRemoveFromPreviousNode, node, blanksToAddAtBegin);
                }
                if (!transfered && blanksToRemoveAtBegin != null && blanksToAddToPreviousNode != null) {
                    transfered = this.transferBlanksBackward(previousNode, blanksToAddToPreviousNode, node, blanksToRemoveAtBegin);
                }
                if (transfered) {
                    simplified = true;
                    text = node.text();
                }
                blanksToRemoveFromPreviousNode = this.blanksToRemoveAtEnd(generatedText, text);
                blanksToAddToPreviousNode = this.blanksToAddAtEnd(generatedText, text);
                previousNode = node;
            }
            return simplified;
        }

        protected boolean removeNeedlessNodes(List nodes) {
            boolean simplified = false;
            int i = 0;
            while (i < nodes.size()) {
                Node node = (Node)nodes.get(i);
                if (node.isInsertion()) {
                    CharSequence generatedBlank;
                    CharSequence charSequence = generatedBlank = node.position == -1 ? node.tag.getBlanksBefore() : node.tag.getBlanksAfter();
                    if (Strings.sameCharSequences((CharSequence)node.text, (CharSequence)generatedBlank)) {
                        this.mgr.removeUserNode(node);
                        nodes.remove(i);
                        --i;
                        simplified = true;
                    }
                } else if (node.isOverride() && node.reindent && Strings.sameCharSequences((CharSequence)node.text, (CharSequence)this.generatedText(node))) {
                    this.mgr.removeUserNode(node);
                    nodes.remove(i);
                    --i;
                    simplified = true;
                }
                ++i;
            }
            return simplified;
        }

        protected boolean moveIndentsToOverrides(List nodes) {
            boolean simplified = false;
            int i = 0;
            while (i < nodes.size()) {
                Node node = (Node)nodes.get(i);
                if (node.isOverride()) {
                    Node next;
                    boolean reindent;
                    int blank;
                    int transferLength;
                    CharSequence blanksToTransfer;
                    Node previous;
                    StringBuilder newText = null;
                    if (i > 0 && this.isInsertionBefore(node, previous = (Node)nodes.get(i - 1))) {
                        CharSequence previousText = previous.text;
                        blanksToTransfer = this.blanksToRemoveAtEnd(this.generatedText(previous), previousText);
                        if (blanksToTransfer != null) {
                            transferLength = blanksToTransfer.length();
                            int previousLength = previousText.length();
                            blank = previous.blankIndicator;
                            reindent = previous.reindent;
                            this.mgr.changeText(previous, previousText.subSequence(0, previousLength - transferLength));
                            previous.blankIndicator = blank;
                            previous.reindent = reindent;
                            newText = new StringBuilder(node.text.length() + transferLength);
                            newText.append(blanksToTransfer).append(node.text);
                        }
                    }
                    if (i < nodes.size() - 1 && this.isInsertionAfter(node, next = (Node)nodes.get(i + 1))) {
                        CharSequence nextText = next.text;
                        blanksToTransfer = this.blanksToRemoveAtBegin(this.generatedText(next), nextText);
                        if (blanksToTransfer != null) {
                            transferLength = blanksToTransfer.length();
                            int nextLength = nextText.length();
                            blank = next.blankIndicator;
                            reindent = next.reindent;
                            this.mgr.changeText(next, nextText.subSequence(transferLength, nextLength));
                            next.blankIndicator = blank;
                            next.reindent = reindent;
                            if (newText == null) {
                                newText = new StringBuilder(node.text.length() + transferLength);
                                newText.append(node.text);
                            }
                            newText.append(blanksToTransfer);
                        }
                    }
                    if (newText != null) {
                        int blank2 = node.blankIndicator;
                        boolean reindent2 = node.reindent;
                        this.mgr.changeText(node, newText.toString());
                        node.blankIndicator = blank2;
                        node.reindent = reindent2;
                        simplified = true;
                    }
                }
                ++i;
            }
            return simplified;
        }

        protected boolean isInsertionBefore(Node anchorNode, Node insertion) {
            if (!insertion.isInsertion()) {
                return false;
            }
            GeneratedTag tag = insertion.tag;
            GeneratedTag nodeTag = anchorNode.tag;
            if (tag == nodeTag) {
                return insertion.position == -1;
            }
            return insertion.position == 1 && tag == nodeTag.previousTag() && tag.areBlanksAfterShared();
        }

        protected boolean isInsertionAfter(Node anchorNode, Node insertion) {
            if (!insertion.isInsertion()) {
                return false;
            }
            GeneratedTag tag = insertion.tag;
            GeneratedTag nodeTag = anchorNode.tag;
            if (tag == nodeTag) {
                return insertion.position == 1;
            }
            return insertion.position == -1 && tag == nodeTag.nextTag() && tag.areBlanksBeforeShared();
        }

        protected boolean removeNeedlessInsertions(List nodes) {
            boolean simplified = false;
            Node previousNode = null;
            int i = 0;
            while (i < nodes.size()) {
                Node node = (Node)nodes.get(i);
                if (node.isOverride()) {
                    previousNode = node;
                } else {
                    CharSequence generatedBlank;
                    Node anchorNode;
                    if (node.position == -1) {
                        anchorNode = i < nodes.size() - 1 ? (Node)nodes.get(i + 1) : null;
                        generatedBlank = node.tag.getBlanksBefore();
                    } else {
                        anchorNode = previousNode;
                        generatedBlank = node.tag.getBlanksAfter();
                    }
                    if ((anchorNode == null || !anchorNode.isOverride() || anchorNode.reindent || anchorNode.tag != node.tag || generatedBlank.length() == 0) && this.mgr.sequenceEquals(node.text, generatedBlank)) {
                        this.mgr.removeUserNode(node);
                        nodes.remove(i);
                        --i;
                        simplified = true;
                    }
                    previousNode = null;
                }
                ++i;
            }
            return simplified;
        }

        protected boolean addNeededInsertions(List nodes) {
            boolean simplified = false;
            Node previousNode = null;
            int i = 0;
            while (i < nodes.size()) {
                Node node = (Node)nodes.get(i);
                if (node.isInsertion()) {
                    previousNode = node;
                } else if (node.reindent) {
                    previousNode = null;
                } else {
                    Node nextNode;
                    GeneratedTag tag = node.tag;
                    if (!(tag.nbBlanksBefore() == 0 || previousNode != null && (previousNode.tag == tag || tag.areBlanksBeforeShared() && tag.previousTag() == previousNode.tag && previousNode.position == 1))) {
                        if (tag.areBlanksBeforeShared()) {
                            this.mgr.setTextAt(tag.previousTag(), 1, tag.getBlanksBefore());
                        } else {
                            this.mgr.insertUserNode(tag, node.parent, -1, tag.getBlanksBefore());
                        }
                        simplified = true;
                    }
                    Node node2 = nextNode = i < nodes.size() - 1 ? (Node)nodes.get(i + 1) : null;
                    if (!(tag.nbBlanksAfter() == 0 || nextNode != null && (nextNode.tag == tag || tag.areBlanksAfterShared() && tag.nextTag() == nextNode.tag && nextNode.position == -1))) {
                        previousNode = this.mgr.insertUserNode(tag, node.parent, 1, tag.getBlanksAfter());
                        simplified = true;
                    } else {
                        previousNode = null;
                    }
                }
                ++i;
            }
            return simplified;
        }

        public boolean fixIndentations() {
            boolean simplified = false;
            TextSegment firstNode = null;
            int index = -1;
            Iterator changes = this.mgr.userExtremities.iterator();
            while (changes.hasNext()) {
                TextSegmentExtremity change = (TextSegmentExtremity)changes.next();
                if (change.isStop()) continue;
                Node node = (Node)change.getNode();
                if (firstNode == null) {
                    firstNode = node;
                } else if (node.startIndex() != index) {
                    ListSortedSet subsetToSimplify = (ListSortedSet)this.mgr.userExtremities.subSet((Object)firstNode.getHead(), (Object)node.getHead());
                    if (this.fixIndentations(subsetToSimplify)) {
                        changes = this.mgr.userExtremities.iteratorFrom((Object)node.getHead(), false);
                        simplified = true;
                    }
                    firstNode = node;
                }
                index = node.stopIndex();
                node.hasReconcilationWarnings();
            }
            if (firstNode != null && this.fixIndentations((ListSortedSet)this.mgr.userExtremities.tailSet((Object)firstNode.getHead()))) {
                simplified = true;
            }
            return simplified;
        }

        protected boolean fixIndentations(ListSortedSet subset) {
            if (subset.size() <= 1) {
                return false;
            }
            boolean simplified = false;
            ArrayList nodes = new ArrayList(subset.size());
            this.copyNodes(subset, nodes);
            Iterator iter = nodes.iterator();
            Node previousNode = (Node)iter.next();
            CharSequence generatedText = this.generatedText(previousNode);
            CharSequence text = previousNode.text();
            CharSequence blanksToRemoveFromPreviousNode = this.blanksToRemoveAtEnd(generatedText, text);
            CharSequence blanksToAddToPreviousNode = this.blanksToAddAtEnd(generatedText, text);
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                generatedText = this.generatedText(node);
                text = node.text();
                if (generatedText.length() == 0 && text.length() == 0) continue;
                CharSequence blanksToAddAtBegin = this.blanksToAddAtBegin(generatedText, text);
                CharSequence blanksToRemoveAtBegin = this.blanksToRemoveAtBegin(generatedText, text);
                boolean transfered = false;
                if (blanksToRemoveFromPreviousNode != null && blanksToAddAtBegin != null) {
                    transfered = this.transferBlanksForward(previousNode, blanksToRemoveFromPreviousNode, node, blanksToAddAtBegin);
                }
                if (!transfered && blanksToRemoveAtBegin != null && blanksToAddToPreviousNode != null) {
                    transfered = this.transferBlanksBackward(previousNode, blanksToAddToPreviousNode, node, blanksToRemoveAtBegin);
                }
                if (transfered) {
                    simplified = true;
                    text = node.text();
                }
                blanksToRemoveFromPreviousNode = this.blanksToRemoveAtEnd(generatedText, text);
                blanksToAddToPreviousNode = this.blanksToAddAtEnd(generatedText, text);
                previousNode = node;
            }
            return simplified;
        }

        protected boolean transferBlanksForward(Node previousNode, CharSequence blanksToRemove, Node nextNode, CharSequence blanksToAdd) {
            int toRemoveLength = blanksToRemove.length();
            int toAddLength = blanksToAdd.length();
            int charsToTransfer = 0;
            int maxCharsToTransfer = Math.min(toRemoveLength, toAddLength);
            while (charsToTransfer < maxCharsToTransfer) {
                char toAdd;
                char toRemove = blanksToRemove.charAt(toRemoveLength - charsToTransfer - 1);
                if (toRemove != (toAdd = blanksToAdd.charAt(toAddLength - charsToTransfer - 1))) break;
                ++charsToTransfer;
            }
            if (charsToTransfer == 0) {
                return false;
            }
            CharSequence previousText = previousNode.text();
            int previousTextLength = previousText.length();
            CharSequence nextText = nextNode.text();
            int nextTextLength = nextText.length();
            int blank = previousNode.blankIndicator;
            boolean reindent = previousNode.reindent;
            this.mgr.changeText(previousNode, previousText.subSequence(0, previousTextLength - charsToTransfer));
            previousNode.blankIndicator = blank;
            previousNode.reindent = reindent;
            StringBuilder newText = new StringBuilder(nextTextLength + charsToTransfer);
            newText.append(previousText.subSequence(previousTextLength - charsToTransfer, previousTextLength));
            newText.append(nextText);
            blank = nextNode.blankIndicator;
            reindent = nextNode.reindent;
            this.mgr.changeText(nextNode, newText.toString());
            nextNode.blankIndicator = blank;
            nextNode.reindent = reindent;
            return true;
        }

        protected boolean transferBlanksBackward(Node previousNode, CharSequence blanksToAdd, Node nextNode, CharSequence blanksToRemove) {
            int toRemoveLength = blanksToRemove.length();
            int toAddLength = blanksToAdd.length();
            int charsToTransfer = 0;
            int maxCharsToTransfer = Math.min(toRemoveLength, toAddLength);
            while (charsToTransfer < maxCharsToTransfer) {
                char toAdd;
                char toRemove = blanksToRemove.charAt(charsToTransfer);
                if (toRemove != (toAdd = blanksToAdd.charAt(charsToTransfer))) break;
                ++charsToTransfer;
            }
            if (charsToTransfer == 0) {
                return false;
            }
            CharSequence previousText = previousNode.text();
            int previousTextLength = previousText.length();
            CharSequence nextText = nextNode.text();
            int nextTextLength = nextText.length();
            int blank = nextNode.blankIndicator;
            boolean reindent = nextNode.reindent;
            this.mgr.changeText(nextNode, nextText.subSequence(charsToTransfer, nextTextLength));
            nextNode.blankIndicator = blank;
            nextNode.reindent = reindent;
            StringBuilder newText = new StringBuilder(previousTextLength + charsToTransfer);
            newText.append(previousText);
            newText.append(nextText.subSequence(0, charsToTransfer));
            blank = previousNode.blankIndicator;
            reindent = previousNode.reindent;
            this.mgr.changeText(previousNode, newText.toString());
            previousNode.blankIndicator = blank;
            previousNode.reindent = reindent;
            return true;
        }

        protected CharSequence generatedText(Node node) {
            int beginIdx = node.getHead().generatedIndex();
            int endIdx = node.getTail().generatedIndex();
            return this.mgr.generated.getText().subSequence(beginIdx, endIdx);
        }

        protected void copyNodes(ListSortedSet set, List nodes) {
            for (TextSegmentExtremity e : set) {
                if (e.isStop()) continue;
                Node node = (Node)e.getNode();
                nodes.add(node);
            }
        }

        protected CharSequence blanksToAddAtBegin(CharSequence reference, CharSequence text) {
            CharSequence refBlanks = this.blanksAtBeginning(reference);
            int refBlanksLength = refBlanks.length();
            StringBuilder reverseRefBlanks = new StringBuilder(refBlanksLength);
            int i = refBlanksLength - 1;
            while (i >= 0) {
                reverseRefBlanks.append(refBlanks.charAt(i));
                --i;
            }
            CharSequence blanks = this.blanksAtBeginning(text);
            int blanksLength = blanks.length();
            StringBuilder reverseBlanks = new StringBuilder(blanksLength);
            int i2 = blanksLength - 1;
            while (i2 >= 0) {
                reverseBlanks.append(blanks.charAt(i2));
                --i2;
            }
            CharSequence reverseResult = this.toAddAtEnd(reverseRefBlanks.toString(), reverseBlanks.toString());
            if (reverseResult == null) {
                return null;
            }
            int resultLength = reverseResult.length();
            StringBuilder result = new StringBuilder(resultLength);
            int i3 = resultLength - 1;
            while (i3 >= 0) {
                result.append(reverseResult.charAt(i3));
                --i3;
            }
            return result.toString();
        }

        protected CharSequence blanksToRemoveAtBegin(CharSequence reference, CharSequence text) {
            CharSequence refBlanks = this.blanksAtBeginning(reference);
            int refBlanksLength = refBlanks.length();
            StringBuilder reverseRefBlanks = new StringBuilder(refBlanksLength);
            int i = refBlanksLength - 1;
            while (i >= 0) {
                reverseRefBlanks.append(refBlanks.charAt(i));
                --i;
            }
            CharSequence blanks = this.blanksAtBeginning(text);
            int blanksLength = blanks.length();
            StringBuilder reverseBlanks = new StringBuilder(blanksLength);
            int i2 = blanksLength - 1;
            while (i2 >= 0) {
                reverseBlanks.append(blanks.charAt(i2));
                --i2;
            }
            CharSequence reverseResult = this.toRemoveAtEnd(reverseRefBlanks.toString(), reverseBlanks.toString());
            if (reverseResult == null) {
                return null;
            }
            int resultLength = reverseResult.length();
            StringBuilder result = new StringBuilder(resultLength);
            int i3 = resultLength - 1;
            while (i3 >= 0) {
                result.append(reverseResult.charAt(i3));
                --i3;
            }
            return result.toString();
        }

        protected CharSequence blanksToAddAtEnd(CharSequence reference, CharSequence text) {
            return this.toAddAtEnd(this.blanksAtEnd(reference), this.blanksAtEnd(text));
        }

        protected CharSequence toAddAtEnd(CharSequence refBlanks, CharSequence blanks) {
            int nbRefBlanks = refBlanks.length();
            if (nbRefBlanks == 0) {
                return null;
            }
            int nbBlanks = blanks.length();
            if (nbBlanks == 0) {
                return refBlanks;
            }
            if (nbBlanks >= nbRefBlanks && Strings.sameSubSequences((CharSequence)blanks, (int)(nbBlanks - nbRefBlanks), (CharSequence)refBlanks, (int)0, (int)nbRefBlanks)) {
                return null;
            }
            int count = nbBlanks < nbRefBlanks ? nbBlanks : nbRefBlanks - 1;
            while (count > 0) {
                if (Strings.sameSubSequences((CharSequence)blanks, (int)(nbBlanks - count), (CharSequence)refBlanks, (int)0, (int)count)) {
                    return refBlanks.subSequence(count, nbRefBlanks);
                }
                --count;
            }
            return refBlanks;
        }

        protected CharSequence blanksToRemoveAtEnd(CharSequence reference, CharSequence text) {
            return this.toRemoveAtEnd(this.blanksAtEnd(reference), this.blanksAtEnd(text));
        }

        protected CharSequence toRemoveAtEnd(CharSequence refBlanks, CharSequence blanks) {
            int nbBlanks = blanks.length();
            if (nbBlanks == 0) {
                return null;
            }
            int nbRefBlanks = refBlanks.length();
            if (nbRefBlanks == 0) {
                return blanks;
            }
            int diff = nbBlanks - nbRefBlanks;
            if (diff >= 0) {
                int idx = 0;
                while (idx < diff) {
                    if (Strings.sameSubSequences((CharSequence)blanks, (int)idx, (CharSequence)refBlanks, (int)0, (int)nbRefBlanks)) {
                        return idx + nbRefBlanks < nbBlanks ? blanks.subSequence(idx + nbRefBlanks, nbBlanks) : null;
                    }
                    ++idx;
                }
            }
            return null;
        }

        protected Comparator getTagMatchingComparator() {
            if (this.tagMatchingComparator == null) {
                this.tagMatchingComparator = this.newTagMatchingComparator();
            }
            return this.tagMatchingComparator;
        }

        protected Comparator newTagMatchingComparator() {
            return new TagMatchingComparator();
        }

        protected TagMatching newTagMatching(GeneratedTag tag) {
            return new TagMatching(tag);
        }

        protected Comparator getMultiTagMatchingComparator() {
            if (this.multiTagMatchingComparator == null) {
                this.multiTagMatchingComparator = this.newMultiTagMatchingComparator();
            }
            return this.multiTagMatchingComparator;
        }

        protected Comparator newMultiTagMatchingComparator() {
            return new MultiTagMatchingComparator();
        }

        protected static class MatchingsStore
        implements Serializable {
            protected OrderedSet matchings = new OrderedHashedSet();

            protected MatchingsStore() {
            }

            protected TagMatching[] getAllMatchings(String code, GeneratedTag tag) {
                StoredMatchingArray matching = (StoredMatchingArray)this.matchings.get((Object)new StoredMatchingArray(code, tag));
                if (matching == null) {
                    return null;
                }
                this.matchings.moveLast((Object)matching);
                return matching.allMatchings;
            }

            protected MultiTagMatching getBestMatch(String code, GeneratedTag[] tags) {
                StoredMultiMatching matching = (StoredMultiMatching)this.matchings.get((Object)new StoredMultiMatching(code, tags));
                if (matching == null) {
                    return null;
                }
                this.matchings.moveLast((Object)matching);
                return matching.bestMatch;
            }

            protected void addAllMatchings(String code, GeneratedTag tag, TagMatching[] allMatchings) {
                StoredMatchingArray storedMatching = new StoredMatchingArray(code, tag);
                storedMatching.allMatchings = allMatchings != null ? allMatchings : nullMatchingArray;
                this.matchings.add((Object)storedMatching);
                int sz = this.matchings.size();
                if (sz > maxStoredMatchings) {
                    Iterator iter = this.matchings.iterator();
                    do {
                        iter.next();
                        iter.remove();
                    } while (--sz > maxStoredMatchings);
                }
            }

            protected void addBestMatch(String code, GeneratedTag[] tags, MultiTagMatching multiMatching) {
                StoredMultiMatching storedMatching = new StoredMultiMatching(code, tags);
                storedMatching.bestMatch = multiMatching != null ? multiMatching : nullMultiMatching;
                this.matchings.add((Object)storedMatching);
                int sz = this.matchings.size();
                if (sz > maxStoredMatchings) {
                    Iterator iter = this.matchings.iterator();
                    do {
                        iter.next();
                        iter.remove();
                    } while (--sz > maxStoredMatchings);
                }
            }

            protected void resetTags(GeneratedInfo newGeneratedInfo) {
                OrderedHashedSet newMatchings = new OrderedHashedSet();
                for (Object o : this.matchings) {
                    if (o instanceof StoredMatchingArray) {
                        this.transferStoredMatchingArray((StoredMatchingArray)o, newGeneratedInfo, (Set)newMatchings);
                        continue;
                    }
                    this.transferStoredMultiMatching((StoredMultiMatching)o, newGeneratedInfo, (Set)newMatchings);
                }
                this.matchings = newMatchings;
            }

            protected boolean transferStoredMatchingArray(StoredMatchingArray stored, GeneratedInfo newGeneratedInfo, Set newStorage) {
                GeneratedTag oldTag = stored.tag;
                GeneratedTag newTag = newGeneratedInfo.getTag(oldTag.getName());
                if (newTag == null) {
                    return false;
                }
                TagMatching[] allMatchings = stored.allMatchings;
                if (allMatchings != nullMatchingArray) {
                    int count = allMatchings.length;
                    while (--count >= 0) {
                        TagMatching matching = allMatchings[count];
                        if (this.convertMatching(oldTag, matching, newTag)) continue;
                        return false;
                    }
                } else if (!this.sameText(oldTag, newTag)) {
                    return false;
                }
                stored.tag = newTag;
                stored.hash = stored.hash ^ oldTag.hashCode() ^ newTag.hashCode();
                newStorage.add(stored);
                return true;
            }

            protected boolean transferStoredMultiMatching(StoredMultiMatching oldStored, GeneratedInfo newGeneratedInfo, Set newStorage) {
                GeneratedTag[] tags = oldStored.tags;
                int count = tags.length;
                TagMatching[] matchings = oldStored.bestMatch.matchings;
                while (--count >= 0) {
                    TagMatching matching = matchings != null ? matchings[count] : null;
                    GeneratedTag oldTag = tags[count];
                    GeneratedTag newTag = newGeneratedInfo.getTag(oldTag.getName());
                    if (newTag == null || !this.convertMatching(oldTag, matching, newTag)) {
                        return false;
                    }
                    tags[count] = newTag;
                    oldStored.hash = oldStored.hash ^ oldTag.hashCode() ^ newTag.hashCode();
                }
                newStorage.add(oldStored);
                return true;
            }

            protected boolean convertMatching(GeneratedTag oldTag, TagMatching matching, GeneratedTag newTag) {
                if (matching == null) {
                    return this.sameText(oldTag, newTag);
                }
                if (matching.tag != oldTag) {
                    return matching.tag != null && matching.tag == newTag;
                }
                if (newTag == null || !this.sameTokens(oldTag.tokens(), newTag.tokens()) || !this.convertSubMatchings(oldTag, matching, newTag)) {
                    matching.tag = null;
                    return false;
                }
                if (matching.tokens == oldTag.tokens()) {
                    matching.tokens = newTag.tokens();
                }
                matching.tag = newTag;
                return true;
            }

            protected boolean convertSubMatchings(GeneratedTag oldTag, TagMatching matching, GeneratedTag newTag) {
                TagMatching[] subMatchings = matching.subTagMatchings;
                if (subMatchings == null) {
                    return true;
                }
                Iterator oldSubTags = oldTag.sons().iterator();
                Iterator newSubTags = newTag.sons().iterator();
                int i = 0;
                while (i < subMatchings.length) {
                    GeneratedTag newSubTag;
                    TagMatching subMatching = subMatchings[i];
                    GeneratedTag oldSubTag = (GeneratedTag)oldSubTags.next();
                    if (!this.convertMatching(oldSubTag, subMatching, newSubTag = (GeneratedTag)newSubTags.next())) {
                        if (subMatching != null) {
                            subMatching.tag = null;
                        }
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            protected boolean sameText(GeneratedTag left, GeneratedTag right) {
                if (left == null || right == null) {
                    return left == right;
                }
                if (!this.sameTokens(left.tokens(), right.tokens())) {
                    return false;
                }
                Iterator leftSubTags = left.sons().iterator();
                Iterator rightSubTags = right.sons().iterator();
                while (leftSubTags.hasNext()) {
                    if (this.sameText((GeneratedTag)leftSubTags.next(), (GeneratedTag)rightSubTags.next())) continue;
                    return false;
                }
                return true;
            }

            /*
             * Unable to fully structure code
             */
            protected boolean sameTokens(CharSequence[] left, CharSequence[] right) {
                count = left.length;
                if (right.length == count) ** GOTO lbl6
                return false;
lbl-1000:
                // 1 sources

                {
                    if (left[count].toString().equals(right[count].toString())) continue;
                    return false;
lbl6:
                    // 2 sources

                    ** while (--count >= 0)
                }
lbl7:
                // 1 sources

                return true;
            }
        }

        protected static class MultiTagMatching
        implements Serializable {
            protected int length;
            protected TagMatching[] matchings;
            protected int start;
            protected int stop;
            protected int matchingLength;

            protected MultiTagMatching() {
            }

            protected MultiTagMatching(int nbOfTags) {
                this.matchings = new TagMatching[nbOfTags];
            }

            protected boolean addMatching(TagMatching matching) {
                if (matching == null) {
                    this.matchings[this.length++] = null;
                    return true;
                }
                if (matching.start < this.stop) {
                    return false;
                }
                if (this.length == 0) {
                    this.start = matching.start;
                }
                this.stop = matching.stop;
                this.matchingLength += matching.matchingLength;
                this.matchings[this.length++] = matching;
                return true;
            }

            protected void removeLastMatching() {
                if (--this.length == 0) {
                    this.matchingLength = 0;
                    this.stop = 0;
                    this.start = 0;
                    this.matchings[this.length] = null;
                    return;
                }
                if (this.matchings[this.length] != null) {
                    this.matchingLength -= this.matchings[this.length].matchingLength;
                }
                this.matchings[this.length] = null;
                int i = this.length - 1;
                while (i >= 0 && this.matchings[i] == null) {
                    --i;
                }
                this.stop = i >= 0 ? this.matchings[i].stop : 0;
            }

            protected boolean isComplete() {
                return this.length == this.matchings.length;
            }

            protected boolean isFull() {
                if (this.length != this.matchings.length) {
                    return false;
                }
                int count = this.length;
                while (--count >= 0) {
                    if (this.matchings[count] != null && this.matchings[count].fullMatching) continue;
                    return false;
                }
                return true;
            }

            protected void copyFrom(MultiTagMatching other) {
                this.length = other.length;
                this.start = other.start;
                this.stop = other.stop;
                this.matchingLength = other.matchingLength;
                System.arraycopy(other.matchings, 0, this.matchings, 0, this.matchings.length);
            }

            protected int getPreviousStop(int matchingIndex) {
                if (matchingIndex <= 0 || this.matchings == null) {
                    return -1;
                }
                if (matchingIndex >= this.length) {
                    return this.stop;
                }
                int i = matchingIndex - 1;
                while (i >= 0 && this.matchings[i] == null) {
                    --i;
                }
                return i >= 0 ? this.matchings[i].stop : -1;
            }

            private int getNextStart(int matchingIndex) {
                if (matchingIndex >= this.length || this.matchings == null) {
                    return -1;
                }
                if (matchingIndex < 0) {
                    return this.start;
                }
                int i = matchingIndex + 1;
                while (i < this.length && this.matchings[i] == null) {
                    ++i;
                }
                return i < this.length ? this.matchings[i].start : -1;
            }

            protected boolean replaceMatching(TagMatching matchingToInsert, int tagMatchingIndexToRemove) {
                int nextStart;
                int previousEnd;
                if (this.matchings == null || tagMatchingIndexToRemove >= this.matchings.length || tagMatchingIndexToRemove < 0) {
                    return false;
                }
                if (matchingToInsert == null) {
                    TagMatching tagMatchingToRemove = this.matchings[tagMatchingIndexToRemove];
                    if (tagMatchingToRemove == null) {
                        return true;
                    }
                    this.matchings[tagMatchingIndexToRemove] = null;
                    this.matchingLength -= tagMatchingToRemove.matchingLength;
                    if (this.stop != tagMatchingToRemove.stop) {
                        int previousStop = this.getPreviousStop(tagMatchingIndexToRemove);
                        int n = this.stop = previousStop == -1 ? 0 : previousStop;
                    }
                    if (this.start != tagMatchingToRemove.start) {
                        int nextStart2 = this.getNextStart(tagMatchingIndexToRemove);
                        this.start = nextStart2 == -1 ? 0 : nextStart2;
                    }
                    return true;
                }
                if (tagMatchingIndexToRemove != 0 && (previousEnd = this.getPreviousStop(tagMatchingIndexToRemove)) != -1 && matchingToInsert.start < previousEnd) {
                    return false;
                }
                if (tagMatchingIndexToRemove != this.matchings.length - 1 && (nextStart = this.getNextStart(tagMatchingIndexToRemove)) != -1 && nextStart < matchingToInsert.stop) {
                    return false;
                }
                TagMatching tagMatchingToRemove = this.matchings[tagMatchingIndexToRemove];
                if (tagMatchingToRemove == null) {
                    this.matchingLength += matchingToInsert.matchingLength;
                    if (matchingToInsert.stop > this.stop) {
                        this.stop = matchingToInsert.stop;
                    }
                    if (matchingToInsert.start < this.start) {
                        this.start = matchingToInsert.start;
                    }
                } else {
                    this.matchingLength += matchingToInsert.matchingLength - tagMatchingToRemove.matchingLength;
                    if (this.stop == tagMatchingToRemove.stop) {
                        this.stop = matchingToInsert.stop;
                    }
                    if (this.start == tagMatchingToRemove.start) {
                        this.start = matchingToInsert.start;
                    }
                }
                this.matchings[tagMatchingIndexToRemove] = matchingToInsert;
                return true;
            }
        }

        protected static class MultiTagMatchingComparator
        implements Comparator,
        Serializable {
            public int compare(Object left, Object right) {
                if (right == null) {
                    return 1;
                }
                if (left == null) {
                    return -1;
                }
                return this.compareMatchings((MultiTagMatching)left, (MultiTagMatching)right);
            }

            protected int compareMatchings(MultiTagMatching left, MultiTagMatching right) {
                int cmp = left.matchingLength - right.matchingLength;
                if (cmp != 0) {
                    return cmp;
                }
                cmp = right.stop - right.start - (left.stop - left.start);
                if (cmp != 0) {
                    return cmp;
                }
                return right.start - left.start;
            }
        }

        protected static class StoredMatchingArray
        implements Serializable {
            protected String code;
            protected GeneratedTag tag;
            protected int hash;
            protected TagMatching[] allMatchings;

            protected StoredMatchingArray() {
            }

            protected StoredMatchingArray(String sourceCode, GeneratedTag generatedTag) {
                this.code = sourceCode;
                this.tag = generatedTag;
                this.hash = this.tag.hashCode() ^ this.code.hashCode();
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object other) {
                if (!(other instanceof StoredMatchingArray)) {
                    return false;
                }
                StoredMatchingArray matching = (StoredMatchingArray)other;
                return this.code.equals(matching.code) && this.tag == matching.tag;
            }

            public TagMatching[] getAllMatchings() {
                return this.allMatchings;
            }

            public void setAllMatchings(TagMatching[] newAllMatchings) {
                this.allMatchings = newAllMatchings;
            }
        }

        protected static class StoredMultiMatching
        implements Serializable {
            protected String code;
            protected GeneratedTag[] tags;
            protected int hash;
            protected MultiTagMatching bestMatch;

            protected StoredMultiMatching() {
            }

            protected StoredMultiMatching(String sourceCode, GeneratedTag[] generatedTags) {
                this.code = sourceCode;
                this.tags = generatedTags;
                this.hash = this.hash(generatedTags) ^ this.code.hashCode();
            }

            protected int hash(GeneratedTag[] generatedTags) {
                int h = 0;
                int count = generatedTags.length;
                while (--count >= 0) {
                    h ^= this.tags[count].hashCode();
                }
                return h;
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object other) {
                if (!(other instanceof StoredMultiMatching)) {
                    return false;
                }
                StoredMultiMatching matching = (StoredMultiMatching)other;
                return this.code.equals(matching.code) && Arrays.equals(this.tags, matching.tags);
            }

            public MultiTagMatching getBestMatch() {
                return this.bestMatch;
            }

            public void setBestMatch(MultiTagMatching newBestMatch) {
                this.bestMatch = newBestMatch;
            }
        }

        protected static class TagMatching
        implements Serializable {
            protected GeneratedTag tag;
            protected CharSequence[] tokens;
            protected boolean fullMatching;
            protected int start;
            protected int stop;
            protected int matchingLength;
            protected int[] indexes;
            protected TagMatching[] subTagMatchings;

            protected TagMatching() {
            }

            protected TagMatching(GeneratedTag generatedTag) {
                this.tag = generatedTag;
            }
        }

        protected static class TagMatchingComparator
        implements Comparator,
        Serializable {
            public int compare(Object left, Object right) {
                if (right == null) {
                    return 1;
                }
                if (left == null) {
                    return -1;
                }
                return this.compareMatchings((TagMatching)left, (TagMatching)right);
            }

            protected int compareMatchings(TagMatching left, TagMatching right) {
                int cmp = left.matchingLength - right.matchingLength;
                if (cmp != 0) {
                    return cmp;
                }
                cmp = right.stop - left.stop;
                if (cmp != 0) {
                    return cmp;
                }
                return right.stop - right.start - (left.stop - left.start);
            }
        }
    }

    protected static class TmpExtremity
    implements TextSegmentExtremity,
    TextNode {
        protected GeneratedTag tag;
        protected int position;
        protected boolean isStart;

        public TmpExtremity(GeneratedTag anchor, int hook, boolean start) {
            this.tag = anchor;
            this.position = hook;
            this.isStart = start;
        }

        @Override
        public int generatedIndex() {
            throw new UnsupportedOperationException("TmpExtremity.generatedIndex");
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public GeneratedTag getTag() {
            return this.tag;
        }

        @Override
        public TextNode getNode() {
            return this;
        }

        @Override
        public boolean isStart() {
            return this.isStart;
        }

        @Override
        public boolean isStop() {
            return !this.isStart;
        }

        public int compareTo(Object o) {
            return extremityComparator.compare(this, o);
        }

        @Override
        public int index() {
            throw new UnsupportedOperationException("TmpExtremity.index");
        }

        @Override
        public int getDepth() {
            throw new UnsupportedOperationException("TmpExtremity.getDepth");
        }

        @Override
        public Iterator children(boolean reverseOrder) {
            throw new UnsupportedOperationException("TmpExtremity.children");
        }

        @Override
        public void cleanWarnings() {
            throw new UnsupportedOperationException("TmpExtremity.cleanWarnings");
        }

        @Override
        public TextNode getParent() {
            throw new UnsupportedOperationException("TmpExtremity.getParent");
        }

        @Override
        public boolean hasChildren() {
            throw new UnsupportedOperationException("TmpExtremity.hasChildren");
        }

        @Override
        public boolean hasUserChangeAncestor() {
            throw new UnsupportedOperationException("TmpExtremity.hasUserChangeAncestor");
        }

        @Override
        public boolean hasWarnings() {
            throw new UnsupportedOperationException("TmpExtremity.hasWarnings");
        }

        @Override
        public boolean includeUserChange() {
            throw new UnsupportedOperationException("TmpExtremity.includeUserChange");
        }

        @Override
        public boolean isAncestorOf(TextNode node) {
            throw new UnsupportedOperationException("TmpExtremity.isAncestorOf");
        }

        @Override
        public boolean isHidden() {
            throw new UnsupportedOperationException("TmpExtremity.isHidden");
        }

        @Override
        public boolean isInSameBranch(TextNode node) {
            throw new UnsupportedOperationException("TmpExtremity.isInSameBranch");
        }

        @Override
        public boolean isInsertion() {
            throw new UnsupportedOperationException("TmpExtremity.isInsertion");
        }

        @Override
        public boolean isOverride() {
            throw new UnsupportedOperationException("TmpExtremity.isOverride");
        }

        @Override
        public boolean isAtomic() {
            throw new UnsupportedOperationException("TmpExtremity.isAtomic");
        }

        @Override
        public boolean isUserChange() {
            throw new UnsupportedOperationException("TmpExtremity.isUserChange");
        }

        @Override
        public boolean isPureIndent() {
            throw new UnsupportedOperationException("TmpExtremity.isPureIndent");
        }

        @Override
        public boolean isReindent() {
            throw new UnsupportedOperationException("TmpExtremity.isReindent");
        }

        @Override
        public boolean includeRealChange() {
            throw new UnsupportedOperationException("TmpExtremity.includeRealChange");
        }

        @Override
        public Iterator subNodes(boolean byStopOrder) {
            throw new UnsupportedOperationException("TmpExtremity.subNodes");
        }

        @Override
        public Iterator warnings() {
            throw new UnsupportedOperationException("TmpExtremity.warnings");
        }

        @Override
        public TextSegmentExtremity getHead() {
            throw new UnsupportedOperationException("TmpExtremity.getHead");
        }

        @Override
        public TextNode getIncludingNode() {
            throw new UnsupportedOperationException("TmpExtremity.getIncludingNode");
        }

        @Override
        public TextSegmentExtremity getTail() {
            throw new UnsupportedOperationException("TmpExtremity.getTail");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("TmpExtremity.isEmpty");
        }

        @Override
        public boolean isGeneratedCode() {
            throw new UnsupportedOperationException("TmpExtremity.isGeneratedCode");
        }

        @Override
        public boolean isUserCode() {
            throw new UnsupportedOperationException("TmpExtremity.isUserCode");
        }

        @Override
        public int length() {
            throw new UnsupportedOperationException("TmpExtremity.length");
        }

        @Override
        public int startIndex() {
            throw new UnsupportedOperationException("TmpExtremity.startIndex");
        }

        @Override
        public int stopIndex() {
            throw new UnsupportedOperationException("TmpExtremity.stopIndex");
        }

        @Override
        public Iterator subSegments(boolean collate, boolean skipEmpty, boolean reverseOrder) {
            throw new UnsupportedOperationException("TmpExtremity.subSegments");
        }

        @Override
        public CharSequence text() {
            throw new UnsupportedOperationException("TmpExtremity.text");
        }

        @Override
        public TextNode commonAncestorWith(TextNode node) {
            throw new UnsupportedOperationException("TmpExtremity.commonAncestorWith");
        }

        @Override
        public boolean restoreGeneratedCode() {
            throw new UnsupportedOperationException("TmpExtremity.restoreGeneratedCode");
        }

        @Override
        public boolean isParentOfHiddenOverride() {
            throw new UnsupportedOperationException("TmpExtremity.isParentOfHiddenOverride");
        }

        @Override
        public boolean isParentOfHiddenReindent() {
            throw new UnsupportedOperationException("TmpExtremity.isParentOfHiddenReindent");
        }

        @Override
        public void refreshParentHiddenAttributes() {
            throw new UnsupportedOperationException("TmpExtremity.refreshParentHiddenAttributes");
        }
    }
}

