/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.editor.core;

import com.ibm.pdp.engine.draft.changes.MatchingExtension;
import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.changes.TextSegmentExtremity;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.containers.ArraySortedSet;
import java.io.Serializable;
import java.util.Iterator;

public class TextChangeHandler
implements TextEventHandler,
Serializable {
    protected UserChangesMgr mixer;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextChangeHandler() {
    }

    public TextChangeHandler(SourceCodeMixer aMixer) {
        this.mixer = (UserChangesMgr)aMixer;
    }

    @Override
    public SourceCodeMixer getSourceCodeMixer() {
        return this.mixer;
    }

    @Override
    public void setSourceCodeMixer(SourceCodeMixer newMixer) {
        this.mixer = (UserChangesMgr)newMixer;
    }

    @Override
    public void replaceText(int startIndex, int stopIndex, CharSequence text) {
        CharSequence oldText = this.mixer.text().subSequence(startIndex, stopIndex);
        if (!this.intervalFullyIncludedInUserCode(startIndex, stopIndex)) {
            this.createNecessaryUserNodes(startIndex, stopIndex);
        }
        this.replaceTextInUserCode(startIndex, stopIndex, text);
        if (this.mixer.matchingExtension != null) {
            this.mixer.matchingExtension.textChanged(startIndex, oldText, text);
        }
        this.mixer.mustSimplifyChanges = true;
    }

    protected boolean intervalFullyIncludedInUserCode(int startIndex, int stopIndex) {
        if (startIndex == stopIndex) {
            return this.indexTouchesUserCode(startIndex);
        }
        Iterator segments = this.mixer.segments(startIndex, stopIndex, false, true, false);
        while (segments.hasNext()) {
            TextSegment segment = (TextSegment)segments.next();
            if (!segment.isGeneratedCode() || !this.notEmptyIntersection(startIndex, stopIndex, segment.startIndex(), segment.stopIndex())) continue;
            return false;
        }
        return true;
    }

    protected boolean notEmptyIntersection(int start1, int stop1, int start2, int stop2) {
        return start1 != stop1 && start2 != stop2 && (start1 <= start2 ? start2 < stop1 : start1 < stop2);
    }

    protected boolean indexTouchesUserCode(int index) {
        Iterator segments = this.mixer.segments(index, index, false, false, false);
        while (segments.hasNext()) {
            if (!((TextSegment)segments.next()).isUserCode()) continue;
            return true;
        }
        return false;
    }

    protected void createNecessaryUserNodes(int startIndex, int stopIndex) {
        if (startIndex == stopIndex) {
            this.createUserNodeAt(startIndex);
            return;
        }
        this.doNecessaryOverrides(startIndex, stopIndex);
        this.doNecessaryInsertions(startIndex, stopIndex);
    }

    protected void createUserNodeAt(int index) {
        TextSegmentExtremity extremity = this.findNecessaryInsertion(index);
        if (extremity == null) {
            UserChangesMgr.Node node = (UserChangesMgr.Node)this.mixer.includingNode(index, index);
            this.mixer.overrideNode(node, node.text());
            return;
        }
        GeneratedTag tag = extremity.getNode().getTag();
        if (extremity.isStart()) {
            this.mixer.setTextAt(tag, -1, tag.getBlanksBefore());
        } else {
            this.mixer.setTextAt(tag, 1, tag.getBlanksAfter());
        }
    }

    protected TextSegmentExtremity findNecessaryInsertion(int index) {
        int minDepth = Integer.MAX_VALUE;
        TextSegmentExtremity e = null;
        Iterator segments = this.mixer.segments(index, index, false, false, false);
        while (segments.hasNext()) {
            TextSegment segment = (TextSegment)segments.next();
            TextSegmentExtremity head = segment.getHead();
            TextSegmentExtremity tail = segment.getTail();
            TextNode headNode = head.getNode();
            TextNode tailNode = tail.getNode();
            if (headNode.getPosition() == 0 && headNode.getDepth() < minDepth && (head.isStart() ? index <= head.index() && index >= head.index() - headNode.getTag().nbBlanksBefore() : index >= head.index() && index <= head.index() + headNode.getTag().nbBlanksAfter())) {
                e = head;
                minDepth = headNode.getDepth();
            }
            if (tailNode.getPosition() != 0 || tailNode.getDepth() >= minDepth || !(tail.isStart() ? index <= tail.index() && index >= tail.index() - tailNode.getTag().nbBlanksBefore() : index >= tail.index() && index <= tail.index() + tailNode.getTag().nbBlanksAfter())) continue;
            e = tail;
            minDepth = tailNode.getDepth();
        }
        return e;
    }

    protected void doNecessaryOverrides(int startIndex, int stopIndex) {
        ArraySortedSet toOverride = new ArraySortedSet();
        Iterator segments = this.mixer.segments(startIndex, stopIndex, false, false, false);
        while (segments.hasNext()) {
            TextSegment segment = (TextSegment)segments.next();
            TextSegmentExtremity extremityToOverride = this.mustDoOverride(startIndex, stopIndex, segment);
            if (extremityToOverride == null) continue;
            toOverride.add((Object)extremityToOverride);
        }
        UserChangesMgr.Node previousNode = null;
        Iterator overrides = toOverride.iterator();
        ArraySortedSet parentsToOverride = null;
        while (overrides.hasNext()) {
            UserChangesMgr.Node node = (UserChangesMgr.Node)((TextSegmentExtremity)overrides.next()).getNode();
            if (previousNode != null && previousNode.isAncestorOf(node)) continue;
            this.mixer.overrideNode(node, node.text());
            UserChangesMgr.Node parent = node.parent;
            if (parent != null && parent.tag.tokensTotalLength() == 0) {
                if (parentsToOverride == null) {
                    parentsToOverride = new ArraySortedSet();
                }
                parentsToOverride.add((Object)parent.getHead());
            }
            previousNode = node;
        }
        if (parentsToOverride != null) {
            this.overrideIfNecessary(parentsToOverride.iterator());
        }
    }

    protected TextSegmentExtremity mustDoOverride(int startIndex, int stopIndex, TextSegment segment) {
        int stopInSegment;
        if (segment.isUserCode() || segment.length() == 0) {
            return null;
        }
        int startInSegment = Math.max(startIndex, segment.startIndex());
        if (startInSegment >= (stopInSegment = Math.min(stopIndex, segment.stopIndex()))) {
            return null;
        }
        if (segment.getHead().isStart() && segment.getTail().isStop()) {
            return segment.getHead();
        }
        TextNode includingNode = segment.getIncludingNode();
        if (includingNode.startIndex() >= startIndex && includingNode.stopIndex() <= stopIndex) {
            return includingNode.getHead();
        }
        if (this.blankInterval(startInSegment, stopInSegment)) {
            TextNode tailNode;
            TextNode headNode;
            TextSegmentExtremity head = segment.getHead();
            if (head.isStop() && (headNode = head.getNode()).getPosition() == 0 && head.index() + headNode.getTag().nbBlanksAfter() >= stopInSegment) {
                return null;
            }
            TextSegmentExtremity tail = segment.getTail();
            if (tail.isStart() && (tailNode = tail.getNode()).getPosition() == 0 && tail.index() - tailNode.getTag().nbBlanksBefore() <= startInSegment) {
                return null;
            }
        }
        return includingNode.getHead();
    }

    protected boolean blankInterval(int start, int stop) {
        MatchingExtension matchingExtension = this.mixer.getMatchingExtension();
        while (start < stop) {
            if (!matchingExtension.isSignificantChar(start++)) continue;
            return false;
        }
        return true;
    }

    protected void overrideIfNecessary(Iterator nodes) {
        ArraySortedSet parentsToOverride = null;
        while (nodes.hasNext()) {
            UserChangesMgr.Node node = (UserChangesMgr.Node)nodes.next();
            int count = node.tag.sons().size();
            if (node.isUserChange() || node.hasUserChangeAncestor() || node.mixedContentCount < count) continue;
            Iterator subTags = node.tag.sons().iterator();
            while (subTags.hasNext()) {
                if (this.mixer.getNodeAtPosition((GeneratedTag)subTags.next(), 0, true) == null) break;
                --count;
            }
            if (count != 0) continue;
            this.mixer.overrideNode(node, node.text());
            UserChangesMgr.Node parent = node.parent;
            if (parent == null || parent.tag.tokensTotalLength() != 0) continue;
            if (parentsToOverride == null) {
                parentsToOverride = new ArraySortedSet();
            }
            parentsToOverride.add((Object)parent.getHead());
        }
        if (parentsToOverride != null) {
            this.overrideIfNecessary(parentsToOverride.iterator());
        }
    }

    protected void doNecessaryInsertions(int startIndex, int stopIndex) {
        ArraySortedSet toInsertBeforeOrAfter = new ArraySortedSet();
        Iterator segments = this.mixer.segments(startIndex, stopIndex, false, true, false);
        while (segments.hasNext()) {
            TextSegmentExtremity extremity = this.mustDoInsertion(startIndex, stopIndex, (TextSegment)segments.next());
            if (extremity == null) continue;
            toInsertBeforeOrAfter.add((Object)extremity);
        }
        for (TextSegmentExtremity extremity : toInsertBeforeOrAfter) {
            GeneratedTag tag = extremity.getNode().getTag();
            if (extremity.isStart()) {
                this.mixer.setTextAt(tag, -1, tag.getBlanksBefore());
                continue;
            }
            this.mixer.setTextAt(tag, 1, tag.getBlanksAfter());
        }
    }

    protected TextSegmentExtremity mustDoInsertion(int startIndex, int stopIndex, TextSegment segment) {
        TextNode tailNode;
        TextNode headNode;
        int stopInSegment;
        if (segment.isUserCode()) {
            return null;
        }
        int startInSegment = Math.max(startIndex, segment.startIndex());
        if (startInSegment >= (stopInSegment = Math.min(stopIndex, segment.stopIndex()))) {
            return null;
        }
        if (!this.blankInterval(startInSegment, stopInSegment)) {
            throw new RuntimeException("Should never occur (overrides not done properly)");
        }
        if (segment.getHead().isStart() && segment.getTail().isStop()) {
            throw new RuntimeException("Should never occur (overrides not done properly)");
        }
        TextSegmentExtremity head = segment.getHead();
        if (head.isStop() && (headNode = head.getNode()).getPosition() == 0 && head.index() + headNode.getTag().nbBlanksAfter() >= stopInSegment) {
            return head;
        }
        TextSegmentExtremity tail = segment.getTail();
        if (tail.isStart() && (tailNode = tail.getNode()).getPosition() == 0 && tail.index() - tailNode.getTag().nbBlanksBefore() <= startInSegment) {
            return tail;
        }
        throw new RuntimeException("Should never occur (overrides not done properly)");
    }

    protected void replaceTextInUserCode(int startIndex, int stopIndex, CharSequence text) {
        if (startIndex == stopIndex) {
            this.insertTextInUserCode(startIndex, text);
            return;
        }
        UserChangesMgr.Node includingNode = (UserChangesMgr.Node)this.mixer.includingNode(startIndex, stopIndex);
        if (includingNode != null && includingNode.isUserCode()) {
            this.replaceTextInUserNode(includingNode, startIndex, stopIndex, text);
            return;
        }
        UserChangesMgr.Node previousUserNode = null;
        Iterator userExtremities = this.mixer.userExtremities.subSet(this.mixer.newIndexRangeComparator(startIndex, stopIndex)).iterator();
        while (userExtremities.hasNext() && startIndex < stopIndex) {
            int toInsertInNode;
            TextSegmentExtremity extrem = (TextSegmentExtremity)userExtremities.next();
            UserChangesMgr.Node userNode = (UserChangesMgr.Node)extrem.getNode();
            if (userNode == previousUserNode) continue;
            int toRemoveLength = stopIndex - startIndex;
            int indexInNode = startIndex - userNode.start;
            int userNodeLength = userNode.text.length();
            int toRemoveInNode = userNodeLength - indexInNode;
            if (toRemoveInNode > toRemoveLength) {
                toRemoveInNode = toRemoveLength;
            }
            if ((toInsertInNode = text.length()) > toRemoveInNode) {
                toInsertInNode = toRemoveInNode;
            }
            CharSequence oldText = userNode.text;
            if (toRemoveInNode != toInsertInNode || !this.same(text, 0, oldText, indexInNode, toRemoveInNode)) {
                StringBuffer newText = new StringBuffer(userNodeLength - toRemoveInNode + toInsertInNode);
                newText.append(oldText.subSequence(0, indexInNode)).append(text.subSequence(0, toInsertInNode)).append(oldText.subSequence(indexInNode + toRemoveInNode, userNodeLength));
                this.mixer.changeText(userNode, newText);
            }
            if (toInsertInNode > 0) {
                text = text.subSequence(toInsertInNode, text.length());
            }
            startIndex += toRemoveInNode;
            previousUserNode = userNode;
        }
        if (text.length() != 0) {
            this.insertTextInUserNode(previousUserNode, startIndex, text);
        }
    }

    protected void replaceTextInUserNode(UserChangesMgr.Node userNode, int startIndex, int stopIndex, CharSequence text) {
        int userNodeLength = userNode.text.length();
        int indexInNode = startIndex - userNode.start;
        int toRemoveLength = stopIndex - startIndex;
        StringBuffer newText = new StringBuffer(userNodeLength - toRemoveLength + text.length());
        newText.append(userNode.text.subSequence(0, indexInNode)).append(text).append(userNode.text.subSequence(indexInNode + toRemoveLength, userNodeLength));
        this.mixer.changeText(userNode, newText);
    }

    protected void insertTextInUserCode(int index, CharSequence text) {
        Iterator segments = this.mixer.segments(index, index, false, false, false);
        while (segments.hasNext()) {
            TextSegment segment = (TextSegment)segments.next();
            if (!segment.isUserCode()) continue;
            this.insertTextInUserNode((UserChangesMgr.Node)segment.getIncludingNode(), index, text);
            return;
        }
    }

    protected void insertTextInUserNode(UserChangesMgr.Node node, int idx, CharSequence text) {
        int oldLength = node.length();
        if (oldLength == 0) {
            this.mixer.changeText(node, text);
            return;
        }
        CharSequence oldText = node.text;
        StringBuffer newText = new StringBuffer(oldLength + text.length());
        newText.append(oldText.subSequence(0, idx -= node.startIndex())).append(text).append(oldText.subSequence(idx, oldLength));
        this.mixer.changeText(node, newText);
    }

    protected boolean same(CharSequence left, CharSequence right) {
        int length = left.length();
        return right.length() == length && this.same(left, 0, right, 0, length);
    }

    protected boolean same(CharSequence left, int leftIdx, CharSequence right, int rightIdx, int length) {
        while (--length >= 0) {
            if (left.charAt(leftIdx++) == right.charAt(rightIdx++)) continue;
            return false;
        }
        return true;
    }
}

