/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.editor.core;

import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegment;
import com.ibm.pdp.engine.draft.changes.TextSegmentExtremity;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.containers.ArraySortedSet;
import com.ibm.pdp.util.containers.ListSortedSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class DocChangeEventHandler
implements TextEventHandler {
    SourceCodeMixer scMixer = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DocChangeEventHandler(SourceCodeMixer scMixer) {
        this.scMixer = scMixer;
    }

    public DocChangeEventHandler() {
    }

    @Override
    public SourceCodeMixer getSourceCodeMixer() {
        return this.scMixer;
    }

    @Override
    public void setSourceCodeMixer(SourceCodeMixer mixer) {
        this.scMixer = mixer;
    }

    @Override
    public void replaceText(int startIndex, int stopIndex, CharSequence text) {
        if (!this.modifyExistingSpecific(startIndex, stopIndex, text) && !this.newInsertion(startIndex, stopIndex, text)) {
            this.otherCase(startIndex, stopIndex, text);
        }
        ((UserChangesMgr)this.scMixer).simplifyUserChanges();
    }

    protected boolean modifyExistingSpecific(int event_begin, int event_end, CharSequence text) {
        Iterator segments = this.scMixer.segments(event_begin, event_end, false, true, false);
        if (!segments.hasNext()) {
            return false;
        }
        TextSegment current = (TextSegment)segments.next();
        if (segments.hasNext()) {
            TextSegment next = (TextSegment)segments.next();
            while (current.isGeneratedCode() && segments.hasNext()) {
                current = next;
                next = (TextSegment)segments.next();
            }
            current = current.isGeneratedCode() ? next : current;
        }
        TextNode parent = current.getIncludingNode();
        if (current.isGeneratedCode() || current.startIndex() > event_begin || current.stopIndex() < event_end) {
            return false;
        }
        if (parent.isUserCode()) {
            CharSequence oldText = parent.text();
            int node_begin = parent.startIndex();
            int node_end = parent.stopIndex();
            String newText = oldText.subSequence(0, event_begin - node_begin).toString() + String.valueOf(text) + oldText.subSequence(event_end - node_begin, node_end - node_begin).toString();
            this.scMixer.setTextAt(parent.getTag(), parent.getPosition(), newText);
            return true;
        }
        return false;
    }

    protected boolean newInsertion(int event_begin, int event_end, CharSequence event_text) {
        Iterator segments = this.scMixer.segments(event_begin, event_end, false, true, false);
        if (!segments.hasNext()) {
            return false;
        }
        TextSegment segment = (TextSegment)segments.next();
        TextSegmentExtremity extremity = this.findExtremity(segment, event_begin, event_end);
        if (segments.hasNext()) {
            while (segments.hasNext() && extremity == null) {
                segment = (TextSegment)segments.next();
                extremity = this.findExtremity(segment, event_begin, event_end);
            }
        }
        if (extremity == null) {
            return false;
        }
        CharSequence segment_text = segment.text();
        int nodeBegin = segment.startIndex();
        int nodeEnd = segment.stopIndex();
        CharSequence replacedText = segment_text.subSequence(event_begin - nodeBegin, event_end - nodeBegin);
        if (!DocChangeEventHandler.isBlankCharSeq(replacedText)) {
            return false;
        }
        CharSequence begin_text = segment_text.subSequence(0, event_begin - nodeBegin);
        CharSequence end_text = segment_text.subSequence(event_end - nodeBegin, nodeEnd - nodeBegin);
        if (extremity.isStop() && DocChangeEventHandler.isBlankCharSeq(begin_text)) {
            String textToInsert = extremity == segment.getTail() ? event_text.toString() : begin_text.toString() + event_text.toString() + DocChangeEventHandler.extractBlanks(end_text, false);
            this.scMixer.setTextAt(extremity.getNode().getTag(), 1, textToInsert);
            return true;
        }
        if (extremity.isStart()) {
            if (extremity == segment.getHead()) {
                this.scMixer.setTextAt(extremity.getNode().getTag(), -1, event_text.toString());
                return true;
            }
            if (DocChangeEventHandler.isBlankCharSeq(end_text)) {
                String textToInsert = DocChangeEventHandler.extractBlanks(begin_text, true) + event_text.toString() + end_text.toString();
                this.scMixer.setTextAt(extremity.getNode().getTag(), -1, textToInsert);
                return true;
            }
        }
        return false;
    }

    protected TextSegmentExtremity findExtremity(TextSegment segment, int event_begin, int event_end) {
        TextSegmentExtremity head = segment.getHead();
        TextSegmentExtremity tail = segment.getTail();
        boolean headStart = head.isStart();
        boolean tailStart = tail.isStart();
        int start = head.index();
        int stop = tail.index();
        CharSequence segmentText = segment.text();
        if (event_begin < start || stop < event_end) {
            return null;
        }
        if (headStart && !tailStart) {
            if (event_end == start) {
                return head;
            }
            return null;
        }
        if (headStart && tailStart) {
            if (event_end == start) {
                return head;
            }
            return tail;
        }
        if (!headStart && tailStart) {
            if (DocChangeEventHandler.isBlankCharSeq(segmentText.subSequence(0, event_begin - start))) {
                return head;
            }
            return tail;
        }
        if (!headStart && !tailStart) {
            if (event_begin < stop) {
                return head;
            }
            if (event_begin == stop && event_end == stop) {
                return tail;
            }
        }
        return null;
    }

    protected static String extractBlanks(CharSequence cs, boolean fromEnd) {
        StringBuffer result = new StringBuffer();
        if (fromEnd) {
            int i = cs.length() - 1;
            boolean weiter = true;
            while (i >= 0 && weiter) {
                char c;
                if (DocChangeEventHandler.isBlankChar(c = cs.charAt(i--))) {
                    result.append(c);
                    continue;
                }
                weiter = false;
            }
            result.reverse();
        } else {
            int max = cs.length();
            int i = 0;
            boolean weiter = true;
            while (i < max && weiter) {
                char c;
                if (DocChangeEventHandler.isBlankChar(c = cs.charAt(i++))) {
                    result.append(c);
                    continue;
                }
                weiter = false;
            }
        }
        return result.toString();
    }

    public static boolean isBlankCharSeq(CharSequence seq) {
        int max = seq.length();
        int i = 0;
        while (i < max) {
            if (!DocChangeEventHandler.isBlankChar(seq.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBlankChar(char c) {
        return Character.isWhitespace(c);
    }

    protected void simplifyTree(TextNode node) {
        if (node.isInsertion()) {
            return;
        }
        if (!node.isOverride()) {
            this.scMixer.setTextAt(node.getTag(), 0, node.text());
        }
        GeneratedTag tag = node.getTag();
        this.simplifyNodeBefore(node, tag);
        this.moveBeforeToOn(tag);
        this.simplifyNodeAfter(node, tag);
        this.moveAfterToOn(tag);
    }

    protected void simplifyNodeBefore(TextNode node, GeneratedTag tag) {
        TextNode nodeBefore = this.scMixer.getNodeAtPosition(tag, -1, false);
        TextSegmentExtremity prev = this.scMixer.previousExtremity(node.getHead());
        int nbBlanks = tag.nbBlanksBefore();
        if (nbBlanks == 0 && nodeBefore == null) {
            this.scMixer.setTextAt(tag, -1, "");
        } else if (nodeBefore == null && prev.index() != node.startIndex()) {
            TextNode parent = node.getParent();
            int parentStart = parent.startIndex();
            int nodeStart = node.startIndex();
            String blanks = parent.text().subSequence(nodeStart - nbBlanks - parentStart, nodeStart - parentStart).toString();
            this.scMixer.setTextAt(tag, -1, blanks);
        }
    }

    protected void moveBeforeToOn(GeneratedTag tag) {
        CharSequence textBefore;
        TextNode nodeBefore = this.scMixer.getNodeAtPosition(tag, -1, true);
        if (nodeBefore != null && !nodeBefore.isEmpty() && DocChangeEventHandler.isBlankCharSeq(textBefore = nodeBefore.text())) {
            StringBuffer result = new StringBuffer(textBefore.toString());
            result.append(this.scMixer.getNodeAtPosition(tag, 0, false).text().toString());
            this.scMixer.setTextAt(tag, -1, "");
            this.scMixer.setTextAt(tag, 0, result.toString());
        }
    }

    protected void simplifyNodeAfter(TextNode node, GeneratedTag tag) {
        TextNode nodeAfter = this.scMixer.getNodeAtPosition(tag, 1, false);
        TextSegmentExtremity next = this.scMixer.nextExtremity(node.getTail());
        int nbBlanks = tag.nbBlanksAfter();
        if (nodeAfter == null && nbBlanks > 0 && next.index() != node.stopIndex()) {
            TextNode parent = node.getParent();
            int parentStart = parent.startIndex();
            int nodeStop = node.stopIndex();
            String blanks = parent.text().subSequence(nodeStop - parentStart, nodeStop - parentStart + nbBlanks).toString();
            this.scMixer.setTextAt(tag, 1, blanks);
        }
    }

    protected void moveAfterToOn(GeneratedTag tag) {
        CharSequence textAfter;
        StringBuffer result = new StringBuffer(this.scMixer.getNodeAtPosition(tag, 0, false).text().toString());
        TextNode nodeAfter = this.scMixer.getNodeAtPosition(tag, 1, true);
        if (nodeAfter != null && DocChangeEventHandler.isBlankCharSeq(textAfter = nodeAfter.text())) {
            result.append(textAfter);
            this.scMixer.setTextAt(tag, 1, "");
            this.scMixer.setTextAt(tag, 0, result.toString());
        }
    }

    protected void otherCase(int event_begin, int event_end, CharSequence text) {
        Iterator segments = this.scMixer.segments(event_begin, event_end, false, true, false);
        Object[] tmp = DocChangeEventHandler.findNodesToModify(event_begin, event_end, segments);
        if (tmp.length == 0) {
            Iterator it = this.scMixer.rootNodes(false);
            TextNode node = (TextNode)it.next();
            this.scMixer.setTextAt(node.getTag(), node.getPosition(), text);
            return;
        }
        SortedSet nodes = (SortedSet)tmp[0];
        TextNode first = (TextNode)nodes.first();
        TextNode last = (TextNode)nodes.last();
        ListSortedSet blanksToEliminate = (ListSortedSet)tmp[1];
        int endIndexBefore = this.totalSize(nodes, blanksToEliminate);
        if (nodes.size() == 1) {
            TextNode the_node = first;
            this.changeInNode(the_node, event_begin, event_end, text);
            int endIndexAfter = this.totalSize(nodes, blanksToEliminate);
            int newEnd = event_end - (endIndexBefore - endIndexAfter);
            this.deleteSegments(blanksToEliminate, event_begin, newEnd);
        } else {
            if (nodes.size() != 0) {
                this.deleteOnSeveralNodes(nodes, event_begin, event_end);
            }
            int endIndexAfter = this.totalSize(nodes, blanksToEliminate);
            int newEnd = event_end - (endIndexBefore - endIndexAfter);
            List<TextNode> nodes2 = this.deleteSegments(blanksToEliminate, event_begin, newEnd);
            if (text.length() > 0) {
                TextNode[] array = nodes.size() == 0 ? nodes2.toArray(new TextNode[0]) : nodes.toArray(new TextNode[0]);
                this.insertTextAt(text, array);
            }
            if (nodes.size() != 0) {
                this.simplifyTree((TextNode)nodes.first());
                this.simplifyTree((TextNode)nodes.last());
            }
        }
        this.cancelInsertionBefore(first);
        this.cancelInsertionAfter(last);
    }

    protected int totalSize(SortedSet nodes, ListSortedSet blanksToEliminate) {
        if (nodes.isEmpty() && blanksToEliminate.isEmpty()) {
            throw Util.rethrow((Throwable)new Exception("tout est vide"));
        }
        if (blanksToEliminate.isEmpty()) {
            return ((TextNode)nodes.last()).stopIndex();
        }
        if (nodes.isEmpty()) {
            return ((TextSegment)blanksToEliminate.last()).stopIndex();
        }
        return Math.max(((TextNode)nodes.last()).stopIndex(), ((TextSegment)blanksToEliminate.last()).stopIndex());
    }

    protected List<TextNode> deleteSegments(ListSortedSet segments, int event_begin, int event_end) {
        ArrayList<TextNode> result = new ArrayList<TextNode>(segments.size());
        for (TextSegment tmp : segments.reverseSet()) {
            if (tmp.isEmpty()) continue;
            result.add(0, this.deleteSegment(tmp, event_begin, event_end));
        }
        return result;
    }

    protected TextNode deleteSegment(TextSegment segment, int event_begin, int event_end) {
        TextSegmentExtremity attach = DocChangeEventHandler.blankAndAnchorable(segment, event_begin, event_end);
        if (attach == null) {
            return null;
        }
        TextNode node = attach.getNode();
        GeneratedTag tag = node.getTag();
        if (attach.isStart()) {
            this.simplifyNodeBefore(node, tag);
            TextNode nodeBefore = this.scMixer.getNodeAtPosition(tag, -1, false);
            String newText = nodeBefore == null ? "" : DocChangeEventHandler.keepOutRange(nodeBefore.text(), nodeBefore.startIndex(), nodeBefore.stopIndex(), event_begin, event_end);
            this.scMixer.setTextAt(tag, -1, newText);
        } else {
            this.simplifyNodeAfter(node, tag);
            TextNode nodeAfter = this.scMixer.getNodeAtPosition(tag, 1, false);
            String newText = nodeAfter == null ? "" : DocChangeEventHandler.keepOutRange(nodeAfter.text(), nodeAfter.startIndex(), nodeAfter.stopIndex(), event_begin, event_end);
            this.scMixer.setTextAt(tag, 1, newText);
        }
        return attach.getNode();
    }

    protected void changeInNode(TextNode the_node, int event_begin, int event_end, CharSequence text) {
        this.simplifyTree(the_node);
        CharSequence oldText = the_node.text();
        int parent_begin = the_node.startIndex();
        int parent_end = the_node.stopIndex();
        StringBuffer newText = new StringBuffer();
        if (parent_begin < event_begin) {
            String str = DocChangeEventHandler.keepInRange(oldText, parent_begin, parent_end, parent_begin - 1, event_begin).toString();
            newText.append(str);
        }
        newText.append(text);
        if (parent_end > event_end) {
            String str1 = DocChangeEventHandler.keepInRange(oldText, parent_begin, parent_end, event_end, parent_end + 1).toString();
            newText.append(str1);
        }
        this.scMixer.setTextAt(the_node.getTag(), the_node.getPosition(), newText.toString());
    }

    protected void deleteOnSeveralNodes(SortedSet nodes, int event_begin, int event_end) {
        TextNode current;
        Iterator nodesIt = nodes.iterator();
        TextNode last = (TextNode)nodes.last();
        if (last.stopIndex() <= event_end) {
            this.simplifyTree(last);
        }
        CharSequence oldText = last.text();
        String newText = DocChangeEventHandler.keepOutRange(oldText, last.startIndex(), last.stopIndex(), event_begin, event_end);
        this.scMixer.setTextAt(last.getTag(), last.getPosition(), newText);
        TextNode first = current = ((TextSegmentExtremity)nodesIt.next()).getNode();
        TextNode next = (TextNode)nodesIt.next();
        while (nodesIt.hasNext()) {
            if (!current.isEmpty() && current.startIndex() >= event_begin) {
                this.scMixer.setTextAt(current.getTag(), current.getPosition(), "");
            }
            this.computeBlankBetweenNodes(current, next);
            current = next;
            next = (TextNode)nodesIt.next();
        }
        if (!current.isEmpty() && current.startIndex() >= event_begin) {
            this.scMixer.setTextAt(current.getTag(), current.getPosition(), "");
        }
        this.computeBlankBetweenNodes(current, last);
        if (first.startIndex() > event_begin) {
            this.simplifyTree(first);
        }
        oldText = first.text();
        newText = DocChangeEventHandler.keepOutRange(oldText, first.startIndex(), first.stopIndex(), event_begin, event_end);
        this.scMixer.setTextAt(first.getTag(), first.getPosition(), newText);
    }

    protected void insertTextAt(CharSequence text, TextNode[] at) {
        TextNode current;
        int size = at.length;
        if (size == 0 || size == 1 && !at[0].isEmpty()) {
            throw Util.rethrow((Throwable)new Exception("No valid insertion point."));
        }
        int i = 0;
        while (i < size) {
            current = at[i];
            if (!current.isInsertion() && current.isEmpty()) {
                this.scMixer.setTextAt(current.getTag(), 0, text);
                return;
            }
            ++i;
        }
        if (size >= 2 && ((current = at[0]).isOverride() || current.isInsertion() && !current.isEmpty())) {
            this.scMixer.setTextAt(current.getTag(), current.getPosition(), String.valueOf(current.text()) + text.toString());
            return;
        }
        if (size >= 2 && ((current = at[size - 1]).isOverride() || current.isInsertion() && !current.isEmpty())) {
            this.scMixer.setTextAt(current.getTag(), current.getPosition(), text.toString() + String.valueOf(current.text()));
            return;
        }
        throw Util.rethrow((Throwable)new Exception("No insertion point was found."));
    }

    protected void computeBlankBetweenNodes(TextNode first, TextNode second) {
        if (!first.isInsertion() && !this.scMixer.nextExtremity(first.getTail()).getNode().isInsertion()) {
            this.scMixer.setTextAt(first.getTag(), 1, "");
        }
        if (!second.isInsertion() && !this.scMixer.previousExtremity(second.getHead()).getNode().isInsertion()) {
            this.scMixer.setTextAt(second.getTag(), -1, "");
        }
    }

    protected static TextSegmentExtremity blankAndAnchorable(TextSegment seg, int event_begin, int event_end) {
        int seg_begin = seg.startIndex();
        int seg_end = seg.stopIndex();
        CharSequence subSeq = DocChangeEventHandler.keepInRange(seg.text(), seg_begin, seg_end, event_begin, event_end);
        if (!DocChangeEventHandler.isBlankCharSeq(subSeq)) {
            return null;
        }
        TextSegmentExtremity head = seg.getHead();
        if (event_end < seg_end && head.isStop()) {
            return head;
        }
        TextSegmentExtremity tail = seg.getTail();
        if (seg_begin < event_begin && tail.isStart()) {
            return tail;
        }
        if (head.isStop()) {
            return head;
        }
        if (tail.isStart()) {
            return tail;
        }
        return null;
    }

    protected static Object[] findNodesToModify(int event_begin, int event_end, Iterator segments) {
        TreeSet result = new TreeSet();
        ArraySortedSet otherBlanks = new ArraySortedSet((Comparator)new SegmentCompator());
        TextSegment first = null;
        TextSegment next = null;
        TextSegment last = null;
        if (!segments.hasNext()) {
            return new Object[0];
        }
        next = last = (TextSegment)segments.next();
        first = last;
        if (segments.hasNext()) {
            next = last = (TextSegment)segments.next();
        }
        while (segments.hasNext()) {
            last = (TextSegment)segments.next();
            if (next.isUserCode() || DocChangeEventHandler.blankAndAnchorable(next, event_begin, event_end) == null) {
                DocChangeEventHandler.addNode(next.getIncludingNode(), result);
            } else {
                otherBlanks.add((Object)next);
            }
            next = last;
        }
        if (first.isUserCode() || first == last) {
            DocChangeEventHandler.addNode(first.getIncludingNode(), result);
        } else {
            CharSequence firstText = first.text();
            int firstBegin = first.startIndex();
            if (firstBegin < event_begin) {
                firstText = DocChangeEventHandler.keepInRange(firstText, firstBegin, first.stopIndex(), event_begin, event_end);
            }
            if (!DocChangeEventHandler.isBlankCharSeq(firstText) || !first.getTail().isStart()) {
                DocChangeEventHandler.addNode(first.getIncludingNode(), result);
            } else if (first.stopIndex() > event_begin) {
                otherBlanks.add((Object)first);
            }
        }
        if (last != first) {
            if (last.isUserCode()) {
                DocChangeEventHandler.addNode(last.getIncludingNode(), result);
            } else {
                CharSequence lastText = last.text();
                int lastEnd = last.stopIndex();
                if (lastEnd > event_end) {
                    lastText = DocChangeEventHandler.keepInRange(lastText, last.startIndex(), lastEnd, event_begin, event_end);
                }
                if (!DocChangeEventHandler.isBlankCharSeq(lastText) || last.getHead().isStart()) {
                    DocChangeEventHandler.addNode(last.getIncludingNode(), result);
                } else if (last.startIndex() < event_end) {
                    otherBlanks.add((Object)last);
                }
            }
        }
        DocChangeEventHandler.removeIncludedBlanks((ListSortedSet)otherBlanks, result);
        return new Object[]{result, otherBlanks};
    }

    protected static void removeIncludedBlanks(ListSortedSet otherBlanks, SortedSet nodes) {
        Iterator it = otherBlanks.iterator();
        ArrayList<TextSegment> segToDelete = new ArrayList<TextSegment>();
        while (it.hasNext()) {
            TextSegment tmp = (TextSegment)it.next();
            TextNode includingNode = DocChangeEventHandler.isNodeIncludedIn(tmp.getIncludingNode(), nodes);
            if (includingNode == null) continue;
            segToDelete.add(tmp);
        }
        otherBlanks.removeAll(segToDelete);
    }

    /*
     * Unable to fully structure code
     */
    protected static TextNode isNodeIncludedIn(TextNode node, SortedSet nodes) {
        it = nodes.iterator();
        if (!nodes.contains(node)) ** GOTO lbl7
        return node;
lbl-1000:
        // 1 sources

        {
            tmp = (TextNode)it.next();
            if (node != tmp && !tmp.isAncestorOf(node)) continue;
            return tmp;
lbl7:
            // 2 sources

            ** while (it.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    public static void addNode(TextNode node, SortedSet set) {
        if (set.contains(node)) {
            return;
        }
        Iterator it = set.iterator();
        boolean isNodeIncluded = false;
        while (!isNodeIncluded && it.hasNext()) {
            TextNode next = (TextNode)it.next();
            if (!next.isAncestorOf(node)) continue;
            isNodeIncluded = true;
        }
        if (isNodeIncluded) {
            return;
        }
        it = set.iterator();
        ArrayList<TextNode> toRemove = new ArrayList<TextNode>();
        while (it.hasNext()) {
            TextNode next = (TextNode)it.next();
            if (!node.isAncestorOf(next)) continue;
            toRemove.add(next);
        }
        set.removeAll(toRemove);
        set.add(node);
    }

    protected static CharSequence keepInRange(CharSequence cs, int begin, int end, int range_begin, int range_end) {
        CharSequence result = cs;
        if (begin <= range_end && range_end < end) {
            result = result.subSequence(0, range_end - begin);
        }
        if (begin < range_begin && range_begin <= end) {
            result = result.subSequence(range_begin - begin, result.length());
        }
        return result;
    }

    protected static String keepOutRange(CharSequence cs, int begin, int end, int range_begin, int range_end) {
        StringBuffer result = new StringBuffer();
        if (range_begin > begin && range_begin <= end) {
            result.append(cs.subSequence(0, range_begin - begin));
        }
        if (range_end < end && range_end >= begin) {
            result.append(cs.subSequence(range_end - begin, end - begin));
        }
        return result.toString();
    }

    protected void cancelInsertionBefore(TextNode node) {
        if (!node.isOverride()) {
            return;
        }
        GeneratedTag tag = node.getTag();
        TextNode nodeBefore = this.scMixer.getNodeAtPosition(tag, -1, false);
        if (nodeBefore == null || !nodeBefore.isEmpty()) {
            return;
        }
        int nbBlanksBefore = tag.nbBlanksBefore();
        String originalBlanksBegin = tag.getBlanksBefore().toString() + DocChangeEventHandler.extractBlanks(tag.getText(), false);
        CharSequence text = node.text();
        String actualBlanksBegin = DocChangeEventHandler.extractBlanks(node.text(), false);
        if (originalBlanksBegin.equals(actualBlanksBegin)) {
            this.scMixer.setTextAt(tag, -1, null);
            this.scMixer.setTextAt(tag, 0, text.subSequence(nbBlanksBefore, text.length()));
        }
    }

    protected void cancelInsertionAfter(TextNode node) {
        if (!node.isOverride()) {
            return;
        }
        GeneratedTag tag = node.getTag();
        TextNode nodeAfter = this.scMixer.getNodeAtPosition(tag, 1, false);
        if (nodeAfter == null || !nodeAfter.isEmpty()) {
            return;
        }
        int nbBlanksAfter = tag.nbBlanksAfter();
        String originalBlanksAfter = DocChangeEventHandler.extractBlanks(tag.getText(), true) + tag.getBlanksAfter().toString();
        CharSequence text = node.text();
        String actualBlanksAfter = DocChangeEventHandler.extractBlanks(node.text(), true);
        if (originalBlanksAfter.equals(actualBlanksAfter)) {
            this.scMixer.setTextAt(tag, 1, null);
            this.scMixer.setTextAt(tag, 0, text.subSequence(0, text.length() - nbBlanksAfter));
        }
    }

    public static class SegmentCompator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TextSegment s1 = (TextSegment)o1;
            TextSegment s2 = (TextSegment)o2;
            return s1.stopIndex() - s2.stopIndex();
        }
    }
}

