/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.editor.core;

public class BitSequence {
    protected int nbBits;
    protected long[] bits;
    protected static final long ALL_1 = -1L;
    protected static final long ALL_0 = 0L;
    protected static final long[] masks;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        long[] lArray = new long[65];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        lArray[32] = 0xFFFFFFFFL;
        lArray[33] = 0x1FFFFFFFFL;
        lArray[34] = 0x3FFFFFFFFL;
        lArray[35] = 0x7FFFFFFFFL;
        lArray[36] = 0xFFFFFFFFFL;
        lArray[37] = 0x1FFFFFFFFFL;
        lArray[38] = 0x3FFFFFFFFFL;
        lArray[39] = 0x7FFFFFFFFFL;
        lArray[40] = 0xFFFFFFFFFFL;
        lArray[41] = 0x1FFFFFFFFFFL;
        lArray[42] = 0x3FFFFFFFFFFL;
        lArray[43] = 0x7FFFFFFFFFFL;
        lArray[44] = 0xFFFFFFFFFFFL;
        lArray[45] = 0x1FFFFFFFFFFFL;
        lArray[46] = 0x3FFFFFFFFFFFL;
        lArray[47] = 0x7FFFFFFFFFFFL;
        lArray[48] = 0xFFFFFFFFFFFFL;
        lArray[49] = 0x1FFFFFFFFFFFFL;
        lArray[50] = 0x3FFFFFFFFFFFFL;
        lArray[51] = 0x7FFFFFFFFFFFFL;
        lArray[52] = 0xFFFFFFFFFFFFFL;
        lArray[53] = 0x1FFFFFFFFFFFFFL;
        lArray[54] = 0x3FFFFFFFFFFFFFL;
        lArray[55] = 0x7FFFFFFFFFFFFFL;
        lArray[56] = 0xFFFFFFFFFFFFFFL;
        lArray[57] = 0x1FFFFFFFFFFFFFFL;
        lArray[58] = 0x3FFFFFFFFFFFFFFL;
        lArray[59] = 0x7FFFFFFFFFFFFFFL;
        lArray[60] = 0xFFFFFFFFFFFFFFFL;
        lArray[61] = 0x1FFFFFFFFFFFFFFFL;
        lArray[62] = 0x3FFFFFFFFFFFFFFFL;
        lArray[63] = Long.MAX_VALUE;
        lArray[64] = -1L;
        masks = lArray;
    }

    protected static long lowBits(int nbBits) {
        return masks[nbBits];
    }

    protected static long highBits(int nbBits) {
        return masks[64 - nbBits] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    protected static long bitsInterval(int fromBitIdx, int toBitIdx) {
        return masks[toBitIdx - fromBitIdx] << fromBitIdx;
    }

    protected static long composeLong(int beginIdx, long first, long second) {
        return first >>> beginIdx | second & masks[beginIdx];
    }

    protected static long composeLong(long header, int headerLength, int beginIdx, long first, long second) {
        return 0L;
    }

    public BitSequence() {
    }

    public BitSequence(int nbOfBits) {
        this.bits = new long[this.nbLongToStore(nbOfBits)];
        this.nbBits = nbOfBits;
    }

    public int size() {
        return this.nbBits;
    }

    public boolean getBit(int bitIdx) {
        return (this.bits[bitIdx / 64] & (long)(1 << bitIdx % 64)) != 0L;
    }

    public void setBit(int bitIdx) {
        int n = bitIdx / 64;
        this.bits[n] = this.bits[n] | (long)(1 << bitIdx % 64);
    }

    public void clearBit(int bitIdx) {
        int n = bitIdx / 64;
        this.bits[n] = this.bits[n] & (long)(~(1 << bitIdx % 64));
    }

    public void toggleBit(int bitIdx) {
        int n = bitIdx / 64;
        this.bits[n] = this.bits[n] ^ (long)(1 << bitIdx % 64);
    }

    public void setBit(int bitIdx, boolean newValue) {
        if (newValue) {
            this.setBit(bitIdx);
        } else {
            this.clearBit(bitIdx);
        }
    }

    public void set(int beginIdx, int endIdx) {
        int beginWordIdx = beginIdx / 64;
        int beginShift = beginIdx % 64;
        int endWordIdx = endIdx / 64;
        int endShift = endIdx % 64;
        if (beginWordIdx == endWordIdx) {
            int n = beginWordIdx;
            this.bits[n] = this.bits[n] | BitSequence.bitsInterval(beginShift, endShift);
            return;
        }
        if (beginShift > 0) {
            int n = beginWordIdx++;
            this.bits[n] = this.bits[n] | BitSequence.lowBits(beginShift) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (endShift > 0) {
            int n = endWordIdx;
            this.bits[n] = this.bits[n] | BitSequence.lowBits(endShift);
        }
        while (beginWordIdx < endWordIdx) {
            this.bits[beginWordIdx++] = -1L;
        }
    }

    public void clear(int beginIdx, int endIdx) {
        long mask;
        int beginWordIdx = beginIdx / 64;
        int beginShift = beginIdx % 64;
        int endWordIdx = endIdx / 64;
        int endShift = endIdx % 64;
        if (beginWordIdx == endWordIdx) {
            int n = beginWordIdx;
            this.bits[n] = this.bits[n] & (BitSequence.bitsInterval(beginShift, endShift) ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        if (beginShift > 0) {
            mask = masks[beginShift];
            int n = beginWordIdx++;
            this.bits[n] = this.bits[n] & BitSequence.lowBits(beginShift);
        }
        if (endShift > 0) {
            mask = masks[endShift] ^ 0xFFFFFFFFFFFFFFFFL;
            int n = endWordIdx;
            this.bits[n] = this.bits[n] & mask;
        }
        while (beginWordIdx < endWordIdx) {
            this.bits[beginWordIdx++] = 0L;
        }
    }

    public void toggle(int beginIdx, int endIdx) {
        long mask;
        int beginWordIdx = beginIdx / 64;
        int beginShift = beginIdx % 64;
        int endWordIdx = endIdx / 64;
        int endShift = endIdx % 64;
        if (beginWordIdx == endWordIdx) {
            int nbBits = endShift - beginShift;
            if (nbBits > 0) {
                long mask2 = masks[nbBits - 1];
                if (beginIdx > 0) {
                    mask2 <<= beginIdx;
                }
                int n = beginWordIdx;
                this.bits[n] = this.bits[n] ^ mask2;
            }
            return;
        }
        if (beginShift > 0) {
            mask = masks[beginShift] ^ 0xFFFFFFFFFFFFFFFFL;
            int n = beginWordIdx++;
            this.bits[n] = this.bits[n] ^ mask;
        }
        if (endShift > 0) {
            mask = masks[endShift];
            int n = endWordIdx;
            this.bits[n] = this.bits[n] ^ mask;
        }
        while (beginWordIdx < endWordIdx) {
            int n = beginWordIdx++;
            this.bits[n] = this.bits[n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void set(int beginIdx, int endIdx, boolean newValue) {
        if (newValue) {
            this.set(beginIdx, endIdx);
        } else {
            this.clear(beginIdx, endIdx);
        }
    }

    public void remove(int beginIdx, int endIdx) {
        long mask;
        int beginWordIdx = beginIdx / 64;
        int beginShift = beginIdx % 64;
        int endWordIdx = endIdx / 64;
        int endShift = endIdx % 64;
        if (beginWordIdx == endWordIdx) {
            int nbBits = endShift - beginShift;
            if (nbBits > 0) {
                long mask2 = masks[nbBits - 1];
                if (beginIdx > 0) {
                    mask2 <<= beginIdx;
                }
                int n = beginWordIdx;
                this.bits[n] = this.bits[n] | mask2;
            }
            return;
        }
        if (beginShift > 0) {
            mask = masks[beginShift] ^ 0xFFFFFFFFFFFFFFFFL;
            int n = beginWordIdx++;
            this.bits[n] = this.bits[n] | mask;
        }
        if (endShift > 0) {
            mask = masks[endShift];
            int n = endWordIdx;
            this.bits[n] = this.bits[n] | mask;
        }
        while (beginWordIdx < endWordIdx) {
            this.bits[beginWordIdx++] = -1L;
        }
    }

    public void append(boolean value) {
    }

    public void append(boolean value, int nbBits) {
    }

    public void append(BitSequence src) {
    }

    public void append(BitSequence src, int srcBeginIdx, int srcEndIdx) {
    }

    public void insert(int idx, boolean value, int nbBits) {
    }

    public void insert(int idx, BitSequence src) {
    }

    public void insert(int idx, BitSequence src, int srcBeginIdx, int srcEndIdx) {
    }

    public void replace(int beginIdx, int endIdx, BitSequence src) {
    }

    public void replace(int dstBeginIdx, int dstEndIdx, BitSequence src, int srcBeginIdx, int srcEndIdx) {
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.nbBits);
        int maxWord = this.nbBits / 64;
        int wordIdx = 0;
        while (wordIdx < maxWord) {
            long word = this.bits[wordIdx];
            int mask = 1;
            while (mask != 0) {
                str.append((word & (long)mask) == 0L ? (char)'.' : '*');
                mask <<= 1;
            }
            str.append('\n');
            ++wordIdx;
        }
        int stopMask = 1 << this.nbBits % 64;
        int mask = 1;
        while (mask != stopMask) {
            str.append((this.bits[maxWord] & (long)mask) == 0L ? (char)'.' : '*');
            mask <<= 1;
        }
        str.append('\n');
        return str.toString();
    }

    protected void copy(int srcBitIdx, long[] src, int dstBitIdx, long[] dst, int nbBits) {
        if (nbBits == 0) {
            return;
        }
        int srcShift = srcBitIdx % 64;
        int dstShift = dstBitIdx % 64;
        if (srcShift == dstShift) {
            this.copyAligned(srcBitIdx, src, dstBitIdx, dst, nbBits);
            return;
        }
        int cfr_ignored_0 = srcBitIdx / 64;
        int cfr_ignored_1 = dstBitIdx / 64;
    }

    protected void copyAligned(int srcBitIdx, long[] src, int dstBitIdx, long[] dst, int nbBits) {
    }

    protected int nbLongToStore(int nbBits) {
        return (nbBits + 63) / 64;
    }
}

