/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.draft.api.PdpProblem;
import com.ibm.pdp.engine.draft.api.PdpTextProcessor;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class WarningsIterator
implements Iterator,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object nextOne;
    private UserChangesMgr.Node node;
    private List warningList;
    private int nextElementInWarningList;
    private Iterator nodes;
    protected transient PdpTextProcessor processor;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WarningsIterator(PdpTextProcessor textProcessor, Iterator nodes) {
        this.nodes = nodes;
        this.processor = textProcessor;
    }

    private UserChangesMgr.Node findNextNode() {
        while (this.nodes.hasNext()) {
            UserChangesMgr.Node node = (UserChangesMgr.Node)this.nodes.next();
            if (!node.hasWarnings()) continue;
            return node;
        }
        return null;
    }

    private Object findNextOne() {
        if (this.warningList != null && this.nextElementInWarningList < this.warningList.size()) {
            CharSequence seq = (CharSequence)this.warningList.get(this.nextElementInWarningList);
            return this.newPdpProblem(this.node, this.nextElementInWarningList++, seq.toString());
        }
        this.node = this.findNextNode();
        if (this.node == null) {
            return null;
        }
        this.warningList = this.node.getWarnings();
        boolean isNodeChangeControlWarning = this.node.hasChangeControlWarning();
        this.nextElementInWarningList = isNodeChangeControlWarning ? -1 : 0;
        String seq = isNodeChangeControlWarning ? "User change forbidden at this position" : (CharSequence)this.warningList.get(this.nextElementInWarningList);
        return this.newPdpProblem(this.node, this.nextElementInWarningList++, seq.toString());
    }

    protected PdpProblem newPdpProblem(TextNode node, int messageIndex, String message) {
        return new PdpProblem(this.processor, node, messageIndex, message);
    }

    @Override
    public boolean hasNext() {
        if (this.nextOne != null) {
            return true;
        }
        this.nextOne = this.findNextOne();
        return this.nextOne != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("WarningsIterator");
        }
        Object toReturn = this.nextOne;
        this.nextOne = null;
        return toReturn;
    }

    @Override
    public void remove() {
    }
}

