/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.ITextChangeEvent;
import com.ibm.pdp.engine.ITextChangeListener;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.draft.api.PdpGeneratedInfo;
import com.ibm.pdp.engine.draft.api.PdpTextChangedEvent;
import com.ibm.pdp.engine.draft.api.WarningsIterator;
import com.ibm.pdp.engine.draft.changes.MatchingExtension;
import com.ibm.pdp.engine.draft.changes.ReconcileExtension;
import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.changes.TextEventHandler;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.changes.TextSegmentExtremity;
import com.ibm.pdp.engine.draft.editor.core.TextChangeHandler;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedInfoControler;
import com.ibm.pdp.engine.extension.IEditTreeExtension;
import com.ibm.pdp.engine.extension.IMatchingExtension;
import com.ibm.pdp.engine.extension.IReconcileExtension;
import com.ibm.pdp.engine.extension.IReformatExtension;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.events.DefaultEventRedirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;

public class PdpTextProcessor
implements ITextProcessor {
    protected SourceCodeMixer sourceCodeMixer;
    private TextEventHandler textEventHandler;
    private DefaultEventRedirector eventRedirector;
    private WeakHashMap weakListeners;
    private GeneratedInfoControler generatedInfoControler;
    private CharSequence transientText = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpTextProcessor() {
        this.sourceCodeMixer = new UserChangesMgr();
        this.textEventHandler = new TextChangeHandler(this.sourceCodeMixer);
        this.eventRedirector = new DefaultEventRedirector();
    }

    public PdpTextProcessor(SourceCodeMixer scm) {
        this.sourceCodeMixer = scm;
        this.textEventHandler = new TextChangeHandler(scm);
        this.eventRedirector = new DefaultEventRedirector();
    }

    public void initialize(IGeneratedInfo info) {
        throw new UnsupportedOperationException();
    }

    public void addTextChangeListener(ITextChangeListener listener) {
        this.eventRedirector.addPropertyChangeListener((PropertyChangeListener)new PdpTextChangeListener(listener, false));
    }

    public void addTextChangeListener(ITextChangeListener listener, boolean isTransient, boolean isWeak) {
        PdpTextChangeListener pdpTCL = new PdpTextChangeListener(listener, isWeak);
        if (isWeak) {
            if (this.weakListeners == null) {
                this.weakListeners = new WeakHashMap();
            }
            this.weakListeners.put(listener, pdpTCL);
        }
        this.eventRedirector.addPropertyChangeListener((PropertyChangeListener)pdpTCL, isTransient, isWeak);
    }

    public IGeneratedInfo getGeneratedInfo() {
        GeneratedCodeMgr genI = (GeneratedCodeMgr)this.sourceCodeMixer.getGeneratedInfo();
        if (genI == null) {
            return null;
        }
        return ((GeneratedCodeMgr)this.sourceCodeMixer.getGeneratedInfo()).wrap();
    }

    public IMatchingExtension getMatchingExtension() {
        return this.sourceCodeMixer.getMatchingExtension();
    }

    public IReconcileExtension getReconcileExtension() {
        return (IReconcileExtension)this.sourceCodeMixer.getReconcileExtension();
    }

    public IReformatExtension getReformatExtension() {
        return null;
    }

    public int getTextLength() {
        if (this.transientText != null) {
            return this.transientText.length();
        }
        return this.sourceCodeMixer.text().length();
    }

    public CharSequence getText() {
        if (this.transientText != null) {
            return this.transientText;
        }
        return this.sourceCodeMixer.text();
    }

    public Iterator problems() {
        if (this.transientText != null) {
            return Iterators.emptyIterator();
        }
        Iterator nodesIterator = this.sourceCodeMixer.nodes(false);
        return this.newWarningsIterator(nodesIterator);
    }

    public Iterator problems(int beginIdx, int endIdx) {
        if (this.transientText != null) {
            return Iterators.emptyIterator();
        }
        UserChangesMgr ucm = (UserChangesMgr)this.sourceCodeMixer;
        return this.newWarningsIterator(ucm.includedNodes(beginIdx, endIdx, false));
    }

    protected Iterator newWarningsIterator(Iterator nodes) {
        return new WarningsIterator(this, nodes);
    }

    public void removeAllProblems() {
        if (this.transientText != null) {
            return;
        }
        Iterator nodesIterator = this.sourceCodeMixer.nodes(false);
        while (nodesIterator.hasNext()) {
            ((TextNode)nodesIterator.next()).cleanWarnings();
        }
    }

    public void removeTextChangeListener(ITextChangeListener listener) {
        Iterator it = this.eventRedirector.iterator();
        while (it.hasNext()) {
            PropertyChangeListener element = (PropertyChangeListener)it.next();
            if (!(element instanceof PdpTextChangeListener) || ((PdpTextChangeListener)element).getTextChangeListener() != listener) continue;
            if (this.weakListeners != null) {
                this.weakListeners.remove(listener);
            }
            it.remove();
            break;
        }
    }

    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        if (this.transientText != null) {
            int len = this.transientText.length() + endIdx - beginIdx + newText.length();
            StringBuilder sb = new StringBuilder(len);
            sb.append(this.transientText.subSequence(0, beginIdx));
            sb.append(newText);
            sb.append(this.transientText.subSequence(endIdx, this.transientText.length()));
            return;
        }
        CharSequence oldText = this.getText().subSequence(beginIdx, endIdx);
        this.textEventHandler.replaceText(beginIdx, endIdx, newText);
        PdpTextChangedEvent event = new PdpTextChangedEvent(this, oldText, newText, beginIdx);
        this.eventRedirector.propertyChange((PropertyChangeEvent)((Object)event));
    }

    public void restoreGeneratedCode() {
        if (this.transientText != null) {
            return;
        }
        Iterator rootNodes = this.sourceCodeMixer.rootNodes(false);
        while (rootNodes.hasNext()) {
            TextNode rootNode = (TextNode)rootNodes.next();
            rootNode.restoreGeneratedCode();
        }
    }

    public void restoreGeneratedCode(TextNode node) {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        list.add(node);
        this.restoreGeneratedCode(list);
    }

    public void restoreGeneratedCode(int beginIdx, int endIdx) {
        if (this.transientText != null) {
            return;
        }
        Iterator it = ((UserChangesMgr)this.sourceCodeMixer).userExtremitiesInInterval(beginIdx, endIdx).iterator();
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        if (!it.hasNext()) {
            TextSegmentExtremity beforeBeginIdxExtremity = ((UserChangesMgr)this.sourceCodeMixer).extremityBefore(beginIdx);
            if (beforeBeginIdxExtremity == null) {
                return;
            }
            if (beforeBeginIdxExtremity.getNode().isGeneratedCode()) {
                return;
            }
            list.add(beforeBeginIdxExtremity.getNode());
        } else {
            list.add(((TextSegmentExtremity)it.next()).getNode());
            while (it.hasNext()) {
                TextSegmentExtremity tse = (TextSegmentExtremity)it.next();
                if (!tse.isStart()) continue;
                list.add(tse.getNode());
            }
        }
        this.restoreGeneratedCode(list);
    }

    private void restoreGeneratedCode(ArrayList list) {
        TextNode margin;
        TextNode firstNode = (TextNode)list.get(0);
        CharSequence textBeforeRestore = this.getText();
        int oldStartIndex = firstNode.startIndex();
        if (firstNode.isOverride() && (margin = ((UserChangesMgr)this.sourceCodeMixer).getNodeAtPosition(firstNode.getTag(), -1, true)) != null && margin.isPureIndent()) {
            oldStartIndex -= margin.length();
        }
        Iterator it = list.iterator();
        boolean restored = false;
        while (it.hasNext()) {
            TextNode node = (TextNode)it.next();
            boolean nodeRestored = ((UserChangesMgr.Node)node).restoreGeneratedCode(true);
            boolean bl = restored = restored || nodeRestored;
        }
        if (!restored) {
            return;
        }
        CharSequence textAfterRestore = this.getText();
        int afterIndex = textAfterRestore.length() - 1;
        int beforeIndex = textBeforeRestore.length() - 1;
        while (beforeIndex >= oldStartIndex && afterIndex >= oldStartIndex) {
            if (textAfterRestore.charAt(afterIndex) != textBeforeRestore.charAt(beforeIndex)) {
                CharSequence oldText = textBeforeRestore.subSequence(oldStartIndex, beforeIndex + 1);
                CharSequence newText = this.getText().subSequence(oldStartIndex, afterIndex + 1);
                PdpTextChangedEvent event = new PdpTextChangedEvent(this, oldText, newText, oldStartIndex);
                this.eventRedirector.propertyChange((PropertyChangeEvent)((Object)event));
                return;
            }
            --afterIndex;
            --beforeIndex;
        }
        CharSequence oldText = textBeforeRestore.subSequence(oldStartIndex, beforeIndex + 1);
        String newText = afterIndex <= oldStartIndex ? "" : this.getText().subSequence(oldStartIndex, afterIndex + 1);
        PdpTextChangedEvent event = new PdpTextChangedEvent(this, oldText, newText, oldStartIndex);
        this.eventRedirector.propertyChange((PropertyChangeEvent)((Object)event));
    }

    public void fireEvent(PropertyChangeEvent event) {
        this.eventRedirector.propertyChange(event);
    }

    private ITextSegment getTransientSegment() {
        return new com.ibm.pdp.engine.internal.ITextSegment(){

            public CharSequence subSequence(int start, int end) {
                return "";
            }

            public int length() {
                return 0;
            }

            public char charAt(int index) {
                return '\u0000';
            }

            public CharSequence fullText() {
                return "";
            }

            public int endIndex() {
                return 0;
            }

            public int beginIndex() {
                return 0;
            }

            public boolean isRemoved() {
                return false;
            }

            public boolean isReformated() {
                return false;
            }

            public boolean isModified() {
                return false;
            }

            public boolean isInserted() {
                return true;
            }

            public boolean isGenerated() {
                return false;
            }

            public boolean isFromMacro() {
                return false;
            }

            public boolean isEditable() {
                return true;
            }

            public CharSequence generatedText() {
                return null;
            }
        };
    }

    public Iterator segments() {
        if (this.transientText != null) {
            ITextSegment its = this.getTransientSegment();
            ArrayList<ITextSegment> l = new ArrayList<ITextSegment>();
            l.add(its);
            return l.iterator();
        }
        this.checkSimplifyUserChanges();
        return this.sourceCodeMixer.segments(null, null, false, false, false);
    }

    public Iterator segments(int beginIdx, int endIdx) {
        if (this.transientText != null) {
            ITextSegment its = this.getTransientSegment();
            ArrayList<ITextSegment> l = new ArrayList<ITextSegment>();
            l.add(its);
            return l.iterator();
        }
        this.checkSimplifyUserChanges();
        return this.sourceCodeMixer.segments(beginIdx, endIdx, false, false, false);
    }

    public void setGeneratedInfo(IGeneratedInfo info) {
        this.checkSimplifyUserChanges();
        CharSequence oldText = this.getGeneratedInfo() == null ? "" : this.getText();
        if (this.generatedInfoControler == null) {
            this.generatedInfoControler = new GeneratedInfoControler();
        }
        IGeneratedInfo genInfo = this.generatedInfoControler.control(info);
        this.sourceCodeMixer.setGeneratedInfo(((PdpGeneratedInfo)genInfo).getOldGeneratedInfo());
        if (this.transientText != null) {
            this.textEventHandler.replaceText(0, info.getText().length(), this.transientText);
            this.transientText = null;
        }
        PdpTextChangedEvent event = new PdpTextChangedEvent(this, oldText, this.getText(), 0);
        this.eventRedirector.propertyChange((PropertyChangeEvent)((Object)event));
    }

    public void setMatchingExtension(IMatchingExtension newMatchingExtension) {
        this.sourceCodeMixer.setMatchingExtension((MatchingExtension)newMatchingExtension);
    }

    public void setReconcileExtension(IReconcileExtension newReconcileExtension) {
        this.sourceCodeMixer.setReconcileExtension((ReconcileExtension)newReconcileExtension);
    }

    public void setReformatExtension(IReformatExtension newReformatExtension) {
    }

    public void setText(CharSequence newText) {
        if (this.sourceCodeMixer.getGeneratedInfo() == null) {
            this.transientText = newText;
            return;
        }
        if (this.getText() == null) {
            this.replaceText(0, 0, newText);
        } else {
            this.replaceText(0, this.getText().length(), newText);
        }
    }

    public IGeneratedInfo exportAsGeneratedInfo(String rootTagName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public TextEventHandler getTextEventHandler() {
        return this.textEventHandler;
    }

    public void setTextEventHandler(TextEventHandler textEventHandler) {
        this.textEventHandler = textEventHandler;
        this.sourceCodeMixer = textEventHandler.getSourceCodeMixer();
    }

    public IEditTree getEditTree() {
        return null;
    }

    public IEditTreeExtension getEditTreeExtension() {
        return null;
    }

    public void setEditTreeExtension(IEditTreeExtension newEditTreeExtension) {
    }

    protected void checkSimplifyUserChanges() {
        ((UserChangesMgr)this.sourceCodeMixer).checkSimplifyUserChanges();
    }

    public IMicroPatternProcessingContext getMicroPatternProcessingContext() {
        return null;
    }

    public IProblem problem(int beginIdx, int endIdx, String id) {
        return null;
    }

    private class PdpTextChangeListener
    implements PropertyChangeListener,
    Serializable {
        private ITextChangeListener listener;
        private WeakReference weakListener;
        private boolean isWeak;

        private PdpTextChangeListener(ITextChangeListener listener, boolean isWeak) {
            this.isWeak = isWeak;
            if (!isWeak) {
                this.listener = listener;
            } else {
                this.weakListener = new WeakReference<ITextChangeListener>(listener);
            }
        }

        private ITextChangeListener getTextChangeListener() {
            if (this.isWeak) {
                return (ITextChangeListener)this.weakListener.get();
            }
            return this.listener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ITextChangeListener itcl;
            if (evt instanceof ITextChangeEvent && (itcl = this.getTextChangeListener()) != null) {
                itcl.textChanged((ITextChangeEvent)evt);
            }
        }
    }
}

