/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.ITextInterval;
import java.io.Serializable;

public class PdpTextInterval
implements ITextInterval,
CharSequence,
Serializable {
    private int beginIndex;
    private int endIndex;
    private CharSequence fullText;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpTextInterval(int beginIndex, int endIndex, CharSequence fullText) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.fullText = fullText;
    }

    public int beginIndex() {
        return this.beginIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public CharSequence fullText() {
        return this.fullText;
    }

    @Override
    public int length() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public char charAt(int index) {
        return this.fullText.charAt(this.beginIndex + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new PdpTextInterval(this.beginIndex + start, this.beginIndex + end, this.fullText);
    }

    @Override
    public String toString() {
        return this.fullText.subSequence(this.beginIndex, this.endIndex).toString();
    }
}

