/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.ITextChangeEvent;
import com.ibm.pdp.engine.ITextInterval;
import com.ibm.pdp.engine.draft.api.PdpTextInterval;
import com.ibm.pdp.util.events.CharSequenceChangeEvent;

public class PdpTextChangedEvent
extends CharSequenceChangeEvent
implements ITextChangeEvent {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpTextChangedEvent(Object source, CharSequence removedChars, CharSequence addedChars, int idx) {
        super(source, removedChars, addedChars, idx);
    }

    public CharSequence addedText() {
        return this.getAdded();
    }

    public int idx() {
        return this.getIndex();
    }

    public CharSequence removedText() {
        return this.getRemoved();
    }

    public ITextInterval translateInterval(int beginIdx, int endIdx) {
        int beginResult = beginIdx;
        int endResult = endIdx;
        if (endIdx <= this.idx()) {
            beginResult = beginIdx;
            endResult = endIdx;
            return new PdpTextInterval(beginResult, endResult, null);
        }
        if (beginIdx >= this.idx() + this.removedText().length()) {
            beginResult = beginIdx + this.addedText().length() - this.removedText().length();
            endResult = endIdx + this.addedText().length() - this.removedText().length();
            return new PdpTextInterval(beginResult, endResult, null);
        }
        if (this.removedText().length() != 0) {
            beginResult = beginIdx < this.idx() ? beginIdx : this.idx();
            endResult = endIdx >= this.idx() + this.removedText().length() ? endIdx - this.removedText().length() : this.idx();
        }
        if (this.addedText().length() != 0) {
            if (beginResult >= this.idx()) {
                beginResult += this.addedText().length();
            }
            if (endResult > this.idx()) {
                endResult = this.idx();
            }
        }
        return new PdpTextInterval(beginResult, endResult, null);
    }
}

