/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.draft.api.PdpTextChangedEvent;
import com.ibm.pdp.engine.draft.api.PdpTextProcessor;
import com.ibm.pdp.engine.draft.changes.TextNode;
import com.ibm.pdp.engine.draft.editor.core.UserChangesMgr;
import com.ibm.pdp.util.Strings;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PdpProblem
implements IProblem,
Serializable {
    private static final long serialVersionUID = 1L;
    private int messageIndex;
    private TextNode node;
    private String message;
    protected transient PdpTextProcessor processor;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpProblem(PdpTextProcessor processor, TextNode node, int messageIndex, String message) {
        this.node = node;
        this.messageIndex = messageIndex;
        this.processor = processor;
        this.message = message == null ? (String)((UserChangesMgr.Node)node).getWarnings().get(messageIndex) : message;
    }

    public Iterator<IProblem.IQuickFixAction> actions() {
        UserChangesMgr.Node n;
        if (this.messageIndex == -1) {
            PdpRestoreGeneratedQuickFixAction fix = new PdpRestoreGeneratedQuickFixAction();
            List<PdpRestoreGeneratedQuickFixAction> list = Collections.singletonList(fix);
            return list.iterator();
        }
        ArrayList<Serializable> fixes = new ArrayList<Serializable>(4);
        fixes.add(new PdpShowGeneratedCodeQuickFixAction());
        if (this.message != null && this.message.equals("User code has been lost")) {
            fixes.add(new PdpShowLostCodeQuickFixAction());
        }
        if (!Strings.sameCharSequences((CharSequence)(n = (UserChangesMgr.Node)this.node).getGeneratedText(), (CharSequence)n.getReconciledText())) {
            fixes.add(new PdpShowReconciledCodeQuickFixAction());
        }
        fixes.add(new PdpRemoveQuickFixAction());
        return fixes.iterator();
    }

    public String code() {
        return null;
    }

    public boolean isError() {
        return false;
    }

    public boolean isWarning() {
        return true;
    }

    public String message() {
        return this.message;
    }

    public String[] parameters() {
        return null;
    }

    public void remove() {
        if (this.messageIndex == -1) {
            return;
        }
        UserChangesMgr.Node nod = (UserChangesMgr.Node)this.node;
        List list = nod.getWarnings();
        if (list != null) {
            list.remove(this.messageIndex);
        }
    }

    public int beginIndex() {
        return this.node.startIndex();
    }

    public int endIndex() {
        return this.node.stopIndex();
    }

    public CharSequence fullText() {
        return ((UserChangesMgr.Node)this.node).getRootNode().getManager().text();
    }

    public int length() {
        return this.endIndex() - this.beginIndex();
    }

    public char charAt(int index) {
        return this.fullText().charAt(this.beginIndex() + index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.fullText().subSequence(this.beginIndex() + start, this.beginIndex() + end);
    }

    public String toString() {
        return this.fullText().subSequence(this.beginIndex(), this.endIndex()).toString();
    }

    public String id() {
        return null;
    }

    public class PdpRemoveQuickFixAction
    implements IProblem.IQuickFixAction,
    Serializable {
        private static final long serialVersionUID = 1L;
        String code;
        String[] parameters;
        String message = "Remove warning";

        public String code() {
            return this.code;
        }

        public String[] parameters() {
            return this.parameters;
        }

        public String message() {
            return this.message;
        }

        public boolean doIt() {
            PdpProblem.this.remove();
            return true;
        }
    }

    public class PdpRestoreGeneratedQuickFixAction
    implements IProblem.IQuickFixAction,
    Serializable {
        String code;
        String[] parameters;
        String message = "Restore Generated Code";

        public String code() {
            return this.code;
        }

        public String[] parameters() {
            return this.parameters;
        }

        public String message() {
            return this.message;
        }

        public boolean doIt() {
            PdpProblem.this.node.restoreGeneratedCode();
            return true;
        }
    }

    public class PdpShowGeneratedCodeQuickFixAction
    implements IProblem.IQuickFixAction,
    Serializable {
        String code;
        String[] parameters;
        String message = "Show generated code";

        public String code() {
            return this.code;
        }

        public String[] parameters() {
            return this.parameters;
        }

        public String message() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            return Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getGeneratedText())) ? this.message + " (now showing)" : this.message;
        }

        public boolean doIt() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            if (!Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getGeneratedText()))) {
                int startIndex = n.startIndex();
                n.putGeneratedText();
                PdpProblem.this.processor.fireEvent((PropertyChangeEvent)((Object)new PdpTextChangedEvent(PdpProblem.this.processor, oldText, newText, startIndex)));
            }
            return false;
        }
    }

    public class PdpShowLostCodeQuickFixAction
    implements IProblem.IQuickFixAction,
    Serializable {
        String code;
        String[] parameters;
        String message = "Show lost code";

        public String code() {
            return this.code;
        }

        public String[] parameters() {
            return this.parameters;
        }

        public String message() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            return Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getLostText())) ? this.message + " (now showing)" : this.message;
        }

        public boolean doIt() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            if (!Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getLostText()))) {
                int startIndex = n.startIndex();
                n.putLostText();
                PdpProblem.this.processor.fireEvent((PropertyChangeEvent)((Object)new PdpTextChangedEvent(PdpProblem.this.processor, oldText, newText, startIndex)));
            }
            return false;
        }
    }

    public class PdpShowReconciledCodeQuickFixAction
    implements IProblem.IQuickFixAction,
    Serializable {
        String code;
        String[] parameters;
        String message = "Show reconciled code";

        public String code() {
            return this.code;
        }

        public String[] parameters() {
            return this.parameters;
        }

        public String message() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            return Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getReconciledText())) ? this.message + " (now showing)" : this.message;
        }

        public boolean doIt() {
            CharSequence newText;
            UserChangesMgr.Node n = (UserChangesMgr.Node)PdpProblem.this.node;
            CharSequence oldText = n.text();
            if (!Strings.sameCharSequences((CharSequence)oldText, (CharSequence)(newText = n.getReconciledText()))) {
                int startIndex = n.startIndex();
                n.putReconciledText();
                PdpProblem.this.processor.fireEvent((PropertyChangeEvent)((Object)new PdpTextChangedEvent(PdpProblem.this.processor, oldText, newText, startIndex)));
            }
            return false;
        }
    }
}

