/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.draft.generator.GeneratedTag;
import com.ibm.pdp.util.iterators.ConvertIterator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

public class PdpGeneratedTag
implements IGeneratedTag,
Serializable {
    private GeneratedTag oldGeneratedTag;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpGeneratedTag(GeneratedTag generatedTag) {
        this.oldGeneratedTag = generatedTag;
    }

    public int getBeginIndex() {
        return this.oldGeneratedTag.getStartIndex();
    }

    public int getEndIndex() {
        return this.oldGeneratedTag.getStopIndex();
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.oldGeneratedTag.getGeneratedInfo().wrap();
    }

    public String getName() {
        return this.oldGeneratedTag.getName();
    }

    GeneratedTag getOldGeneratedTag() {
        return this.oldGeneratedTag;
    }

    public IGeneratedTag getParent() {
        GeneratedTag parent = this.oldGeneratedTag.getParent();
        if (parent == null) {
            return null;
        }
        return parent.wrap();
    }

    public Iterator<String> propertyNames() {
        if (((GeneratedCodeMgr.Tag)this.oldGeneratedTag).getProperties() == null) {
            Set names = Collections.emptySet();
            return names.iterator();
        }
        final Enumeration<?> names = ((GeneratedCodeMgr.Tag)this.oldGeneratedTag).getProperties().propertyNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return names.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)names.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getProperty(String name) {
        return this.oldGeneratedTag.getProperty(name);
    }

    public void setProperty(String name, String value) {
        ((GeneratedCodeMgr.Tag)this.oldGeneratedTag).getProperties().setProperty(name, value);
    }

    public CharSequence getText() {
        return this.oldGeneratedTag.getText();
    }

    public String toString() {
        return this.oldGeneratedTag.toString();
    }

    public int nbOfSons() {
        return this.oldGeneratedTag.sons().size();
    }

    public Iterator<IGeneratedTag> sons() {
        ConvertIterator<GeneratedTag, IGeneratedTag> convertIterator = new ConvertIterator<GeneratedTag, IGeneratedTag>(this.oldGeneratedTag.sons().iterator()){

            public IGeneratedTag convert(GeneratedTag source) {
                return source.wrap();
            }
        };
        return convertIterator;
    }

    public CharSequence[] getTokens() {
        return this.oldGeneratedTag.tokens();
    }

    public boolean hasEmptyToken() {
        CharSequence[] tokens;
        CharSequence[] charSequenceArray = tokens = this.oldGeneratedTag.tokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence charsequence = charSequenceArray[n2];
            if (charsequence == null || charsequence.length() == 0) {
                return true;
            }
            ++n2;
        }
        Iterator<IGeneratedTag> it = this.sons();
        while (it.hasNext()) {
            PdpGeneratedTag element = (PdpGeneratedTag)it.next();
            if (!element.hasEmptyToken()) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnoreCase() {
        return this.oldGeneratedTag.isIgnoreCase();
    }

    public boolean isFreeFormatting() {
        return this.oldGeneratedTag.isFreeFormatting();
    }
}

