/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.draft.api;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.draft.api.PdpGeneratedInfo;
import com.ibm.pdp.engine.draft.api.PdpGeneratedInfoFactory;
import com.ibm.pdp.engine.draft.api.PdpTextProcessor;
import com.ibm.pdp.engine.draft.changes.SourceCodeMixer;
import com.ibm.pdp.engine.draft.editor.core.TextChangeHandler;
import com.ibm.pdp.engine.draft.generator.GeneratedCodeMgr;
import com.ibm.pdp.engine.extension.IExtensionManager;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PdpEngineFactory
implements IEngineFactory {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IGeneratedInfoFactory newGeneratedInfoFactory() {
        return new PdpGeneratedInfoFactory();
    }

    public ITextProcessor newTextProcessor() {
        return new PdpTextProcessor();
    }

    public IGeneratedInfo readGeneratedInfo(InputStream in) {
        GeneratedCodeMgr mgr = new GeneratedCodeMgr();
        mgr.readFrom(new InputStreamReader(in));
        return mgr.wrap();
    }

    public void writeGeneratedInfo(IGeneratedInfo generatedInfo, OutputStream out) {
        PdpGeneratedInfo pgi = (PdpGeneratedInfo)generatedInfo;
        GeneratedCodeMgr mgr = (GeneratedCodeMgr)pgi.oldGeneratedInfo;
        PrintWriter writer = new PrintWriter(out);
        mgr.writeTo(writer);
        writer.flush();
    }

    public ITextProcessor readTextProcessor(InputStream in) {
        try {
            SourceCodeMixer scm = (SourceCodeMixer)new LocalObjectInputStream(in).readObject();
            return new PdpTextProcessor(scm);
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void loadTextProcessor(ITextProcessor processor, InputStream in) {
        try {
            SourceCodeMixer scm = (SourceCodeMixer)new LocalObjectInputStream(in).readObject();
            ((PdpTextProcessor)processor).setTextEventHandler(new TextChangeHandler(scm));
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public void writeTextProcessor(ITextProcessor processor, OutputStream out) {
        try {
            new ObjectOutputStream(out).writeObject(((PdpTextProcessor)processor).sourceCodeMixer);
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public IExtensionManager getExtensionManager() {
        return null;
    }

    public void setExtensionManager(IExtensionManager extensionManager) {
    }

    public void loadTextProcessor(ITextProcessor processor, XMLStreamReader in) {
    }

    public void writeTextProcessor(ITextProcessor processor, XMLStreamWriter out) {
    }

    protected static class LocalObjectInputStream
    extends ObjectInputStream {
        public LocalObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return super.resolveClass(desc);
        }
    }
}

