/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.extension;

public class TextToken {
    public int beginIdx;
    public int endIdx;
    public int category;
    public boolean ignoreCase;
    public int hash;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextToken() {
    }

    public TextToken(int beginIndex, int endIndex, int category, boolean ignoreCase, int hash) {
        this.beginIdx = beginIndex;
        this.endIdx = endIndex;
        this.category = category;
        this.ignoreCase = ignoreCase;
        this.hash = hash;
    }

    public boolean match(CharSequence text, int wordCategory, boolean wordIgnoreCase, int wordHash, CharSequence wordText) {
        if (wordHash != this.hash || wordCategory != this.category || wordIgnoreCase != this.ignoreCase) {
            return false;
        }
        int tokenLength = this.endIdx - this.beginIdx;
        if (wordText.length() != tokenLength) {
            return false;
        }
        int startIdx = this.beginIdx;
        if (this.ignoreCase) {
            int i = 0;
            while (i < tokenLength) {
                char c2;
                char c1 = wordText.charAt(i);
                if (c1 != (c2 = text.charAt(startIdx + i)) && (c2 < 'A' || c2 > 'Z' || (c2 | 0x20) != c1)) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tokenLength) {
                if (text.charAt(startIdx + i) != wordText.charAt(i)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

