/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.extension;

import com.ibm.pdp.engine.ITextArtefactLocation;

public class TextArtefactLocation
implements ITextArtefactLocation {
    private int beginIndex = -1;
    private int length = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextArtefactLocation(int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.length = endIndex - beginIndex;
    }

    @Override
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public void shift(int decalage) {
        this.beginIndex += decalage;
    }

    @Override
    public void shiftEnd(int decalage) {
        this.length += decalage;
        if (this.length < 0) {
            this.length = 0;
        }
    }

    @Override
    public int getEndIndex() {
        return this.beginIndex + this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append('[');
        sb.append(this.getBeginIndex());
        sb.append(',');
        sb.append(this.getEndIndex());
        sb.append(']');
        return sb.toString();
    }
}

