/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.extension;

import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.TextToken;

public class DefaultTextPartitioner
implements ITextPartitioner {
    protected static final byte NORMAL = 0;
    protected static final byte SPECIAL = 1;
    protected static final byte WHITE = 2;
    protected static final byte EOL = 3;
    protected static final byte[] charCategory;
    protected static final char[] specials;
    protected static final char[] whites;
    protected static final char[] eols;
    protected static final int NORMAL_ATOM = 0;
    protected static final int LINE_COMMENT = 1;
    protected static final int BLOCK_COMMENT = 2;
    protected static final int BLOCK_COMMENT_END = 3;
    protected static final int LINE_COMMENT_HASH = 1504;
    protected static final int BLOCK_COMMENT_HASH = 1349;
    protected static final int BLOCK_COMMENT_END_HASH = 1499;
    protected CharSequence text;
    protected boolean defaultIgnoreCase;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        char c;
        specials = new char[]{'\"', '-', '/', '.', ',', ';', ':', '+', '*', '!', '#', '%', '&', '?', '|', '~', '<', '>', '=', '(', ')', '[', ']', '{', '}', '\\', '\'', '\u00b0', '^'};
        whites = new char[]{' ', '\t'};
        eols = new char[]{'\n', '\r'};
        charCategory = new byte[65536];
        char[] cArray = specials;
        int n = specials.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            DefaultTextPartitioner.charCategory[c] = 1;
            ++n2;
        }
        cArray = whites;
        n = whites.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            DefaultTextPartitioner.charCategory[c] = 2;
            ++n2;
        }
        cArray = eols;
        n = eols.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            DefaultTextPartitioner.charCategory[c] = 3;
            ++n2;
        }
    }

    public DefaultTextPartitioner() {
        this(null, false);
    }

    public DefaultTextPartitioner(boolean ignoreCase) {
        this(null, ignoreCase);
    }

    public DefaultTextPartitioner(CharSequence initialText, boolean ignoreCase) {
        this.text = initialText;
        this.defaultIgnoreCase = ignoreCase;
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public void setText(CharSequence newText) {
        this.text = newText;
    }

    public boolean getDefaultIgnoreCase() {
        return this.defaultIgnoreCase;
    }

    public void setDefaultIgnoreCase(boolean newDefaultIgnoreCase) {
        this.defaultIgnoreCase = newDefaultIgnoreCase;
    }

    @Override
    public TextToken newToken() {
        return new TextToken();
    }

    @Override
    public TextToken newToken(int beginIndex, int endIndex, int category, boolean ignoreCase, int hash) {
        return new TextToken(beginIndex, endIndex, category, ignoreCase, hash);
    }

    @Override
    public boolean nextToken(TextToken token) {
        int idx = token.endIdx;
        CharSequence txt = this.text;
        int length = txt.length();
        if (idx >= length) {
            return false;
        }
        int chr = txt.charAt(idx);
        byte category = charCategory[chr];
        int defaultAtomCategory = token.category;
        if (defaultAtomCategory == 3) {
            defaultAtomCategory = 0;
        } else if (defaultAtomCategory == 1) {
            while (category == 2) {
                if (++idx == length) {
                    return false;
                }
                chr = txt.charAt(idx);
                category = charCategory[chr];
            }
            if (category == 3) {
                defaultAtomCategory = 0;
            }
        }
        while (category == 2 || category == 3) {
            if (++idx == length) {
                return false;
            }
            chr = txt.charAt(idx);
            category = charCategory[chr];
        }
        token.beginIdx = idx++;
        token.category = defaultAtomCategory;
        if (category == 1) {
            token.ignoreCase = false;
            token.hash = chr;
            if (defaultAtomCategory == 2) {
                if (chr == 42 && idx < length && txt.charAt(idx) == '/') {
                    token.category = 3;
                    token.hash = 1499;
                    ++idx;
                }
            } else if (defaultAtomCategory == 0) {
                if (chr == 47 && idx < length) {
                    chr = txt.charAt(idx);
                    if (chr == 47) {
                        token.category = 1;
                        token.hash = 1504;
                        ++idx;
                    } else if (chr == 42) {
                        token.category = 2;
                        token.hash = 1349;
                        ++idx;
                    }
                } else if (chr == 39 || chr == 34) {
                    int hash = chr;
                    int multiplier = 31;
                    boolean quoted = false;
                    while (idx < length) {
                        char nextChr = txt.charAt(idx++);
                        if (quoted) {
                            quoted = false;
                        } else if (nextChr == '\\') {
                            quoted = true;
                        } else {
                            if (nextChr == chr) {
                                hash += multiplier * chr;
                                break;
                            }
                            if (charCategory[nextChr] == 3) {
                                --idx;
                                break;
                            }
                        }
                        hash += multiplier * nextChr;
                        multiplier = (multiplier << 5) - multiplier;
                    }
                    token.hash = hash;
                }
            }
        } else if (this.defaultIgnoreCase) {
            boolean caseSensible = false;
            int hash = chr;
            int multiplier = 31;
            while (idx < length) {
                char c = txt.charAt(idx);
                if (charCategory[c] != 0) break;
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c | 0x20);
                    caseSensible = true;
                } else if (c >= 'a' && c <= 'z') {
                    caseSensible = true;
                }
                hash += c * multiplier;
                multiplier = (multiplier << 5) - multiplier;
                ++idx;
            }
            token.ignoreCase = caseSensible;
            token.hash = hash;
        } else {
            int hash = chr;
            int multiplier = 31;
            while (idx < length) {
                char c = txt.charAt(idx);
                if (charCategory[c] != 0) break;
                hash += c * multiplier;
                multiplier = (multiplier << 5) - multiplier;
                ++idx;
            }
            token.ignoreCase = false;
            token.hash = hash;
        }
        token.endIdx = idx;
        return true;
    }

    @Override
    public void textChanged(int index, int nbRemoved, int nbAdded) {
    }
}

