/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.matcher;

import com.ibm.pdp.compare.matcher.PTListDiffEngine;
import com.ibm.pdp.compare.matcher.PTMatcherLabel;
import com.ibm.pdp.mdl.compare.match.MatchFactory;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.compare.match.Unmatch;
import com.ibm.pdp.mdl.compare.match.UnmatchSide;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import com.ibm.pdp.util.diff.Difference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PTMatcher {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<EObject, Matching> _cachedMatchings = new HashMap<EObject, Matching>();
    private List<Unmatch> _cachedUnmatches = new ArrayList<Unmatch>();
    private Map<EObject, Matching> _leftPendings = new HashMap<EObject, Matching>();
    private Map<EObject, Matching> _rightPendings = new HashMap<EObject, Matching>();

    public MatchModel doMatch(EObject eLeftObject, EObject eRightObject, IProgressMonitor monitor) throws InterruptedException {
        monitor.subTask(PTMatcherLabel.getString(PTMatcherLabel._MatcherInProgress));
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.setLeftRoot(eLeftObject);
        matchModel.setRightRoot(eRightObject);
        if (matchModel.getLeftRoot() != null && matchModel.getRightRoot() != null) {
            Matching matching = this.createMatching(matchModel.getLeftRoot(), matchModel.getRightRoot(), false);
            this.doRecursive2WayMatch(matching, monitor);
            matchModel.setMatching(matching);
            matchModel.getUnmatches().addAll(this._cachedUnmatches);
        }
        this._cachedUnmatches.clear();
        this._cachedMatchings.clear();
        return matchModel;
    }

    public MatchModel doMatch(EObject eLeftObject, EObject eRightObject, EObject eAncestorObject, IProgressMonitor monitor) throws InterruptedException {
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.setLeftRoot(eLeftObject);
        matchModel.setRightRoot(eRightObject);
        matchModel.setAncestorRoot(eAncestorObject);
        MatchModel leftModel = this.doMatch(eLeftObject, eAncestorObject, monitor);
        MatchModel rightModel = this.doMatch(eRightObject, eAncestorObject, monitor);
        EObject leftObject = leftModel.getMatching().getLeftObject();
        EObject rightObject = rightModel.getMatching().getLeftObject();
        EObject ancestorObject = rightModel.getMatching().getRightObject();
        Matching3Way matching3Way = this.createMatching3Way(leftObject, rightObject, ancestorObject, false);
        this.doRecursive3WayMatch(matching3Way, leftModel.getMatching(), rightModel.getMatching(), monitor);
        matchModel.setMatching((Matching)matching3Way);
        this.matchUnmatch(matchModel, leftModel.getUnmatches(), rightModel.getUnmatches(), monitor);
        this._leftPendings.clear();
        this._rightPendings.clear();
        return matchModel;
    }

    public void mergeMatch(MatchModel matchModel, Matching matching, EReference eReference, boolean threeWay) {
        int i = matchModel.getUnmatches().size() - 1;
        while (i >= 0) {
            Unmatch nextUnmatch = (Unmatch)matchModel.getUnmatches().get(i);
            if (nextUnmatch.getParent() == matching && nextUnmatch.getReference() == eReference) {
                matchModel.getUnmatches().remove(i);
            }
            --i;
        }
        i = matching.getMatchings().size() - 1;
        while (i >= 0) {
            Matching nextMatching = (Matching)matching.getMatchings().get(i);
            if (nextMatching.getLeftObject().eContainmentFeature() == eReference) {
                matching.getMatchings().remove(i);
            }
            --i;
        }
        if (threeWay) {
            this.merge3WayMatch(matchModel, (Matching3Way)matching, eReference);
        } else {
            this.merge2WayMatch(matchModel, matching, eReference);
        }
    }

    private void doRecursive2WayMatch(Matching matching, IProgressMonitor monitor) throws InterruptedException {
        if (matching.getLeftObject().eClass() != matching.getRightObject().eClass()) {
            return;
        }
        for (EReference eReference : matching.getLeftObject().eClass().getEAllReferences()) {
            List<Matching> subMatchings = this.doRecursive2WayMatch(matching, eReference, monitor);
            matching.getMatchings().addAll(subMatchings);
        }
        for (Matching subMatching : matching.getMatchings()) {
            if (subMatching.isProxy()) continue;
            this.doRecursive2WayMatch(subMatching, monitor);
        }
    }

    private List<Matching> doRecursive2WayMatch(Matching matching, EReference eReference, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<Matching> subMatchings = new ArrayList<Matching>(1);
        String sourceClass = null;
        if (matching.getLeftObject() instanceof Entity) {
            sourceClass = ((Entity)matching.getLeftObject()).getOwner().eClass().getName();
        }
        if (!PTLabelFactory.acceptReference((EReference)eReference, sourceClass, null)) {
            return subMatchings;
        }
        if (eReference.isMany()) {
            List leftList = (List)matching.getLeftObject().eGet((EStructuralFeature)eReference);
            List rightList = (List)matching.getRightObject().eGet((EStructuralFeature)eReference);
            subMatchings.addAll(this.match2WayList(matching, eReference, leftList, rightList, monitor));
        } else {
            boolean proxy;
            Matching subMatching;
            EObject leftObject = (EObject)matching.getLeftObject().eGet((EStructuralFeature)eReference);
            EObject rightObject = (EObject)matching.getRightObject().eGet((EStructuralFeature)eReference);
            if (leftObject != null && rightObject != null && (subMatching = this.createMatching(leftObject, rightObject, proxy = !eReference.isContainment())) != null) {
                subMatchings.add(subMatching);
            }
        }
        return subMatchings;
    }

    private List<Matching> match2WayList(Matching parent, EReference eReference, List<Entity> leftList, List<Entity> rightList, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<Matching> matchings = new ArrayList<Matching>();
        PTListDiffEngine listDiffEngine = new PTListDiffEngine(leftList, rightList);
        Difference[] differences = listDiffEngine.computeDifferences();
        HashMap<EObject, Difference> leftUnmatches = new HashMap<EObject, Difference>();
        HashMap<EObject, Difference> rightUnmatches = new HashMap<EObject, Difference>();
        Difference[] differenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            Difference diff = differenceArray[n2];
            if (diff.isDeletion()) {
                i = diff.getReferenceBeginIndex();
                while (i < diff.getReferenceEndIndex()) {
                    leftUnmatches.put((EObject)leftList.get(i), diff);
                    ++i;
                }
            } else if (diff.isInsertion()) {
                i = diff.getModifiedBeginIndex();
                while (i < diff.getModifiedEndIndex()) {
                    rightUnmatches.put((EObject)rightList.get(i), diff);
                    ++i;
                }
            } else if (diff.isReplacement()) {
                i = diff.getReferenceBeginIndex();
                while (i < diff.getReferenceEndIndex()) {
                    leftUnmatches.put((EObject)leftList.get(i), diff);
                    ++i;
                }
                i = diff.getModifiedBeginIndex();
                while (i < diff.getModifiedEndIndex()) {
                    rightUnmatches.put((EObject)rightList.get(i), diff);
                    ++i;
                }
            }
            ++n2;
        }
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftList.size() || rightIndex < rightList.size()) {
            EObject leftObject = null;
            if (leftIndex < leftList.size()) {
                leftObject = (EObject)leftList.get(leftIndex);
            }
            EObject rightObject = null;
            if (rightIndex < rightList.size()) {
                rightObject = (EObject)rightList.get(rightIndex);
            }
            if (!leftUnmatches.containsKey(leftObject) && !rightUnmatches.containsKey(rightObject)) {
                boolean proxy = !eReference.isContainment();
                Matching matching = this.createMatching(leftObject, rightObject, proxy);
                if (matching != null) {
                    matchings.add(matching);
                }
                ++leftIndex;
                ++rightIndex;
                continue;
            }
            if (leftUnmatches.containsKey(leftObject)) {
                Unmatch unmatch = this.createUnmatch(UnmatchSide.Left, leftObject, (Difference)leftUnmatches.get(leftObject));
                unmatch.setParent(parent);
                unmatch.setReference(eReference);
                ++leftIndex;
            }
            if (!rightUnmatches.containsKey(rightObject)) continue;
            Unmatch unmatch = this.createUnmatch(UnmatchSide.Right, rightObject, (Difference)rightUnmatches.get(rightObject));
            unmatch.setParent(parent);
            unmatch.setReference(eReference);
            ++rightIndex;
        }
        return matchings;
    }

    private void doRecursive3WayMatch(Matching3Way matching3Way, Matching leftMatching, Matching rightMatching, IProgressMonitor monitor) throws InterruptedException {
        HashMap<EObject, Matching> leftMap = new HashMap<EObject, Matching>();
        HashMap<EObject, Matching> rightMap = new HashMap<EObject, Matching>();
        for (Matching matching : leftMatching.getMatchings()) {
            leftMap.put(matching.getRightObject(), matching);
            this._leftPendings.put(matching.getLeftObject(), matching);
        }
        for (Matching matching : rightMatching.getMatchings()) {
            rightMap.put(matching.getRightObject(), matching);
            this._rightPendings.put(matching.getLeftObject(), matching);
        }
        for (Map.Entry entry : leftMap.entrySet()) {
            boolean proxy;
            EObject rightObject;
            EObject ancestorObject = (EObject)entry.getKey();
            Matching leftSubMatching = (Matching)entry.getValue();
            Matching rightSubMatching = (Matching)rightMap.get(ancestorObject);
            if (leftSubMatching == null || rightSubMatching == null) continue;
            EObject leftObject = leftSubMatching.getLeftObject();
            Matching3Way subMatching3Way = this.createMatching3Way(leftObject, rightObject = rightSubMatching.getLeftObject(), ancestorObject, proxy = leftSubMatching.isProxy() || rightSubMatching.isProxy());
            if (subMatching3Way != null) {
                matching3Way.getMatchings().add(subMatching3Way);
                this._leftPendings.remove(leftObject);
                this._rightPendings.remove(rightObject);
            }
            if (proxy) continue;
            this.doRecursive3WayMatch(subMatching3Way, leftSubMatching, rightSubMatching, monitor);
        }
    }

    private void match3WayList(MatchModel matchModel, List<Unmatch> leftUnmatches, List<Unmatch> rightUnmatches, Matching3Way matching, List<Entity> leftInputList, List<Entity> rightInputList, IProgressMonitor monitor) throws InterruptedException {
        HashSet<Entity> leftSet = new HashSet<Entity>();
        for (Entity entity : leftInputList) {
            if (this._cachedMatchings.containsKey(entity)) continue;
            leftSet.add(entity);
        }
        HashSet<Entity> rightSet = new HashSet<Entity>();
        for (Entity entity : rightInputList) {
            if (this._cachedMatchings.containsKey(entity)) continue;
            rightSet.add(entity);
        }
        Entity[] leftArray = leftSet.toArray(new Entity[leftSet.size()]);
        Entity[] rightArray = rightSet.toArray(new Entity[rightSet.size()]);
        Entity[] entityArray = leftArray;
        int n = leftArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity leftEntity = entityArray[n2];
            Entity[] entityArray2 = rightArray;
            int n3 = rightArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Entity rightEntity = entityArray2[n4];
                if (leftEntity.isSame(rightEntity)) {
                    Object ancestorObject = this._leftPendings.containsKey(leftEntity) ? this._leftPendings.get(leftEntity).getRightObject() : (this._rightPendings.containsKey(rightEntity) ? this._rightPendings.get(rightEntity).getRightObject() : null);
                    Matching3Way matching3Way = this.createMatching3Way((EObject)leftEntity, (EObject)rightEntity, (EObject)ancestorObject, false);
                    if (matching3Way != null) {
                        if (ancestorObject == null) {
                            this.doRecursive2WayMatch((Matching)matching3Way, monitor);
                            matching3Way = this.convertTo3Way((Matching)matching3Way);
                        }
                        matching3Way.setUnmatch(true);
                        matching.getMatchings().add(matching3Way);
                    }
                    leftSet.remove(leftEntity);
                    rightSet.remove(rightEntity);
                }
                ++n4;
            }
            ++n2;
        }
        for (Unmatch unmatch : leftUnmatches) {
            if (unmatch.getSide() != UnmatchSide.Left || !leftSet.contains(unmatch.getObject())) continue;
            Unmatch unmatch3Way = this.createUnmatch(UnmatchSide.Left, unmatch.getObject(), unmatch.getDifference());
            unmatch3Way.setParent((Matching)matching);
            unmatch3Way.setReference(unmatch.getReference());
            matchModel.getUnmatches().add(unmatch3Way);
        }
        for (Unmatch unmatch : rightUnmatches) {
            if (unmatch.getSide() != UnmatchSide.Left || !rightSet.contains(unmatch.getObject())) continue;
            Unmatch unmatch3Way = this.createUnmatch(UnmatchSide.Right, unmatch.getObject(), unmatch.getDifference());
            unmatch3Way.setParent((Matching)matching);
            unmatch3Way.setReference(unmatch.getReference());
            unmatch3Way.setRemote(true);
            matchModel.getUnmatches().add(unmatch3Way);
        }
    }

    private void matchUnmatch(MatchModel matchModel, List<Unmatch> leftUnmatches, List<Unmatch> rightUnmatches, IProgressMonitor monitor) throws InterruptedException {
        Map<EObject, Set<EReference>> allLeftReferences = this.collectListWithUnmatch(leftUnmatches);
        for (Map.Entry<EObject, Set<EReference>> entry : allLeftReferences.entrySet()) {
            EObject leftObject = entry.getKey();
            Set<EReference> references = entry.getValue();
            Matching matching = this._cachedMatchings.get(leftObject);
            if (matching == null) continue;
            EObject rightObject = matching.getRightObject();
            for (EReference eReference : references) {
                List leftList = (List)leftObject.eGet((EStructuralFeature)eReference);
                List rightList = (List)rightObject.eGet((EStructuralFeature)eReference);
                this.match3WayList(matchModel, leftUnmatches, rightUnmatches, (Matching3Way)matching, leftList, rightList, monitor);
            }
        }
    }

    private Map<EObject, Set<EReference>> collectListWithUnmatch(List<Unmatch> unmatches) {
        HashMap<EObject, Set<EReference>> allReferences = new HashMap<EObject, Set<EReference>>();
        for (Unmatch unmatch : unmatches) {
            if (unmatch.getSide() != UnmatchSide.Left) continue;
            EObject eContainer = unmatch.getObject().eContainer();
            EReference eReference = unmatch.getObject().eContainmentFeature();
            HashSet<EReference> references = (HashSet<EReference>)allReferences.get(eContainer);
            if (references == null) {
                references = new HashSet<EReference>();
                allReferences.put(eContainer, references);
            }
            references.add(eReference);
        }
        return allReferences;
    }

    private Matching3Way convertTo3Way(Matching matching) {
        Matching3Way matching3Way = this.createMatching3Way(matching.getLeftObject(), matching.getRightObject(), null, matching.isProxy());
        for (Matching subMatching : matching.getMatchings()) {
            matching3Way.getMatchings().add(this.convertTo3Way(subMatching));
        }
        return matching3Way;
    }

    private void merge2WayMatch(MatchModel matchModel, Matching matching, EReference eReference) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            List<Matching> subMatchings = this.doRecursive2WayMatch(matching, eReference, (IProgressMonitor)monitor);
            matching.getMatchings().addAll(subMatchings);
            for (Matching subMatching : subMatchings) {
                if (subMatching.isProxy()) continue;
                this.doRecursive2WayMatch(subMatching, (IProgressMonitor)monitor);
            }
            for (Unmatch unmatch : this._cachedUnmatches) {
                if (unmatch.getParent() != matching || unmatch.getReference() != eReference) continue;
                matchModel.getUnmatches().add(unmatch);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void merge3WayMatch(MatchModel matchModel, Matching3Way matching3Way, EReference eReference) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            Matching leftMatching = this.createMatching(matching3Way.getLeftObject(), matching3Way.getAncestorObject(), false);
            List<Matching> leftMatchings = this.doRecursive2WayMatch(leftMatching, eReference, (IProgressMonitor)monitor);
            leftMatching.getMatchings().addAll(leftMatchings);
            ArrayList<Unmatch> leftUnmatches = new ArrayList<Unmatch>(this._cachedUnmatches);
            this._cachedUnmatches.clear();
            Matching rightMatching = this.createMatching(matching3Way.getRightObject(), matching3Way.getAncestorObject(), false);
            List<Matching> rightMatchings = this.doRecursive2WayMatch(rightMatching, eReference, (IProgressMonitor)monitor);
            rightMatching.getMatchings().addAll(rightMatchings);
            ArrayList<Unmatch> rightUnmatches = new ArrayList<Unmatch>(this._cachedUnmatches);
            this._cachedUnmatches.clear();
            this.doRecursive3WayMatch(matching3Way, leftMatching, rightMatching, (IProgressMonitor)monitor);
            this._cachedMatchings.put(matching3Way.getLeftObject(), (Matching)matching3Way);
            this._cachedMatchings.put(matching3Way.getRightObject(), (Matching)matching3Way);
            this._cachedMatchings.put(matching3Way.getAncestorObject(), (Matching)matching3Way);
            this.matchUnmatch(matchModel, leftUnmatches, rightUnmatches, (IProgressMonitor)monitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Matching createMatching(EObject leftObject, EObject rightObject, boolean proxy) {
        Matching matching = null;
        if (leftObject != null && rightObject != null) {
            matching = MatchFactory.eINSTANCE.createMatching();
            matching.setLeftObject(leftObject);
            matching.setRightObject(rightObject);
            matching.setProxy(proxy);
            this._cachedMatchings.put(leftObject, matching);
            this._cachedMatchings.put(rightObject, matching);
        }
        return matching;
    }

    private Matching3Way createMatching3Way(EObject leftObject, EObject rightObject, EObject ancestorObject, boolean proxy) {
        Matching3Way matching3Way = null;
        if (leftObject != null && rightObject != null) {
            matching3Way = MatchFactory.eINSTANCE.createMatching3Way();
            matching3Way.setLeftObject(leftObject);
            matching3Way.setRightObject(rightObject);
            matching3Way.setAncestorObject(ancestorObject);
            matching3Way.setProxy(proxy);
            this._cachedMatchings.put(leftObject, (Matching)matching3Way);
            this._cachedMatchings.put(rightObject, (Matching)matching3Way);
            this._cachedMatchings.put(ancestorObject, (Matching)matching3Way);
        }
        return matching3Way;
    }

    private Unmatch createUnmatch(UnmatchSide side, EObject eObject, Difference difference) {
        Unmatch unmatch = MatchFactory.eINSTANCE.createUnmatch();
        unmatch.setSide(side);
        unmatch.setObject(eObject);
        unmatch.setDifference(difference);
        this._cachedUnmatches.add(unmatch);
        return unmatch;
    }
}

