/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.differencer;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.differencer.PTChangeAnalyzer;
import com.ibm.pdp.compare.differencer.PTDifferencerLabel;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeFactory;
import com.ibm.pdp.mdl.compare.change.ChangeGroup;
import com.ibm.pdp.mdl.compare.change.ChangeModel;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.compare.match.Unmatch;
import com.ibm.pdp.mdl.compare.match.UnmatchSide;
import com.ibm.pdp.util.diff.Difference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PTDifferencer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<EObject, Matching> _matchCrossRefs;
    private Map<EObject, ChangeGroup> _changeCrossRefs;
    private PTChangeAnalyzer _changeAnalyzer;

    public ChangeModel doDiff(MatchModel matchModel, boolean threeWay, IProgressMonitor monitor) throws InterruptedException {
        monitor.subTask(PTDifferencerLabel.getString(PTDifferencerLabel._DifferencerInProgress));
        this._matchCrossRefs = new HashMap<EObject, Matching>();
        this._changeCrossRefs = new HashMap<EObject, ChangeGroup>();
        ArrayList<Matching> matchings = new ArrayList<Matching>(1);
        matchings.add(matchModel.getMatching());
        this.initMatchingCrossRefs(matchings);
        this._changeAnalyzer = new PTChangeAnalyzer();
        ChangeModel changeModel = ChangeFactory.eINSTANCE.createChangeModel();
        changeModel.setLeftRoot(matchModel.getLeftRoot());
        changeModel.setRightRoot(matchModel.getRightRoot());
        changeModel.setAncestorRoot(matchModel.getAncestorRoot());
        if (!threeWay) {
            this.doDiff2Way(changeModel, matchModel, monitor);
        } else {
            this.doDiff3Way(changeModel, matchModel, monitor);
        }
        return changeModel;
    }

    public void mergeDiff(MatchModel matchModel, ChangeModel changeModel, Matching matching, PendingReference pendingChange) {
        this._matchCrossRefs = new HashMap<EObject, Matching>();
        this._changeCrossRefs = new HashMap<EObject, ChangeGroup>();
        ArrayList<Matching> matchings = new ArrayList<Matching>(1);
        matchings.add(matching);
        this.initMatchingCrossRefs(matchings);
        this._changeCrossRefs.put(matching.getLeftObject(), (ChangeGroup)pendingChange.getParent());
        EReference eReference = pendingChange.getReference();
        ArrayList<ChangeElement> preList = new ArrayList<ChangeElement>();
        ArrayList<ChangeElement> postList = new ArrayList<ChangeElement>();
        boolean isPreList = true;
        for (ChangeElement nextChange : pendingChange.getParent().getChangeElements()) {
            if (nextChange instanceof PendingReference && ((PendingReference)nextChange).getReference() == eReference) {
                isPreList = false;
                continue;
            }
            if (isPreList) {
                preList.add(nextChange);
                continue;
            }
            postList.add(nextChange);
        }
        pendingChange.getParent().getChangeElements().clear();
        ArrayList<Unmatch> unmatches = new ArrayList<Unmatch>();
        for (Unmatch unmatch : matchModel.getUnmatches()) {
            if (unmatch.getParent() != matching || unmatch.getReference() != eReference) continue;
            unmatches.add(unmatch);
        }
        pendingChange.getParent().getChangeElements().addAll(preList);
        this.processUnmatches(changeModel.getChangeGroup(), unmatches);
        pendingChange.getParent().getChangeElements().addAll(postList);
    }

    private void doDiff2Way(ChangeModel changeModel, MatchModel matchModel, IProgressMonitor monitor) throws InterruptedException {
        ChangeGroup changeRoot = ChangeFactory.eINSTANCE.createChangeGroup();
        changeRoot.setObject(matchModel.getMatching().getLeftObject());
        this._changeCrossRefs.put(matchModel.getMatching().getLeftObject(), changeRoot);
        this.doRecursive2WayDiff(changeRoot, matchModel.getMatching(), monitor);
        changeModel.setChangeGroup(changeRoot);
        this.processUnmatches(changeRoot, matchModel.getUnmatches());
    }

    private void doRecursive2WayDiff(ChangeGroup changeRoot, Matching matching, IProgressMonitor monitor) throws InterruptedException {
        List<ChangeElement> changes = this._changeAnalyzer.getChanges(matching);
        for (ChangeElement change : changes) {
            this.addInStructureHierarchy(changeRoot, change, matching.getLeftObject());
        }
        for (Matching subMatching : matching.getMatchings()) {
            if (subMatching.isProxy()) continue;
            this.doRecursive2WayDiff(changeRoot, subMatching, monitor);
        }
    }

    private void doDiff3Way(ChangeModel changeModel, MatchModel matchModel, IProgressMonitor monitor) throws InterruptedException {
        ChangeGroup changeRoot = ChangeFactory.eINSTANCE.createChangeGroup();
        changeRoot.setObject(matchModel.getMatching().getLeftObject());
        this._changeCrossRefs.put(matchModel.getMatching().getLeftObject(), changeRoot);
        this.doRecursive3WayDiff(changeRoot, (Matching3Way)matchModel.getMatching(), monitor);
        changeModel.setChangeGroup(changeRoot);
        this.processUnmatches(changeRoot, matchModel.getUnmatches());
    }

    private void doRecursive3WayDiff(ChangeGroup changeRoot, Matching3Way matching, IProgressMonitor monitor) throws InterruptedException {
        List<ChangeElement> changes = this._changeAnalyzer.getChanges((Matching)matching);
        for (ChangeElement change : changes) {
            this.addInStructureHierarchy(changeRoot, change, matching.getLeftObject());
        }
        for (Matching subMatching : matching.getMatchings()) {
            if (subMatching.isProxy()) continue;
            this.doRecursive3WayDiff(changeRoot, (Matching3Way)subMatching, monitor);
        }
    }

    private void addInStructureHierarchy(ChangeGroup changeRoot, ChangeElement change, EObject eObject) {
        if (eObject == null) {
            System.out.println("addInStructureHierarchy failed: No matched right object");
            return;
        }
        ChangeGroup changeGroup = this._changeCrossRefs.get(eObject);
        if (changeGroup == null) {
            changeGroup = this._changeCrossRefs.get(this.getMatchedEObject(eObject));
        }
        if (changeGroup == null) {
            changeGroup = this.createStructureHierarchy(changeRoot, eObject);
        }
        change.setParent((ChangeElement)changeGroup);
        changeGroup.getChangeElements().add(change);
    }

    private ChangeGroup createStructureHierarchy(ChangeGroup changeRoot, EObject eObject) {
        ChangeGroup changeGroup = ChangeFactory.eINSTANCE.createChangeGroup();
        changeGroup.setObject(eObject);
        this._changeCrossRefs.put(eObject, changeGroup);
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            ChangeGroup changeGroupParent = this._changeCrossRefs.get(eContainer);
            if (changeGroupParent == null) {
                changeGroupParent = this._changeCrossRefs.get(this.getMatchedEObject(eContainer));
            }
            if (changeGroupParent == null) {
                changeGroupParent = this.createStructureHierarchy(changeRoot, eContainer);
            }
            changeGroup.setParent((ChangeElement)changeGroupParent);
            changeGroupParent.getChangeElements().add(changeGroup);
        } else {
            changeGroup.setParent((ChangeElement)changeRoot);
            changeRoot.getChangeElements().add(changeGroup);
        }
        return changeGroup;
    }

    private void initMatchingCrossRefs(List<Matching> matchings) {
        for (Matching matching : matchings) {
            this._matchCrossRefs.put(matching.getLeftObject(), matching);
            this._matchCrossRefs.put(matching.getRightObject(), matching);
            if (matching instanceof Matching3Way) {
                this._matchCrossRefs.put(((Matching3Way)matching).getAncestorObject(), matching);
            }
            this.initMatchingCrossRefs(matching.getMatchings());
        }
    }

    private EObject getMatchedEObject(EObject from) {
        Matching matching = this._matchCrossRefs.get(from);
        EObject matchedEObject = null;
        if (matching.getLeftObject() == from) {
            matchedEObject = matching.getRightObject();
        } else if (matching.getRightObject() == from) {
            matchedEObject = matching.getLeftObject();
        }
        return matchedEObject;
    }

    private EObject getMatchedEObject(EObject from, PTPartSide partSide) {
        Matching matching = this._matchCrossRefs.get(from);
        if (matching == null) {
            return null;
        }
        EObject matchedEObject = null;
        if (partSide == PTPartSide.Left) {
            matchedEObject = matching.getLeftObject();
        } else if (partSide == PTPartSide.Right) {
            matchedEObject = matching.getRightObject();
        } else if (partSide == PTPartSide.Ancestor && matching instanceof Matching3Way) {
            matchedEObject = ((Matching3Way)matching).getAncestorObject();
        }
        return matchedEObject;
    }

    private void processUnmatches(ChangeGroup changeRoot, List<Unmatch> unmatches) {
        for (Unmatch unmatch : unmatches) {
            EObject eAncestorContainer;
            EObject eObject = unmatch.getObject();
            ChangeElement conflictChange = null;
            if (unmatch.isConflicting()) {
                System.out.println("Missing statements in PTDifferencer#processUnmatches(...)");
            }
            if (unmatch.getSide() == UnmatchSide.Left) {
                LeftPending leftPending = ChangeFactory.eINSTANCE.createLeftPending();
                leftPending.setLeftObject(eObject);
                leftPending.setRemote(unmatch.isRemote());
                leftPending.setLeftContainer(unmatch.getParent().getLeftObject());
                EObject eRightContainer = unmatch.getParent().getRightObject();
                leftPending.setRightContainer(eRightContainer);
                leftPending.setReference(unmatch.getReference());
                leftPending.setRightAnchor(this.getAnchorObject(unmatch, eRightContainer));
                eAncestorContainer = this.getMatchedEObject(eObject.eContainer(), PTPartSide.Ancestor);
                if (eAncestorContainer != null) {
                    leftPending.setAncestorAnchor(this.getAnchorObject(unmatch, eAncestorContainer));
                }
                if (conflictChange != null) {
                    leftPending.setParent(conflictChange);
                    conflictChange.getChangeElements().add(leftPending);
                    this.addInStructureHierarchy(changeRoot, conflictChange, eRightContainer);
                    continue;
                }
                this.addInStructureHierarchy(changeRoot, (ChangeElement)leftPending, eRightContainer);
                continue;
            }
            if (unmatch.getSide() != UnmatchSide.Right) continue;
            RightPending rightPending = ChangeFactory.eINSTANCE.createRightPending();
            rightPending.setRightObject(eObject);
            rightPending.setRemote(unmatch.isRemote());
            rightPending.setRightContainer(unmatch.getParent().getRightObject());
            EObject eLeftContainer = unmatch.getParent().getLeftObject();
            rightPending.setLeftContainer(eLeftContainer);
            rightPending.setReference(unmatch.getReference());
            rightPending.setLeftAnchor(this.getAnchorObject(unmatch, eLeftContainer));
            eAncestorContainer = this.getMatchedEObject(eObject.eContainer(), PTPartSide.Ancestor);
            if (eAncestorContainer != null) {
                rightPending.setAncestorAnchor(this.getAnchorObject(unmatch, eAncestorContainer));
            }
            if (conflictChange != null) {
                rightPending.setParent(conflictChange);
                conflictChange.getChangeElements().add(rightPending);
                this.addInStructureHierarchy(changeRoot, conflictChange, eLeftContainer);
                continue;
            }
            this.addInStructureHierarchy(changeRoot, (ChangeElement)rightPending, eLeftContainer);
        }
    }

    private EObject getAnchorObject(Unmatch unmatch, EObject eOppositeContainer) {
        EObject oppositeAnchor = null;
        Difference diff = unmatch.getDifference();
        EReference eReference = unmatch.getReference();
        EList eList = (EList)eOppositeContainer.eGet((EStructuralFeature)eReference);
        if (diff.isDeletion()) {
            int oppositeIndex = diff.getModifiedBeginIndex();
            if (oppositeIndex > 0 && oppositeIndex <= eList.size()) {
                oppositeAnchor = (EObject)eList.get(oppositeIndex - 1);
            }
        } else if (diff.isInsertion()) {
            int oppositeIndex = diff.getReferenceBeginIndex();
            if (oppositeIndex > 0 && oppositeIndex <= eList.size()) {
                oppositeAnchor = (EObject)eList.get(oppositeIndex - 1);
            }
        } else if (diff.isReplacement()) {
            int oppositeIndex = 0;
            if (unmatch.getSide() == UnmatchSide.Left) {
                oppositeIndex = diff.getModifiedBeginIndex();
            } else if (unmatch.getSide() == UnmatchSide.Right) {
                oppositeIndex = diff.getReferenceBeginIndex();
            }
            if (oppositeIndex > 0 && oppositeIndex <= eList.size()) {
                oppositeAnchor = (EObject)eList.get(oppositeIndex - 1);
            }
        }
        return oppositeAnchor;
    }
}

